<?php
 namespace Noalyss\XMLPayment; const ERROR_SEPA=[0=>'OK',1=>'Montant invalide',2=>'Fiche invalide',3=>'IBAN incorrect',99=>'Autre error']; class Sepa { protected $payment_id; protected $domdoc; protected $dbcnx; function __construct($payment_id) { $this->payment_id = $payment_id; $this->domdoc = null; $this->dbcnx=\Dossier::connect(); } protected function build_initiatingParty() { global $g_parameter; $initgPty = $this->domdoc->createElement('InitgPty'); $initgPty->appendChild($this->domdoc->createElement('Nm', $g_parameter->MY_NAME)); return $initgPty; } private function append_GroupHeader($xml_document) { $group_header = $this->domdoc->createElement('GrpHdr'); $group_header->appendChild($this->domdoc->createElement('MsgId', 'noalyss' .sprintf("/%s/%s/",$this->payment_id,\Dossier::id()) . date('ymdHi'))); $group_header->appendChild($this->domdoc->createElement('CreDtTm', date('c'))); $nb_transaction = $this->dbcnx->get_value('select count(*) from xmlpayment.payment_detail where payment_id=$1' , [$this->payment_id]); $group_header->appendChild($this->domdoc->createElement('NbOfTxs', $nb_transaction)); $sum_amount = $this->dbcnx->get_value('select sum(d_amount) from xmlpayment.payment_detail where payment_id=$1' , [$this->payment_id]); $group_header->appendChild($this->domdoc->createElement('CtrlSum', sprintf('%.2f', $sum_amount))); $initiatingParty = $this->build_initiatingParty(); $group_header->appendChild($initiatingParty); $xml_document->appendChild($group_header); } private function build_PaymentInformation():\DOMElement { global $g_parameter; $xml_document = $this->domdoc->createElement('PmtInf'); $xml_document->appendChild($this->domdoc->createElement('PmtInfId', uniqid('noalyss/'))); $xml_document->appendChild($this->domdoc->createElement('PmtMtd', 'TRF')); $xml_document->appendChild($this->domdoc->createElement('BtchBookg', 'false')); $tmpTpInf = $this->domdoc->createElement('PmtTpInf'); $InstrPrty = $this->domdoc->createElement('InstrPrty', 'NORM'); $SvcLvl = $this->domdoc->createElement('SvcLvl'); $Cd = $this->domdoc->createElement('Cd', 'SEPA'); $SvcLvl->appendChild($Cd); $tmpTpInf->appendChild($InstrPrty); $tmpTpInf->appendChild($SvcLvl); $xml_document->appendChild($tmpTpInf); $exec_date=$this->dbcnx->get_value("select to_char(p_exec_date,'YYYY-MM-DD')  
        from xmlpayment.payment where p_id=$1", [$this->payment_id]); if ( $exec_date == "" ) { $exec_date=date('Y-m-d'); } else{ $d=\DateTime::createFromFormat("Y-m-d", $exec_date); if ($d ==false || $d->format('Ymd')< date('Ymd')) { $exec_date=date('Y-m-d'); } } $xml_document->appendChild($this->domdoc->createElement('ReqdExctnDt', $exec_date)); $debitor = $this->domdoc->createElement('Dbtr'); $debitor->appendChild($this->domdoc->createElement('Nm', $g_parameter->MY_NAME)); $xml_document->appendChild($debitor); $account = $this->dbcnx->get_row('
            select b_id
                 ,b_bank_number
                 ,b_bank_id 
            from 
                xmlpayment.bank_account 
                    join xmlpayment.payment on (bank_account.b_id = payment.bank_account_id)
            where 
                p_id=$1', [$this->payment_id]); if (count($account) == 0) throw new \Exception(__FUNCTION__ . "not bank account given"); $debitor_account = $this->domdoc->createElement('DbtrAcct'); $id= $this->domdoc->createElement('Id'); $id->appendChild($this->domdoc->createElement('IBAN',$account['b_bank_number'])); $debitor_account->appendChild($id); $debitor_account->appendChild($this->domdoc->createElement('Ccy','EUR')); $xml_document->appendChild($debitor_account); $debitor_agent=$this->domdoc->createElement('DbtrAgt'); $financial=$this->domdoc->createElement('FinInstnId'); $financial->appendChild($this->domdoc->createElement('BIC',$account['b_bank_id'])); $debitor_agent->appendChild($financial); $xml_document->appendChild($debitor_agent); return $xml_document; } private function append_CreditTransferTransactionInformation($payment_information) { $a_payment=$this->dbcnx->get_array('
                select d_id
                     ,d_amount
                     ,d_bank_account
                     ,d_message
                     , fiche_id
                     ,d_jr_id 
                from 
                    xmlpayment.payment_detail 
                where
                    payment_id=$1 ',[$this->payment_id]); $nb_payement=count($a_payment); if ($nb_payement==0) { throw new \Exception(__FUNCTION__ . 'Liste paiement vide'); } for ($i=0;$i<$nb_payement;$i++) { $xml_document=$this->domdoc->createElement('CdtTrfTxInf'); $id=$this->domdoc->createElement('PmtId'); $id->appendChild($this->domdoc->createElement('EndToEndId' ,sprintf("id:%s/jr:%s",$a_payment[$i]['d_id'],$a_payment[$i]['d_jr_id']))); $xml_document->appendChild($id); $amt=$this->domdoc->createElement('Amt'); $instdAmt=$this->domdoc->createElement('InstdAmt',sprintf("%.2f",$a_payment[$i]['d_amount'])); $instdAmt->setAttribute('Ccy','EUR'); $amt->appendChild($instdAmt); $xml_document->appendChild($amt); $card=new \Fiche($this->dbcnx,$a_payment[$i]['fiche_id']); $cdtr=$this->domdoc->createElement('Cdtr'); $cdtr->appendChild($this->domdoc->createElement('Nm',$card->get_attribute(ATTR_DEF_NAME))); $xml_document->appendChild($cdtr); $CdtrAcct=$this->domdoc->createElement('CdtrAcct'); $id=$this->domdoc->createElement('Id'); $id->appendChild($this->domdoc->createElement('IBAN',$a_payment[$i]['d_bank_account'])); $CdtrAcct->appendChild($id); $xml_document->appendChild($CdtrAcct); if ( $a_payment[$i]['d_message'] != "") { $RmtInf=$this->domdoc->createElement('RmtInf'); $RmtInf->appendChild($this->domdoc->createElement('Ustrd',$a_payment[$i]['d_message']??'')); $xml_document->appendChild($RmtInf); } $payment_information->appendChild($xml_document); } } function build_xml():\DOMDocument { $this->domdoc = new \DOMDocument('1.0', 'UTF-8'); $this->domdoc->formatOutput = true; $document = $this->domdoc->createElementNS('urn:iso:std:iso:20022:tech:xsd:pain.001.001.03', 'Document'); $document->setAttribute('xmlns:xsi', 'http://www.w3.org/2001/XMLSchema-instance'); $CstmrCdtTrfInitn = $this->domdoc->createElement('CstmrCdtTrfInitn'); $this->append_GroupHeader($CstmrCdtTrfInitn); $payment_information = $this->build_PaymentInformation(); $this->append_CreditTransferTransactionInformation($payment_information); $CstmrCdtTrfInitn->appendChild($payment_information); $document->appendChild($CstmrCdtTrfInitn); $this->domdoc->appendChild($document); return $this->domdoc; } function verify() { $this->dbcnx->exec_sql('update xmlpayment.payment_detail 
           set d_error=0
        where payment_id=$1',[$this->payment_id]); $this->dbcnx->exec_sql('update xmlpayment.payment_detail 
           set d_error=1
        where d_amount <= 0 and payment_id=$1',[$this->payment_id]); $nb_zero=$this->dbcnx->get_value('select count(*) from xmlpayment.payment_detail where payment_id=$1 and d_error=1',[$this->payment_id]); $this->dbcnx->exec_sql('update xmlpayment.payment_detail 
           set d_error=2
        where fiche_id is null and payment_id=$1',[$this->payment_id]); $nb_card=$this->dbcnx->get_value('select count(*) from xmlpayment.payment_detail where payment_id=$1 and d_error=2',[$this->payment_id]); $aPayment_detail = $this->dbcnx->get_array("select * from xmlpayment.payment_detail where d_error=0 and payment_id=$1",[$this->payment_id]); $nb_iban=0; if (count($aPayment_detail) >0 ) { foreach ($aPayment_detail as $payment_detail ) { if ( Tools::check_iban($payment_detail['d_bank_account']) == false ) { $this->dbcnx->exec_sql("update xmlpayment.payment_detail set d_error = 3 where d_id=$1",[$payment_detail['d_id']]); $nb_iban++; } } } $nb_record=$this->dbcnx->get_value('select count(*) from xmlpayment.payment_detail where payment_id=$1 and d_error=0',[$this->payment_id]); return array('amount'=>$nb_zero,'card'=>$nb_card,'iban'=>$nb_iban,'valid'=>$nb_record); } }