drop schema if exists xmlpayment cascade;
begin;
create schema xmlpayment;

create table xmlpayment.version (v_id int primary key, v_note text not null, v_date timestamp not null default now());
comment on table xmlpayment.version is 'table pour les version';
comment on column xmlpayment.version.v_note is 'Résumé de ce qui a été fait ';

create table xmlpayment.payment (
    p_id int generated   by default as identity primary key,
    p_date date ,
    p_status char(1) not null default 'N',
    p_comment text,
    tech_user text,
    create_date timestamp default now(),
    tech_date timestamp default now());

comment on table xmlpayment.payment is 'List of the XML files for payment';
comment on column xmlpayment.payment.p_date is 'Date of deposit to the bank';
comment on column xmlpayment.payment.p_status is 'N is new , D: deposit to bank';
comment on column xmlpayment.payment.p_comment is 'Comment about this list';

create table xmlpayment.payment_detail (
	   d_id bigint generated   by default as identity primary key,
	   d_amount numeric(15,2) not null,
	   d_bank_account text,
	   fiche_id bigint, -- can be null
	   d_message text,  --message for bank
	   payment_id int references xmlpayment.payment (p_id) on delete cascade on update cascade,
	   d_jr_id bigint references public.jrn (jr_id) on delete set null on update set null,
	   tech_user text,
	   tech_date timestamp default now()
);

create trigger trg_set_tech_user before insert
    or update on
    xmlpayment.payment for each row execute function comptaproc.set_tech_user();

create trigger trg_set_tech_user before insert
    or update on
    xmlpayment.payment_detail for each row execute function comptaproc.set_tech_user();

COMMENT ON COLUMN xmlpayment.payment_detail.d_amount IS 'Amount to pay';
COMMENT ON COLUMN xmlpayment.payment_detail.d_bank_account IS 'Bank Account';
COMMENT ON COLUMN xmlpayment.payment_detail.fiche_id IS 'Card id (fiche.f_id)';
COMMENT ON COLUMN xmlpayment.payment_detail.d_message IS 'Message';
COMMENT ON COLUMN xmlpayment.payment_detail.payment_id IS 'FK to  xmlpayment.payment ';
COMMENT ON COLUMN xmlpayment.payment_detail.d_jr_id IS 'FK to jrn.jr_id, optionnal';

CREATE TABLE xmlpayment.bank_account (
     b_id int GENERATED BY DEFAULT AS IDENTITY NOT NULL primary key ,
     b_bank_number text NOT NULL,
     b_bank_id text NULL,
     CONSTRAINT bank_account_unique UNIQUE (b_bank_number)
);

-- Column comments

COMMENT ON COLUMN xmlpayment.bank_account.b_id IS 'PK';
COMMENT ON COLUMN xmlpayment.bank_account.b_bank_number IS 'IBAN Banque';
COMMENT ON COLUMN xmlpayment.bank_account.b_bank_id IS 'BIC';

ALTER TABLE xmlpayment.payment ADD bank_account_id int NULL;
COMMENT ON COLUMN xmlpayment.payment.bank_account_id IS 'FK to bank_account';
ALTER TABLE xmlpayment.payment ADD CONSTRAINT payment_bank_account_fk FOREIGN KEY (bank_account_id) REFERENCES xmlpayment.bank_account(b_id) ON DELETE SET NULL ON UPDATE SET NULL;

ALTER TABLE xmlpayment.bank_account ADD b_name_account text NOT NULL;
COMMENT ON COLUMN xmlpayment.bank_account.b_name_account IS 'Name of this bank account';


insert into xmlpayment.version(v_id,v_note) values (1,'Installation');

commit;