begin;

create or replace function xmlpayment.format_iban(p_iban text)returns text
as
$_$
declare
    str_bank text;
begin
    str_bank := replace(p_iban,' ','');
    str_bank := replace(str_bank,'.','');
    str_bank := replace(str_bank,'-','');
    str_bank := replace(str_bank,'/','');
    str_bank := upper(str_bank);
    return str_bank;
end;
$_$
language plpgsql;

create or replace function xmlpayment.clean_iban_bic() returns trigger
as
$_$
begin
    new.b_bank_number := xmlpayment.format_iban(new.b_bank_number);
    new.b_bank_id := xmlpayment.format_iban(new.b_bank_id);
    return new;

end;
$_$
LANGUAGE plpgsql;

create or replace function xmlpayment.clean_iban() returns trigger
as
$_$
begin
    new.d_bank_account := xmlpayment.format_iban(new.d_bank_account);

    return new;

end;
$_$
LANGUAGE plpgsql;



create or replace function xmlpayment.clean_iban_bic() returns trigger
as
$_$
begin
    new.b_bank_number := xmlpayment.format_iban(new.b_bank_number);
    new.b_bank_id := xmlpayment.format_iban(new.b_bank_id);
    return new;

end;
$_$
LANGUAGE plpgsql;

CREATE TRIGGER t_clean_iban_bic
    BEFORE
        INSERT OR UPDATE
    ON xmlpayment.bank_account -- table
    FOR EACH ROW --
EXECUTE PROCEDURE xmlpayment.clean_iban_bic();

CREATE TRIGGER t_clean_iban
    BEFORE
        INSERT OR UPDATE
    ON xmlpayment.payment_detail
    FOR EACH ROW --
EXECUTE PROCEDURE xmlpayment.clean_iban();

insert into xmlpayment.version(v_id, v_note) values(2,'Trigger to clean IBAN');
commit;
