-- begin;

create schema noalyss_form;


create table noalyss_form.version (v_id int primary key, v_note text,v_date timestamp default now());

create table noalyss_form.form(
                                  f_id int generated by default as identity  primary key,
                                  f_token	text,
                                  f_url_allow text,
                                  f_url_success text,
                                  f_url_fail text,
                                  fiche_def_id int references fiche_def(fd_id)
);

create table noalyss_form.form_detail(
                                         fd_id int generated by default as identity  primary key,
                                         form_id int not null references noalyss_form.form(f_id) on delete cascade on update cascade,
                                         fd_post_param text not null,
                                         ad_id int references attr_def (ad_id) on delete cascade  on update cascade
);
create table noalyss_form.data_received_raw
(
    dr_id bigint generated always as identity primary key,
    dr_from text ,
    dr_status int,
    dr_time timestamp default now()
);
create table noalyss_form.data_received_raw_detail
(
    drd_id bigint generated always as identity primary key,
    data_received_raw_id bigint references noalyss_form.data_received_raw(dr_id)  on delete cascade on update cascade,
    form_detail_id bigint references noalyss_form.form_detail(fd_id) on delete cascade on update cascade,
    drd_post_value text,
    drd_status int
);


alter table noalyss_form.form    add f_title text;

comment on column noalyss_form.form.f_title is 'Title of the FORM';

alter table noalyss_form.form    add f_description text;

comment on column noalyss_form.form.f_description is 'notes about this form';
alter table noalyss_form.form     add constraint form_token_un         unique (f_token);

alter table noalyss_form.data_received_raw    add fiche_id bigint;

comment on column noalyss_form.data_received_raw.fiche_id is 'Card created with this request';

