<?php
namespace Belgian_Tax; #[\AllowDynamicProperties] class Tva_Amount { var $param ; var $detail_id ; var $db; var $start_periode; var $end_periode; private static $variable=array('amount'=>'amount', 'amount_tva'=>'amount_tva', 'param'=>'param', 'start_periode'=>'start_periode', 'end_periode'=>'end_periode', 'grid'=>'grid' ); function __construct ($p_init,$p_start_periode,$p_end_periode) { $this->db=$p_init; $this->start_periode=$p_start_periode; $this->end_periode=$p_end_periode; $this->param=null; } public function get_parameter($p_string) { if ( array_key_exists($p_string,self::$variable) ) { $idx=self::$variable[$p_string]; return $this->$idx; } else throw new \Exception("Attribut inexistant $p_string"); } public function set_parameter($p_string,$p_value) { if ( array_key_exists($p_string,self::$variable) ) { $idx=self::$variable[$p_string]; $this->$idx=$p_value; } else throw new \Exception("Attribut inexistant $p_string"); } public function __toString() { return var_export(self::$variable,true); } public function verify() { } public function load_parameter() { if ( $this->param != null ) return; $ctva=$this->db->get_array("
    select pi_id,
           tva_id,
           pcm_val,
           ledger_id,
           filter_ledger,
           p_operation ,
           p_side
    from 
        tva_belge.parameter_chld 
    where 
        pcode=$1
        ",array($this->grid)); $this->param=$ctva; } function amount_operation() { $this->load_parameter(); $result = 0; bcscale(4); for ($i = 0; $i < count($this->param); $i++) { if ($this->param[$i]['filter_ledger'] == FILTER_LEDGER_MISC || $this->param[$i]['filter_ledger'] == FILTER_LEDGER_FINANCIAL ) { $acc_accounting = new \Acc_Account_Ledger($this->db,0); $acc_accounting->id = $this->param[$i]['pcm_val']; $jrn_type= match (intval($this->param[$i]['filter_ledger'])) { FILTER_LEDGER_FINANCIAL=>'FIN', FILTER_LEDGER_MISC=>'ODS' }; $cond = sprintf(" 
                j_jrn_def in (select jrn_def_id from jrn_def where jrn_def_type='%s')
            and  j_date >= to_date('%s','DD.MM.YYYY')
            and j_date <= to_date('%s','DD.MM.YYYY')", $jrn_type, $this->start_periode, $this->end_periode ); $tmp_calc =$acc_accounting->get_solde($cond); } else { $tmp_calc = $this->get_amount_filter($this->param[$i]); } $warning = ""; if ($this->param[$i]['p_side'] == 'P' & $tmp_calc < 0) $warning = _('Montant négatif'); if ($this->param[$i]['p_side'] == 'N' & $tmp_calc > 0) $warning = _('Montant positif'); if ($this->param[$i]['p_operation'] == 'A') { $result = bcadd($result, $tmp_calc); } elseif ($this->param[$i]['p_operation'] == 'S') { $result = bcsub($result, $tmp_calc); } else { throw new \Exception("TVA115 : error p_operation unknown {$this->param[$i]['p_operation']}"); } if ($tmp_calc != 0) $this->db->exec_sql('insert into TVA_BELGE.DECLARATION_AMOUNT_DETAIL(detail_id,parameter_child_id,d1_amount,d1_info)
values ($1,$2,$3,$4)', [$this->detail_id, $this->param[$i]['pi_id'], $tmp_calc, $warning]); } return round($result, 2); } function amount_vat(bool $autoreverse) { $this->load_parameter(); $result=0; bcscale(4); for ($i=0;$i<count($this->param);$i++) { if ( ! $autoreverse) $tmp_calc=$this->get_vat_filter($this->param[$i]); else $tmp_calc=$this->get_vat_filter_autoreverse($this->param[$i]); $warning=""; if ($this->param[$i]['p_side'] == 'P' & $tmp_calc < 0) $warning=_('Montant négatif'); if ($this->param[$i]['p_side'] == 'N' & $tmp_calc > 0) $warning=_('Montant positif'); if ($this->param[$i]['p_operation']=='A') { $result=bcadd($result,$tmp_calc); } elseif ($this->param[$i]['p_operation']=='S') { $result=bcsub($result,$tmp_calc); }else { throw new \Exception("TVA115 : error p_operation unknown {$this->param[$i]['p_operation']}"); } if ($tmp_calc != 0 ) $this->db->exec_sql('insert into TVA_BELGE.DECLARATION_AMOUNT_DETAIL(detail_id,parameter_child_id,d1_amount,d1_info)
values ($1,$2,$3,$4)',[$this->detail_id,$this->param[$i]['pi_id'],$tmp_calc,$warning]); } return round($result,2); } private function get_amount_filter($aParameter_chld) { if (trim($aParameter_chld['tva_id'])=="") return 0; $pcm_val = (trim($aParameter_chld['pcm_val']??"") == "") ? "%" : $aParameter_chld['pcm_val']; $a_sql_param=array( $aParameter_chld['tva_id'], $this->start_periode, $this->end_periode, $aParameter_chld['pcm_val'] ); $filter_ledger=""; $type=$aParameter_chld['filter_ledger']; if ( $aParameter_chld['filter_ledger']== FILTER_LEDGER_ID && $aParameter_chld['ledger_id'] !="" ) { $filter_ledger=' and j_jrn_def=$5'; $a_sql_param[]=$aParameter_chld['ledger_id']; $type=$this->db->get_value("select case jrn_def_type when 'ACH' 
                  then 2 else 1 end from jrn_def 
                  where jrn_def_id=$1",[$aParameter_chld['ledger_id']]); } if ( $type == FILTER_LEDGER_SALE ) { $sql="select coalesce(sum(qs_price),0) as amount 
                from quant_sold
		        join jrnx using (j_id)
                where
                        qs_vat_code=$1
                    and (j_date >= to_date($2,'DD.MM.YYYY') 
                    and j_date <= to_date($3,'DD.MM.YYYY'))
                    and j_poste::text like ($4)
                    $filter_ledger
                    "; $res=$this->db->get_array($sql,$a_sql_param); return $res[0]['amount']; } if ( $type == FILTER_LEDGER_PURCHASE ) { $sql="select coalesce(sum(qp_price),0) as amount 
            from 
                quant_purchase 
                join jrnx using (j_id)
           where 
                   qp_vat_code=$1 
               and (j_date >= to_date($2,'DD.MM.YYYY') 
               and j_date <= to_date($3,'DD.MM.YYYY'))
               and j_poste::text like ($4)
               $filter_ledger
               "; $res=$this->db->get_array($sql,$a_sql_param); return $res[0]['amount']; } return 0; } private function get_vat_filter($aParameter_chld) { if (trim($aParameter_chld['tva_id']) == "") return 0; $pcm_val = (\noalyss_trim($aParameter_chld['pcm_val']) == "") ? "%" : $aParameter_chld['pcm_val']; $a_sql_param = array( $aParameter_chld['tva_id'], $this->start_periode, $this->end_periode, $pcm_val ); $flag_ledger=$aParameter_chld['filter_ledger'] ; $filter_ledger = ""; if ($aParameter_chld['filter_ledger'] == 3 && $aParameter_chld['ledger_id'] != "") { $filter_ledger = ' and j_jrn_def=$5'; $a_sql_param[] = $aParameter_chld['ledger_id']; $x=$this->db->get_value('select jrn_def_type from jrn_def where jrn_def_id=$1', [$aParameter_chld['ledger_id']]); $flag_ledger=match($x){'VEN'=>1,'ACH'=>2,default=>0}; } if ($flag_ledger == 0) throw new \Exception("TVMNT276. Journal invalid pour jrn_def_id{$aParameter_chld['ledger_id']}"); if ($flag_ledger == 1) { $sql = "select coalesce(sum(qs_vat),0) as amount 
            from 
                quant_sold 
                join jrnx using (j_id)
           where 
               qs_vat_code=$1
                and (j_date >= to_date($2,'DD.MM.YYYY')
                and j_date <= to_date($3,'DD.MM.YYYY'))
                and j_poste::text like ($4)
                $filter_ledger
                "; $res = $this->db->get_array($sql, $a_sql_param); return $res[0]['amount']; } if ($flag_ledger == 2) { $sql = "select 
                coalesce(sum(qp_vat),0) as amount 
            from 
                quant_purchase 
                join jrnx using (j_id)
           where 
               qp_vat_code=$1
               and  (j_date >= to_date($2,'DD.MM.YYYY')
               and j_date <= to_date($3,'DD.MM.YYYY'))
               and j_poste::text like ($4)
               $filter_ledger
               "; $res = $this->db->get_array($sql, $a_sql_param); return $res[0]['amount']; } return 0; } private function get_vat_filter_autoreverse($aParameter_chld) { if (trim($aParameter_chld['tva_id']) == "") return 0; $pcm_val = (\noalyss_trim($aParameter_chld['pcm_val']) == "") ? "%" : $aParameter_chld['pcm_val']; $a_sql_param = array( $aParameter_chld['tva_id'], $this->start_periode, $this->end_periode, $pcm_val ); $flag_ledger=$aParameter_chld['filter_ledger'] ; $filter_ledger = ""; if ($aParameter_chld['filter_ledger'] == 3 && $aParameter_chld['ledger_id'] != "") { $filter_ledger = ' and j_jrn_def=$5'; $a_sql_param[] = $aParameter_chld['ledger_id']; $x=$this->db->get_value('select jrn_def_type from jrn_def where jrn_def_id=$1', [$aParameter_chld['ledger_id']]); $flag_ledger=match($x){'VEN'=>1,'ACH'=>2,default=>0}; } if ($flag_ledger == 0) throw new \Exception("TVMNT276. Journal invalid pour jrn_def_id{$aParameter_chld['ledger_id']}"); if ($flag_ledger == 1) { $sql = "select coalesce(sum(qs_vat_sided),0) as amount 
            from 
                quant_sold 
                join jrnx using (j_id)
           where 
               qs_vat_code=$1
                and (j_date >= to_date($2,'DD.MM.YYYY')
                and j_date <= to_date($3,'DD.MM.YYYY'))
                and j_poste::text like ($4)
                $filter_ledger
                "; $res = $this->db->get_array($sql, $a_sql_param); return $res[0]['amount']; } if ($flag_ledger == 2) { $sql = "select 
                coalesce(sum(qp_vat_sided),0) as amount 
            from 
                quant_purchase 
                join jrnx using (j_id)
           where 
               qp_vat_code=$1
               and  (j_date >= to_date($2,'DD.MM.YYYY')
               and j_date <= to_date($3,'DD.MM.YYYY'))
               and j_poste::text like ($4)
               $filter_ledger
               "; $res = $this->db->get_array($sql, $a_sql_param); return $res[0]['amount']; } return 0; } } 