<?php
 namespace Belgian_Tax; class Ext_List_Intra extends Listing { protected $variable = array( "id"=>"i_id", "date"=>"i_date", "date_decl"=>"date_decl", "start_periode"=>"start_periode", "end_periode"=>"end_periode", "xml_file"=>"xml_file", "num_tva"=>"num_tva", "name"=>"tva_name", "adress"=>"adress", "country"=>"country", "flag_periode"=>"flag_periode", "exercice"=>"exercice", "periode_dec"=>"periode_dec" ); private $aChild=array(); public function __construct($p_cn) { parent::__construct($p_cn); $declarant=new XML\Declarant(); $this->name=$declarant->name; $this->num_tva=$declarant->vatnumber; $this->adress=$declarant->street; $this->country=$declarant->city; } function from_array($p_array){ if( isset($p_array['name_child'])) { $name=$p_array['name_child']; $qcode=$p_array['qcode']; $code=$p_array['tvacode']; $tva_num=$p_array['tva_num_child']; $amount=$p_array['amount']; $periode=$p_array['periode']; $array=array(); for ($i=0;$i<count($name);$i++){ $child=new Ext_List_Intra_Child($this->db); $child->set_parameter('amount',$amount[$i]); $child->set_parameter('periode',$periode[$i]); $child->set_parameter('qcode',$qcode[$i]); $child->set_parameter('code',$code[$i]); $child->set_parameter('name_child',$name[$i]); $child->set_parameter('tva_num',$tva_num[$i]); $array[]=$child; } $this->aChild=$array; } else $this->aChild=array(); $this->start_periode=$p_array['start_periode']; $this->end_periode=$p_array['end_periode']; $this->flag_periode=$p_array['flag_periode']; $this->tva_name=$p_array['name']; $this->num_tva=$p_array['num_tva']; $this->adress=$p_array['adress']; $this->country=$p_array['country']; $this->periode_dec=$p_array['periode_dec']; $this->exercice=$p_array['exercice']; } function display() { $http=new \HttpInput(); $r= $this->menu(); $r.= '<form class="print" id="readonly">'; $r.=$this->display_info(); $r.=\HtmlInput::request_to_hidden(array('ac')); $r.=$this->display_declaration_amount(p_readonly: true); $r.='</form>'; $r.= create_script("$('readonly').disable();$('lk_tb_dsp').enable()"); return $r; } function load() { $sql="select * from tva_belge.intracomm where i_id=$1"; $res=$this->db->get_array( $sql, array($this->i_id) ); if ( $this->db->count() == 0 ) return 0; foreach ($res[0] as $idx=>$value) { $this->$idx=$value; } $sql="select * from tva_belge.intracomm_chld where i_id=$1"; $res=$this->db->get_array( $sql, array($this->i_id) ); $nb=$this->db->count(); $array=array(); for ($i=0;$i<$nb;$i++){ $child=new Ext_List_Intra_Child($this->db); foreach ($res[$i] as $idx=>$value){ $child->$idx=$value; } $array[]=$child; } $this->aChild=$array; return 1; } function verify() { return 0; } function insert() { $this->db->start(); $sql=<<<EOF
INSERT INTO tva_belge.intracomm(
            start_date, end_date,  periodicity, tva_name,
            num_tva, adress, country,  periode_dec,exercice)
      VALUES (to_date($1,'DD.MM.YYYY'),to_date($2,'DD.MM.YYYY'),$3,$4,$5,$6,$7,$8,$9) returning i_id;
EOF;
$this->i_id=$this->db->get_value($sql, array( $this->start_periode, $this->end_periode, $this->flag_periode, $this->tva_name, $this->num_tva, $this->adress, $this->country, $this->periode_dec, $this->exercice ) ); for ($e=0;$e<count($this->aChild);$e++){ $this->aChild[$e]->set_parameter('depend',$this->i_id); $this->aChild[$e]->insert(); } $this->db->commit(); } function update() { } function compute(){ $array=array(); $match_tva_code=array('CLINTRA'=>'S','CLINTRAGD'=>'L','CLINTRATR'=>'T'); foreach (array('CLINTRA','CLINTRAGD','CLINTRATR') as $tva_code) { $all=[]; $aInfo=$this->find_tva_acc($tva_code); if (empty($aInfo)) $aInfo=[['pcm_val'=>'x','tva_id'=>-1,'ledger_id'=>0]]; foreach ($aInfo as $info){ $a_sql_param=array( $info['tva_id'], $info['pcm_val'], $this->start_periode, $this->end_periode, ); $filter_ledger=""; if ( $info['ledger_id']!="" ) { $filter_ledger=' and j_jrn_def=$5'; $a_sql_param[]=$info['ledger_id']; } $sql=<<<EOF
                    select fd1.ad_value j_qcode,sum(qs_price) amount
                    from quant_sold
                    join jrnx using (j_id)
                    join fiche_detail fd1 on (qs_client=fd1.f_id and fd1.ad_id=23)
                    where 
                        qs_vat_code =$1 
                        and qs_fiche in (select f_id from fiche_detail where ad_id=5 and ad_value like $2)
                         and (j_date >= to_date($3,'DD.MM.YYYY') and j_date <= to_date($4,'DD.MM.YYYY'))
                    $filter_ledger
                    group by ad_value;
EOF;
$all=$this->db->get_array($sql,$a_sql_param); for ($i=0;$i<count($all);$i++){ $child=new Ext_List_Intra_Child($this->db); $child->set_parameter('amount',$all[$i]['amount']); switch ($this->flag_periode) { case 1: $child->set_parameter('periode',sprintf('%02d%s',$this->periode_dec,$this->exercice)); break; case 2: $child->set_parameter('periode',sprintf('3%d%s',$this->periode_dec,$this->exercice)); break; case 3: $child->set_parameter('periode',sprintf('00%s',$this->periode_dec,$this->exercice)); break; } $child->set_parameter('qcode',$all[$i]['j_qcode']); $fiche=new \Fiche($this->db); $fiche->get_by_qcode($all[$i]['j_qcode'],false); $num_tva=$fiche->get_attribute(ATTR_DEF_NUMTVA); if ( trim($num_tva) === "") {continue;} $child->set_parameter('tva_num',$num_tva); $child->set_parameter('name_child',$fiche->get_attribute(ATTR_DEF_NAME)); $child->set_parameter('code',$match_tva_code[$tva_code]); $array[]=$child; } } } $this->aChild=$array; } function display_declaration_amount($p_readonly=false) { $res='<fieldset><h3>Listing</h3>'; $res.=\HtmlInput::filter_table("tb_dsp", '0,1,2,3,4',1); $res.= '<table id="tb_dsp" class="result" style="width:80%;">'; $js_clean="deleteRow('tb_dsp',this);"; $r=''; $r.=th('QuickCode'); $r.=th('Name'); $r.=th('Code Pays et numéro de TVA'); $r.=th('Categorie L/T/S'); $r.=th('montant'); $r.=th('periode'); $r.=th(''); $amount=0; $res.=tr($r); $ck=new \ICheckBox("delIntra[]"); $ck->set_range("delck"); for ($i=0;$i<count($this->aChild);$i++) { $a=new \IHidden('qcode[]',$this->aChild[$i]->get_parameter('qcode')); $b=new \IText('name_child[]',$this->aChild[$i]->get_parameter('name_child')); if ( $p_readonly) $c=new \IText('tva_num_child[]',$this->aChild[$i]->get_parameter('tva_num')); else $c=new \IVATNumber('tva_num_child[]',$this->aChild[$i]->get_parameter('tva_num')); $d=new \IText('tvacode[]',$this->aChild[$i]->get_parameter('code')); $e=new \INum('amount[]',$this->aChild[$i]->get_parameter('amount')); $f=new \IText('periode[]',$this->aChild[$i]->get_parameter('periode')); $amount+=round($this->aChild[$i]->get_parameter('amount'),2); $r=td($a->input().\HtmlInput::card_detail($this->aChild[$i]->get_parameter('qcode'))); $r.=td($b->input()); $r.=td($c->input()); $r.=td($d->input()); $r.=td($e->input()); $r.=td($f->input()); $ck->value=uniqid("cust"); if (! $p_readonly) { $r.=td(\Icon_Action::trash(uniqid(), $js_clean)); $r.=td($ck->input()); } $class=($i%2==0)?' class="odd" ':' class="even" '; $res.=tr($r,$class); } if ( $p_readonly) { $r=td(''); $r.=td(''); $r.=td(''); $r.=td(hb('Total')); $r.=td(hb(sprintf('%.02f',$amount))); $r.=td(''); $r.=td(''); $res.=tr($r); } $res.='</table>'; $res.='</fieldset>'; return $res; } function export_csv($p_id) { $sql="
        select 
               i.exercice,ic_tvanum,ic_amount,ic_code, ic_periode ,ic_name
        from 
                tva_belge.intracomm i   join tva_belge.intracomm_chld   using (i_id)
        where 
        i_id=$1;
      "; $a_row=$this->db->get_array($sql,array($p_id)); if ( empty($a_row)) { return; } $nb_row=count($a_row); $csv=new \Noalyss_Csv(sprintf("listing-intra-%s",$a_row[0]['exercice'])); $csv->send_header(); $csv->write_header([_("Nom"),_("N° TVA"),_('S/L/T'),_("Montant")]); for ($i=0;$i<$nb_row;$i++) { $csv->add($a_row[$i]["ic_name"]); $csv->add($a_row[$i]["ic_tvanum"]); $csv->add($a_row[$i]["ic_code"]); $csv->add($a_row[$i]["ic_amount"],"number"); $csv->write(); } } function menu($array=array()) { $http = new \HttpInput(); $dossier = \Dossier::id(); $plugin_code = $http->request("plugin_code"); $ac = $http->request("ac"); $r = ''; $js_remove=sprintf("onclick=\"if ( confirm(content[50])){remove_form('%s',%d,%d,'li');}\"", $http->request('plugin_code'), \dossier::id(), $this->i_id); $array = array( array("extension.raw.php?".http_build_query(array( "gDossier"=>$dossier, "ac"=>$ac, "plugin_code"=>$plugin_code, "type"=>"li", "op"=>'xml_document', 'i_id'=>$this->i_id)) , _("Déclaration XML"), _("Création du fichier xml"), 2), array("javascript:void(0)", _("Effacement déclaration"), _("Effacement déclaration"), 3, $js_remove), array("extension.raw.php?" . http_build_query(['gDossier' => $dossier, "ac" => $ac, "plugin_code" => $plugin_code, "sa"=>"li", "op" => "exportcsv", "i_id" => $this->i_id]) , _("Export CSV"), _("Export du listing en CSV"), 4) ); $r .=parent::menu($array); return $r; } } class Ext_List_Intra_Child extends \Belgian_Tax\Ext_List_Intra { protected $variable=array( "id"=>"ic_id", "tva_num"=>"ic_tvanum", "amount"=>"ic_amount", "code"=>"ic_code", "periode"=>"ic_periode", "depend"=>"i_id", "qcode"=>"ic_qcode", "name_child"=>'ic_name' ); function insert() { $sql=<<<EOF
INSERT INTO tva_belge.intracomm_chld(
            i_id, ic_tvanum, ic_amount, ic_code, ic_periode, ic_qcode,
            ic_name)
  VALUES ($1, $2, $3, $4, $5, $6, $7) returning ic_id;
EOF;
$this->ic_id=$this->db->get_value($sql,array( $this->i_id, $this->ic_tvanum, $this->ic_amount, $this->ic_code, $this->ic_periode, $this->ic_qcode, $this->ic_name)); } } 