<?php
namespace Belgian_Tax\XML; use IText; use ISelect; use INum; class Representative { var $id; var $issued; var $type; var $name; var $street; var $postcode; var $city; var $countrycode; var $email; var $phone; var $data; var $readOnly; var $representative_id; function __construct() { $this->readOnly = false; $this->data = new \Belgian_Tax\Representative_SQL(1); $this->from_db(); } function fromPost() { $http=new \HttpInput(); $this->id = 1; $this->type = $http->post("p_type","string", null); $this->name = $http->post("p_name", "string",null); $this->street = $http->post("p_street","string", null); $this->postcode = $http->post("p_postcode", "string",null); $this->city = $http->post("p_city", "string",null); $this->countrycode = $http->post("p_countrycode", "string",null); $this->email = $http->post("p_email","string", null); $this->phone = $http->post("p_phone", "string",null); $this->issued = $http->post("p_issued","string", null); $this->representative_id=$http->post('p_representative_id',"string",null); } function input($error=0,$errmsg="") { $h_type = new ISelect('p_type'); $h_type->value = array( array("label" => 'TIN', "value" => "TIN"), array("label" => 'NVAT', "value" => "NVAT"), array("label" => 'other', "value" => "other") ); $h_type->selected = $this->type; $h_type->readOnly = $this->readOnly; $h_name = new IText('p_name', $this->name); $h_name->readOnly = $this->readOnly; $h_representative_id=new IText('p_representative_id',$this->representative_id); $h_representative_id->readOnly=$this->readOnly; $h_street = new IText('p_street', $this->street); $h_street->readOnly = $this->readOnly; $h_postcode = new IText('p_postcode', $this->postcode); $h_postcode->readOnly = $this->readOnly; $h_postcode->style=' class="input_text" pattern="[0-9]+" '; $h_postcode->placeholder='9999'; $h_city = new IText('p_city', $this->city); $h_city->readOnly = $this->readOnly; $h_countrycode = new IText('p_countrycode', $this->countrycode); $h_countrycode->readOnly = $this->readOnly; $h_email = new IText('p_email', $this->email); $h_email->readOnly = $this->readOnly; $h_phone = new IText('p_phone', str_ireplace(array(' ','+'),'',$this->phone??"")); $h_phone->readOnly = $this->readOnly; $h_id = new INum('p_id', $this->id); $h_id->readOnly = $this->readOnly; $h_issued = new IText("p_issued", $this->issued); $h_issued->readOnly = $this->readOnly; global $g_tva_parameter; require_once $g_tva_parameter['template'].'/xml_belgian_tax_representative-input.php'; } function save() { $this->verify(); $this->issued="BE"; $this->data->rp_listing_id = $this->id; $this->data->rp_issued = $this->issued; $this->data->rp_type = $this->type; $this->data->rp_name = $this->name; $this->data->rp_street = $this->street; $this->data->rp_postcode = $this->postcode; $this->data->rp_countrycode = $this->countrycode; $this->data->rp_email = $this->email; $this->data->rp_phone = $this->phone; $this->data->rp_city=$this->city; $this->data->rp_representative_id=$this->representative_id; if ($this->data->exist()>0) $this->data->update(); else $this->data->insert(); } function display() { $this->readOnly = true; $this->input(); } function from_db() { global $cn; $this->issued = $this->data->rp_issued; $this->type = $this->data->rp_type; $this->name = $this->data->rp_name; $this->street = $this->data->rp_street; $this->postcode = $this->data->rp_postcode; $this->countrycode = $this->data->rp_countrycode; $this->email = $this->data->rp_email; $this->phone = $this->data->rp_phone; $this->city=$this->data->rp_city; $this->representative_id=$this->data->rp_representative_id; } function verify() { if ( trim($this->name) == "") return; if (! filter_var($this->email, FILTER_VALIDATE_EMAIL)) { throw new \Exception(_('Représentant Email incorrect'),20); } $this->countrycode= strtoupper($this->countrycode); if ($this->countrycode != 'BE') { throw new \Exception(_('Représentant  Code Pays incorrect'),21); } if ( ! preg_match('/^[0-9]+/',$this->phone)) { throw new \Exception(_('Représentant  Numéro de téléphone incorrect'),22); } if (trim($this->street) == "" ) { throw new \Exception(_('Représentant Rue obligatoire'),31 ); } if (trim($this->postcode) == "" ) { throw new \Exception(_('Représentant  code postal obligatoire'),32 ); } $a=trim($this->postcode); $x=preg_replace('/[^0-9]+/','',$a); if ( $x != $a ) { throw new \Exception(_('Représentant code postal uniquement des chiffres'),33); } if (trim($this->city) == "" ) { throw new \Exception(_('Représentant  ville obligatoire'),33 ); } if ( in_array($this->type ,['NVAT','other'])) { $a=$this->representative_id; $x=preg_replace('/[^0-9]+/','',$a); if ( $x != $a ) { throw new \Exception(_('TVA ou NISS mandataire incorrecte'),33); } } } } 