<?php
 require_once 'transform_declarant.class.php'; require_once 'transform_representative.class.php'; require_once 'transform_client.class.php'; class Transform_Intervat { var $domdoc; var $ns; function __construct() { $this->domdoc = new DOMDocument('1.0', 'ISO-8859-1'); $this->ns = 'http://www.minfin.fgov.be/ClientListingConsignment'; $this->domdoc->formatOutput = true; } function append_root() { $ns = 'http://www.minfin.fgov.be/ClientListingConsignment'; $t = $this->domdoc->createElementNS($this->ns, 'ns2:ClientListingConsignment'); $root = $this->domdoc->appendChild($t); $xmls = $root->setAttribute("xmlns", "http://www.minfin.fgov.be/InputCommon"); $listing = $this->domdoc->appendChild($root); $nb = $this->domdoc->createAttribute('ClientListingsNbr'); $nb->value = 1; $listing->appendChild($nb); $this->domdoc->appendChild($root); } function append_representative(Transform_Representative $p_representative) { $representative = $this->domdoc->createElementNS($this->ns, "ns2:Representative"); $rep_id = $this->domdoc->createElement("RepresentativeID"); $at = $rep_id->setAttribute('identificationType', $p_representative->type); $ai = $rep_id->setAttribute('issuedBy', $p_representative->issued); $value = $this->domdoc->createTextNode($p_representative->id); $rep_id->appendChild($value); $representative->appendChild($rep_id); $representative->appendChild($this->domdoc->createElement("Name", $p_representative->name)); $representative->appendChild($this->domdoc->createElement("Street", $p_representative->street)); $representative->appendChild($this->domdoc->createElement("PostCode", $p_representative->postcode)); $representative->appendChild($this->domdoc->createElement("City", $p_representative->city)); $representative->appendChild($this->domdoc->createElement("CountryCode", $p_representative->countrycode)); $representative->appendChild($this->domdoc->createElement("EmailAddress", $p_representative->email)); $representative->appendChild($this->domdoc->createElement("Phone", $p_representative->phone)); $l = $this->domdoc->getElementsByTagNameNS($this->ns, "ClientListingConsignment"); $nb = $l->length; if ($nb <> 1) die('erreur non trouvé'); $root = $l->item(0); $root->appendChild($representative); } function append_client_listing(Transform_Declarant $p_declarant) { $client=new Transform_Client; $client->compute_value($p_declarant->data->d_id); $vat_amount_sum = $client->vat_amount_sum; $turnoversum = $client->turnoversum; $clientnb = $client->nb; $seqnb = 1; $periode = $p_declarant->data->d_periode; $commentaire=""; $decl = $this->domdoc->createElementNS($this->ns, "ns2:ClientListing"); $ai = $decl->setAttribute('VATAmountSum', sprintf('%8.2f',$vat_amount_sum)); $ai = $decl->setAttribute('TurnOverSum', sprintf("%8.2f",$turnoversum)); $ai = $decl->setAttribute('ClientsNbr', $clientnb); $ai = $decl->setAttribute('SequenceNumber', $seqnb); $this->append_declarant($decl, $p_declarant); $periode = $this->domdoc->createElementNS($this->ns, "ns2:Period", $p_declarant->year); $decl->appendChild($periode); $this->append_listing($decl, $client); $l = $this->domdoc->getElementsByTagNameNS($this->ns, "ClientListingConsignment"); $nb = $l->length; if ($nb <> 1) die('erreur non trouvé'); $root = $l->item(0); $root->appendChild($decl); $decomment = $this->domdoc->createElementNS($this->ns, "ns2:Comment",$commentaire); $decl->appendChild($decomment); } function append_declarant(DOMElement $p_dom, Transform_Declarant $p_declarant) { $declarant = $this->domdoc->createElementNS($this->ns, "ns2:Declarant"); $declarant->appendChild($this->domdoc->createElement("VATNumber", $p_declarant->vatnumber)); $declarant->appendChild($this->domdoc->createElement("Name", $p_declarant->name)); $declarant->appendChild($this->domdoc->createElement("Street", $p_declarant->street)); $declarant->appendChild($this->domdoc->createElement("PostCode", $p_declarant->postcode)); $declarant->appendChild($this->domdoc->createElement("City", $p_declarant->city)); $declarant->appendChild($this->domdoc->createElement("CountryCode", $p_declarant->countrycode)); $declarant->appendChild($this->domdoc->createElement("EmailAddress", $p_declarant->email)); $declarant->appendChild($this->domdoc->createElement("Phone", $p_declarant->phone)); $p_dom->appendChild($declarant); } function append_listing(DOMElement $p_dom, Transform_Client $p_client) { for ($i = 0; $i < $p_client->nb; $i++) { $client=$p_client->array[$i]; $dom_client = $this->domdoc->createElementNS($this->ns, "ns2:Client"); $ai = $dom_client->setAttribute('SequenceNumber', $i+1); $company = $this->domdoc->createElementNS($this->ns, "ns2:CompanyVATNumber"); $company->setAttribute('issuedBy', $client['c_issuedby']); $de_vat_number = $this->domdoc->createTextNode($client['c_vatnumber']); $company->appendChild($de_vat_number); $dom_client->appendChild($company); $dom_client->appendChild($this->domdoc->createElementNS($this->ns,"ns2:TurnOver", sprintf("%8.2f",$client['c_amount_novat']))); $dom_client->appendChild($this->domdoc->createElementNS($this->ns,"ns2:VATAmount", sprintf("%8.2f",$client['c_amount_vat']))); $p_dom->appendChild($dom_client); } } function toxml() { $str=$this->domdoc->saveXML(); return $str; } } 