<?php
 use PHPUnit\Framework\TestCase; require 'global.php'; class Rapav_RepositoryTest extends TestCase { protected $object; protected $connection; protected function setUp(): void { global $g_connection; $this->connection = $g_connection; } protected function tearDown(): void { } public static function setUpBeforeClass(): void { } static function tearDownAfterClass(): void { } function testConstruct() { $web_xml = $_ENV['TMP'] . "/web.xml"; if ( file_exists($web_xml) ) unlink($web_xml); $rapav_repository = new \RAPAV\Rapav_Repository(); $this->assertFileExists($web_xml, $_ENV['TMP'] . "/web.xml not loaded"); $this->assertGreaterThan(18000, filesize($web_xml), " web.xml truncated"); } function testCache() { $web_xml = $_ENV['TMP'] . "/web.xml"; $rapav_repository = new \RAPAV\Rapav_Repository(); $this->assertFileExists($web_xml, $_ENV['TMP'] . "/web.xml not loaded"); clearstatcache(true, $web_xml); $time = filemtime($web_xml); sleep(2); $rapav_repository2 = new \RAPAV\Rapav_Repository(); clearstatcache(true, $web_xml); $time2 = filemtime($web_xml); $this->assertEquals($time, $time2, " web.xml not cached"); \RAPAV\Rapav_Repository::setTimeCacheSecond(5); sleep(10); $this->assertEquals(\RAPAV\Rapav_Repository::getTimeCacheSecond(), 5, "cache not set correctly"); $rapav_repository3 = new \RAPAV\Rapav_Repository(); clearstatcache(true, $web_xml); $time3 = filemtime($web_xml); $this->assertNotEquals($time, $time3, " web.xml not refreshed"); } function testAvailableReport() { $rapav_repository=new \Rapav\Rapav_Repository(); $a_report=$rapav_repository->available_report(); $this->assertNotEquals(0,count($a_report),"No report advanced found"); } function testfindReport() { $rapav_repository=new \Rapav\Rapav_Repository(); $report=$rapav_repository->find_report("FRBIL01"); $this->assertTrue(get_class($report)=="SimpleXMLElement","invalid return"); $report=$rapav_repository->find_report("FRBIL01XXXXX"); $this->assertTrue(empty($report),"unnkown report must return NULL"); } } 