<?php
 namespace rapav; require_once 'rapav_formulaire.class.php'; require_once 'formulaire_param_detail.class.php'; require_once 'rapport_avance_sql.class.php'; require_once NOALYSS_INCLUDE."/lib/noalyss_csv.class.php"; require_once NOALYSS_INCLUDE."/class/periode.class.php"; require_once NOALYSS_INCLUDE.'/class/pdf.class.php'; class Rapav_Declaration extends RAPAV_Declaration_SQL { public $form; function __construct() { $this->form=new RAPAV_Formulaire(); parent::__construct(); } function load_formulaire() { $this->form->load(); } static function export_csv($p_id, $p_orient="list") { global $cn; $title=self::get_title($p_id); $csv=new \Noalyss_Csv($title); $csv->send_header(); if ($p_orient=="list") { self::get_title_csv($csv,$p_id); $csv->write(); $a_row=$cn->get_array('select dr_code,dr_libelle,dr_amount,dr_start,dr_end,dr_account
			from rapport_advanced.declaration_row
			where d_id=$1 order by dr_order,dr_start', array($p_id)); for ($i=0; $i<count($a_row); $i++) { $csv->add($a_row[$i]['dr_code']); $csv->add($a_row[$i]['dr_account']); $csv->add($a_row[$i]['dr_libelle']); $csv->add($a_row[$i]['dr_amount'], "number"); $csv->add(format_date($a_row[$i]['dr_start'])); $csv->add(format_date($a_row[$i]['dr_end'])); $csv->write(); } } elseif ($p_orient=="table") { $csv->add($title); $csv->write(); $a_periode=$cn->get_array('select distinct dr_start,dr_end
			from rapport_advanced.declaration_row
			where d_id=$1 order by dr_start', array($p_id)); $csv->add(""); $csv->add(""); $csv->add(""); for ($i=0; $i<count($a_periode); $i++) { $csv->add(format_date($a_periode[$i]['dr_start'])."-".format_date($a_periode[$i]['dr_end'])); } $csv->write(); $a_row=$cn->get_array('select dr_code,dr_libelle,dr_amount,dr_start,dr_end,dr_account
			from rapport_advanced.declaration_row
			where d_id=$1 order by dr_order,dr_start', array($p_id)); $last_code=""; $last_lib=""; for ($i=0; $i<count($a_row); $i++) { if ($last_code!=$a_row[$i]['dr_code']||$last_lib!=$a_row[$i]['dr_libelle']) { if ($last_code!="") { $csv->write(); } $csv->add($a_row[$i]['dr_account']); $csv->add($a_row[$i]['dr_code']); $csv->add($a_row[$i]['dr_libelle']); $last_code=$a_row[$i]['dr_code']; $last_lib=$a_row[$i]['dr_libelle']; } $csv->add($a_row[$i]['dr_amount'], "number"); } $csv->write(); } } function get_file_to_parse() { global $cn; $dirname=tempnam($_ENV['TMP'], 'rapav_'); unlink($dirname); mkdir($dirname); chdir($dirname); $cn->start(); $filename=$this->d_filename; $exp=$cn->lo_export($this->d_lob, $dirname.DIRECTORY_SEPARATOR.$filename); if ($exp===false) echo_warning(__FILE__.":".__LINE__."Export NOK $filename"); $type="n"; if (strpos($this->d_mimetype, 'vnd.oasis')!=0) { ob_start(); $zip=new \Zip_Extended; if ($zip->open($filename)===TRUE) { $zip->extractTo($dirname.DIRECTORY_SEPARATOR); $zip->close(); } else { echo __FILE__.":".__LINE__."cannot unzip model ".$filename; } unlink($filename); ob_end_clean(); $file_to_parse="content.xml"; $type="OOo"; } else $file_to_parse=$filename; $cn->commit(); return array($file_to_parse, $dirname, $type); } function generate_document() { global $cn; if ($this->d_filename=="") return; list($file_to_parse, $dirname, $type)=$this->get_file_to_parse(); $this->parse_document($dirname, $file_to_parse, $type); $this->special_tag($dirname, $file_to_parse, $type); if ($type=='OOo') { ob_start(); $zip=new \Zip_Extended; $res=$zip->open($this->d_filename, \ZipArchive::CREATE); if ($res!==TRUE) { echo __FILE__.":".__LINE__."cannot recreate zip"; exit; } $zip->add_recurse_folder($dirname.DIRECTORY_SEPARATOR); $zip->close(); ob_end_clean(); $file_to_save=$this->d_filename; } else { $file_to_save=$file_to_parse; } $this->load_document($dirname.DIRECTORY_SEPARATOR.$file_to_save); if (GENERATE_PDF == 'YES') { $this->save_pdf($dirname,$file_to_save); } } private function save_pdf($p_dir,$p_file) { global $cn; $ext = strrpos($p_file, "."); $filetosend = substr($p_file, 0, $ext); $filetosend .=".pdf"; passthru(OFFICE . escapeshellarg($p_dir.DIRECTORY_SEPARATOR.$p_file), $status); if ($status == 0) { $cn->start(); $this->d_pdf_lob=$cn->lo_import($p_dir.DIRECTORY_SEPARATOR.$filetosend); if ($this->d_pdf_lob==false) { echo_warning(sprintf ( _("Echec import  [%s]"),$filetosend)); return 1; } $this->d_pdf_size=filesize($p_file); $date=date('ymd-Hi'); $this->d_pdf_filename=$date.'-'.$filetosend; $this->update(); $cn->commit(); } else { $msg=sprintf ( _("Echec création PDF [%s]"),$filetosend); echo_warning($msg); return 1; } return 0; } function parse_document($p_dir, $p_filename, $p_type) { global $cn; if ($p_type=="OOo") { $array=$cn->get_array("select '&lt;&lt;'||dr_code||'&gt;&gt;' as code,dr_amount from rapport_advanced.declaration_row where d_id=$1 and dr_type=3", array($this->d_id)); $array_mult=$cn->get_array("select '&lt;&lt;'||dr_code||'&gt;&gt;' as code,
                    '&lt;&lt;'||dr_code||'_LIB&gt;&gt;' as code_lib,
                    '&lt;&lt;'||dr_code||'_ACC&gt;&gt;' as code_acc,
                    dr_account,
                    dr_amount,dr_libelle from rapport_advanced.declaration_row where d_id=$1 and dr_type=9 and dr_amount <> 0", array($this->d_id)); } else { $array=$cn->get_array("select '<<'||dr_code||'>>' as code,dr_amount from rapport_advanced.declaration_row where d_id=$1 and dr_type=3", array($this->d_id)); $array_mult=$cn->get_array("select '<<'||dr_code||'>>' as code,
                '<<'||dr_code||'_LIB>>' as code_lib,
                '<<'||dr_code||'_ACC>>' as code_acc,
                dr_account,
                dr_amount,dr_libelle from rapport_advanced.declaration_row where d_id=$1 and dr_type=9 and dr_amount <> 0 order by dr_order", array($this->d_id)); } $ifilename=$p_dir.'/'.$p_filename; $ifile=fopen($ifilename, 'r'); $temp_dir=$_ENV['TMP']; if (is_dir($temp_dir)==false) { if (mkdir($temp_dir)==false) { echo "Ne peut pas créer le répertoire ".$temp_dir; exit(); } } $oname=tempnam($temp_dir, "rapport_avance_"); $ofile=fopen($oname, "w+"); $buffer=fread($ifile, filesize($ifilename)); foreach ($array as $key=> $value) { $buffer=\Document::replace_value($buffer,$value['code'],$value['dr_amount'],-1,$p_type); } if ($array_mult==false) { } else { $a_code_clean=array(); $a_code_lib_clean=array(); $a_code_acc_clean=array(); $idx=0; foreach ($array_mult as $key=> $value) { if ($idx==0) { $a_code_clean[$idx]=$value['code']; $a_code_lib_clean[$idx]=$value['code_lib']; $a_code_acc_clean[$idx]=$value['code_acc']; $idx++; } else { if (!in_array($value['code'], $a_code_clean)) { $a_code_clean[$idx]=$value['code']; $a_code_lib_clean[$idx]=$value['code_lib']; $a_code_acc_clean[$idx]=$value['code_acc']; $idx++; } } $buffer=\Document::replace_value($buffer,$value['code'],$value['dr_amount'],1,$p_type); $buffer=\Document::replace_value($buffer,$value['code_lib'],$value['dr_libelle'],1,$p_type); $buffer=\Document::replace_value($buffer,$value['code_acc'],$value['dr_account'],1,$p_type); } for ($k=0; $k<$idx; $k++) { $code=$a_code_clean[$k]; $code_lib=$a_code_lib_clean[$k]; $code_acc=$a_code_acc_clean[$k]; $buffer=preg_replace("/".$code."/", "", $buffer); $buffer=preg_replace("/".$code_lib."/", "", $buffer); $buffer=preg_replace("/".$code_acc."/", "", $buffer); } } fwrite($ofile, $buffer); fclose($ifile); fclose($ofile); if (($ret=copy($oname, $p_dir.'/'.$p_filename))==FALSE) { echo _('Ne peut pas sauver '.$oname.' vers '.$p_dir.'/'.$p_filename.' code d\'erreur ='.$ret); } } function special_tag($p_dir, $p_filename, $p_type) { global $cn, $g_parameter; $array[]=array('code'=>'PERIODE_DECLARATION', 'value'=>format_date($this->d_start)." - ".format_date($this->d_end)); $array[]=array('code'=>'TITRE', 'value'=>$this->d_title); $array[]=array('code'=>'ENTITY_ID', 'value'=>$g_parameter->MY_TVA); $array[]=array('code'=>'DOSSIER', 'value'=>$cn->format_name($_REQUEST['gDossier'], 'dos')); $array[]=array('code'=>'NAME', 'value'=>$g_parameter->MY_NAME); $array[]=array('code'=>'STREET', 'value'=>$g_parameter->MY_STREET); $array[]=array('code'=>'NUMBER', 'value'=>$g_parameter->MY_NUMBER); $array[]=array('code'=>'LOCALITE', 'value'=>$g_parameter->MY_CITY); $array[]=array('code'=>'COUNTRY', 'value'=>$g_parameter->MY_COUNTRY_CODE); $array[]=array('code'=>'PHONE', 'value'=>$g_parameter->MY_PHONE); $array[]=array('code'=>'CEDEX', 'value'=>$g_parameter->MY_POSTCODE); $array[]=array('code'=>'FAX', 'value'=>$g_parameter->MY_FAX); $array[]=array('code'=>'NOTE', 'value'=>$this->d_description); $array[]=array('code'=>'TODAY', 'value'=>date('d.m.Y')); $array[]=array('code'=>'START_DATE', 'value'=>format_date($this->d_start)); $array[]=array('code'=>'END_DATE', 'value'=>format_date($this->d_end)); $p_id=$this->find_periode($this->d_start); $exercice=" ??? "; if ($p_id > -1 ) { $periode=new \Periode($cn,$p_id); $exercice=$periode->get_exercice(); } $array[]=array('code'=>'EXERCICE','value'=>$exercice); $date_start=\DateTime::createFromFormat('d.m.Y', $this->d_start); $date_end=\DateTime::createFromFormat('d.m.Y', $this->d_end); $date_end->add(new \DateInterval('P1D')); $interval=$date_start->diff($date_end); $interval_year=$interval->format("%y"); $array[]=array('code'=>'INTERVAL_DAY', 'value'=>$interval->format('%a')); $array[]=array('code'=>'INTERVAL_MONTH', 'value'=>$interval->format('%m')+$interval_year*12); $array[]=array('code'=>'INTERVAL_YEAR', 'value'=>$interval_year); $ifile=fopen($p_dir.'/'.$p_filename, 'r'); $temp_dir=$_ENV["TMP"]; if (is_dir($temp_dir)==false) { if (mkdir($temp_dir)==false) { echo "Ne peut pas créer le répertoire ".$temp_dir; exit(); } } $oname=tempnam($temp_dir, "rapport_avance_"); $ofile=fopen($oname, "w+"); while (!feof($ifile)) { $buffer=fgets($ifile); foreach ($array as $key=> $value) { if ($p_type=='OOo') { $replace='&lt;&lt;'.$value['code'].'&gt;&gt;'; $fmt_value=$value['value']; $fmt_value=noalyss_str_replace('&', '&amp;', $fmt_value); $fmt_value=noalyss_str_replace('<', '&lt;', $fmt_value); $fmt_value=noalyss_str_replace('>', '&gt;', $fmt_value); $fmt_value=noalyss_str_replace('"', '&quot;', $fmt_value); $fmt_value=noalyss_str_replace("'", '&apos;', $fmt_value); } else { $replace='<<'.$value['code'].'>>'; $fmt_value=$value['value']; } $buffer=noalyss_str_replace($replace, $fmt_value, $buffer); } fwrite($ofile, $buffer); } fclose($ifile); fclose($ofile); if (($ret=copy($oname, $p_dir.'/'.$p_filename))==FALSE) { echo _('Ne peut pas sauver '.$oname.' vers '.$p_dir.'/'.$p_filename.' code d\'erreur ='.$ret); } } function load_document($p_file) { global $cn; $cn->start(); $this->d_lob=$cn->lo_import($p_file); if ($this->d_lob==false) { echo "ne peut pas importer [$p_file]"; return 1; } $this->d_size=filesize($p_file); $this->d_mimetype=$this->d_mimetype??mime_content_type($p_file); $date=date('ymd-Hi'); $this->d_filename=$date.'-'.$this->d_filename; $this->update(); $cn->commit(); } function compute($p_id, $p_start, $p_end, $p_step) { global $cn; $cn->start(); $this->form->f_id=$p_id; $this->form->load(); $this->d_title=$this->form->f_title; $this->d_start=$p_start; $this->d_end=$p_end; $this->to_keep='N'; $this->d_lob=$this->form->f_lob; $this->d_filename=$this->form->f_filename; $this->d_mimetype=$this->form->f_mimetype; $this->d_size=$this->form->f_size; $this->d_step=$p_step; $this->insert(); $array=$cn->get_array("select p_id,p_code,p_libelle,p_type,p_order,f_id,t_id
			from rapport_advanced.formulaire_param
			where
			f_id=$1
			order by p_order", array($p_id)); if ($p_step==0) { for ($i=0; $i<count($array); $i++) { $row=new Rapav_Declaration_Param(); $row->d_id=$this->d_id; $row->dr_id=$cn->get_next_seq('rapport_advanced.declaration_param_seq'); $row->from_array($array[$i]); $row->dr_start=$p_start; $row->dr_end=$p_end; $row->dr_account=null; if ($array[$i]['p_type']==3) { $row->compute($p_start, $p_end); $row->insert(); } elseif ($array[$i]['p_type']==9) { $this->add_child_account($row, $array[$i], $p_start, $p_end); } else { $row->amount=0; $row->dr_start=$p_start; $row->dr_end=$p_end; $row->insert(); } } } else { while ($this->compute_interval($p_start, $p_end, $p_step)==1) { for ($i=0; $i<count($array); $i++) { $row=new Rapav_Declaration_Param(); $row->d_id=$this->d_id; $row->dr_id=$cn->get_next_seq('rapport_advanced.declaration_param_seq'); $row->from_array($array[$i]); $row->dr_account=null; if ($array[$i]['p_type']==3) { $row->compute($this->start, $this->end); $row->dr_start=$this->start; $row->dr_end=$this->end; $row->insert(); } elseif ($array[$i]['p_type']==9) { $this->add_child_account($row, $array[$i], $this->start, $this->end); } } } } $cn->commit(); } function add_child_account(Rapav_Declaration_Param $row, $p_array, $p_start, $p_end) { global $cn; $a_depending=$row->get_depending(); if (empty($a_depending)) { $row->amount=0; $row->dr_start=$p_start; $row->dr_end=$p_end; $row->insert(); } else { $nb_depending=count($a_depending); for ($j=0; $j<$nb_depending; $j++) { $row=new Rapav_Declaration_Param(); $row->d_id=$this->d_id; $row->dr_id=$cn->get_next_seq('rapport_advanced.declaration_param_seq'); $row->from_array($p_array); $row->dr_start=$p_start; $row->dr_end=$p_end; $row->compute_child($a_depending[$j]['pcm_val'], $p_start, $p_end); $row->dr_account=$a_depending[$j]['pcm_val']; $row->param->p_libelle=$a_depending[$j]['pcm_lib']; $row->param->p_order=$row->param->p_order+$j/1000; $row->insert(); } } } function compute_interval($p_start, $p_end, $p_step) { static $s_start=""; static $s_count=0; if ($s_start=="") { $s_start=$p_start; } $s_count++; $date_start=\DateTime::createFromFormat('d.m.Y', $s_start); $date_end=\DateTime::createFromFormat('d.m.Y', $s_start); $date_finish=\DateTime::createFromFormat('d.m.Y', $p_end); $add=$this->get_interval($p_step); if ($s_count>1) { $date_start->add($add); $date_end->add($add); } $date_end->add($add); $date_end->sub(new \DateInterval('P1D')); if ($date_end>$date_finish) return 0; $this->start=$date_start->format("d.m.Y"); $this->end=$date_end->format("d.m.Y"); $s_start=$this->start; return 1; } function get_interval($p_step) { $array_interval=array("", "P7D", "P14D", "P1M", "P2M", "P3M", 'P6M', 'P1Y'); return new \DateInterval($array_interval[$p_step]); } function anchor_document() { $url=\HtmlInput::request_to_string(array('gDossier', 'ac', 'plugin_code')); $url='extension.raw.php'.$url.'&amp;act=export_decla_document&amp;id='.$this->d_id; return \HtmlInput::anchor($this->d_filename, $url); } function anchor_pdf() { $url=\HtmlInput::request_to_string(array('gDossier', 'ac', 'plugin_code')); $url='extension.raw.php'.$url.'&amp;act=export_decla_document_pdf&amp;id='.$this->d_id; return \HtmlInput::anchor($this->d_pdf_filename, $url); } function display() { global $cn; $array=$cn->get_array('select * from rapport_advanced.declaration_row where d_id=$1 order by dr_order,dr_start', array($this->d_id)); require_once RAPAV_DIR.'/include/template/declaration_display.php'; } function save() { global $cn; try { $http=new \HttpInput(); $cn->start(); $this->to_keep='Y'; $this->update(); $code=$http->post('code','array',array()); $amount=$http->post('amount','array',array()); for ($i=0; $i<count($code); $i++) { $cn->exec_sql('update rapport_advanced.declaration_row set dr_amount=$2 where dr_id=$1', array($code[$i], $amount[$i])); } $cn->commit(); } catch (Exception $e) { alert($e->getTraceAsString()); } } function find_periode($p_date) { global $cn; $sql="select p_id from parm_periode where p_start <= to_date($1,'DD.MM.YYYY') and p_end >= to_date($1,'DD.MM.YYYY') "; $result=$cn->get_value($sql, array($p_date)); if ($result=="") return -1; return $result; } static function export_pdf($p_id) { global $cn; $title=self::get_title($p_id, FALSE); $pdf=new \PDF($cn); $pdf->setDossierInfo($title, 'UTF8'); $pdf->AliasNbPages(); $pdf->SetAuthor('NOALYSS OpenSource'); $pdf->SetTitle($title, 'UTF8'); $a_row=$cn->get_array('select * from rapport_advanced.declaration_row where d_id=$1 order by dr_order,dr_start', array($p_id)); $pdf->addPage(); $pdf->setFont("DejaVu", "B", 14); $nb_row=(empty($a_row))?0:count($a_row); $step = $cn->get_value("select d_step from rapport_advanced.declaration where d_id=$1",[$p_id]); $add=1; $idx=0; for ($i=0; $i<$nb_row; $i++) { $row=$a_row[$i]; $per=($step<>0)?$row['dr_start']." : ".$row['dr_end']:""; switch ($row['dr_type']) { case 10: if ( $add == 0 ) $pdf->AddPage (); $add=0; $pdf->setFont("DejaVu", "B", 14); $pdf->write_cell(0,14,$row["dr_libelle"],1,0,"C"); $pdf->line_new(); $idx=0; break; case 1: $pdf->line_new(); $pdf->setFont("DejaVu", "B", 12); $pdf->fill_row(0); $pdf->write_cell(0,10,$row["dr_libelle"],1,0,"C",1); $pdf->line_new(); $pdf->fill_row(1); $idx=0; break; case 2: $pdf->setFont("DejaVu", "B", 12); $pdf->SetTextColor(0, 0, 127); $pdf->write_cell(0,9,$row["dr_libelle"],0,0,"c"); $pdf->line_new(); $pdf->SetTextColor(0); $idx=0; break; case 6: $pdf->setFont("DejaVu", "BI", 9); $pdf->write_cell(120,8,$row["dr_libelle"],0,0,"c"); $pdf->line_new(); $idx=0; break; case 3: if ( $per != "") { $fill=$pdf->is_fill($i); $idx++; } else { $fill=0; } $pdf->write_cell(5,6,""); $size=($per=="")?120:70; if (trim($row["dr_libelle"]??"")!=""){ $pdf->setFont("DejaVu", "", 9); $pdf->longLine($size,6,$row["dr_libelle"],1,"",$fill); $pdf->write_cell(50,6,nbm($row['dr_amount'],2),1,0,'R',$fill); }else { $pdf->setFont("DejaVu", "BI", 9); $pdf->longLine($size,6,"",0,"",$fill); $pdf->write_cell(50,6,nbm($row['dr_amount'],2),1,0,'R',$fill); } if ( $per != "" ) { $pdf->setFont("DejaVuCond", "", 6); $pdf->write_cell(50,6,$per,0,0,'R'); } $pdf->line_new(); break; case 7: $idx=0; $pdf->setFont("DejaVu", "I", 9); $pdf->write_cell(40,6,""); $pdf->longLine(80,6,$row["dr_libelle"],0); $pdf->line_new(); break; case 8: $idx=0; $pdf->setFont("DejaVu", "B", 9); $pdf->SetTextColor(255,0.1,0.1); $pdf->longLine(80,6,$row["dr_libelle"]); $pdf->SetTextColor(0,0,0); $pdf->line_new(); break; case 9: if ($row['dr_amount']==0) { continue 2; } if ( $per != "") { $fill=$pdf->is_fill($i); $idx++; } else { $fill=0; } $pdf->setFont("DejaVuCond", "I", 9); $pdf->write_cell(10,5,"",0,0,'',$fill); $pdf->longLine(115,5,$row["dr_account"]."/".$row["dr_libelle"],0,'',$fill); $pdf->write_cell(50,5,nbm($row['dr_amount'],2),0,0,'R',$fill); if ( $per != "" ) { $pdf->setFont("DejaVuCond", "", 9); $pdf->write_cell(50,5,$per,0,0,'R'); } $pdf->line_new(); break; } } $pdf->output(self::get_title($p_id, TRUE).".pdf",'D'); } static function get_title($p_id,$p_escape=TRUE) { global $cn; $a_title=$cn->get_array("select d_title
             ,to_char(d_start,'DD.MM.YYYY') as start
             ,to_char(d_end,'DD.MM.YYYY') as end
             from
             rapport_advanced.declaration
             where
             d_id=$1 ", array($p_id)); $title=$a_title[0]['d_title']."-".$a_title[0]['start']."-".$a_title[0]['end']; if ( $p_escape == TRUE ) { $title=mb_strtolower($title, 'UTF-8'); $title=noalyss_str_replace(array('/', '*', '<', '>', '*', '.', '+', ':', '?', '!', " ", ";"), "_", $title); } return $title; } static function get_title_csv($p_csv,$p_id) { global $cn; $a_title=$cn->get_array("select d_title
             ,to_char(d_start,'DD.MM.YYYY') as start
             ,to_char(d_end,'DD.MM.YYYY') as end
             from
             rapport_advanced.declaration
             where
             d_id=$1 ", array($p_id)); $p_csv->add($a_title[0]['d_title']); $p_csv->add($a_title[0]['start']); $p_csv->add($a_title[0]['end']); } } #[\AllowDynamicProperties] class Rapav_Declaration_Param { function insert() { $data=new RAPAV_Declaration_Row_SQL(); $data->dr_code=$this->param->p_code; $data->dr_libelle=$this->param->p_libelle; $data->dr_order=$this->param->p_order; $data->dr_amount=$this->amount; $data->d_id=$this->d_id; $data->dr_id=$this->dr_id; $data->dr_type=$this->param->p_type; $data->dr_start=$this->dr_start; $data->dr_end=$this->dr_end; $data->dr_account=$this->dr_account; $data->insert(); } function from_array($p_array) { $sql=new formulaire_param_sql($p_array['p_id']); $this->param=new Formulaire_Param($sql); foreach (array('p_id', 'p_code', 'p_libelle', 'p_type', 'p_order', 'f_id', 't_id') as $e) { $this->param->$e=$p_array[$e]; } } function find_periode($p_date) { global $cn; $sql="select p_id from parm_periode where p_start <= to_date($1,'DD.MM.YYYY') and p_end >= to_date($1,'DD.MM.YYYY') "; $result=$cn->get_value($sql, array($p_date)); if ($result=="") return -1; return $result; } function compute_date($p_start, $p_end) { global $cn; $exercice_n=-1; if ($exercice_n==-1) { $per=$this->find_periode($p_start); if ($per!=-1) { $periode=new \Periode($cn, $per); $exercice_n=$periode->get_exercice(); } else { $exercice_n=0; } } switch ($this->param->t_id) { case 1: $this->start=$p_start; $this->end=$p_end; return; break; case 2: $exercice=$exercice_n; break; case 3: $exercice=$exercice_n-1; break; case 4: $exercice=$exercice_n-2; break; case 5: $exercice=$exercice_n-3; break; case 6: if ($exercice_n > 0 ) { $periode=new \Periode($cn); list($tstart, $tend)=$periode->get_limit($exercice_n); $this->start=$tstart->first_day(); $this->end=$p_end; } else { $this->start='01.01.1900'; $this->end='01.01.1900'; } return; break; default: throw new Exception('compute_date : t_id est incorrect'); } $exist_exercice=$cn->get_value('select count(p_id) from parm_periode where p_exercice=$1', array($exercice)); if ($exist_exercice==0) { $this->start='01.01.1900'; $this->end='01.01.1900'; return; } $periode=new \Periode($cn); list($per_start, $per_end)=$periode->get_limit($exercice); $this->start=$per_start->first_day(); $this->end=$per_end->last_day(); } function compute_child($p_pcm_val, $p_start, $p_end) { global $cn; bcscale(2); $this->amount="0"; $array=$cn->get_array("select fp_id,p_id,tmp_val,tva_id,fp_formula,fp_signed,jrn_def_type,tt_id,type_detail,
			with_tmp_val,type_sum_account,operation_pcm_val,jrn_def_id,date_paid
			from rapport_advanced.formulaire_param_detail where p_id=$1", array($this->param->p_id)); $this->compute_date($p_start, $p_end); for ($e=0; $e<count($array); $e++) { $row_detail=Rapav_Declaration_Detail::factory($array[$e]); $row_detail->form->tmp_val=$p_pcm_val; $row_detail->dr_id=$this->dr_id; $row_detail->d_id=$this->d_id; $tmp_amount=$row_detail->compute($this->start, $this->end); $this->amount=bcadd($tmp_amount??0, "$this->amount"); $row_detail->insert(); } } function compute($p_start, $p_end) { global $cn; bcscale(2); $this->amount="0"; $array=$cn->get_array("select fp_id,p_id,tmp_val,tva_id,fp_formula,fp_signed,jrn_def_type,tt_id,type_detail,
			with_tmp_val,type_sum_account,operation_pcm_val,jrn_def_id,date_paid
			from rapport_advanced.formulaire_param_detail where p_id=$1", array($this->param->p_id)); $this->compute_date($p_start, $p_end); for ($e=0; $e<count($array); $e++) { $row_detail=Rapav_Declaration_Detail::factory($array[$e]); $row_detail->dr_id=$this->dr_id; $row_detail->d_id=$this->d_id; $tmp_amount=$row_detail->compute($this->start, $this->end); $this->amount=bcadd($tmp_amount??0, "$this->amount"); $row_detail->insert(); } } function get_depending() { global $cn; $accounting=$cn->get_value(" select tmp_val
                from rapport_advanced.formulaire_param_detail
                where p_id=$1", array($this->param->p_id)); $array=$cn->get_array("select pcm_val,pcm_lib from  tmp_pcmn  where
                 pcm_val like $1||'%' order by pcm_val::text", array($accounting)); return $array; } } #[\AllowDynamicProperties] class Rapav_Declaration_Detail extends RAPAV_Declaration_Row_Detail_SQL { public $d_id; public $form; static function factory($p_array) { switch ($p_array['type_detail']) { case '1': $ret=new Rapav_dd_Formula(); break; case '2': $ret=new Rapav_dd_Account_Tva(); break; case '3': $ret=new Rapav_dd_Compute(); break; case '4': $ret=new Rapav_dd_Account(); break; case '5': $ret=new Rapav_dd_Reconcile(); break; case '6' : $ret=new Rapav_dd_Account(); break; default: throw new Exception("Type inconnu"); } $ret->from_array($p_array); $ret->ddr_amount=0; return $ret; } function from_array($p_array) { $this->form=new Formulaire_Param_Detail(); $attribute=explode(',', 'fp_id,p_id,tmp_val,tva_id,fp_formula,fp_signed,jrn_def_type,tt_id,type_detail,with_tmp_val,type_sum_account,operation_pcm_val,jrn_def_id,date_paid'); foreach ($attribute as $e) { $this->form->$e=$p_array[$e]; } } } class Rapav_dd_Formula extends Rapav_Declaration_Detail { function compute($p_start, $p_end) { global $cn; $sql=""; if ($this->form->jrn_def_id!=null) { $sql=' and j_jrn_def ='.$this->form->jrn_def_id; } if ($this->form->date_paid==1) { $sql.=sprintf(" and j_id in ( select j_id from jrnx join jrn on (j_grpt=jr_grpt_id) where jr_date_paid >= to_date('%s','DD.MM.YYYY') and jr_date_paid <= to_date ('%s','DD.MM.YYYY'))", $p_start, $p_end); $p_start='01.01.1900'; $p_end='01.01.2100'; } if ($this->form->date_paid==2) { $sql.=sprintf(" and j_id in ( select j_id from jrnx join jrn on (j_grpt=jr_grpt_id) where jr_ech >= to_date('%s','DD.MM.YYYY') and jr_ech <= to_date ('%s','DD.MM.YYYY'))", $p_start, $p_end); $p_start='01.01.1900'; $p_end='01.01.2100'; } $amount=\Impress::parse_formula($cn, "", $this->form->fp_formula, $p_start, $p_end, true, 1, $sql); return $amount['montant']; } } class Rapav_dd_Compute extends Rapav_Declaration_Detail { function compute($p_start, $p_end) { global $cn; $amount=0; bcscale(2); $formula=$this->form->fp_formula; preg_match_all("/\[([A-Z]*[0-9]*_*)+\]/i", $formula, $e); $tmp=$e[0]; foreach ($tmp as $piece) { $search=noalyss_str_replace('[', '', $piece); $search=noalyss_str_replace(']', '', $search); $value=$cn->get_value('select coalesce(sum(dr_amount),0) as value
				from rapport_advanced.declaration_row where d_id=$1 and dr_code=$2', array($this->d_id, $search)); $value="(".$value.")"; $formula=noalyss_str_replace($piece, $value, $formula); } eval('$amount = '.$formula.';'); return $amount; } } class Rapav_dd_Account_Tva extends Rapav_Declaration_Detail { private function compute_tva($p_start, $p_end) { $filter_ledger=""; if ($this->form->jrn_def_id!="") { $filter_ledger=" and j_jrn_def = ".sql_string($this->form->jrn_def_id); } $sql_date=RAPAV::get_sql_date($this->form->date_paid); if ($this->form->jrn_def_type=='ACH') { $sql="select coalesce(sum(qp_vat),0) as amount
						from quant_purchase join jrnx as jrn1 using (j_id)
						where qp_vat_code=$1
						$sql_date
						and j_poste::text like ($4) $filter_ledger"; $amount=$this->cn->get_value($sql, array($this->form->tva_id, $p_start, $p_end, $this->form->tmp_val)); return $amount; } if ($this->form->jrn_def_type=='VEN') { $sql="select coalesce(sum(qs_vat),0) as amount
						from quant_sold join jrnx as jrn1  using (j_id)
						where qs_vat_code=$1
						$sql_date
						and j_poste::text like ($4)  $filter_ledger"; $amount=$this->cn->get_value($sql, array($this->form->tva_id, $p_start, $p_end, $this->form->tmp_val)); return $amount; } $this->errcode='Erreur dans le journal'; return 0; } private function compute_amount($p_start, $p_end) { $filter_ledger=""; if ($this->form->jrn_def_id!="") { $filter_ledger=" and j_jrn_def = ".sql_string($this->form->jrn_def_id); } $sql_date=RAPAV::get_sql_date($this->form->date_paid); if ($this->form->jrn_def_type=='ACH') { $sql="select coalesce(sum(qp_price),0) as amount from quant_purchase join jrnx as jrn1  using (j_id)
					where qp_vat_code=$1 $sql_date
					and j_poste::text like ($4) $filter_ledger"; $amount=$this->cn->get_value($sql, array($this->form->tva_id, $p_start, $p_end, $this->form->tmp_val)); return $amount; } if ($this->form->jrn_def_type=='VEN') { $sql="select coalesce(sum(qs_price),0) as amount from quant_sold
					join jrnx as jrn1  using (j_id)
					where qs_vat_code=$1 $sql_date
					and j_poste::text like ($4) $filter_ledger"; $amount=$this->cn->get_value($sql, array($this->form->tva_id, $p_start, $p_end, $this->form->tmp_val)); return $amount; } $this->errcode='Erreur dans le journal'; return 0; } function compute($p_start, $p_end) { bcscale(2); switch ($this->form->tt_id) { case 0: $t1_amount=$this->compute_amount($p_start, $p_end); $t2_amount=$this->compute_tva($p_start, $p_end); $amount=bcadd($t1_amount??0, $t2_amount??0); break; case 1: $amount=$this->compute_tva($p_start, $p_end); $amount=bcadd($amount??0, 0); break; case 2: $amount=$this->compute_amount($p_start, $p_end); $amount=bcadd($amount??0, 0); break; default: throw new Exception('Type de total invalide'); break; } return $amount; } } class Rapav_dd_Account extends Rapav_Declaration_Detail { function compute($p_start, $p_end) { global $cn; $filter_ledger=""; if ($this->form->jrn_def_id!="") { $filter_ledger=" and jrn1.j_jrn_def = ".sql_string($this->form->jrn_def_id); } $amount=0; bcscale(2); switch ($this->form->type_sum_account) { case 1: case 2: $sql_date=RAPAV::get_sql_date($this->form->date_paid, 'jrn1'); $sql="
                        select sum(jrnx_amount)
                        from (
                                select distinct jrn1.j_id,case when jrn1.j_debit = 't' then jrn1.j_montant else jrn1.j_montant*(-1) end as jrnx_amount
                                from jrnx as jrn1
                                join jrnx as jrn2 on (jrn1.j_grpt=jrn2.j_grpt)
                                where
                                jrn1.j_poste like $1
                                $sql_date
                                and
                                jrn2.j_poste like $4
                                $filter_ledger
                                ) as tv_amount
							 "; $amount=$cn->get_value($sql, array( $this->form->tmp_val, $p_start, $p_end, $this->form->with_tmp_val )); if ($this->form->type_sum_account==2) $amount=bcmul($amount??0, -1); break; case 3: $sql_date=RAPAV::get_sql_date($this->form->date_paid, 'jrn1'); $sql="
                        select sum(jrnx_amount)
                        from (
                                select distinct jrn1.j_id,jrn1.j_montant as jrnx_amount
                                from jrnx as jrn1
                                join jrnx as jrn2 on (jrn1.j_grpt=jrn2.j_grpt)
                                where
                                jrn1.j_poste like $1
                                $sql_date
                                and
                                jrn2.j_poste like $4
                                and
                                jrn1.j_debit='t'
                                $filter_ledger
                                ) as tv_amount
							 "; $amount=$cn->get_value($sql, array( $this->form->tmp_val, $p_start, $p_end, $this->form->with_tmp_val )); break; case 4: $sql_date=RAPAV::get_sql_date($this->form->date_paid, 'jrn1'); $sql="
                        select sum(jrnx_amount)
                        from (
                                select distinct jrn1.j_id,jrn1.j_montant as jrnx_amount
                                from jrnx as jrn1
                                join jrnx as jrn2 on (jrn1.j_grpt=jrn2.j_grpt)
                                where
                                jrn1.j_poste like $1
                                $sql_date
                                and
                                jrn2.j_poste like $4
                                and
                                jrn1.j_debit='f'
                                $filter_ledger
                                ) as tv_amount
							 "; $amount=$cn->get_value($sql, array( $this->form->tmp_val, $p_start, $p_end, $this->form->with_tmp_val, )); break; default: if (DEBUGNOALYSS > 0) var_dump($this); die(__FILE__.":".__LINE__." UNKNOW SUM TYPE"); break; } return $amount; } } class Rapav_dd_Reconcile extends Rapav_Declaration_Detail { function compute($p_start, $p_end) { global $cn; bcscale(2); $filter_ledger=""; if ($this->form->jrn_def_id!="") { $filter_ledger=" and jrn1.j_jrn_def = ".sql_string($this->form->jrn_def_id); } switch ($this->form->type_sum_account) { case 1: case 2: $sql="
                        select sum(tv_amount.jrnx_amount)
                                from (
                                        select distinct jrn1.j_id,j1.jr_id,
                                        case when jrn1.j_debit = 't' then jrn1.j_montant else jrn1.j_montant*(-1) end as jrnx_amount
                                        from jrnx as jrn1
                                        join jrnx as jrn2 on (jrn1.j_grpt=jrn2.j_grpt)
                                        join jrn as j1 on (jrn1.j_grpt=j1.jr_grpt_id)
                                        where
                                        jrn1.j_poste like $1
                                        and	jrn2.j_poste like $2
                                        $filter_ledger
                                        ) as tv_amount
                                join jrn_rapt as rap1 on (rap1.jr_id=tv_amount.jr_id or rap1.jra_concerned=tv_amount.jr_id)
                                join (select distinct jrn3.j_id,j2.jr_id
                                        from jrnx as jrn3
                                        join jrn as j2 on (j2.jr_grpt_id=jrn3.j_grpt)
                                        where
                                (jrn3.j_date >= to_date($3,'DD.MM.YYYY') and jrn3.j_date <= to_date($4,'DD.MM.YYYY')) and
                                         jrn3.j_poste like $5) as reconc on (rap1.jr_id=reconc.jr_id or rap1.jra_concerned=reconc.jr_id)

							 "; $amount=$cn->get_value($sql, array( $this->form->tmp_val, $this->form->with_tmp_val, $p_start, $p_end, $this->form->operation_pcm_val )); if ($this->form->type_sum_account==2) $amount=bcmul($amount??0, -1); break; case 3: $sql="
                        select sum(tv_amount.jrnx_amount)
                                from (
                                        select distinct jrn1.j_id,j1.jr_id,
                                        jrn1.j_montant as jrnx_amount
                                        from jrnx as jrn1
                                        join jrnx as jrn2 on (jrn1.j_grpt=jrn2.j_grpt)
                                        join jrn as j1 on (jrn1.j_grpt=j1.jr_grpt_id)
                                        where
                                        jrn1.j_poste like $1
                                        and	jrn2.j_poste like $2
                                        and jrn1.j_debit='t'
                                        $filter_ledger
                                        ) as tv_amount
                                join jrn_rapt as rap1 on (rap1.jr_id=tv_amount.jr_id or rap1.jra_concerned=tv_amount.jr_id)
                                join (select distinct jrn3.j_id,j2.jr_id
                                        from jrnx as jrn3
                                        join jrn as j2 on (j2.jr_grpt_id=jrn3.j_grpt)
                                        where
                                (jrn3.j_date >= to_date($3,'DD.MM.YYYY') and jrn3.j_date <= to_date($4,'DD.MM.YYYY')) and
                                         jrn3.j_poste like $5) as reconc on (rap1.jr_id=reconc.jr_id or rap1.jra_concerned=reconc.jr_id)

							 "; $amount=$cn->get_value($sql, array( $this->form->tmp_val, $this->form->with_tmp_val, $p_start, $p_end, $this->form->operation_pcm_val )); break; case 4: $sql="
                        select sum(tv_amount.jrnx_amount)
                                        from (
                                                select distinct jrn1.j_id,j1.jr_id,
                                                jrn1.j_montant  as jrnx_amount
                                                from jrnx as jrn1
                                                join jrnx as jrn2 on (jrn1.j_grpt=jrn2.j_grpt)
                                                join jrn as j1 on (jrn1.j_grpt=j1.jr_grpt_id)
                                                where
                                                jrn1.j_poste like $1
                                                and	jrn2.j_poste like $2
                                                and jrn1.j_debit='f'
                                                $filter_ledger
                                                ) as tv_amount
                                        join jrn_rapt as rap1 on (rap1.jr_id=tv_amount.jr_id or rap1.jra_concerned=tv_amount.jr_id)
                                        join (select distinct jrn3.j_id,j2.jr_id
                                                from jrnx as jrn3
                                                join jrn as j2 on (j2.jr_grpt_id=jrn3.j_grpt)
                                                where
                                        (jrn3.j_date >= to_date($3,'DD.MM.YYYY') and jrn3.j_date <= to_date($4,'DD.MM.YYYY')) and
                                                 jrn3.j_poste like $5) as reconc on (rap1.jr_id=reconc.jr_id or rap1.jra_concerned=reconc.jr_id)

							 "; $amount=$cn->get_value($sql, array( $this->form->tmp_val, $this->form->with_tmp_val, $p_start, $p_end, $this->form->operation_pcm_val )); break; default: if (DEBUGNOALYSS > 0) var_dump($this); die(__FILE__.":".__LINE__." UNKNOW SUM TYPE"); break; } return $amount; } } ?>
