<?php
 namespace Noalyss\Import_Bank\Test; require "configtest.php"; use PHPUnit\Framework\TestCase; require "../bank_constant.php"; assert_options(ASSERT_ACTIVE, 1); assert_options(ASSERT_WARNING, 0); function importbank_assert_handler($file, $line, $code) { echo "<hr>Échec de l'assertion :
        File '$file'<br />
        Line '$line'<br />
        Code '$code'<br /><hr />"; } assert_options(ASSERT_CALLBACK, 'importbank_assert_handler'); class Import_CodaMock extends \Noalyss\Import_Bank\Import_Coda { function move_uploaded_file($temporary_name, $target_path):bool { copy ($temporary_name, $target_path); return true; } } class importCodaTest extends TestCase { protected $backupGlobals = FALSE; function dataRecord() { return array(["header"],["mvt"],["saldo_old"],["mvt2"],["mvt3"],["info"],['info2'],["info3"],["footer"],["message"],["endr"]); } function testcomputeSize($record) { $obj=new Import_CodaMock(); $size=$obj->computeSize($record); $this->assertEquals(128, $size,"record $record incorrect"); } function testParseRow() { $data="0000027052410905                  NOALYSS COMPANY           CTBKBEBXXXX00123456789 00000                                       2"; $obj=new Import_CodaMock(); $ret=$obj->parse_record($data); $this->assertEquals("CTBKBEBXXXX", $ret['BIC']); $this->assertEquals("00123456789", $ret['owner_id']); $this->assertEquals("270524", $ret['date_file']); $data="12000BE57222222345127                  EUR0000000036924160300424NOALYSS COMPANY                                              000"; $ret= $obj->parse_record($data); $this->assertEquals("BE57222222345127                  EUR", $ret['account_nr_currency']); $this->assertEquals("300424", $ret['amount_date']); $data="2100010000                     1000000000837380010524004020000Paiement releve Visa                                 30042400000 0
"; $ret= $obj->parse_record($data); print_r($ret); } function testFileCODA() { $ret=fopen("CODAFT2024052800000.dat","r"); $obj=new Import_CodaMock(); while( $row = fgets($ret)){ $result=$obj->parse_record($row); print_r($result); $this->assertTrue(is_array($result),"return value is not an array"); } } function testUpload_filesDat() { $obj=new Import_CodaMock(); $_FILES=array(); $_FILES['test_upload']=[]; $_FILES['test_upload']['name']="fake1.dat"; $_FILES['test_upload']['error']=0; $this->assertFileExists(__DIR__."/data/".$_FILES['test_upload']['name'], $_FILES['test_upload']['name']." file absent , pls create it"); $_FILES['test_upload']['size']=stat(__DIR__."/data/".$_FILES['test_upload']['name'])['size']; $_FILES['test_upload']['tmp_name']=tempnam("/tmp",""); copy ("data/fake1.dat",$_FILES['test_upload']['tmp_name']); $a_files=$obj->upload_file("test_upload"); $this->assertTrue(count($a_files)===1," no files found"); foreach( $a_files as $file) { $this->assertFileExists($file); } } function testUpload_filesZip() { $obj=new Import_CodaMock(); $_FILES=array(); $_FILES['test_upload']=[]; $_FILES['test_upload']['name']="fake1.zip"; $_FILES['test_upload']['error']=0; $this->assertFileExists(__DIR__."/data/".$_FILES['test_upload']['name'], $_FILES['test_upload']['name']." file absent , pls create it"); $_FILES['test_upload']['size']=stat(__DIR__."/data/".$_FILES['test_upload']['name'])['size']; $_FILES['test_upload']['tmp_name']=tempnam("/tmp",""); copy ("data/fake1.zip",$_FILES['test_upload']['tmp_name']); $a_files=$obj->upload_file("test_upload"); $this->assertTrue(count($a_files)===1," no files found"); $this->assertTrue(strpos($a_files[0],"dat") > 1," no files found"); foreach( $a_files as $file) { $this->assertFileExists($file); } } function testUpload_filesZipMult() { $obj=new Import_CodaMock(); $_FILES=array(); $_FILES['test_upload']=[]; $_FILES['test_upload']['name']="fakex.zip"; $_FILES['test_upload']['error']=0; $this->assertFileExists(__DIR__."/data/".$_FILES['test_upload']['name'], $_FILES['test_upload']['name']." file absent , pls create it"); $_FILES['test_upload']['size']=stat(__DIR__."/data/".$_FILES['test_upload']['name'])['size']; $_FILES['test_upload']['tmp_name']=tempnam("/tmp",""); copy ("data/fakex.zip",$_FILES['test_upload']['tmp_name']); $a_files=$obj->upload_file("test_upload"); $this->assertTrue(count($a_files)===3," expecting 3 files"); $this->assertTrue(strpos($a_files[0],"1.dat") > 1," no files found"); $this->assertTrue(strpos($a_files[1],"2.dat") > 1," no files found"); $this->assertTrue(strpos($a_files[2],"3.dat") > 1," no files found"); foreach( $a_files as $file) { $this->assertFileExists($file); } } function testParseFile() { global $cn; $cn=\Dossier::connect(); $obj=new Import_CodaMock(); $obj->import_file(array("data/coda-test.dat")); } } 