begin;

COMMENT ON TABLE importbank.format_bank IS 'parameter for importing CSV  files';

ALTER TABLE importbank.format_bank ADD format_type int2 NULL DEFAULT 0;

--@TODO@ format_type is useless to remove --
COMMENT ON COLUMN importbank.format_bank.format_type IS '0 CSV ,';

ALTER TABLE importbank.format_bank ADD CONSTRAINT format_type_check CHECK (format_charset in (0,1));


ALTER TABLE importbank."import" ADD i_format int NULL;
COMMENT ON COLUMN importbank."import".i_format IS '0 = CSV , 1 = CODA';
update importbank."import" set i_format=0 where format_bank_id  is not null;

drop table if exists importbank.temp_coda;

CREATE TABLE importbank.temp_coda (
                                      c_id int4 GENERATED ALWAYS AS IDENTITY( INCREMENT BY 1 MINVALUE 1 MAXVALUE 2147483647 START 1 CACHE 1 NO CYCLE) NOT NULL, -- PK
                                      c_type bpchar(1) NOT NULL, -- type of records
                                      c_code bpchar(1) NOT NULL, -- code if any
                                      c_sequence char(4) null,
                                      c_row text NULL, -- row
                                      import_id int4 NOT NULL, -- FK to IMPORT.ID
                                      CONSTRAINT temp_coda_pk PRIMARY KEY (c_id)
);
COMMENT ON TABLE importbank.temp_coda IS 'keep records from CODA file';

-- Column comments

COMMENT ON COLUMN importbank.temp_coda.c_id IS 'PK';
COMMENT ON COLUMN importbank.temp_coda.c_type IS 'type of records';
COMMENT ON COLUMN importbank.temp_coda.c_code IS 'code if any';
COMMENT ON COLUMN importbank.temp_coda.c_row IS 'row ';
COMMENT ON COLUMN importbank.temp_coda.c_sequence IS 'sequence for record type 2 or 3 ';
COMMENT ON COLUMN importbank.temp_coda.import_id IS 'FK to IMPORT.ID';
insert into importbank.version (id, v_comment) values (6,'import coda file');

commit;

