<?php
 namespace Noalyss\Import_Bank; use Exception; use Zip_Extended; global $record_struct; $record_struct = array(); $record_struct['header'] = array( "id" => 1, "zero" => 4, "date_file" => 6, "bank_id" => 3, "bank_appl" => 2, "duplicata" => 1, "blank" => 7, "ref_file" => 10, "dest_name" => 26, "BIC" => 11, "owner_id" => 11, "blank1" => 1, "appl_dis" => 5, "blank2" => 16, "blank3" => 16, "blank4" => 7, "version" => 1 ); $record_struct['saldo_old'] = array( "id" => 1, "account_type" => 1, "sequence" => 3, "account_nr_currency" => 37, "sign" => 1, "amount_old" => 15, "amount_date" => 6, "account_holder" => 26, "account_label" => 35, "sequence2" => 3 ); $record_struct['mvt'] = array( "id" => 1, "code" => 1, "sequence" => 4, "detail_seq" => 4, "reference" => 21, "sign" => 1, "amount" => 15, "date_value" => 6, "code_op" => 8, "communication_type" => 1, "communication" => 53, "date_account" => 6, "sequence2" => 3, "global" => 1, "follow" => 1, "blank" => 1, "follow2" => 1 ); $record_struct['mvt2'] = array( "id" => 1, "code" => 1, "sequence" => 4, "detail_seq" => 4, "communication" => 53, "reference_customer" => 35, "BIC" => 11, "blank" => 3, "type" => 1, "iso_rrr" => 4, "category_purpose" => 4, "purpose" => 4, "follow" => 1, "blank2" => 1, "follow2" => 1 ); $record_struct['mvt3'] = array( "id" => 1, "code" => 1, "sequence" => 4, "detail_seq" => 4, "from_account" => 37, "from_name" => 35, "communication" => 43, "blank" => 1, "blank2" => 1, "follow2" => 1 ); $record_struct["info"] = array( "id" => 1, "code" => 1, "sequence" => 4, "detail_seq" => 4, "reference" => 21, "code_operation" => 8, "code_communication" => 1, "communication" => 73, "blank" => 12, "follow" => 1, "blank2" => 1, "follow2" => 1 ); $record_struct["info2"] = array( "id" => 1, "code" => 1, "sequence" => 4, "detail_seq" => 4, "communication" => 105, "blank" => 10, "follow" => 1, "blank2" => 1, "follow2" => 1 ); $record_struct["info3"] = array( "id" => 1, "code" => 1, "sequence" => 4, "detail_seq" => 4, "communication" => 90, "blank" => 25, "follow" => 1, "blank2" => 1, "follow2" => 1 ); $record_struct['footer'] = array( "id" => 1, "sequence" => 3, "account_nr_currency" => 37, "sign" => 1, "amount_new" => 15, "amount_date" => 6, "blank" => 64, "follow" => 1 ); $record_struct['message'] = array( "id" => 1, "blank" => 1, "sequence" => 4, "detail_seq" => 4, "blank2" => 22, "communication" => 80, "blank3" => 15, "follow" => 1 ); $record_struct['endr'] = array( "id" => 1, "blank" => 15, "record_nb" => 6, "amount_file_credit" => 15, "amount_file_debit" => 15, "blank2" => 75, "follow" => 1 ); class Import_Coda extends Import_Bank { function parse_record($row): array { global $record_struct; if (empty ($row)) throw new Exception(_("IC187 : fichier vide")); $type_record = substr($row, 0, 1); switch ($type_record) { case '0': $field = "header"; break; case '1': $field = "saldo_old"; break; case '2': $field = match (substr($row, 1, 1)) { '1' => "mvt", '2' => "mvt2", '3' => "mvt3", default => "error" }; break; case '3': $field = match (substr($row, 1, 1)) { '1' => "info", '2' => "info2", '3' => "info3", default => "error" }; break; case '4': $field = "message"; break; case '8': $field = "footer"; break; case '9': $field = "endr"; break; default: throw new Exception("Unknow type record [$type_record]"); } if ($field == "error") { $head_row = substr($row, 0, 8); throw new Exception("Unknow type record [$type_record] - >>$head_row<<"); } $struct = array_values($record_struct[$field]); $struct_name = array_keys($record_struct[$field]); $pos = 0; $idx = 0; $a_result = array(); while ($pos < 128) { $size = $struct[$idx]; $key = $struct_name[$idx]; $a_result[$key] = substr($row, $pos, $size); $pos += $size; $idx++; } return $a_result; } function computeSize($field):int { global $record_struct; $header = array_values($record_struct[$field]); $size = 0; foreach ($header as $item) { $size += $item; } return $size; } function upload_file(string $name): array { global $directory; $filename = tempnam($_ENV['TMP'], 'upload_'); $this->move_uploaded_file($_FILES[$name]["tmp_name"], $filename); $return_filename = array($filename); if (strpos($_FILES[$name]["name"], ".zip") > 0) { $zip = new Zip_Extended(); $tmp_dir = uniqid($name); $directory = $_ENV['TMP'] . DIRECTORY_SEPARATOR . $tmp_dir; mkdir($directory); if ($zip->open($filename) == TRUE) { $zip->extractTo($directory); $zip->close(); } else { throw new Exception("cannot unzip $filename"); } $files = scandir($directory); $return_filename = array(); foreach ($files as $item) { if ($item === '.' || $item === '..') continue; $return_filename[] = $directory . DIRECTORY_SEPARATOR . $item; } } return $return_filename; } function move_uploaded_file($tmp_name, $target_path): bool { return move_uploaded_file($tmp_name, $target_path); } function import_file(array $a_file) { global $cn; try { if (!is_array($a_file)) { throw new \Exception("IC316.parameter is not an array"); } $cn->start(); $import = new Import_SQL($cn); $import->setp("i_format", 1); $import->save(); $import_id = $import->getp("id"); foreach ($a_file as $file) { $cn->start(); $hdl_file = fopen($file, "r"); while ($row = fgets($hdl_file)) { try { mb_internal_encoding("UTF-8"); $row = rtrim(Import_Bank::convert_char($row,p_code:1)); $result = $this->parse_record($row); } catch (Exception $e) { throw new Exception("IC334 row [$row] corrupted"); } $code = match ($result['id']) { '1' => $result['account_type'], '2' => $result['code'], '3' => $result['code'], default => '0' }; $sequence = $result['sequence'] ?? "0000"; $cn->exec_sql("
                        insert into 
                            importbank.temp_coda(c_type,c_code,c_row,c_sequence,import_id)
                            values ($1,$2,$3,$4,$5)", array($result['id'], $code, $row, $sequence, $import_id)); } } $cn->commit(); return $import_id; } catch (Exception $e) { $cn->rollback(); throw ($e); } } function transfer_temp_bank($import_id) { global $cn; try { $cn->start(); $hdl_sql = $cn->exec_sql(" select 
                    c_id
                   ,c_type     
                   ,c_code     
                   ,c_sequence 
                   ,c_row      
                from importbank.temp_coda
                where 
                    c_type in ('2','3') 
                    and import_id=$1 order by c_id" , [$import_id]); $nb_record = \Database::num_row($hdl_sql); for ($i = 0; $i < $nb_record; $i++) { $row = \Database::fetch_row($hdl_sql, $i); $result = $this->parse_record($row[4]); if ($result['id'] === "2" && $result["code"] === "1") { $temp_bank_sql = new Temp_Bank_sql($cn); $temp_bank_sql->ref_operation=sprintf('coda%d',$i); $amount = (float)$result["amount"] / 1000; $amount = ($result['sign'] === '1') ? bcsub(0, $amount,4) : $amount; $temp_bank_sql->set_parameter("amount", $amount); $temp_bank_sql->import_id=$import_id; $temp_bank_sql->status="N"; $date =\DateTime::createFromFormat("dmy", $result['date_value']); $temp_bank_sql->set_parameter("tp_date", $date->format("d.m.Y")); $temp_bank_sql->libelle=$result['communication']; if ( $result['follow']==="0" && $result['follow2'] === "0") { $temp_bank_sql->save(); } }elseif ($result['id'] === "2" && $result["code"] === "2") { $temp_bank_sql->libelle .=$result['communication']; $temp_bank_sql->tp_extra.=$result['reference_customer']; if ( $result['follow']==="0" && $result['follow2'] === "0") { $temp_bank_sql->save(); } }elseif ($result['id'] === "2" && $result["code"] === "3") { $temp_bank_sql->libelle.=$result['from_account']; $temp_bank_sql->libelle.=$result['from_name']; $temp_bank_sql->libelle.=$result['communication']; $temp_bank_sql->libelle.=$result['from_name']; if ( $result['follow2'] === "0") { $temp_bank_sql->save(); } }elseif ($result['id'] === "3" && $result["code"] === "1") { if ( $result['follow']==="0" && $result['follow2'] === "0") { $temp_bank_sql->save(); } }elseif ($result['id'] === "3" && $result["code"] === "2") { $temp_bank_sql->tp_extra .=$result['communication']; if ( $result['follow']==="0" && $result['follow2'] === "0") { $temp_bank_sql->save(); } }elseif ($result['id'] === "3" && $result["code"] === "3") { $temp_bank_sql->tp_extra .=$result['communication']; if ( $result['follow']==="0" && $result['follow2'] === "0") { $temp_bank_sql->save(); } }else { throw new Exception("IC414 unknow id [{$result['id']}] code [{$result["code"]}]"); } } $cn->commit(); } catch (\Exception $e) { $cn->commit(); throw new \Exception($e->getMessage()); } } function get_info($import_id) { global $cn; $a_info = $cn->get_array("select c_id,c_row,c_type 
                                    from importbank.temp_coda 
                                    where import_id=$1
                                    and c_type in ('0','1')
                                    order by c_id,c_type", [$import_id]); if (empty($a_info)) return null; $aCompany = array(); $aBankNr = array(); foreach ($a_info as $item) { $row = $this->parse_record($item['c_row']); if ($item['c_type'] == '0') { $aCompany[] = $row['dest_name']; } elseif ($item['c_type'] == '1') $aBankNr[] = $row['account_nr_currency']; } return array("company"=>$aCompany,"bank_acc"=>$aBankNr); } }