begin;

alter table amortissement.amortissement add a_sale_price numeric(20,4);
alter table amortissement.amortissement add a_sale_date date;

comment on column amortissement.amortissement.a_sale_price is 'Sale price when the asset is sold';
comment on column amortissement.amortissement.a_sale_date is 'Date of the sale of this asset';

drop VIEW amortissement.v_amortissement_summary;

CREATE OR REPLACE VIEW amortissement.v_amortissement_summary
AS SELECT amortissement.f_id,
          vw_fiche_attr.vw_name,
          vw_fiche_attr.vw_description,
          vw_fiche_attr.quick_code,
          amortissement.a_id,
          amortissement.account_deb,
          amortissement.account_cred,
          amortissement.a_amount,
          amortissement.a_nb_year,
          amortissement.a_start,
          amortissement.a_date,
          amortissement.a_visible,
          amortissement.card_cred,
          ( SELECT vw_poste_qcode.j_qcode
            FROM vw_poste_qcode
            WHERE vw_poste_qcode.f_id = amortissement.card_cred) AS card_cred_qcode,
          amortissement.card_deb,
          ( SELECT vw_poste_qcode.j_qcode
            FROM vw_poste_qcode
            WHERE vw_poste_qcode.f_id = amortissement.card_deb) AS card_deb_qcode,
          ( SELECT COALESCE(sum(amortissement_histo.h_amount), 0::numeric) AS "coalesce"
            FROM amortissement.amortissement_histo
            WHERE amortissement_histo.a_id = amortissement.a_id) AS amort_done,
          amortissement.a_sale_price,
          amortissement.a_sale_date
   FROM amortissement.amortissement
            JOIN vw_fiche_attr USING (f_id);

COMMENT ON VIEW amortissement.v_amortissement_summary IS 'View of material with card';


insert into amortissement.version values (9);
commit;