<?php

/**
 * This file is a part of horstoeko/zugferd.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace horstoeko\zugferd\codelists;

/**
 * Class representing the Unit codes
 *
 * @category Zugferd
 * @package  Zugferd
 * @author   D. Erling <horstoeko@erling.com.de>
 * @license  https://opensource.org/licenses/MIT MIT
 * @link     https://github.com/horstoeko/zugferd
 */
class ZugferdUnitCodes
{
    /**
     * group
     */
    public const REC20_GROUP = '10';

    /**
     * outfit
     */
    public const REC20_OUTFIT = '11';

    /**
     * ration
     */
    public const REC20_RATION = '13';

    /**
     * shot
     */
    public const REC20_SHOT = '14';

    /**
     * stick, military
     */
    public const REC20_STICK_MILITARY = '15';

    /**
     * twenty foot container
     */
    public const REC20_TWENTY_FOOT_CONTAINER = '20';

    /**
     * forty foot container
     */
    public const REC20_FORTY_FOOT_CONTAINER = '21';

    /**
     * decilitre per gram
     */
    public const REC20_DECILITRE_PER_GRAM = '22';

    /**
     * gram per cubic centimetre
     */
    public const REC20_GRAM_PER_CUBIC_CENTIMETRE = '23';

    /**
     * theoretical pound
     */
    public const REC20_THEORETICAL_POUND = '24';

    /**
     * gram per square centimetre
     */
    public const REC20_GRAM_PER_SQUARE_CENTIMETRE = '25';

    /**
     * theoretical ton
     */
    public const REC20_THEORETICAL_TON = '27';

    /**
     * kilogram per square metre
     */
    public const REC20_KILOGRAM_PER_SQUARE_METRE = '28';

    /**
     * kilopascal square metre per gram
     */
    public const REC20_KILOPASCAL_SQUARE_METRE_PER_GRAM = '33';

    /**
     * kilopascal per millimetre
     */
    public const REC20_KILOPASCAL_PER_MILLIMETRE = '34';

    /**
     * millilitre per square centimetre second
     */
    public const REC20_MILLILITRE_PER_SQUARE_CENTIMETRE_SECOND = '35';

    /**
     * ounce per square foot
     */
    public const REC20_OUNCE_PER_SQUARE_FOOT = '37';

    /**
     * ounce per square foot per 0,01inch
     */
    public const REC20_OUNCE_PER_SQUARE_FOOT_PER_001INCH = '38';

    /**
     * millilitre per second
     */
    public const REC20_MILLILITRE_PER_SECOND = '40';

    /**
     * millilitre per minute
     */
    public const REC20_MILLILITRE_PER_MINUTE = '41';

    /**
     * sitas
     */
    public const REC20_SITAS = '56';

    /**
     * mesh
     */
    public const REC20_MESH = '57';

    /**
     * net kilogram
     */
    public const REC20_NET_KILOGRAM = '58';

    /**
     * part per million
     */
    public const REC20_PART_PER_MILLION = '59';

    /**
     * percent weight
     */
    public const REC20_PERCENT_WEIGHT = '60';

    /**
     * part per billion (US)
     */
    public const REC20_PART_PER_BILLION_US = '61';

    /**
     * millipascal
     */
    public const REC20_MILLIPASCAL = '74';

    /**
     * milli-inch
     */
    public const REC20_MILLIINCH = '77';

    /**
     * pound per square inch absolute
     */
    public const REC20_POUND_PER_SQUARE_INCH_ABSOLUTE = '80';

    /**
     * henry
     */
    public const REC20_HENRY = '81';

    /**
     * foot pound-force
     */
    public const REC20_FOOT_POUNDFORCE = '85';

    /**
     * pound per cubic foot
     */
    public const REC20_POUND_PER_CUBIC_FOOT = '87';

    /**
     * poise
     */
    public const REC20_POISE = '89';

    /**
     * stokes
     */
    public const REC20_STOKES = '91';

    /**
     * fixed rate
     */
    public const REC20_FIXED_RATE = '1I';

    /**
     * radian per second
     */
    public const REC20_RADIAN_PER_SECOND = '2A';

    /**
     * radian per second squared
     */
    public const REC20_RADIAN_PER_SECOND_SQUARED = '2B';

    /**
     * roentgen
     */
    public const REC20_ROENTGEN = '2C';

    /**
     * volt AC
     */
    public const REC20_VOLT_AC = '2G';

    /**
     * volt DC
     */
    public const REC20_VOLT_DC = '2H';

    /**
     * British thermal unit (international table) per hour
     */
    public const REC20_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_HOUR = '2I';

    /**
     * cubic centimetre per second
     */
    public const REC20_CUBIC_CENTIMETRE_PER_SECOND = '2J';

    /**
     * cubic foot per hour
     */
    public const REC20_CUBIC_FOOT_PER_HOUR = '2K';

    /**
     * cubic foot per minute
     */
    public const REC20_CUBIC_FOOT_PER_MINUTE = '2L';

    /**
     * centimetre per second
     */
    public const REC20_CENTIMETRE_PER_SECOND = '2M';

    /**
     * decibel
     */
    public const REC20_DECIBEL = '2N';

    /**
     * kilobyte
     */
    public const REC20_KILOBYTE = '2P';

    /**
     * kilobecquerel
     */
    public const REC20_KILOBECQUEREL = '2Q';

    /**
     * kilocurie
     */
    public const REC20_KILOCURIE = '2R';

    /**
     * megagram
     */
    public const REC20_MEGAGRAM = '2U';

    /**
     * metre per minute
     */
    public const REC20_METRE_PER_MINUTE = '2X';

    /**
     * milliroentgen
     */
    public const REC20_MILLIROENTGEN = '2Y';

    /**
     * millivolt
     */
    public const REC20_MILLIVOLT = '2Z';

    /**
     * megajoule
     */
    public const REC20_MEGAJOULE = '3B';

    /**
     * manmonth
     */
    public const REC20_MANMONTH = '3C';

    /**
     * centistokes
     */
    public const REC20_CENTISTOKES = '4C';

    /**
     * microlitre
     */
    public const REC20_MICROLITRE = '4G';

    /**
     * micrometre (micron)
     */
    public const REC20_MICROMETRE_MICRON = '4H';

    /**
     * milliampere
     */
    public const REC20_MILLIAMPERE = '4K';

    /**
     * megabyte
     */
    public const REC20_MEGABYTE = '4L';

    /**
     * milligram per hour
     */
    public const REC20_MILLIGRAM_PER_HOUR = '4M';

    /**
     * megabecquerel
     */
    public const REC20_MEGABECQUEREL = '4N';

    /**
     * microfarad
     */
    public const REC20_MICROFARAD = '4O';

    /**
     * newton per metre
     */
    public const REC20_NEWTON_PER_METRE = '4P';

    /**
     * ounce inch
     */
    public const REC20_OUNCE_INCH = '4Q';

    /**
     * ounce foot
     */
    public const REC20_OUNCE_FOOT = '4R';

    /**
     * picofarad
     */
    public const REC20_PICOFARAD = '4T';

    /**
     * pound per hour
     */
    public const REC20_POUND_PER_HOUR = '4U';

    /**
     * ton (US) per hour
     */
    public const REC20_TON_US_PER_HOUR = '4W';

    /**
     * kilolitre per hour
     */
    public const REC20_KILOLITRE_PER_HOUR = '4X';

    /**
     * barrel (US) per minute
     */
    public const REC20_BARREL_US_PER_MINUTE = '5A';

    /**
     * batch
     */
    public const REC20_BATCH = '5B';

    /**
     * MMSCF/day
     */
    public const REC20_MMSCF_DAY = '5E';

    /**
     * hydraulic horse power
     */
    public const REC20_HYDRAULIC_HORSE_POWER = '5J';

    /**
     * ampere square metre per joule second
     */
    public const REC20_AMPERE_SQUARE_METRE_PER_JOULE_SECOND = 'A10';

    /**
     * angstrom
     */
    public const REC20_ANGSTROM = 'A11';

    /**
     * astronomical unit
     */
    public const REC20_ASTRONOMICAL_UNIT = 'A12';

    /**
     * attojoule
     */
    public const REC20_ATTOJOULE = 'A13';

    /**
     * barn
     */
    public const REC20_BARN = 'A14';

    /**
     * barn per electronvolt
     */
    public const REC20_BARN_PER_ELECTRONVOLT = 'A15';

    /**
     * barn per steradian electronvolt
     */
    public const REC20_BARN_PER_STERADIAN_ELECTRONVOLT = 'A16';

    /**
     * barn per steradian
     */
    public const REC20_BARN_PER_STERADIAN = 'A17';

    /**
     * becquerel per kilogram
     */
    public const REC20_BECQUEREL_PER_KILOGRAM = 'A18';

    /**
     * becquerel per cubic metre
     */
    public const REC20_BECQUEREL_PER_CUBIC_METRE = 'A19';

    /**
     * ampere per centimetre
     */
    public const REC20_AMPERE_PER_CENTIMETRE = 'A2';

    /**
     * British thermal unit (international table) per second square foot
     * degree Rankine
     */
    public const REC20_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_SECOND_SQUARE_FOOT_DEGREE_RANKINE = 'A20';

    /**
     * British thermal unit (international table) per pound degree Rankine
     */
    public const REC20_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_POUND_DEGREE_RANKINE = 'A21';

    /**
     * British thermal unit (international table) per second foot degree
     * Rankine
     */
    public const REC20_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_SECOND_FOOT_DEGREE_RANKINE = 'A22';

    /**
     * British thermal unit (international table) per hour square foot degree
     * Rankine
     */
    public const REC20_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_HOUR_SQUARE_FOOT_DEGREE_RANKINE = 'A23';

    /**
     * candela per square metre
     */
    public const REC20_CANDELA_PER_SQUARE_METRE = 'A24';

    /**
     * coulomb metre
     */
    public const REC20_COULOMB_METRE = 'A26';

    /**
     * coulomb metre squared per volt
     */
    public const REC20_COULOMB_METRE_SQUARED_PER_VOLT = 'A27';

    /**
     * coulomb per cubic centimetre
     */
    public const REC20_COULOMB_PER_CUBIC_CENTIMETRE = 'A28';

    /**
     * coulomb per cubic metre
     */
    public const REC20_COULOMB_PER_CUBIC_METRE = 'A29';

    /**
     * ampere per millimetre
     */
    public const REC20_AMPERE_PER_MILLIMETRE = 'A3';

    /**
     * coulomb per cubic millimetre
     */
    public const REC20_COULOMB_PER_CUBIC_MILLIMETRE = 'A30';

    /**
     * coulomb per kilogram second
     */
    public const REC20_COULOMB_PER_KILOGRAM_SECOND = 'A31';

    /**
     * coulomb per mole
     */
    public const REC20_COULOMB_PER_MOLE = 'A32';

    /**
     * coulomb per square centimetre
     */
    public const REC20_COULOMB_PER_SQUARE_CENTIMETRE = 'A33';

    /**
     * coulomb per square metre
     */
    public const REC20_COULOMB_PER_SQUARE_METRE = 'A34';

    /**
     * coulomb per square millimetre
     */
    public const REC20_COULOMB_PER_SQUARE_MILLIMETRE = 'A35';

    /**
     * cubic centimetre per mole
     */
    public const REC20_CUBIC_CENTIMETRE_PER_MOLE = 'A36';

    /**
     * cubic decimetre per mole
     */
    public const REC20_CUBIC_DECIMETRE_PER_MOLE = 'A37';

    /**
     * cubic metre per coulomb
     */
    public const REC20_CUBIC_METRE_PER_COULOMB = 'A38';

    /**
     * cubic metre per kilogram
     */
    public const REC20_CUBIC_METRE_PER_KILOGRAM = 'A39';

    /**
     * ampere per square centimetre
     */
    public const REC20_AMPERE_PER_SQUARE_CENTIMETRE = 'A4';

    /**
     * cubic metre per mole
     */
    public const REC20_CUBIC_METRE_PER_MOLE = 'A40';

    /**
     * ampere per square metre
     */
    public const REC20_AMPERE_PER_SQUARE_METRE = 'A41';

    /**
     * curie per kilogram
     */
    public const REC20_CURIE_PER_KILOGRAM = 'A42';

    /**
     * deadweight tonnage
     */
    public const REC20_DEADWEIGHT_TONNAGE = 'A43';

    /**
     * decalitre
     */
    public const REC20_DECALITRE = 'A44';

    /**
     * decametre
     */
    public const REC20_DECAMETRE = 'A45';

    /**
     * decitex
     */
    public const REC20_DECITEX = 'A47';

    /**
     * degree Rankine
     */
    public const REC20_DEGREE_RANKINE = 'A48';

    /**
     * ampere square metre
     */
    public const REC20_AMPERE_SQUARE_METRE = 'A5';

    /**
     * electronvolt
     */
    public const REC20_ELECTRONVOLT = 'A53';

    /**
     * electronvolt per metre
     */
    public const REC20_ELECTRONVOLT_PER_METRE = 'A54';

    /**
     * electronvolt square metre
     */
    public const REC20_ELECTRONVOLT_SQUARE_METRE = 'A55';

    /**
     * electronvolt square metre per kilogram
     */
    public const REC20_ELECTRONVOLT_SQUARE_METRE_PER_KILOGRAM = 'A56';

    /**
     * 8-part cloud cover
     */
    public const REC20_8PART_CLOUD_COVER = 'A59';

    /**
     * ampere per square metre kelvin squared
     */
    public const REC20_AMPERE_PER_SQUARE_METRE_KELVIN_SQUARED = 'A6';

    /**
     * exajoule
     */
    public const REC20_EXAJOULE = 'A68';

    /**
     * farad per metre
     */
    public const REC20_FARAD_PER_METRE = 'A69';

    /**
     * ampere per square millimetre
     */
    public const REC20_AMPERE_PER_SQUARE_MILLIMETRE = 'A7';

    /**
     * femtojoule
     */
    public const REC20_FEMTOJOULE = 'A70';

    /**
     * femtometre
     */
    public const REC20_FEMTOMETRE = 'A71';

    /**
     * foot per second squared
     */
    public const REC20_FOOT_PER_SECOND_SQUARED = 'A73';

    /**
     * foot pound-force per second
     */
    public const REC20_FOOT_POUNDFORCE_PER_SECOND = 'A74';

    /**
     * freight ton
     */
    public const REC20_FREIGHT_TON = 'A75';

    /**
     * gal
     */
    public const REC20_GAL = 'A76';

    /**
     * ampere second
     */
    public const REC20_AMPERE_SECOND = 'A8';

    /**
     * gigacoulomb per cubic metre
     */
    public const REC20_GIGACOULOMB_PER_CUBIC_METRE = 'A84';

    /**
     * gigaelectronvolt
     */
    public const REC20_GIGAELECTRONVOLT = 'A85';

    /**
     * gigahertz
     */
    public const REC20_GIGAHERTZ = 'A86';

    /**
     * gigaohm
     */
    public const REC20_GIGAOHM = 'A87';

    /**
     * gigaohm metre
     */
    public const REC20_GIGAOHM_METRE = 'A88';

    /**
     * gigapascal
     */
    public const REC20_GIGAPASCAL = 'A89';

    /**
     * rate
     */
    public const REC20_RATE = 'A9';

    /**
     * gigawatt
     */
    public const REC20_GIGAWATT = 'A90';

    /**
     * gon
     */
    public const REC20_GON = 'A91';

    /**
     * gram per cubic metre
     */
    public const REC20_GRAM_PER_CUBIC_METRE = 'A93';

    /**
     * gram per mole
     */
    public const REC20_GRAM_PER_MOLE = 'A94';

    /**
     * gray
     */
    public const REC20_GRAY = 'A95';

    /**
     * gray per second
     */
    public const REC20_GRAY_PER_SECOND = 'A96';

    /**
     * hectopascal
     */
    public const REC20_HECTOPASCAL = 'A97';

    /**
     * henry per metre
     */
    public const REC20_HENRY_PER_METRE = 'A98';

    /**
     * bit
     */
    public const REC20_BIT = 'A99';

    /**
     * ball
     */
    public const REC20_BALL = 'AA';

    /**
     * bulk pack
     */
    public const REC20_BULK_PACK = 'AB';

    /**
     * acre
     */
    public const REC20_ACRE = 'ACR';

    /**
     * activity
     */
    public const REC20_ACTIVITY = 'ACT';

    /**
     * byte
     */
    public const REC20_BYTE = 'AD';

    /**
     * ampere per metre
     */
    public const REC20_AMPERE_PER_METRE = 'AE';

    /**
     * additional minute
     */
    public const REC20_ADDITIONAL_MINUTE = 'AH';

    /**
     * average minute per call
     */
    public const REC20_AVERAGE_MINUTE_PER_CALL = 'AI';

    /**
     * fathom
     */
    public const REC20_FATHOM = 'AK';

    /**
     * access line
     */
    public const REC20_ACCESS_LINE = 'AL';

    /**
     * ampere hour
     */
    public const REC20_AMPERE_HOUR = 'AMH';

    /**
     * ampere
     */
    public const REC20_AMPERE = 'AMP';

    /**
     * year
     */
    public const REC20_YEAR = 'ANN';

    /**
     * troy ounce or apothecary ounce
     */
    public const REC20_TROY_OUNCE_OR_APOTHECARY_OUNCE = 'APZ';

    /**
     * anti-hemophilic factor (AHF) unit
     */
    public const REC20_ANTIHEMOPHILIC_FACTOR_AHF_UNIT = 'AQ';

    /**
     * assortment
     */
    public const REC20_ASSORTMENT = 'AS';

    /**
     * alcoholic strength by mass
     */
    public const REC20_ALCOHOLIC_STRENGTH_BY_MASS = 'ASM';

    /**
     * alcoholic strength by volume
     */
    public const REC20_ALCOHOLIC_STRENGTH_BY_VOLUME = 'ASU';

    /**
     * standard atmosphere
     */
    public const REC20_STANDARD_ATMOSPHERE = 'ATM';

    /**
     * american wire gauge
     */
    public const REC20_AMERICAN_WIRE_GAUGE = 'AWG';

    /**
     * assembly
     */
    public const REC20_ASSEMBLY = 'AY';

    /**
     * British thermal unit (international table) per pound
     */
    public const REC20_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_POUND = 'AZ';

    /**
     * barrel (US) per day
     */
    public const REC20_BARREL_US_PER_DAY = 'B1';

    /**
     * bit per second
     */
    public const REC20_BIT_PER_SECOND = 'B10';

    /**
     * joule per kilogram kelvin
     */
    public const REC20_JOULE_PER_KILOGRAM_KELVIN = 'B11';

    /**
     * joule per metre
     */
    public const REC20_JOULE_PER_METRE = 'B12';

    /**
     * joule per square metre
     */
    public const REC20_JOULE_PER_SQUARE_METRE = 'B13';

    /**
     * joule per metre to the fourth power
     */
    public const REC20_JOULE_PER_METRE_TO_THE_FOURTH_POWER = 'B14';

    /**
     * joule per mole
     */
    public const REC20_JOULE_PER_MOLE = 'B15';

    /**
     * joule per mole kelvin
     */
    public const REC20_JOULE_PER_MOLE_KELVIN = 'B16';

    /**
     * credit
     */
    public const REC20_CREDIT = 'B17';

    /**
     * joule second
     */
    public const REC20_JOULE_SECOND = 'B18';

    /**
     * digit
     */
    public const REC20_DIGIT = 'B19';

    /**
     * joule square metre per kilogram
     */
    public const REC20_JOULE_SQUARE_METRE_PER_KILOGRAM = 'B20';

    /**
     * kelvin per watt
     */
    public const REC20_KELVIN_PER_WATT = 'B21';

    /**
     * kiloampere
     */
    public const REC20_KILOAMPERE = 'B22';

    /**
     * kiloampere per square metre
     */
    public const REC20_KILOAMPERE_PER_SQUARE_METRE = 'B23';

    /**
     * kiloampere per metre
     */
    public const REC20_KILOAMPERE_PER_METRE = 'B24';

    /**
     * kilobecquerel per kilogram
     */
    public const REC20_KILOBECQUEREL_PER_KILOGRAM = 'B25';

    /**
     * kilocoulomb
     */
    public const REC20_KILOCOULOMB = 'B26';

    /**
     * kilocoulomb per cubic metre
     */
    public const REC20_KILOCOULOMB_PER_CUBIC_METRE = 'B27';

    /**
     * kilocoulomb per square metre
     */
    public const REC20_KILOCOULOMB_PER_SQUARE_METRE = 'B28';

    /**
     * kiloelectronvolt
     */
    public const REC20_KILOELECTRONVOLT = 'B29';

    /**
     * batting pound
     */
    public const REC20_BATTING_POUND = 'B3';

    /**
     * gibibit
     */
    public const REC20_GIBIBIT = 'B30';

    /**
     * kilogram metre per second
     */
    public const REC20_KILOGRAM_METRE_PER_SECOND = 'B31';

    /**
     * kilogram metre squared
     */
    public const REC20_KILOGRAM_METRE_SQUARED = 'B32';

    /**
     * kilogram metre squared per second
     */
    public const REC20_KILOGRAM_METRE_SQUARED_PER_SECOND = 'B33';

    /**
     * kilogram per cubic decimetre
     */
    public const REC20_KILOGRAM_PER_CUBIC_DECIMETRE = 'B34';

    /**
     * kilogram per litre
     */
    public const REC20_KILOGRAM_PER_LITRE = 'B35';

    /**
     * barrel, imperial
     */
    public const REC20_BARREL_IMPERIAL = 'B4';

    /**
     * kilojoule per kelvin
     */
    public const REC20_KILOJOULE_PER_KELVIN = 'B41';

    /**
     * kilojoule per kilogram
     */
    public const REC20_KILOJOULE_PER_KILOGRAM = 'B42';

    /**
     * kilojoule per kilogram kelvin
     */
    public const REC20_KILOJOULE_PER_KILOGRAM_KELVIN = 'B43';

    /**
     * kilojoule per mole
     */
    public const REC20_KILOJOULE_PER_MOLE = 'B44';

    /**
     * kilomole
     */
    public const REC20_KILOMOLE = 'B45';

    /**
     * kilomole per cubic metre
     */
    public const REC20_KILOMOLE_PER_CUBIC_METRE = 'B46';

    /**
     * kilonewton
     */
    public const REC20_KILONEWTON = 'B47';

    /**
     * kilonewton metre
     */
    public const REC20_KILONEWTON_METRE = 'B48';

    /**
     * kiloohm
     */
    public const REC20_KILOOHM = 'B49';

    /**
     * kiloohm metre
     */
    public const REC20_KILOOHM_METRE = 'B50';

    /**
     * kilosecond
     */
    public const REC20_KILOSECOND = 'B52';

    /**
     * kilosiemens
     */
    public const REC20_KILOSIEMENS = 'B53';

    /**
     * kilosiemens per metre
     */
    public const REC20_KILOSIEMENS_PER_METRE = 'B54';

    /**
     * kilovolt per metre
     */
    public const REC20_KILOVOLT_PER_METRE = 'B55';

    /**
     * kiloweber per metre
     */
    public const REC20_KILOWEBER_PER_METRE = 'B56';

    /**
     * light year
     */
    public const REC20_LIGHT_YEAR = 'B57';

    /**
     * litre per mole
     */
    public const REC20_LITRE_PER_MOLE = 'B58';

    /**
     * lumen hour
     */
    public const REC20_LUMEN_HOUR = 'B59';

    /**
     * lumen per square metre
     */
    public const REC20_LUMEN_PER_SQUARE_METRE = 'B60';

    /**
     * lumen per watt
     */
    public const REC20_LUMEN_PER_WATT = 'B61';

    /**
     * lumen second
     */
    public const REC20_LUMEN_SECOND = 'B62';

    /**
     * lux hour
     */
    public const REC20_LUX_HOUR = 'B63';

    /**
     * lux second
     */
    public const REC20_LUX_SECOND = 'B64';

    /**
     * megaampere per square metre
     */
    public const REC20_MEGAAMPERE_PER_SQUARE_METRE = 'B66';

    /**
     * megabecquerel per kilogram
     */
    public const REC20_MEGABECQUEREL_PER_KILOGRAM = 'B67';

    /**
     * gigabit
     */
    public const REC20_GIGABIT = 'B68';

    /**
     * megacoulomb per cubic metre
     */
    public const REC20_MEGACOULOMB_PER_CUBIC_METRE = 'B69';

    /**
     * cycle
     */
    public const REC20_CYCLE = 'B7';

    /**
     * megacoulomb per square metre
     */
    public const REC20_MEGACOULOMB_PER_SQUARE_METRE = 'B70';

    /**
     * megaelectronvolt
     */
    public const REC20_MEGAELECTRONVOLT = 'B71';

    /**
     * megagram per cubic metre
     */
    public const REC20_MEGAGRAM_PER_CUBIC_METRE = 'B72';

    /**
     * meganewton
     */
    public const REC20_MEGANEWTON = 'B73';

    /**
     * meganewton metre
     */
    public const REC20_MEGANEWTON_METRE = 'B74';

    /**
     * megaohm
     */
    public const REC20_MEGAOHM = 'B75';

    /**
     * megaohm metre
     */
    public const REC20_MEGAOHM_METRE = 'B76';

    /**
     * megasiemens per metre
     */
    public const REC20_MEGASIEMENS_PER_METRE = 'B77';

    /**
     * megavolt
     */
    public const REC20_MEGAVOLT = 'B78';

    /**
     * megavolt per metre
     */
    public const REC20_MEGAVOLT_PER_METRE = 'B79';

    /**
     * joule per cubic metre
     */
    public const REC20_JOULE_PER_CUBIC_METRE = 'B8';

    /**
     * gigabit per second
     */
    public const REC20_GIGABIT_PER_SECOND = 'B80';

    /**
     * reciprocal metre squared reciprocal second
     */
    public const REC20_RECIPROCAL_METRE_SQUARED_RECIPROCAL_SECOND = 'B81';

    /**
     * inch per linear foot
     */
    public const REC20_INCH_PER_LINEAR_FOOT = 'B82';

    /**
     * metre to the fourth power
     */
    public const REC20_METRE_TO_THE_FOURTH_POWER = 'B83';

    /**
     * microampere
     */
    public const REC20_MICROAMPERE = 'B84';

    /**
     * microbar
     */
    public const REC20_MICROBAR = 'B85';

    /**
     * microcoulomb
     */
    public const REC20_MICROCOULOMB = 'B86';

    /**
     * microcoulomb per cubic metre
     */
    public const REC20_MICROCOULOMB_PER_CUBIC_METRE = 'B87';

    /**
     * microcoulomb per square metre
     */
    public const REC20_MICROCOULOMB_PER_SQUARE_METRE = 'B88';

    /**
     * microfarad per metre
     */
    public const REC20_MICROFARAD_PER_METRE = 'B89';

    /**
     * microhenry
     */
    public const REC20_MICROHENRY = 'B90';

    /**
     * microhenry per metre
     */
    public const REC20_MICROHENRY_PER_METRE = 'B91';

    /**
     * micronewton
     */
    public const REC20_MICRONEWTON = 'B92';

    /**
     * micronewton metre
     */
    public const REC20_MICRONEWTON_METRE = 'B93';

    /**
     * microohm
     */
    public const REC20_MICROOHM = 'B94';

    /**
     * microohm metre
     */
    public const REC20_MICROOHM_METRE = 'B95';

    /**
     * micropascal
     */
    public const REC20_MICROPASCAL = 'B96';

    /**
     * microradian
     */
    public const REC20_MICRORADIAN = 'B97';

    /**
     * microsecond
     */
    public const REC20_MICROSECOND = 'B98';

    /**
     * microsiemens
     */
    public const REC20_MICROSIEMENS = 'B99';

    /**
     * bar [unit of pressure]
     */
    public const REC20_BAR_UNIT_OF_PRESSURE = 'BAR';

    /**
     * base box
     */
    public const REC20_BASE_BOX = 'BB';

    /**
     * board foot
     */
    public const REC20_BOARD_FOOT = 'BFT';

    /**
     * brake horse power
     */
    public const REC20_BRAKE_HORSE_POWER = 'BHP';

    /**
     * billion (EUR)
     */
    public const REC20_BILLION_EUR = 'BIL';

    /**
     * dry barrel (US)
     */
    public const REC20_DRY_BARREL_US = 'BLD';

    /**
     * barrel (US)
     */
    public const REC20_BARREL_US = 'BLL';

    /**
     * hundred board foot
     */
    public const REC20_HUNDRED_BOARD_FOOT = 'BP';

    /**
     * beats per minute
     */
    public const REC20_BEATS_PER_MINUTE = 'BPM';

    /**
     * becquerel
     */
    public const REC20_BECQUEREL = 'BQL';

    /**
     * British thermal unit (international table)
     */
    public const REC20_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE = 'BTU';

    /**
     * bushel (US)
     */
    public const REC20_BUSHEL_US = 'BUA';

    /**
     * bushel (UK)
     */
    public const REC20_BUSHEL_UK = 'BUI';

    /**
     * call
     */
    public const REC20_CALL = 'C0';

    /**
     * millifarad
     */
    public const REC20_MILLIFARAD = 'C10';

    /**
     * milligal
     */
    public const REC20_MILLIGAL = 'C11';

    /**
     * milligram per metre
     */
    public const REC20_MILLIGRAM_PER_METRE = 'C12';

    /**
     * milligray
     */
    public const REC20_MILLIGRAY = 'C13';

    /**
     * millihenry
     */
    public const REC20_MILLIHENRY = 'C14';

    /**
     * millijoule
     */
    public const REC20_MILLIJOULE = 'C15';

    /**
     * millimetre per second
     */
    public const REC20_MILLIMETRE_PER_SECOND = 'C16';

    /**
     * millimetre squared per second
     */
    public const REC20_MILLIMETRE_SQUARED_PER_SECOND = 'C17';

    /**
     * millimole
     */
    public const REC20_MILLIMOLE = 'C18';

    /**
     * mole per kilogram
     */
    public const REC20_MOLE_PER_KILOGRAM = 'C19';

    /**
     * millinewton
     */
    public const REC20_MILLINEWTON = 'C20';

    /**
     * kibibit
     */
    public const REC20_KIBIBIT = 'C21';

    /**
     * millinewton per metre
     */
    public const REC20_MILLINEWTON_PER_METRE = 'C22';

    /**
     * milliohm metre
     */
    public const REC20_MILLIOHM_METRE = 'C23';

    /**
     * millipascal second
     */
    public const REC20_MILLIPASCAL_SECOND = 'C24';

    /**
     * milliradian
     */
    public const REC20_MILLIRADIAN = 'C25';

    /**
     * millisecond
     */
    public const REC20_MILLISECOND = 'C26';

    /**
     * millisiemens
     */
    public const REC20_MILLISIEMENS = 'C27';

    /**
     * millisievert
     */
    public const REC20_MILLISIEVERT = 'C28';

    /**
     * millitesla
     */
    public const REC20_MILLITESLA = 'C29';

    /**
     * microvolt per metre
     */
    public const REC20_MICROVOLT_PER_METRE = 'C3';

    /**
     * millivolt per metre
     */
    public const REC20_MILLIVOLT_PER_METRE = 'C30';

    /**
     * milliwatt
     */
    public const REC20_MILLIWATT = 'C31';

    /**
     * milliwatt per square metre
     */
    public const REC20_MILLIWATT_PER_SQUARE_METRE = 'C32';

    /**
     * milliweber
     */
    public const REC20_MILLIWEBER = 'C33';

    /**
     * mole
     */
    public const REC20_MOLE = 'C34';

    /**
     * mole per cubic decimetre
     */
    public const REC20_MOLE_PER_CUBIC_DECIMETRE = 'C35';

    /**
     * mole per cubic metre
     */
    public const REC20_MOLE_PER_CUBIC_METRE = 'C36';

    /**
     * kilobit
     */
    public const REC20_KILOBIT = 'C37';

    /**
     * mole per litre
     */
    public const REC20_MOLE_PER_LITRE = 'C38';

    /**
     * nanoampere
     */
    public const REC20_NANOAMPERE = 'C39';

    /**
     * nanocoulomb
     */
    public const REC20_NANOCOULOMB = 'C40';

    /**
     * nanofarad
     */
    public const REC20_NANOFARAD = 'C41';

    /**
     * nanofarad per metre
     */
    public const REC20_NANOFARAD_PER_METRE = 'C42';

    /**
     * nanohenry
     */
    public const REC20_NANOHENRY = 'C43';

    /**
     * nanohenry per metre
     */
    public const REC20_NANOHENRY_PER_METRE = 'C44';

    /**
     * nanometre
     */
    public const REC20_NANOMETRE = 'C45';

    /**
     * nanoohm metre
     */
    public const REC20_NANOOHM_METRE = 'C46';

    /**
     * nanosecond
     */
    public const REC20_NANOSECOND = 'C47';

    /**
     * nanotesla
     */
    public const REC20_NANOTESLA = 'C48';

    /**
     * nanowatt
     */
    public const REC20_NANOWATT = 'C49';

    /**
     * neper
     */
    public const REC20_NEPER = 'C50';

    /**
     * neper per second
     */
    public const REC20_NEPER_PER_SECOND = 'C51';

    /**
     * picometre
     */
    public const REC20_PICOMETRE = 'C52';

    /**
     * newton metre second
     */
    public const REC20_NEWTON_METRE_SECOND = 'C53';

    /**
     * newton metre squared per kilogram squared
     */
    public const REC20_NEWTON_METRE_SQUARED_PER_KILOGRAM_SQUARED = 'C54';

    /**
     * newton per square metre
     */
    public const REC20_NEWTON_PER_SQUARE_METRE = 'C55';

    /**
     * newton per square millimetre
     */
    public const REC20_NEWTON_PER_SQUARE_MILLIMETRE = 'C56';

    /**
     * newton second
     */
    public const REC20_NEWTON_SECOND = 'C57';

    /**
     * newton second per metre
     */
    public const REC20_NEWTON_SECOND_PER_METRE = 'C58';

    /**
     * octave
     */
    public const REC20_OCTAVE = 'C59';

    /**
     * ohm centimetre
     */
    public const REC20_OHM_CENTIMETRE = 'C60';

    /**
     * ohm metre
     */
    public const REC20_OHM_METRE = 'C61';

    /**
     * one
     */
    public const REC20_ONE = 'C62';

    /**
     * parsec
     */
    public const REC20_PARSEC = 'C63';

    /**
     * pascal per kelvin
     */
    public const REC20_PASCAL_PER_KELVIN = 'C64';

    /**
     * pascal second
     */
    public const REC20_PASCAL_SECOND = 'C65';

    /**
     * pascal second per cubic metre
     */
    public const REC20_PASCAL_SECOND_PER_CUBIC_METRE = 'C66';

    /**
     * pascal second per metre
     */
    public const REC20_PASCAL_SECOND_PER_METRE = 'C67';

    /**
     * petajoule
     */
    public const REC20_PETAJOULE = 'C68';

    /**
     * phon
     */
    public const REC20_PHON = 'C69';

    /**
     * centipoise
     */
    public const REC20_CENTIPOISE = 'C7';

    /**
     * picoampere
     */
    public const REC20_PICOAMPERE = 'C70';

    /**
     * picocoulomb
     */
    public const REC20_PICOCOULOMB = 'C71';

    /**
     * picofarad per metre
     */
    public const REC20_PICOFARAD_PER_METRE = 'C72';

    /**
     * picohenry
     */
    public const REC20_PICOHENRY = 'C73';

    /**
     * kilobit per second
     */
    public const REC20_KILOBIT_PER_SECOND = 'C74';

    /**
     * picowatt
     */
    public const REC20_PICOWATT = 'C75';

    /**
     * picowatt per square metre
     */
    public const REC20_PICOWATT_PER_SQUARE_METRE = 'C76';

    /**
     * pound-force
     */
    public const REC20_POUNDFORCE = 'C78';

    /**
     * kilovolt ampere hour
     */
    public const REC20_KILOVOLT_AMPERE_HOUR = 'C79';

    /**
     * millicoulomb per kilogram
     */
    public const REC20_MILLICOULOMB_PER_KILOGRAM = 'C8';

    /**
     * rad
     */
    public const REC20_RAD = 'C80';

    /**
     * radian
     */
    public const REC20_RADIAN = 'C81';

    /**
     * radian square metre per mole
     */
    public const REC20_RADIAN_SQUARE_METRE_PER_MOLE = 'C82';

    /**
     * radian square metre per kilogram
     */
    public const REC20_RADIAN_SQUARE_METRE_PER_KILOGRAM = 'C83';

    /**
     * radian per metre
     */
    public const REC20_RADIAN_PER_METRE = 'C84';

    /**
     * reciprocal angstrom
     */
    public const REC20_RECIPROCAL_ANGSTROM = 'C85';

    /**
     * reciprocal cubic metre
     */
    public const REC20_RECIPROCAL_CUBIC_METRE = 'C86';

    /**
     * reciprocal cubic metre per second
     */
    public const REC20_RECIPROCAL_CUBIC_METRE_PER_SECOND = 'C87';

    /**
     * reciprocal electron volt per cubic metre
     */
    public const REC20_RECIPROCAL_ELECTRON_VOLT_PER_CUBIC_METRE = 'C88';

    /**
     * reciprocal henry
     */
    public const REC20_RECIPROCAL_HENRY = 'C89';

    /**
     * coil group
     */
    public const REC20_COIL_GROUP = 'C9';

    /**
     * reciprocal joule per cubic metre
     */
    public const REC20_RECIPROCAL_JOULE_PER_CUBIC_METRE = 'C90';

    /**
     * reciprocal kelvin or kelvin to the power minus one
     */
    public const REC20_RECIPROCAL_KELVIN_OR_KELVIN_TO_THE_POWER_MINUS_ONE = 'C91';

    /**
     * reciprocal metre
     */
    public const REC20_RECIPROCAL_METRE = 'C92';

    /**
     * reciprocal square metre
     */
    public const REC20_RECIPROCAL_SQUARE_METRE = 'C93';

    /**
     * reciprocal minute
     */
    public const REC20_RECIPROCAL_MINUTE = 'C94';

    /**
     * reciprocal mole
     */
    public const REC20_RECIPROCAL_MOLE = 'C95';

    /**
     * reciprocal pascal or pascal to the power minus one
     */
    public const REC20_RECIPROCAL_PASCAL_OR_PASCAL_TO_THE_POWER_MINUS_ONE = 'C96';

    /**
     * reciprocal second
     */
    public const REC20_RECIPROCAL_SECOND = 'C97';

    /**
     * reciprocal second per metre squared
     */
    public const REC20_RECIPROCAL_SECOND_PER_METRE_SQUARED = 'C99';

    /**
     * carrying capacity in metric ton
     */
    public const REC20_CARRYING_CAPACITY_IN_METRIC_TON = 'CCT';

    /**
     * candela
     */
    public const REC20_CANDELA = 'CDL';

    /**
     * degree Celsius
     */
    public const REC20_DEGREE_CELSIUS = 'CEL';

    /**
     * hundred
     */
    public const REC20_HUNDRED = 'CEN';

    /**
     * card
     */
    public const REC20_CARD = 'CG';

    /**
     * centigram
     */
    public const REC20_CENTIGRAM = 'CGM';

    /**
     * coulomb per kilogram
     */
    public const REC20_COULOMB_PER_KILOGRAM = 'CKG';

    /**
     * hundred leave
     */
    public const REC20_HUNDRED_LEAVE = 'CLF';

    /**
     * centilitre
     */
    public const REC20_CENTILITRE = 'CLT';

    /**
     * square centimetre
     */
    public const REC20_SQUARE_CENTIMETRE = 'CMK';

    /**
     * cubic centimetre
     */
    public const REC20_CUBIC_CENTIMETRE = 'CMQ';

    /**
     * centimetre
     */
    public const REC20_CENTIMETRE = 'CMT';

    /**
     * hundred pack
     */
    public const REC20_HUNDRED_PACK = 'CNP';

    /**
     * cental (UK)
     */
    public const REC20_CENTAL_UK = 'CNT';

    /**
     * coulomb
     */
    public const REC20_COULOMB = 'COU';

    /**
     * content gram
     */
    public const REC20_CONTENT_GRAM = 'CTG';

    /**
     * metric carat
     */
    public const REC20_METRIC_CARAT = 'CTM';

    /**
     * content ton (metric)
     */
    public const REC20_CONTENT_TON_METRIC = 'CTN';

    /**
     * curie
     */
    public const REC20_CURIE = 'CUR';

    /**
     * hundred pound (cwt) / hundred weight (US)
     */
    public const REC20_HUNDRED_POUND_CWT___HUNDRED_WEIGHT_US = 'CWA';

    /**
     * hundred weight (UK)
     */
    public const REC20_HUNDRED_WEIGHT_UK = 'CWI';

    /**
     * kilowatt hour per hour
     */
    public const REC20_KILOWATT_HOUR_PER_HOUR = 'D03';

    /**
     * lot  [unit of weight]
     */
    public const REC20_LOT__UNIT_OF_WEIGHT = 'D04';

    /**
     * reciprocal second per steradian
     */
    public const REC20_RECIPROCAL_SECOND_PER_STERADIAN = 'D1';

    /**
     * siemens per metre
     */
    public const REC20_SIEMENS_PER_METRE = 'D10';

    /**
     * mebibit
     */
    public const REC20_MEBIBIT = 'D11';

    /**
     * siemens square metre per mole
     */
    public const REC20_SIEMENS_SQUARE_METRE_PER_MOLE = 'D12';

    /**
     * sievert
     */
    public const REC20_SIEVERT = 'D13';

    /**
     * sone
     */
    public const REC20_SONE = 'D15';

    /**
     * square centimetre per erg
     */
    public const REC20_SQUARE_CENTIMETRE_PER_ERG = 'D16';

    /**
     * square centimetre per steradian erg
     */
    public const REC20_SQUARE_CENTIMETRE_PER_STERADIAN_ERG = 'D17';

    /**
     * metre kelvin
     */
    public const REC20_METRE_KELVIN = 'D18';

    /**
     * square metre kelvin per watt
     */
    public const REC20_SQUARE_METRE_KELVIN_PER_WATT = 'D19';

    /**
     * reciprocal second per steradian metre squared
     */
    public const REC20_RECIPROCAL_SECOND_PER_STERADIAN_METRE_SQUARED = 'D2';

    /**
     * square metre per joule
     */
    public const REC20_SQUARE_METRE_PER_JOULE = 'D20';

    /**
     * square metre per kilogram
     */
    public const REC20_SQUARE_METRE_PER_KILOGRAM = 'D21';

    /**
     * square metre per mole
     */
    public const REC20_SQUARE_METRE_PER_MOLE = 'D22';

    /**
     * pen gram (protein)
     */
    public const REC20_PEN_GRAM_PROTEIN = 'D23';

    /**
     * square metre per steradian
     */
    public const REC20_SQUARE_METRE_PER_STERADIAN = 'D24';

    /**
     * square metre per steradian joule
     */
    public const REC20_SQUARE_METRE_PER_STERADIAN_JOULE = 'D25';

    /**
     * square metre per volt second
     */
    public const REC20_SQUARE_METRE_PER_VOLT_SECOND = 'D26';

    /**
     * steradian
     */
    public const REC20_STERADIAN = 'D27';

    /**
     * terahertz
     */
    public const REC20_TERAHERTZ = 'D29';

    /**
     * terajoule
     */
    public const REC20_TERAJOULE = 'D30';

    /**
     * terawatt
     */
    public const REC20_TERAWATT = 'D31';

    /**
     * terawatt hour
     */
    public const REC20_TERAWATT_HOUR = 'D32';

    /**
     * tesla
     */
    public const REC20_TESLA = 'D33';

    /**
     * tex
     */
    public const REC20_TEX = 'D34';

    /**
     * megabit
     */
    public const REC20_MEGABIT = 'D36';

    /**
     * tonne per cubic metre
     */
    public const REC20_TONNE_PER_CUBIC_METRE = 'D41';

    /**
     * tropical year
     */
    public const REC20_TROPICAL_YEAR = 'D42';

    /**
     * unified atomic mass unit
     */
    public const REC20_UNIFIED_ATOMIC_MASS_UNIT = 'D43';

    /**
     * var
     */
    public const REC20_VAR = 'D44';

    /**
     * volt squared per kelvin squared
     */
    public const REC20_VOLT_SQUARED_PER_KELVIN_SQUARED = 'D45';

    /**
     * volt - ampere
     */
    public const REC20_VOLT__AMPERE = 'D46';

    /**
     * volt per centimetre
     */
    public const REC20_VOLT_PER_CENTIMETRE = 'D47';

    /**
     * volt per kelvin
     */
    public const REC20_VOLT_PER_KELVIN = 'D48';

    /**
     * millivolt per kelvin
     */
    public const REC20_MILLIVOLT_PER_KELVIN = 'D49';

    /**
     * kilogram per square centimetre
     */
    public const REC20_KILOGRAM_PER_SQUARE_CENTIMETRE = 'D5';

    /**
     * volt per metre
     */
    public const REC20_VOLT_PER_METRE = 'D50';

    /**
     * volt per millimetre
     */
    public const REC20_VOLT_PER_MILLIMETRE = 'D51';

    /**
     * watt per kelvin
     */
    public const REC20_WATT_PER_KELVIN = 'D52';

    /**
     * watt per metre kelvin
     */
    public const REC20_WATT_PER_METRE_KELVIN = 'D53';

    /**
     * watt per square metre
     */
    public const REC20_WATT_PER_SQUARE_METRE = 'D54';

    /**
     * watt per square metre kelvin
     */
    public const REC20_WATT_PER_SQUARE_METRE_KELVIN = 'D55';

    /**
     * watt per square metre kelvin to the fourth power
     */
    public const REC20_WATT_PER_SQUARE_METRE_KELVIN_TO_THE_FOURTH_POWER = 'D56';

    /**
     * watt per steradian
     */
    public const REC20_WATT_PER_STERADIAN = 'D57';

    /**
     * watt per steradian square metre
     */
    public const REC20_WATT_PER_STERADIAN_SQUARE_METRE = 'D58';

    /**
     * weber per metre
     */
    public const REC20_WEBER_PER_METRE = 'D59';

    /**
     * roentgen per second
     */
    public const REC20_ROENTGEN_PER_SECOND = 'D6';

    /**
     * weber per millimetre
     */
    public const REC20_WEBER_PER_MILLIMETRE = 'D60';

    /**
     * minute [unit of angle]
     */
    public const REC20_MINUTE_UNIT_OF_ANGLE = 'D61';

    /**
     * second [unit of angle]
     */
    public const REC20_SECOND_UNIT_OF_ANGLE = 'D62';

    /**
     * book
     */
    public const REC20_BOOK = 'D63';

    /**
     * round
     */
    public const REC20_ROUND = 'D65';

    /**
     * number of words
     */
    public const REC20_NUMBER_OF_WORDS = 'D68';

    /**
     * inch to the fourth power
     */
    public const REC20_INCH_TO_THE_FOURTH_POWER = 'D69';

    /**
     * joule square metre
     */
    public const REC20_JOULE_SQUARE_METRE = 'D73';

    /**
     * kilogram per mole
     */
    public const REC20_KILOGRAM_PER_MOLE = 'D74';

    /**
     * megacoulomb
     */
    public const REC20_MEGACOULOMB = 'D77';

    /**
     * megajoule per second
     */
    public const REC20_MEGAJOULE_PER_SECOND = 'D78';

    /**
     * microwatt
     */
    public const REC20_MICROWATT = 'D80';

    /**
     * microtesla
     */
    public const REC20_MICROTESLA = 'D81';

    /**
     * microvolt
     */
    public const REC20_MICROVOLT = 'D82';

    /**
     * millinewton metre
     */
    public const REC20_MILLINEWTON_METRE = 'D83';

    /**
     * microwatt per square metre
     */
    public const REC20_MICROWATT_PER_SQUARE_METRE = 'D85';

    /**
     * millicoulomb
     */
    public const REC20_MILLICOULOMB = 'D86';

    /**
     * millimole per kilogram
     */
    public const REC20_MILLIMOLE_PER_KILOGRAM = 'D87';

    /**
     * millicoulomb per cubic metre
     */
    public const REC20_MILLICOULOMB_PER_CUBIC_METRE = 'D88';

    /**
     * millicoulomb per square metre
     */
    public const REC20_MILLICOULOMB_PER_SQUARE_METRE = 'D89';

    /**
     * rem
     */
    public const REC20_REM = 'D91';

    /**
     * second per cubic metre
     */
    public const REC20_SECOND_PER_CUBIC_METRE = 'D93';

    /**
     * second per cubic metre radian
     */
    public const REC20_SECOND_PER_CUBIC_METRE_RADIAN = 'D94';

    /**
     * joule per gram
     */
    public const REC20_JOULE_PER_GRAM = 'D95';

    /**
     * decare
     */
    public const REC20_DECARE = 'DAA';

    /**
     * ten day
     */
    public const REC20_TEN_DAY = 'DAD';

    /**
     * day
     */
    public const REC20_DAY = 'DAY';

    /**
     * dry pound
     */
    public const REC20_DRY_POUND = 'DB';

    /**
     * degree [unit of angle]
     */
    public const REC20_DEGREE_UNIT_OF_ANGLE = 'DD';

    /**
     * decade
     */
    public const REC20_DECADE = 'DEC';

    /**
     * decigram
     */
    public const REC20_DECIGRAM = 'DG';

    /**
     * decagram
     */
    public const REC20_DECAGRAM = 'DJ';

    /**
     * decilitre
     */
    public const REC20_DECILITRE = 'DLT';

    /**
     * cubic decametre
     */
    public const REC20_CUBIC_DECAMETRE = 'DMA';

    /**
     * square decimetre
     */
    public const REC20_SQUARE_DECIMETRE = 'DMK';

    /**
     * standard kilolitre
     */
    public const REC20_STANDARD_KILOLITRE = 'DMO';

    /**
     * cubic decimetre
     */
    public const REC20_CUBIC_DECIMETRE = 'DMQ';

    /**
     * decimetre
     */
    public const REC20_DECIMETRE = 'DMT';

    /**
     * decinewton metre
     */
    public const REC20_DECINEWTON_METRE = 'DN';

    /**
     * dozen piece
     */
    public const REC20_DOZEN_PIECE = 'DPC';

    /**
     * dozen pair
     */
    public const REC20_DOZEN_PAIR = 'DPR';

    /**
     * displacement tonnage
     */
    public const REC20_DISPLACEMENT_TONNAGE = 'DPT';

    /**
     * dram (US)
     */
    public const REC20_DRAM_US = 'DRA';

    /**
     * dram (UK)
     */
    public const REC20_DRAM_UK = 'DRI';

    /**
     * dozen roll
     */
    public const REC20_DOZEN_ROLL = 'DRL';

    /**
     * dry ton
     */
    public const REC20_DRY_TON = 'DT';

    /**
     * decitonne
     */
    public const REC20_DECITONNE = 'DTN';

    /**
     * pennyweight
     */
    public const REC20_PENNYWEIGHT = 'DWT';

    /**
     * dozen
     */
    public const REC20_DOZEN = 'DZN';

    /**
     * dozen pack
     */
    public const REC20_DOZEN_PACK = 'DZP';

    /**
     * newton per square centimetre
     */
    public const REC20_NEWTON_PER_SQUARE_CENTIMETRE = 'E01';

    /**
     * megawatt hour per hour
     */
    public const REC20_MEGAWATT_HOUR_PER_HOUR = 'E07';

    /**
     * megawatt per hertz
     */
    public const REC20_MEGAWATT_PER_HERTZ = 'E08';

    /**
     * milliampere hour
     */
    public const REC20_MILLIAMPERE_HOUR = 'E09';

    /**
     * degree day
     */
    public const REC20_DEGREE_DAY = 'E10';

    /**
     * mille
     */
    public const REC20_MILLE = 'E12';

    /**
     * kilocalorie (international table)
     */
    public const REC20_KILOCALORIE_INTERNATIONAL_TABLE = 'E14';

    /**
     * kilocalorie (thermochemical) per hour
     */
    public const REC20_KILOCALORIE_THERMOCHEMICAL_PER_HOUR = 'E15';

    /**
     * million Btu(IT) per hour
     */
    public const REC20_MILLION_BTUIT_PER_HOUR = 'E16';

    /**
     * cubic foot per second
     */
    public const REC20_CUBIC_FOOT_PER_SECOND = 'E17';

    /**
     * tonne per hour
     */
    public const REC20_TONNE_PER_HOUR = 'E18';

    /**
     * ping
     */
    public const REC20_PING = 'E19';

    /**
     * megabit per second
     */
    public const REC20_MEGABIT_PER_SECOND = 'E20';

    /**
     * shares
     */
    public const REC20_SHARES = 'E21';

    /**
     * TEU
     */
    public const REC20_TEU = 'E22';

    /**
     * tyre
     */
    public const REC20_TYRE = 'E23';

    /**
     * active unit
     */
    public const REC20_ACTIVE_UNIT = 'E25';

    /**
     * dose
     */
    public const REC20_DOSE = 'E27';

    /**
     * air dry ton
     */
    public const REC20_AIR_DRY_TON = 'E28';

    /**
     * strand
     */
    public const REC20_STRAND = 'E30';

    /**
     * square metre per litre
     */
    public const REC20_SQUARE_METRE_PER_LITRE = 'E31';

    /**
     * litre per hour
     */
    public const REC20_LITRE_PER_HOUR = 'E32';

    /**
     * foot per thousand
     */
    public const REC20_FOOT_PER_THOUSAND = 'E33';

    /**
     * gigabyte
     */
    public const REC20_GIGABYTE = 'E34';

    /**
     * terabyte
     */
    public const REC20_TERABYTE = 'E35';

    /**
     * petabyte
     */
    public const REC20_PETABYTE = 'E36';

    /**
     * pixel
     */
    public const REC20_PIXEL = 'E37';

    /**
     * megapixel
     */
    public const REC20_MEGAPIXEL = 'E38';

    /**
     * dots per inch
     */
    public const REC20_DOTS_PER_INCH = 'E39';

    /**
     * gross kilogram
     */
    public const REC20_GROSS_KILOGRAM = 'E4';

    /**
     * part per hundred thousand
     */
    public const REC20_PART_PER_HUNDRED_THOUSAND = 'E40';

    /**
     * kilogram-force per square millimetre
     */
    public const REC20_KILOGRAMFORCE_PER_SQUARE_MILLIMETRE = 'E41';

    /**
     * kilogram-force per square centimetre
     */
    public const REC20_KILOGRAMFORCE_PER_SQUARE_CENTIMETRE = 'E42';

    /**
     * joule per square centimetre
     */
    public const REC20_JOULE_PER_SQUARE_CENTIMETRE = 'E43';

    /**
     * kilogram-force metre per square centimetre
     */
    public const REC20_KILOGRAMFORCE_METRE_PER_SQUARE_CENTIMETRE = 'E44';

    /**
     * milliohm
     */
    public const REC20_MILLIOHM = 'E45';

    /**
     * kilowatt hour per cubic metre
     */
    public const REC20_KILOWATT_HOUR_PER_CUBIC_METRE = 'E46';

    /**
     * kilowatt hour per kelvin
     */
    public const REC20_KILOWATT_HOUR_PER_KELVIN = 'E47';

    /**
     * service unit
     */
    public const REC20_SERVICE_UNIT = 'E48';

    /**
     * working day
     */
    public const REC20_WORKING_DAY = 'E49';

    /**
     * accounting unit
     */
    public const REC20_ACCOUNTING_UNIT = 'E50';

    /**
     * job
     */
    public const REC20_JOB = 'E51';

    /**
     * run foot
     */
    public const REC20_RUN_FOOT = 'E52';

    /**
     * test
     */
    public const REC20_TEST = 'E53';

    /**
     * trip
     */
    public const REC20_TRIP = 'E54';

    /**
     * use
     */
    public const REC20_USE = 'E55';

    /**
     * well
     */
    public const REC20_WELL = 'E56';

    /**
     * zone
     */
    public const REC20_ZONE = 'E57';

    /**
     * exabit per second
     */
    public const REC20_EXABIT_PER_SECOND = 'E58';

    /**
     * exbibyte
     */
    public const REC20_EXBIBYTE = 'E59';

    /**
     * pebibyte
     */
    public const REC20_PEBIBYTE = 'E60';

    /**
     * tebibyte
     */
    public const REC20_TEBIBYTE = 'E61';

    /**
     * gibibyte
     */
    public const REC20_GIBIBYTE = 'E62';

    /**
     * mebibyte
     */
    public const REC20_MEBIBYTE = 'E63';

    /**
     * kibibyte
     */
    public const REC20_KIBIBYTE = 'E64';

    /**
     * exbibit per metre
     */
    public const REC20_EXBIBIT_PER_METRE = 'E65';

    /**
     * exbibit per square metre
     */
    public const REC20_EXBIBIT_PER_SQUARE_METRE = 'E66';

    /**
     * exbibit per cubic metre
     */
    public const REC20_EXBIBIT_PER_CUBIC_METRE = 'E67';

    /**
     * gigabyte per second
     */
    public const REC20_GIGABYTE_PER_SECOND = 'E68';

    /**
     * gibibit per metre
     */
    public const REC20_GIBIBIT_PER_METRE = 'E69';

    /**
     * gibibit per square metre
     */
    public const REC20_GIBIBIT_PER_SQUARE_METRE = 'E70';

    /**
     * gibibit per cubic metre
     */
    public const REC20_GIBIBIT_PER_CUBIC_METRE = 'E71';

    /**
     * kibibit per metre
     */
    public const REC20_KIBIBIT_PER_METRE = 'E72';

    /**
     * kibibit per square metre
     */
    public const REC20_KIBIBIT_PER_SQUARE_METRE = 'E73';

    /**
     * kibibit per cubic metre
     */
    public const REC20_KIBIBIT_PER_CUBIC_METRE = 'E74';

    /**
     * mebibit per metre
     */
    public const REC20_MEBIBIT_PER_METRE = 'E75';

    /**
     * mebibit per square metre
     */
    public const REC20_MEBIBIT_PER_SQUARE_METRE = 'E76';

    /**
     * mebibit per cubic metre
     */
    public const REC20_MEBIBIT_PER_CUBIC_METRE = 'E77';

    /**
     * petabit
     */
    public const REC20_PETABIT = 'E78';

    /**
     * petabit per second
     */
    public const REC20_PETABIT_PER_SECOND = 'E79';

    /**
     * pebibit per metre
     */
    public const REC20_PEBIBIT_PER_METRE = 'E80';

    /**
     * pebibit per square metre
     */
    public const REC20_PEBIBIT_PER_SQUARE_METRE = 'E81';

    /**
     * pebibit per cubic metre
     */
    public const REC20_PEBIBIT_PER_CUBIC_METRE = 'E82';

    /**
     * terabit
     */
    public const REC20_TERABIT = 'E83';

    /**
     * terabit per second
     */
    public const REC20_TERABIT_PER_SECOND = 'E84';

    /**
     * tebibit per metre
     */
    public const REC20_TEBIBIT_PER_METRE = 'E85';

    /**
     * tebibit per cubic metre
     */
    public const REC20_TEBIBIT_PER_CUBIC_METRE = 'E86';

    /**
     * tebibit per square metre
     */
    public const REC20_TEBIBIT_PER_SQUARE_METRE = 'E87';

    /**
     * bit per metre
     */
    public const REC20_BIT_PER_METRE = 'E88';

    /**
     * bit per square metre
     */
    public const REC20_BIT_PER_SQUARE_METRE = 'E89';

    /**
     * reciprocal centimetre
     */
    public const REC20_RECIPROCAL_CENTIMETRE = 'E90';

    /**
     * reciprocal day
     */
    public const REC20_RECIPROCAL_DAY = 'E91';

    /**
     * cubic decimetre per hour
     */
    public const REC20_CUBIC_DECIMETRE_PER_HOUR = 'E92';

    /**
     * kilogram per hour
     */
    public const REC20_KILOGRAM_PER_HOUR = 'E93';

    /**
     * kilomole per second
     */
    public const REC20_KILOMOLE_PER_SECOND = 'E94';

    /**
     * mole per second
     */
    public const REC20_MOLE_PER_SECOND = 'E95';

    /**
     * degree per second
     */
    public const REC20_DEGREE_PER_SECOND = 'E96';

    /**
     * millimetre per degree Celcius metre
     */
    public const REC20_MILLIMETRE_PER_DEGREE_CELCIUS_METRE = 'E97';

    /**
     * degree Celsius per kelvin
     */
    public const REC20_DEGREE_CELSIUS_PER_KELVIN = 'E98';

    /**
     * hectopascal per bar
     */
    public const REC20_HECTOPASCAL_PER_BAR = 'E99';

    /**
     * each
     */
    public const REC20_EACH = 'EA';

    /**
     * electronic mail box
     */
    public const REC20_ELECTRONIC_MAIL_BOX = 'EB';

    /**
     * equivalent gallon
     */
    public const REC20_EQUIVALENT_GALLON = 'EQ';

    /**
     * bit per cubic metre
     */
    public const REC20_BIT_PER_CUBIC_METRE = 'F01';

    /**
     * kelvin per kelvin
     */
    public const REC20_KELVIN_PER_KELVIN = 'F02';

    /**
     * kilopascal per bar
     */
    public const REC20_KILOPASCAL_PER_BAR = 'F03';

    /**
     * millibar per bar
     */
    public const REC20_MILLIBAR_PER_BAR = 'F04';

    /**
     * megapascal per bar
     */
    public const REC20_MEGAPASCAL_PER_BAR = 'F05';

    /**
     * poise per bar
     */
    public const REC20_POISE_PER_BAR = 'F06';

    /**
     * pascal per bar
     */
    public const REC20_PASCAL_PER_BAR = 'F07';

    /**
     * milliampere per inch
     */
    public const REC20_MILLIAMPERE_PER_INCH = 'F08';

    /**
     * kelvin per hour
     */
    public const REC20_KELVIN_PER_HOUR = 'F10';

    /**
     * kelvin per minute
     */
    public const REC20_KELVIN_PER_MINUTE = 'F11';

    /**
     * kelvin per second
     */
    public const REC20_KELVIN_PER_SECOND = 'F12';

    /**
     * slug
     */
    public const REC20_SLUG = 'F13';

    /**
     * gram per kelvin
     */
    public const REC20_GRAM_PER_KELVIN = 'F14';

    /**
     * kilogram per kelvin
     */
    public const REC20_KILOGRAM_PER_KELVIN = 'F15';

    /**
     * milligram per kelvin
     */
    public const REC20_MILLIGRAM_PER_KELVIN = 'F16';

    /**
     * pound-force per foot
     */
    public const REC20_POUNDFORCE_PER_FOOT = 'F17';

    /**
     * kilogram square centimetre
     */
    public const REC20_KILOGRAM_SQUARE_CENTIMETRE = 'F18';

    /**
     * kilogram square millimetre
     */
    public const REC20_KILOGRAM_SQUARE_MILLIMETRE = 'F19';

    /**
     * pound inch squared
     */
    public const REC20_POUND_INCH_SQUARED = 'F20';

    /**
     * pound-force inch
     */
    public const REC20_POUNDFORCE_INCH = 'F21';

    /**
     * pound-force foot per ampere
     */
    public const REC20_POUNDFORCE_FOOT_PER_AMPERE = 'F22';

    /**
     * gram per cubic decimetre
     */
    public const REC20_GRAM_PER_CUBIC_DECIMETRE = 'F23';

    /**
     * kilogram per kilomol
     */
    public const REC20_KILOGRAM_PER_KILOMOL = 'F24';

    /**
     * gram per hertz
     */
    public const REC20_GRAM_PER_HERTZ = 'F25';

    /**
     * gram per day
     */
    public const REC20_GRAM_PER_DAY = 'F26';

    /**
     * gram per hour
     */
    public const REC20_GRAM_PER_HOUR = 'F27';

    /**
     * gram per minute
     */
    public const REC20_GRAM_PER_MINUTE = 'F28';

    /**
     * gram per second
     */
    public const REC20_GRAM_PER_SECOND = 'F29';

    /**
     * kilogram per day
     */
    public const REC20_KILOGRAM_PER_DAY = 'F30';

    /**
     * kilogram per minute
     */
    public const REC20_KILOGRAM_PER_MINUTE = 'F31';

    /**
     * milligram per day
     */
    public const REC20_MILLIGRAM_PER_DAY = 'F32';

    /**
     * milligram per minute
     */
    public const REC20_MILLIGRAM_PER_MINUTE = 'F33';

    /**
     * milligram per second
     */
    public const REC20_MILLIGRAM_PER_SECOND = 'F34';

    /**
     * gram per day kelvin
     */
    public const REC20_GRAM_PER_DAY_KELVIN = 'F35';

    /**
     * gram per hour kelvin
     */
    public const REC20_GRAM_PER_HOUR_KELVIN = 'F36';

    /**
     * gram per minute kelvin
     */
    public const REC20_GRAM_PER_MINUTE_KELVIN = 'F37';

    /**
     * gram per second kelvin
     */
    public const REC20_GRAM_PER_SECOND_KELVIN = 'F38';

    /**
     * kilogram per day kelvin
     */
    public const REC20_KILOGRAM_PER_DAY_KELVIN = 'F39';

    /**
     * kilogram per hour kelvin
     */
    public const REC20_KILOGRAM_PER_HOUR_KELVIN = 'F40';

    /**
     * kilogram per minute kelvin
     */
    public const REC20_KILOGRAM_PER_MINUTE_KELVIN = 'F41';

    /**
     * kilogram per second kelvin
     */
    public const REC20_KILOGRAM_PER_SECOND_KELVIN = 'F42';

    /**
     * milligram per day kelvin
     */
    public const REC20_MILLIGRAM_PER_DAY_KELVIN = 'F43';

    /**
     * milligram per hour kelvin
     */
    public const REC20_MILLIGRAM_PER_HOUR_KELVIN = 'F44';

    /**
     * milligram per minute kelvin
     */
    public const REC20_MILLIGRAM_PER_MINUTE_KELVIN = 'F45';

    /**
     * milligram per second kelvin
     */
    public const REC20_MILLIGRAM_PER_SECOND_KELVIN = 'F46';

    /**
     * newton per millimetre
     */
    public const REC20_NEWTON_PER_MILLIMETRE = 'F47';

    /**
     * pound-force per inch
     */
    public const REC20_POUNDFORCE_PER_INCH = 'F48';

    /**
     * rod [unit of distance]
     */
    public const REC20_ROD_UNIT_OF_DISTANCE = 'F49';

    /**
     * micrometre per kelvin
     */
    public const REC20_MICROMETRE_PER_KELVIN = 'F50';

    /**
     * centimetre per kelvin
     */
    public const REC20_CENTIMETRE_PER_KELVIN = 'F51';

    /**
     * metre per kelvin
     */
    public const REC20_METRE_PER_KELVIN = 'F52';

    /**
     * millimetre per kelvin
     */
    public const REC20_MILLIMETRE_PER_KELVIN = 'F53';

    /**
     * milliohm per metre
     */
    public const REC20_MILLIOHM_PER_METRE = 'F54';

    /**
     * ohm per mile (statute mile)
     */
    public const REC20_OHM_PER_MILE_STATUTE_MILE = 'F55';

    /**
     * ohm per kilometre
     */
    public const REC20_OHM_PER_KILOMETRE = 'F56';

    /**
     * milliampere per pound-force per square inch
     */
    public const REC20_MILLIAMPERE_PER_POUNDFORCE_PER_SQUARE_INCH = 'F57';

    /**
     * reciprocal bar
     */
    public const REC20_RECIPROCAL_BAR = 'F58';

    /**
     * milliampere per bar
     */
    public const REC20_MILLIAMPERE_PER_BAR = 'F59';

    /**
     * degree Celsius per bar
     */
    public const REC20_DEGREE_CELSIUS_PER_BAR = 'F60';

    /**
     * kelvin per bar
     */
    public const REC20_KELVIN_PER_BAR = 'F61';

    /**
     * gram per day bar
     */
    public const REC20_GRAM_PER_DAY_BAR = 'F62';

    /**
     * gram per hour bar
     */
    public const REC20_GRAM_PER_HOUR_BAR = 'F63';

    /**
     * gram per minute bar
     */
    public const REC20_GRAM_PER_MINUTE_BAR = 'F64';

    /**
     * gram per second bar
     */
    public const REC20_GRAM_PER_SECOND_BAR = 'F65';

    /**
     * kilogram per day bar
     */
    public const REC20_KILOGRAM_PER_DAY_BAR = 'F66';

    /**
     * kilogram per hour bar
     */
    public const REC20_KILOGRAM_PER_HOUR_BAR = 'F67';

    /**
     * kilogram per minute bar
     */
    public const REC20_KILOGRAM_PER_MINUTE_BAR = 'F68';

    /**
     * kilogram per second bar
     */
    public const REC20_KILOGRAM_PER_SECOND_BAR = 'F69';

    /**
     * milligram per day bar
     */
    public const REC20_MILLIGRAM_PER_DAY_BAR = 'F70';

    /**
     * milligram per hour bar
     */
    public const REC20_MILLIGRAM_PER_HOUR_BAR = 'F71';

    /**
     * milligram per minute bar
     */
    public const REC20_MILLIGRAM_PER_MINUTE_BAR = 'F72';

    /**
     * milligram per second bar
     */
    public const REC20_MILLIGRAM_PER_SECOND_BAR = 'F73';

    /**
     * gram per bar
     */
    public const REC20_GRAM_PER_BAR = 'F74';

    /**
     * milligram per bar
     */
    public const REC20_MILLIGRAM_PER_BAR = 'F75';

    /**
     * milliampere per millimetre
     */
    public const REC20_MILLIAMPERE_PER_MILLIMETRE = 'F76';

    /**
     * pascal second per kelvin
     */
    public const REC20_PASCAL_SECOND_PER_KELVIN = 'F77';

    /**
     * inch of water
     */
    public const REC20_INCH_OF_WATER = 'F78';

    /**
     * inch of mercury
     */
    public const REC20_INCH_OF_MERCURY = 'F79';

    /**
     * water horse power
     */
    public const REC20_WATER_HORSE_POWER = 'F80';

    /**
     * bar per kelvin
     */
    public const REC20_BAR_PER_KELVIN = 'F81';

    /**
     * hectopascal per kelvin
     */
    public const REC20_HECTOPASCAL_PER_KELVIN = 'F82';

    /**
     * kilopascal per kelvin
     */
    public const REC20_KILOPASCAL_PER_KELVIN = 'F83';

    /**
     * millibar per kelvin
     */
    public const REC20_MILLIBAR_PER_KELVIN = 'F84';

    /**
     * megapascal per kelvin
     */
    public const REC20_MEGAPASCAL_PER_KELVIN = 'F85';

    /**
     * poise per kelvin
     */
    public const REC20_POISE_PER_KELVIN = 'F86';

    /**
     * volt per litre minute
     */
    public const REC20_VOLT_PER_LITRE_MINUTE = 'F87';

    /**
     * newton centimetre
     */
    public const REC20_NEWTON_CENTIMETRE = 'F88';

    /**
     * newton metre per degree
     */
    public const REC20_NEWTON_METRE_PER_DEGREE = 'F89';

    /**
     * newton metre per ampere
     */
    public const REC20_NEWTON_METRE_PER_AMPERE = 'F90';

    /**
     * bar litre per second
     */
    public const REC20_BAR_LITRE_PER_SECOND = 'F91';

    /**
     * bar cubic metre per second
     */
    public const REC20_BAR_CUBIC_METRE_PER_SECOND = 'F92';

    /**
     * hectopascal litre per second
     */
    public const REC20_HECTOPASCAL_LITRE_PER_SECOND = 'F93';

    /**
     * hectopascal cubic metre per second
     */
    public const REC20_HECTOPASCAL_CUBIC_METRE_PER_SECOND = 'F94';

    /**
     * millibar litre per second
     */
    public const REC20_MILLIBAR_LITRE_PER_SECOND = 'F95';

    /**
     * millibar cubic metre per second
     */
    public const REC20_MILLIBAR_CUBIC_METRE_PER_SECOND = 'F96';

    /**
     * megapascal litre per second
     */
    public const REC20_MEGAPASCAL_LITRE_PER_SECOND = 'F97';

    /**
     * megapascal cubic metre per second
     */
    public const REC20_MEGAPASCAL_CUBIC_METRE_PER_SECOND = 'F98';

    /**
     * pascal litre per second
     */
    public const REC20_PASCAL_LITRE_PER_SECOND = 'F99';

    /**
     * degree Fahrenheit
     */
    public const REC20_DEGREE_FAHRENHEIT = 'FAH';

    /**
     * farad
     */
    public const REC20_FARAD = 'FAR';

    /**
     * fibre metre
     */
    public const REC20_FIBRE_METRE = 'FBM';

    /**
     * thousand cubic foot
     */
    public const REC20_THOUSAND_CUBIC_FOOT = 'FC';

    /**
     * hundred cubic metre
     */
    public const REC20_HUNDRED_CUBIC_METRE = 'FF';

    /**
     * micromole
     */
    public const REC20_MICROMOLE = 'FH';

    /**
     * failures in time
     */
    public const REC20_FAILURES_IN_TIME = 'FIT';

    /**
     * flake ton
     */
    public const REC20_FLAKE_TON = 'FL';

    /**
     * foot
     */
    public const REC20_FOOT = 'FOT';

    /**
     * pound per square foot
     */
    public const REC20_POUND_PER_SQUARE_FOOT = 'FP';

    /**
     * foot per minute
     */
    public const REC20_FOOT_PER_MINUTE = 'FR';

    /**
     * foot per second
     */
    public const REC20_FOOT_PER_SECOND = 'FS';

    /**
     * square foot
     */
    public const REC20_SQUARE_FOOT = 'FTK';

    /**
     * cubic foot
     */
    public const REC20_CUBIC_FOOT = 'FTQ';

    /**
     * pascal cubic metre per second
     */
    public const REC20_PASCAL_CUBIC_METRE_PER_SECOND = 'G01';

    /**
     * centimetre per bar
     */
    public const REC20_CENTIMETRE_PER_BAR = 'G04';

    /**
     * metre per bar
     */
    public const REC20_METRE_PER_BAR = 'G05';

    /**
     * millimetre per bar
     */
    public const REC20_MILLIMETRE_PER_BAR = 'G06';

    /**
     * square inch per second
     */
    public const REC20_SQUARE_INCH_PER_SECOND = 'G08';

    /**
     * square metre per second kelvin
     */
    public const REC20_SQUARE_METRE_PER_SECOND_KELVIN = 'G09';

    /**
     * stokes per kelvin
     */
    public const REC20_STOKES_PER_KELVIN = 'G10';

    /**
     * gram per cubic centimetre bar
     */
    public const REC20_GRAM_PER_CUBIC_CENTIMETRE_BAR = 'G11';

    /**
     * gram per cubic decimetre bar
     */
    public const REC20_GRAM_PER_CUBIC_DECIMETRE_BAR = 'G12';

    /**
     * gram per litre bar
     */
    public const REC20_GRAM_PER_LITRE_BAR = 'G13';

    /**
     * gram per cubic metre bar
     */
    public const REC20_GRAM_PER_CUBIC_METRE_BAR = 'G14';

    /**
     * gram per millilitre bar
     */
    public const REC20_GRAM_PER_MILLILITRE_BAR = 'G15';

    /**
     * kilogram per cubic centimetre bar
     */
    public const REC20_KILOGRAM_PER_CUBIC_CENTIMETRE_BAR = 'G16';

    /**
     * kilogram per litre bar
     */
    public const REC20_KILOGRAM_PER_LITRE_BAR = 'G17';

    /**
     * kilogram per cubic metre bar
     */
    public const REC20_KILOGRAM_PER_CUBIC_METRE_BAR = 'G18';

    /**
     * newton metre per kilogram
     */
    public const REC20_NEWTON_METRE_PER_KILOGRAM = 'G19';

    /**
     * US gallon per minute
     */
    public const REC20_US_GALLON_PER_MINUTE = 'G2';

    /**
     * pound-force foot per pound
     */
    public const REC20_POUNDFORCE_FOOT_PER_POUND = 'G20';

    /**
     * cup [unit of volume]
     */
    public const REC20_CUP_UNIT_OF_VOLUME = 'G21';

    /**
     * peck
     */
    public const REC20_PECK = 'G23';

    /**
     * tablespoon (US)
     */
    public const REC20_TABLESPOON_US = 'G24';

    /**
     * teaspoon (US)
     */
    public const REC20_TEASPOON_US = 'G25';

    /**
     * stere
     */
    public const REC20_STERE = 'G26';

    /**
     * cubic centimetre per kelvin
     */
    public const REC20_CUBIC_CENTIMETRE_PER_KELVIN = 'G27';

    /**
     * litre per kelvin
     */
    public const REC20_LITRE_PER_KELVIN = 'G28';

    /**
     * cubic metre per kelvin
     */
    public const REC20_CUBIC_METRE_PER_KELVIN = 'G29';

    /**
     * Imperial gallon per minute
     */
    public const REC20_IMPERIAL_GALLON_PER_MINUTE = 'G3';

    /**
     * millilitre per kelvin
     */
    public const REC20_MILLILITRE_PER_KELVIN = 'G30';

    /**
     * kilogram per cubic centimetre
     */
    public const REC20_KILOGRAM_PER_CUBIC_CENTIMETRE = 'G31';

    /**
     * ounce (avoirdupois) per cubic yard
     */
    public const REC20_OUNCE_AVOIRDUPOIS_PER_CUBIC_YARD = 'G32';

    /**
     * gram per cubic centimetre kelvin
     */
    public const REC20_GRAM_PER_CUBIC_CENTIMETRE_KELVIN = 'G33';

    /**
     * gram per cubic decimetre kelvin
     */
    public const REC20_GRAM_PER_CUBIC_DECIMETRE_KELVIN = 'G34';

    /**
     * gram per litre kelvin
     */
    public const REC20_GRAM_PER_LITRE_KELVIN = 'G35';

    /**
     * gram per cubic metre kelvin
     */
    public const REC20_GRAM_PER_CUBIC_METRE_KELVIN = 'G36';

    /**
     * gram per millilitre kelvin
     */
    public const REC20_GRAM_PER_MILLILITRE_KELVIN = 'G37';

    /**
     * kilogram per cubic centimetre kelvin
     */
    public const REC20_KILOGRAM_PER_CUBIC_CENTIMETRE_KELVIN = 'G38';

    /**
     * kilogram per litre kelvin
     */
    public const REC20_KILOGRAM_PER_LITRE_KELVIN = 'G39';

    /**
     * kilogram per cubic metre kelvin
     */
    public const REC20_KILOGRAM_PER_CUBIC_METRE_KELVIN = 'G40';

    /**
     * square metre per second bar
     */
    public const REC20_SQUARE_METRE_PER_SECOND_BAR = 'G41';

    /**
     * microsiemens per centimetre
     */
    public const REC20_MICROSIEMENS_PER_CENTIMETRE = 'G42';

    /**
     * microsiemens per metre
     */
    public const REC20_MICROSIEMENS_PER_METRE = 'G43';

    /**
     * nanosiemens per centimetre
     */
    public const REC20_NANOSIEMENS_PER_CENTIMETRE = 'G44';

    /**
     * nanosiemens per metre
     */
    public const REC20_NANOSIEMENS_PER_METRE = 'G45';

    /**
     * stokes per bar
     */
    public const REC20_STOKES_PER_BAR = 'G46';

    /**
     * cubic centimetre per day
     */
    public const REC20_CUBIC_CENTIMETRE_PER_DAY = 'G47';

    /**
     * cubic centimetre per hour
     */
    public const REC20_CUBIC_CENTIMETRE_PER_HOUR = 'G48';

    /**
     * cubic centimetre per minute
     */
    public const REC20_CUBIC_CENTIMETRE_PER_MINUTE = 'G49';

    /**
     * gallon (US) per hour
     */
    public const REC20_GALLON_US_PER_HOUR = 'G50';

    /**
     * litre per second
     */
    public const REC20_LITRE_PER_SECOND = 'G51';

    /**
     * cubic metre per day
     */
    public const REC20_CUBIC_METRE_PER_DAY = 'G52';

    /**
     * cubic metre per minute
     */
    public const REC20_CUBIC_METRE_PER_MINUTE = 'G53';

    /**
     * millilitre per day
     */
    public const REC20_MILLILITRE_PER_DAY = 'G54';

    /**
     * millilitre per hour
     */
    public const REC20_MILLILITRE_PER_HOUR = 'G55';

    /**
     * cubic inch per hour
     */
    public const REC20_CUBIC_INCH_PER_HOUR = 'G56';

    /**
     * cubic inch per minute
     */
    public const REC20_CUBIC_INCH_PER_MINUTE = 'G57';

    /**
     * cubic inch per second
     */
    public const REC20_CUBIC_INCH_PER_SECOND = 'G58';

    /**
     * milliampere per litre minute
     */
    public const REC20_MILLIAMPERE_PER_LITRE_MINUTE = 'G59';

    /**
     * volt per bar
     */
    public const REC20_VOLT_PER_BAR = 'G60';

    /**
     * cubic centimetre per day kelvin
     */
    public const REC20_CUBIC_CENTIMETRE_PER_DAY_KELVIN = 'G61';

    /**
     * cubic centimetre per hour kelvin
     */
    public const REC20_CUBIC_CENTIMETRE_PER_HOUR_KELVIN = 'G62';

    /**
     * cubic centimetre per minute kelvin
     */
    public const REC20_CUBIC_CENTIMETRE_PER_MINUTE_KELVIN = 'G63';

    /**
     * cubic centimetre per second kelvin
     */
    public const REC20_CUBIC_CENTIMETRE_PER_SECOND_KELVIN = 'G64';

    /**
     * litre per day kelvin
     */
    public const REC20_LITRE_PER_DAY_KELVIN = 'G65';

    /**
     * litre per hour kelvin
     */
    public const REC20_LITRE_PER_HOUR_KELVIN = 'G66';

    /**
     * litre per minute kelvin
     */
    public const REC20_LITRE_PER_MINUTE_KELVIN = 'G67';

    /**
     * litre per second kelvin
     */
    public const REC20_LITRE_PER_SECOND_KELVIN = 'G68';

    /**
     * cubic metre per day kelvin
     */
    public const REC20_CUBIC_METRE_PER_DAY_KELVIN = 'G69';

    /**
     * cubic metre per hour kelvin
     */
    public const REC20_CUBIC_METRE_PER_HOUR_KELVIN = 'G70';

    /**
     * cubic metre per minute kelvin
     */
    public const REC20_CUBIC_METRE_PER_MINUTE_KELVIN = 'G71';

    /**
     * cubic metre per second kelvin
     */
    public const REC20_CUBIC_METRE_PER_SECOND_KELVIN = 'G72';

    /**
     * millilitre per day kelvin
     */
    public const REC20_MILLILITRE_PER_DAY_KELVIN = 'G73';

    /**
     * millilitre per hour kelvin
     */
    public const REC20_MILLILITRE_PER_HOUR_KELVIN = 'G74';

    /**
     * millilitre per minute kelvin
     */
    public const REC20_MILLILITRE_PER_MINUTE_KELVIN = 'G75';

    /**
     * millilitre per second kelvin
     */
    public const REC20_MILLILITRE_PER_SECOND_KELVIN = 'G76';

    /**
     * millimetre to the fourth power
     */
    public const REC20_MILLIMETRE_TO_THE_FOURTH_POWER = 'G77';

    /**
     * cubic centimetre per day bar
     */
    public const REC20_CUBIC_CENTIMETRE_PER_DAY_BAR = 'G78';

    /**
     * cubic centimetre per hour bar
     */
    public const REC20_CUBIC_CENTIMETRE_PER_HOUR_BAR = 'G79';

    /**
     * cubic centimetre per minute bar
     */
    public const REC20_CUBIC_CENTIMETRE_PER_MINUTE_BAR = 'G80';

    /**
     * cubic centimetre per second bar
     */
    public const REC20_CUBIC_CENTIMETRE_PER_SECOND_BAR = 'G81';

    /**
     * litre per day bar
     */
    public const REC20_LITRE_PER_DAY_BAR = 'G82';

    /**
     * litre per hour bar
     */
    public const REC20_LITRE_PER_HOUR_BAR = 'G83';

    /**
     * litre per minute bar
     */
    public const REC20_LITRE_PER_MINUTE_BAR = 'G84';

    /**
     * litre per second bar
     */
    public const REC20_LITRE_PER_SECOND_BAR = 'G85';

    /**
     * cubic metre per day bar
     */
    public const REC20_CUBIC_METRE_PER_DAY_BAR = 'G86';

    /**
     * cubic metre per hour bar
     */
    public const REC20_CUBIC_METRE_PER_HOUR_BAR = 'G87';

    /**
     * cubic metre per minute bar
     */
    public const REC20_CUBIC_METRE_PER_MINUTE_BAR = 'G88';

    /**
     * cubic metre per second bar
     */
    public const REC20_CUBIC_METRE_PER_SECOND_BAR = 'G89';

    /**
     * millilitre per day bar
     */
    public const REC20_MILLILITRE_PER_DAY_BAR = 'G90';

    /**
     * millilitre per hour bar
     */
    public const REC20_MILLILITRE_PER_HOUR_BAR = 'G91';

    /**
     * millilitre per minute bar
     */
    public const REC20_MILLILITRE_PER_MINUTE_BAR = 'G92';

    /**
     * millilitre per second bar
     */
    public const REC20_MILLILITRE_PER_SECOND_BAR = 'G93';

    /**
     * cubic centimetre per bar
     */
    public const REC20_CUBIC_CENTIMETRE_PER_BAR = 'G94';

    /**
     * litre per bar
     */
    public const REC20_LITRE_PER_BAR = 'G95';

    /**
     * cubic metre per bar
     */
    public const REC20_CUBIC_METRE_PER_BAR = 'G96';

    /**
     * millilitre per bar
     */
    public const REC20_MILLILITRE_PER_BAR = 'G97';

    /**
     * microhenry per kiloohm
     */
    public const REC20_MICROHENRY_PER_KILOOHM = 'G98';

    /**
     * microhenry per ohm
     */
    public const REC20_MICROHENRY_PER_OHM = 'G99';

    /**
     * gallon (US) per day
     */
    public const REC20_GALLON_US_PER_DAY = 'GB';

    /**
     * gigabecquerel
     */
    public const REC20_GIGABECQUEREL = 'GBQ';

    /**
     * gram, dry weight
     */
    public const REC20_GRAM_DRY_WEIGHT = 'GDW';

    /**
     * pound per gallon (US)
     */
    public const REC20_POUND_PER_GALLON_US = 'GE';

    /**
     * gram per metre (gram per 100 centimetres)
     */
    public const REC20_GRAM_PER_METRE_GRAM_PER_100_CENTIMETRES = 'GF';

    /**
     * gram of fissile isotope
     */
    public const REC20_GRAM_OF_FISSILE_ISOTOPE = 'GFI';

    /**
     * great gross
     */
    public const REC20_GREAT_GROSS = 'GGR';

    /**
     * gill (US)
     */
    public const REC20_GILL_US = 'GIA';

    /**
     * gram, including container
     */
    public const REC20_GRAM_INCLUDING_CONTAINER = 'GIC';

    /**
     * gill (UK)
     */
    public const REC20_GILL_UK = 'GII';

    /**
     * gram, including inner packaging
     */
    public const REC20_GRAM_INCLUDING_INNER_PACKAGING = 'GIP';

    /**
     * gram per millilitre
     */
    public const REC20_GRAM_PER_MILLILITRE = 'GJ';

    /**
     * gram per litre
     */
    public const REC20_GRAM_PER_LITRE = 'GL';

    /**
     * dry gallon (US)
     */
    public const REC20_DRY_GALLON_US = 'GLD';

    /**
     * gallon (UK)
     */
    public const REC20_GALLON_UK = 'GLI';

    /**
     * gallon (US)
     */
    public const REC20_GALLON_US = 'GLL';

    /**
     * gram per square metre
     */
    public const REC20_GRAM_PER_SQUARE_METRE = 'GM';

    /**
     * milligram per square metre
     */
    public const REC20_MILLIGRAM_PER_SQUARE_METRE = 'GO';

    /**
     * milligram per cubic metre
     */
    public const REC20_MILLIGRAM_PER_CUBIC_METRE = 'GP';

    /**
     * microgram per cubic metre
     */
    public const REC20_MICROGRAM_PER_CUBIC_METRE = 'GQ';

    /**
     * gram
     */
    public const REC20_GRAM = 'GRM';

    /**
     * grain
     */
    public const REC20_GRAIN = 'GRN';

    /**
     * gross
     */
    public const REC20_GROSS = 'GRO';

    /**
     * gigajoule
     */
    public const REC20_GIGAJOULE = 'GV';

    /**
     * gigawatt hour
     */
    public const REC20_GIGAWATT_HOUR = 'GWH';

    /**
     * henry per kiloohm
     */
    public const REC20_HENRY_PER_KILOOHM = 'H03';

    /**
     * henry per ohm
     */
    public const REC20_HENRY_PER_OHM = 'H04';

    /**
     * millihenry per kiloohm
     */
    public const REC20_MILLIHENRY_PER_KILOOHM = 'H05';

    /**
     * millihenry per ohm
     */
    public const REC20_MILLIHENRY_PER_OHM = 'H06';

    /**
     * pascal second per bar
     */
    public const REC20_PASCAL_SECOND_PER_BAR = 'H07';

    /**
     * microbecquerel
     */
    public const REC20_MICROBECQUEREL = 'H08';

    /**
     * reciprocal year
     */
    public const REC20_RECIPROCAL_YEAR = 'H09';

    /**
     * reciprocal hour
     */
    public const REC20_RECIPROCAL_HOUR = 'H10';

    /**
     * reciprocal month
     */
    public const REC20_RECIPROCAL_MONTH = 'H11';

    /**
     * degree Celsius per hour
     */
    public const REC20_DEGREE_CELSIUS_PER_HOUR = 'H12';

    /**
     * degree Celsius per minute
     */
    public const REC20_DEGREE_CELSIUS_PER_MINUTE = 'H13';

    /**
     * degree Celsius per second
     */
    public const REC20_DEGREE_CELSIUS_PER_SECOND = 'H14';

    /**
     * square centimetre per gram
     */
    public const REC20_SQUARE_CENTIMETRE_PER_GRAM = 'H15';

    /**
     * square decametre
     */
    public const REC20_SQUARE_DECAMETRE = 'H16';

    /**
     * square hectometre
     */
    public const REC20_SQUARE_HECTOMETRE = 'H18';

    /**
     * cubic hectometre
     */
    public const REC20_CUBIC_HECTOMETRE = 'H19';

    /**
     * cubic kilometre
     */
    public const REC20_CUBIC_KILOMETRE = 'H20';

    /**
     * blank
     */
    public const REC20_BLANK = 'H21';

    /**
     * volt square inch per pound-force
     */
    public const REC20_VOLT_SQUARE_INCH_PER_POUNDFORCE = 'H22';

    /**
     * volt per inch
     */
    public const REC20_VOLT_PER_INCH = 'H23';

    /**
     * volt per microsecond
     */
    public const REC20_VOLT_PER_MICROSECOND = 'H24';

    /**
     * percent per kelvin
     */
    public const REC20_PERCENT_PER_KELVIN = 'H25';

    /**
     * ohm per metre
     */
    public const REC20_OHM_PER_METRE = 'H26';

    /**
     * degree per metre
     */
    public const REC20_DEGREE_PER_METRE = 'H27';

    /**
     * microfarad per kilometre
     */
    public const REC20_MICROFARAD_PER_KILOMETRE = 'H28';

    /**
     * microgram per litre
     */
    public const REC20_MICROGRAM_PER_LITRE = 'H29';

    /**
     * square micrometre (square micron)
     */
    public const REC20_SQUARE_MICROMETRE_SQUARE_MICRON = 'H30';

    /**
     * ampere per kilogram
     */
    public const REC20_AMPERE_PER_KILOGRAM = 'H31';

    /**
     * ampere squared second
     */
    public const REC20_AMPERE_SQUARED_SECOND = 'H32';

    /**
     * farad per kilometre
     */
    public const REC20_FARAD_PER_KILOMETRE = 'H33';

    /**
     * hertz metre
     */
    public const REC20_HERTZ_METRE = 'H34';

    /**
     * kelvin metre per watt
     */
    public const REC20_KELVIN_METRE_PER_WATT = 'H35';

    /**
     * megaohm per kilometre
     */
    public const REC20_MEGAOHM_PER_KILOMETRE = 'H36';

    /**
     * megaohm per metre
     */
    public const REC20_MEGAOHM_PER_METRE = 'H37';

    /**
     * megaampere
     */
    public const REC20_MEGAAMPERE = 'H38';

    /**
     * megahertz kilometre
     */
    public const REC20_MEGAHERTZ_KILOMETRE = 'H39';

    /**
     * newton per ampere
     */
    public const REC20_NEWTON_PER_AMPERE = 'H40';

    /**
     * newton metre watt to the power minus 0,5
     */
    public const REC20_NEWTON_METRE_WATT_TO_THE_POWER_MINUS_05 = 'H41';

    /**
     * pascal per metre
     */
    public const REC20_PASCAL_PER_METRE = 'H42';

    /**
     * siemens per centimetre
     */
    public const REC20_SIEMENS_PER_CENTIMETRE = 'H43';

    /**
     * teraohm
     */
    public const REC20_TERAOHM = 'H44';

    /**
     * volt second per metre
     */
    public const REC20_VOLT_SECOND_PER_METRE = 'H45';

    /**
     * volt per second
     */
    public const REC20_VOLT_PER_SECOND = 'H46';

    /**
     * watt per cubic metre
     */
    public const REC20_WATT_PER_CUBIC_METRE = 'H47';

    /**
     * attofarad
     */
    public const REC20_ATTOFARAD = 'H48';

    /**
     * centimetre per hour
     */
    public const REC20_CENTIMETRE_PER_HOUR = 'H49';

    /**
     * reciprocal cubic centimetre
     */
    public const REC20_RECIPROCAL_CUBIC_CENTIMETRE = 'H50';

    /**
     * decibel per kilometre
     */
    public const REC20_DECIBEL_PER_KILOMETRE = 'H51';

    /**
     * decibel per metre
     */
    public const REC20_DECIBEL_PER_METRE = 'H52';

    /**
     * kilogram per bar
     */
    public const REC20_KILOGRAM_PER_BAR = 'H53';

    /**
     * kilogram per cubic decimetre kelvin
     */
    public const REC20_KILOGRAM_PER_CUBIC_DECIMETRE_KELVIN = 'H54';

    /**
     * kilogram per cubic decimetre bar
     */
    public const REC20_KILOGRAM_PER_CUBIC_DECIMETRE_BAR = 'H55';

    /**
     * kilogram per square metre second
     */
    public const REC20_KILOGRAM_PER_SQUARE_METRE_SECOND = 'H56';

    /**
     * inch per two pi radiant
     */
    public const REC20_INCH_PER_TWO_PI_RADIANT = 'H57';

    /**
     * metre per volt second
     */
    public const REC20_METRE_PER_VOLT_SECOND = 'H58';

    /**
     * square metre per newton
     */
    public const REC20_SQUARE_METRE_PER_NEWTON = 'H59';

    /**
     * cubic metre per cubic metre
     */
    public const REC20_CUBIC_METRE_PER_CUBIC_METRE = 'H60';

    /**
     * millisiemens per centimetre
     */
    public const REC20_MILLISIEMENS_PER_CENTIMETRE = 'H61';

    /**
     * millivolt per minute
     */
    public const REC20_MILLIVOLT_PER_MINUTE = 'H62';

    /**
     * milligram per square centimetre
     */
    public const REC20_MILLIGRAM_PER_SQUARE_CENTIMETRE = 'H63';

    /**
     * milligram per gram
     */
    public const REC20_MILLIGRAM_PER_GRAM = 'H64';

    /**
     * millilitre per cubic metre
     */
    public const REC20_MILLILITRE_PER_CUBIC_METRE = 'H65';

    /**
     * millimetre per year
     */
    public const REC20_MILLIMETRE_PER_YEAR = 'H66';

    /**
     * millimetre per hour
     */
    public const REC20_MILLIMETRE_PER_HOUR = 'H67';

    /**
     * millimole per gram
     */
    public const REC20_MILLIMOLE_PER_GRAM = 'H68';

    /**
     * picopascal per kilometre
     */
    public const REC20_PICOPASCAL_PER_KILOMETRE = 'H69';

    /**
     * picosecond
     */
    public const REC20_PICOSECOND = 'H70';

    /**
     * percent per month
     */
    public const REC20_PERCENT_PER_MONTH = 'H71';

    /**
     * percent per hectobar
     */
    public const REC20_PERCENT_PER_HECTOBAR = 'H72';

    /**
     * percent per decakelvin
     */
    public const REC20_PERCENT_PER_DECAKELVIN = 'H73';

    /**
     * watt per metre
     */
    public const REC20_WATT_PER_METRE = 'H74';

    /**
     * decapascal
     */
    public const REC20_DECAPASCAL = 'H75';

    /**
     * gram per millimetre
     */
    public const REC20_GRAM_PER_MILLIMETRE = 'H76';

    /**
     * module width
     */
    public const REC20_MODULE_WIDTH = 'H77';

    /**
     * French gauge
     */
    public const REC20_FRENCH_GAUGE = 'H79';

    /**
     * rack unit
     */
    public const REC20_RACK_UNIT = 'H80';

    /**
     * millimetre per minute
     */
    public const REC20_MILLIMETRE_PER_MINUTE = 'H81';

    /**
     * big point
     */
    public const REC20_BIG_POINT = 'H82';

    /**
     * litre per kilogram
     */
    public const REC20_LITRE_PER_KILOGRAM = 'H83';

    /**
     * gram millimetre
     */
    public const REC20_GRAM_MILLIMETRE = 'H84';

    /**
     * reciprocal week
     */
    public const REC20_RECIPROCAL_WEEK = 'H85';

    /**
     * piece
     */
    public const REC20_PIECE = 'H87';

    /**
     * megaohm kilometre
     */
    public const REC20_MEGAOHM_KILOMETRE = 'H88';

    /**
     * percent per ohm
     */
    public const REC20_PERCENT_PER_OHM = 'H89';

    /**
     * percent per degree
     */
    public const REC20_PERCENT_PER_DEGREE = 'H90';

    /**
     * percent per ten thousand
     */
    public const REC20_PERCENT_PER_TEN_THOUSAND = 'H91';

    /**
     * percent per one hundred thousand
     */
    public const REC20_PERCENT_PER_ONE_HUNDRED_THOUSAND = 'H92';

    /**
     * percent per hundred
     */
    public const REC20_PERCENT_PER_HUNDRED = 'H93';

    /**
     * percent per thousand
     */
    public const REC20_PERCENT_PER_THOUSAND = 'H94';

    /**
     * percent per volt
     */
    public const REC20_PERCENT_PER_VOLT = 'H95';

    /**
     * percent per bar
     */
    public const REC20_PERCENT_PER_BAR = 'H96';

    /**
     * percent per inch
     */
    public const REC20_PERCENT_PER_INCH = 'H98';

    /**
     * percent per metre
     */
    public const REC20_PERCENT_PER_METRE = 'H99';

    /**
     * hank
     */
    public const REC20_HANK = 'HA';

    /**
     * hectobar
     */
    public const REC20_HECTOBAR = 'HBA';

    /**
     * hundred boxes
     */
    public const REC20_HUNDRED_BOXES = 'HBX';

    /**
     * hundred count
     */
    public const REC20_HUNDRED_COUNT = 'HC';

    /**
     * hundred kilogram, dry weight
     */
    public const REC20_HUNDRED_KILOGRAM_DRY_WEIGHT = 'HDW';

    /**
     * head
     */
    public const REC20_HEAD = 'HEA';

    /**
     * hectogram
     */
    public const REC20_HECTOGRAM = 'HGM';

    /**
     * hundred cubic foot
     */
    public const REC20_HUNDRED_CUBIC_FOOT = 'HH';

    /**
     * hundred international unit
     */
    public const REC20_HUNDRED_INTERNATIONAL_UNIT = 'HIU';

    /**
     * hundred kilogram, net mass
     */
    public const REC20_HUNDRED_KILOGRAM_NET_MASS = 'HKM';

    /**
     * hectolitre
     */
    public const REC20_HECTOLITRE = 'HLT';

    /**
     * mile per hour (statute mile)
     */
    public const REC20_MILE_PER_HOUR_STATUTE_MILE = 'HM';

    /**
     * million cubic metre
     */
    public const REC20_MILLION_CUBIC_METRE = 'HMQ';

    /**
     * hectometre
     */
    public const REC20_HECTOMETRE = 'HMT';

    /**
     * hectolitre of pure alcohol
     */
    public const REC20_HECTOLITRE_OF_PURE_ALCOHOL = 'HPA';

    /**
     * hertz
     */
    public const REC20_HERTZ = 'HTZ';

    /**
     * hour
     */
    public const REC20_HOUR = 'HUR';

    /**
     * inch pound (pound inch)
     */
    public const REC20_INCH_POUND_POUND_INCH = 'IA';

    /**
     * person
     */
    public const REC20_PERSON = 'IE';

    /**
     * inch
     */
    public const REC20_INCH = 'INH';

    /**
     * square inch
     */
    public const REC20_SQUARE_INCH = 'INK';

    /**
     * cubic inch
     */
    public const REC20_CUBIC_INCH = 'INQ';

    /**
     * international sugar degree
     */
    public const REC20_INTERNATIONAL_SUGAR_DEGREE = 'ISD';

    /**
     * inch per second
     */
    public const REC20_INCH_PER_SECOND = 'IU';

    /**
     * international unit per gram
     */
    public const REC20_INTERNATIONAL_UNIT_PER_GRAM = 'IUG';

    /**
     * inch per second squared
     */
    public const REC20_INCH_PER_SECOND_SQUARED = 'IV';

    /**
     * percent per millimetre
     */
    public const REC20_PERCENT_PER_MILLIMETRE = 'J10';

    /**
     * per mille per psi
     */
    public const REC20_PER_MILLE_PER_PSI = 'J12';

    /**
     * degree API
     */
    public const REC20_DEGREE_API = 'J13';

    /**
     * degree Baume (origin scale)
     */
    public const REC20_DEGREE_BAUME_ORIGIN_SCALE = 'J14';

    /**
     * degree Baume (US heavy)
     */
    public const REC20_DEGREE_BAUME_US_HEAVY = 'J15';

    /**
     * degree Baume (US light)
     */
    public const REC20_DEGREE_BAUME_US_LIGHT = 'J16';

    /**
     * degree Balling
     */
    public const REC20_DEGREE_BALLING = 'J17';

    /**
     * degree Brix
     */
    public const REC20_DEGREE_BRIX = 'J18';

    /**
     * degree Fahrenheit hour square foot per British thermal unit
     * (thermochemical)
     */
    public const REC20_DEGREE_FAHRENHEIT_HOUR_SQUARE_FOOT_PER_BRITISH_THERMAL_UNIT_THERMOCHEMICAL = 'J19';

    /**
     * joule per kilogram
     */
    public const REC20_JOULE_PER_KILOGRAM = 'J2';

    /**
     * degree Fahrenheit per kelvin
     */
    public const REC20_DEGREE_FAHRENHEIT_PER_KELVIN = 'J20';

    /**
     * degree Fahrenheit per bar
     */
    public const REC20_DEGREE_FAHRENHEIT_PER_BAR = 'J21';

    /**
     * degree Fahrenheit hour square foot per British thermal unit
     * (international table)
     */
    public const REC20_DEGREE_FAHRENHEIT_HOUR_SQUARE_FOOT_PER_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE = 'J22';

    /**
     * degree Fahrenheit per hour
     */
    public const REC20_DEGREE_FAHRENHEIT_PER_HOUR = 'J23';

    /**
     * degree Fahrenheit per minute
     */
    public const REC20_DEGREE_FAHRENHEIT_PER_MINUTE = 'J24';

    /**
     * degree Fahrenheit per second
     */
    public const REC20_DEGREE_FAHRENHEIT_PER_SECOND = 'J25';

    /**
     * reciprocal degree Fahrenheit
     */
    public const REC20_RECIPROCAL_DEGREE_FAHRENHEIT = 'J26';

    /**
     * degree Oechsle
     */
    public const REC20_DEGREE_OECHSLE = 'J27';

    /**
     * degree Rankine per hour
     */
    public const REC20_DEGREE_RANKINE_PER_HOUR = 'J28';

    /**
     * degree Rankine per minute
     */
    public const REC20_DEGREE_RANKINE_PER_MINUTE = 'J29';

    /**
     * degree Rankine per second
     */
    public const REC20_DEGREE_RANKINE_PER_SECOND = 'J30';

    /**
     * degree Twaddell
     */
    public const REC20_DEGREE_TWADDELL = 'J31';

    /**
     * micropoise
     */
    public const REC20_MICROPOISE = 'J32';

    /**
     * microgram per kilogram
     */
    public const REC20_MICROGRAM_PER_KILOGRAM = 'J33';

    /**
     * microgram per cubic metre kelvin
     */
    public const REC20_MICROGRAM_PER_CUBIC_METRE_KELVIN = 'J34';

    /**
     * microgram per cubic metre bar
     */
    public const REC20_MICROGRAM_PER_CUBIC_METRE_BAR = 'J35';

    /**
     * microlitre per litre
     */
    public const REC20_MICROLITRE_PER_LITRE = 'J36';

    /**
     * baud
     */
    public const REC20_BAUD = 'J38';

    /**
     * British thermal unit (mean)
     */
    public const REC20_BRITISH_THERMAL_UNIT_MEAN = 'J39';

    /**
     * British thermal unit (international table) foot per hour square foot
     * degree Fahrenheit
     */
    public const REC20_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_FOOT_PER_HOURSQUARE_FOOT_DEGREE_FAHRENHEIT = 'J40';

    /**
     * British thermal unit (international table) inch per hour square foot
     * degree Fahrenheit
     */
    public const REC20_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_INCH_PER_HOUR_SQUAREFOOT_DEGREE_FAHRENHEIT = 'J41';

    /**
     * British thermal unit (international table) inch per second
     * square foot degree Fahrenheit
     */
    public const REC20_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_INCH_PER_SECOND_SQUAREFOOT_DEGREE_FAHRENHEIT = 'J42';

    /**
     * British thermal unit (international table) per pound degree Fahrenheit
     */
    public const REC20_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_POUND_DEGREE_FAHRENHEIT = 'J43';

    /**
     * British thermal unit (international table) per minute
     */
    public const REC20_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_MINUTE = 'J44';

    /**
     * British thermal unit (international table) per second
     */
    public const REC20_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_SECOND = 'J45';

    /**
     * British thermal unit (thermochemical) foot per hour square foot
     * degree Fahrenheit
     */
    public const REC20_BRITISH_THERMAL_UNIT_THERMOCHEMICAL_FOOT_PER_HOUR_SQUAREFOOT_DEGREE_FAHRENHEIT = 'J46';

    /**
     * British thermal unit (thermochemical) per hour
     */
    public const REC20_BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_HOUR = 'J47';

    /**
     * British thermal unit (thermochemical) inch per hour square foot
     * degree Fahrenheit
     */
    public const REC20_BRITISH_THERMAL_UNIT_THERMOCHEMICAL_INCH_PER_HOUR_SQUAREFOOT_DEGREE_FAHRENHEIT = 'J48';

    /**
     * British thermal unit (thermochemical) inch per second square foot
     * degree Fahrenheit
     */
    public const REC20_BRITISH_THERMAL_UNIT_THERMOCHEMICAL_INCH_PER_SECONDSQUARE_FOOT_DEGREE_FAHRENHEIT = 'J49';

    /**
     * British thermal unit (thermochemical) per pound degree Fahrenheit
     */
    public const REC20_BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_POUND_DEGREE_FAHRENHEIT = 'J50';

    /**
     * British thermal unit (thermochemical) per minute
     */
    public const REC20_BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_MINUTE = 'J51';

    /**
     * British thermal unit (thermochemical) per second
     */
    public const REC20_BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_SECOND = 'J52';

    /**
     * coulomb square metre per kilogram
     */
    public const REC20_COULOMB_SQUARE_METRE_PER_KILOGRAM = 'J53';

    /**
     * megabaud
     */
    public const REC20_MEGABAUD = 'J54';

    /**
     * watt second
     */
    public const REC20_WATT_SECOND = 'J55';

    /**
     * bar per bar
     */
    public const REC20_BAR_PER_BAR = 'J56';

    /**
     * barrel (UK petroleum)
     */
    public const REC20_BARREL_UK_PETROLEUM = 'J57';

    /**
     * barrel (UK petroleum) per minute
     */
    public const REC20_BARREL_UK_PETROLEUM_PER_MINUTE = 'J58';

    /**
     * barrel (UK petroleum) per day
     */
    public const REC20_BARREL_UK_PETROLEUM_PER_DAY = 'J59';

    /**
     * barrel (UK petroleum) per hour
     */
    public const REC20_BARREL_UK_PETROLEUM_PER_HOUR = 'J60';

    /**
     * barrel (UK petroleum) per second
     */
    public const REC20_BARREL_UK_PETROLEUM_PER_SECOND = 'J61';

    /**
     * barrel (US petroleum) per hour
     */
    public const REC20_BARREL_US_PETROLEUM_PER_HOUR = 'J62';

    /**
     * barrel (US petroleum) per second
     */
    public const REC20_BARREL_US_PETROLEUM_PER_SECOND = 'J63';

    /**
     * bushel (UK) per day
     */
    public const REC20_BUSHEL_UK_PER_DAY = 'J64';

    /**
     * bushel (UK) per hour
     */
    public const REC20_BUSHEL_UK_PER_HOUR = 'J65';

    /**
     * bushel (UK) per minute
     */
    public const REC20_BUSHEL_UK_PER_MINUTE = 'J66';

    /**
     * bushel (UK) per second
     */
    public const REC20_BUSHEL_UK_PER_SECOND = 'J67';

    /**
     * bushel (US dry) per day
     */
    public const REC20_BUSHEL_US_DRY_PER_DAY = 'J68';

    /**
     * bushel (US dry) per hour
     */
    public const REC20_BUSHEL_US_DRY_PER_HOUR = 'J69';

    /**
     * bushel (US dry) per minute
     */
    public const REC20_BUSHEL_US_DRY_PER_MINUTE = 'J70';

    /**
     * bushel (US dry) per second
     */
    public const REC20_BUSHEL_US_DRY_PER_SECOND = 'J71';

    /**
     * centinewton metre
     */
    public const REC20_CENTINEWTON_METRE = 'J72';

    /**
     * centipoise per kelvin
     */
    public const REC20_CENTIPOISE_PER_KELVIN = 'J73';

    /**
     * centipoise per bar
     */
    public const REC20_CENTIPOISE_PER_BAR = 'J74';

    /**
     * calorie (mean)
     */
    public const REC20_CALORIE_MEAN = 'J75';

    /**
     * calorie (international table) per gram degree Celsius
     */
    public const REC20_CALORIE_INTERNATIONAL_TABLE_PER_GRAM_DEGREE_CELSIUS = 'J76';

    /**
     * calorie (thermochemical) per centimetre second degree Celsius
     */
    public const REC20_CALORIE_THERMOCHEMICAL_PER_CENTIMETRE_SECOND_DEGREE_CELSIUS = 'J78';

    /**
     * calorie (thermochemical) per gram degree Celsius
     */
    public const REC20_CALORIE_THERMOCHEMICAL_PER_GRAM_DEGREE_CELSIUS = 'J79';

    /**
     * calorie (thermochemical) per minute
     */
    public const REC20_CALORIE_THERMOCHEMICAL_PER_MINUTE = 'J81';

    /**
     * calorie (thermochemical) per second
     */
    public const REC20_CALORIE_THERMOCHEMICAL_PER_SECOND = 'J82';

    /**
     * clo
     */
    public const REC20_CLO = 'J83';

    /**
     * centimetre per second kelvin
     */
    public const REC20_CENTIMETRE_PER_SECOND_KELVIN = 'J84';

    /**
     * centimetre per second bar
     */
    public const REC20_CENTIMETRE_PER_SECOND_BAR = 'J85';

    /**
     * cubic centimetre per cubic metre
     */
    public const REC20_CUBIC_CENTIMETRE_PER_CUBIC_METRE = 'J87';

    /**
     * cubic decimetre per day
     */
    public const REC20_CUBIC_DECIMETRE_PER_DAY = 'J90';

    /**
     * cubic decimetre per cubic metre
     */
    public const REC20_CUBIC_DECIMETRE_PER_CUBIC_METRE = 'J91';

    /**
     * cubic decimetre per minute
     */
    public const REC20_CUBIC_DECIMETRE_PER_MINUTE = 'J92';

    /**
     * cubic decimetre per second
     */
    public const REC20_CUBIC_DECIMETRE_PER_SECOND = 'J93';

    /**
     * ounce (UK fluid) per day
     */
    public const REC20_OUNCE_UK_FLUID_PER_DAY = 'J95';

    /**
     * ounce (UK fluid) per hour
     */
    public const REC20_OUNCE_UK_FLUID_PER_HOUR = 'J96';

    /**
     * ounce (UK fluid) per minute
     */
    public const REC20_OUNCE_UK_FLUID_PER_MINUTE = 'J97';

    /**
     * ounce (UK fluid) per second
     */
    public const REC20_OUNCE_UK_FLUID_PER_SECOND = 'J98';

    /**
     * ounce (US fluid) per day
     */
    public const REC20_OUNCE_US_FLUID_PER_DAY = 'J99';

    /**
     * joule per kelvin
     */
    public const REC20_JOULE_PER_KELVIN = 'JE';

    /**
     * megajoule per kilogram
     */
    public const REC20_MEGAJOULE_PER_KILOGRAM = 'JK';

    /**
     * megajoule per cubic metre
     */
    public const REC20_MEGAJOULE_PER_CUBIC_METRE = 'JM';

    /**
     * pipeline joint
     */
    public const REC20_PIPELINE_JOINT = 'JNT';

    /**
     * joule
     */
    public const REC20_JOULE = 'JOU';

    /**
     * hundred metre
     */
    public const REC20_HUNDRED_METRE = 'JPS';

    /**
     * number of jewels
     */
    public const REC20_NUMBER_OF_JEWELS = 'JWL';

    /**
     * kilowatt demand
     */
    public const REC20_KILOWATT_DEMAND = 'K1';

    /**
     * ounce (US fluid) per hour
     */
    public const REC20_OUNCE_US_FLUID_PER_HOUR = 'K10';

    /**
     * ounce (US fluid) per minute
     */
    public const REC20_OUNCE_US_FLUID_PER_MINUTE = 'K11';

    /**
     * ounce (US fluid) per second
     */
    public const REC20_OUNCE_US_FLUID_PER_SECOND = 'K12';

    /**
     * foot per degree Fahrenheit
     */
    public const REC20_FOOT_PER_DEGREE_FAHRENHEIT = 'K13';

    /**
     * foot per hour
     */
    public const REC20_FOOT_PER_HOUR = 'K14';

    /**
     * foot pound-force per hour
     */
    public const REC20_FOOT_POUNDFORCE_PER_HOUR = 'K15';

    /**
     * foot pound-force per minute
     */
    public const REC20_FOOT_POUNDFORCE_PER_MINUTE = 'K16';

    /**
     * foot per psi
     */
    public const REC20_FOOT_PER_PSI = 'K17';

    /**
     * foot per second degree Fahrenheit
     */
    public const REC20_FOOT_PER_SECOND_DEGREE_FAHRENHEIT = 'K18';

    /**
     * foot per second psi
     */
    public const REC20_FOOT_PER_SECOND_PSI = 'K19';

    /**
     * kilovolt ampere reactive demand
     */
    public const REC20_KILOVOLT_AMPERE_REACTIVE_DEMAND = 'K2';

    /**
     * reciprocal cubic foot
     */
    public const REC20_RECIPROCAL_CUBIC_FOOT = 'K20';

    /**
     * cubic foot per degree Fahrenheit
     */
    public const REC20_CUBIC_FOOT_PER_DEGREE_FAHRENHEIT = 'K21';

    /**
     * cubic foot per day
     */
    public const REC20_CUBIC_FOOT_PER_DAY = 'K22';

    /**
     * cubic foot per psi
     */
    public const REC20_CUBIC_FOOT_PER_PSI = 'K23';

    /**
     * gallon (UK) per day
     */
    public const REC20_GALLON_UK_PER_DAY = 'K26';

    /**
     * gallon (UK) per hour
     */
    public const REC20_GALLON_UK_PER_HOUR = 'K27';

    /**
     * gallon (UK) per second
     */
    public const REC20_GALLON_UK_PER_SECOND = 'K28';

    /**
     * kilovolt ampere reactive hour
     */
    public const REC20_KILOVOLT_AMPERE_REACTIVE_HOUR = 'K3';

    /**
     * gallon (US liquid) per second
     */
    public const REC20_GALLON_US_LIQUID_PER_SECOND = 'K30';

    /**
     * gram-force per square centimetre
     */
    public const REC20_GRAMFORCE_PER_SQUARE_CENTIMETRE = 'K31';

    /**
     * gill (UK) per day
     */
    public const REC20_GILL_UK_PER_DAY = 'K32';

    /**
     * gill (UK) per hour
     */
    public const REC20_GILL_UK_PER_HOUR = 'K33';

    /**
     * gill (UK) per minute
     */
    public const REC20_GILL_UK_PER_MINUTE = 'K34';

    /**
     * gill (UK) per second
     */
    public const REC20_GILL_UK_PER_SECOND = 'K35';

    /**
     * gill (US) per day
     */
    public const REC20_GILL_US_PER_DAY = 'K36';

    /**
     * gill (US) per hour
     */
    public const REC20_GILL_US_PER_HOUR = 'K37';

    /**
     * gill (US) per minute
     */
    public const REC20_GILL_US_PER_MINUTE = 'K38';

    /**
     * gill (US) per second
     */
    public const REC20_GILL_US_PER_SECOND = 'K39';

    /**
     * standard acceleration of free fall
     */
    public const REC20_STANDARD_ACCELERATION_OF_FREE_FALL = 'K40';

    /**
     * grain per gallon (US)
     */
    public const REC20_GRAIN_PER_GALLON_US = 'K41';

    /**
     * horsepower (boiler)
     */
    public const REC20_HORSEPOWER_BOILER = 'K42';

    /**
     * horsepower (electric)
     */
    public const REC20_HORSEPOWER_ELECTRIC = 'K43';

    /**
     * inch per degree Fahrenheit
     */
    public const REC20_INCH_PER_DEGREE_FAHRENHEIT = 'K45';

    /**
     * inch per psi
     */
    public const REC20_INCH_PER_PSI = 'K46';

    /**
     * inch per second degree Fahrenheit
     */
    public const REC20_INCH_PER_SECOND_DEGREE_FAHRENHEIT = 'K47';

    /**
     * inch per second psi
     */
    public const REC20_INCH_PER_SECOND_PSI = 'K48';

    /**
     * reciprocal cubic inch
     */
    public const REC20_RECIPROCAL_CUBIC_INCH = 'K49';

    /**
     * kilobaud
     */
    public const REC20_KILOBAUD = 'K50';

    /**
     * kilocalorie (mean)
     */
    public const REC20_KILOCALORIE_MEAN = 'K51';

    /**
     * kilocalorie (international table) per hour metre degree Celsius
     */
    public const REC20_KILOCALORIE_INTERNATIONAL_TABLE_PER_HOUR_METRE_DEGREE_CELSIUS = 'K52';

    /**
     * kilocalorie (thermochemical)
     */
    public const REC20_KILOCALORIE_THERMOCHEMICAL = 'K53';

    /**
     * kilocalorie (thermochemical) per minute
     */
    public const REC20_KILOCALORIE_THERMOCHEMICAL_PER_MINUTE = 'K54';

    /**
     * kilocalorie (thermochemical) per second
     */
    public const REC20_KILOCALORIE_THERMOCHEMICAL_PER_SECOND = 'K55';

    /**
     * kilomole per hour
     */
    public const REC20_KILOMOLE_PER_HOUR = 'K58';

    /**
     * kilomole per cubic metre kelvin
     */
    public const REC20_KILOMOLE_PER_CUBIC_METRE_KELVIN = 'K59';

    /**
     * kilolitre
     */
    public const REC20_KILOLITRE = 'K6';

    /**
     * kilomole per cubic metre bar
     */
    public const REC20_KILOMOLE_PER_CUBIC_METRE_BAR = 'K60';

    /**
     * kilomole per minute
     */
    public const REC20_KILOMOLE_PER_MINUTE = 'K61';

    /**
     * litre per litre
     */
    public const REC20_LITRE_PER_LITRE = 'K62';

    /**
     * reciprocal litre
     */
    public const REC20_RECIPROCAL_LITRE = 'K63';

    /**
     * pound (avoirdupois) per degree Fahrenheit
     */
    public const REC20_POUND_AVOIRDUPOIS_PER_DEGREE_FAHRENHEIT = 'K64';

    /**
     * pound (avoirdupois) square foot
     */
    public const REC20_POUND_AVOIRDUPOIS_SQUARE_FOOT = 'K65';

    /**
     * pound (avoirdupois) per day
     */
    public const REC20_POUND_AVOIRDUPOIS_PER_DAY = 'K66';

    /**
     * pound per foot hour
     */
    public const REC20_POUND_PER_FOOT_HOUR = 'K67';

    /**
     * pound per foot second
     */
    public const REC20_POUND_PER_FOOT_SECOND = 'K68';

    /**
     * pound (avoirdupois) per cubic foot degree Fahrenheit
     */
    public const REC20_POUND_AVOIRDUPOIS_PER_CUBIC_FOOT_DEGREE_FAHRENHEIT = 'K69';

    /**
     * pound (avoirdupois) per cubic foot psi
     */
    public const REC20_POUND_AVOIRDUPOIS_PER_CUBIC_FOOT_PSI = 'K70';

    /**
     * pound (avoirdupois) per gallon (UK)
     */
    public const REC20_POUND_AVOIRDUPOIS_PER_GALLON_UK = 'K71';

    /**
     * pound (avoirdupois) per hour degree Fahrenheit
     */
    public const REC20_POUND_AVOIRDUPOIS_PER_HOUR_DEGREE_FAHRENHEIT = 'K73';

    /**
     * pound (avoirdupois) per hour psi
     */
    public const REC20_POUND_AVOIRDUPOIS_PER_HOUR_PSI = 'K74';

    /**
     * pound (avoirdupois) per cubic inch degree Fahrenheit
     */
    public const REC20_POUND_AVOIRDUPOIS_PER_CUBIC_INCH_DEGREE_FAHRENHEIT = 'K75';

    /**
     * pound (avoirdupois) per cubic inch psi
     */
    public const REC20_POUND_AVOIRDUPOIS_PER_CUBIC_INCH_PSI = 'K76';

    /**
     * pound (avoirdupois) per psi
     */
    public const REC20_POUND_AVOIRDUPOIS_PER_PSI = 'K77';

    /**
     * pound (avoirdupois) per minute
     */
    public const REC20_POUND_AVOIRDUPOIS_PER_MINUTE = 'K78';

    /**
     * pound (avoirdupois) per minute degree Fahrenheit
     */
    public const REC20_POUND_AVOIRDUPOIS_PER_MINUTE_DEGREE_FAHRENHEIT = 'K79';

    /**
     * pound (avoirdupois) per minute psi
     */
    public const REC20_POUND_AVOIRDUPOIS_PER_MINUTE_PSI = 'K80';

    /**
     * pound (avoirdupois) per second
     */
    public const REC20_POUND_AVOIRDUPOIS_PER_SECOND = 'K81';

    /**
     * pound (avoirdupois) per second degree Fahrenheit
     */
    public const REC20_POUND_AVOIRDUPOIS_PER_SECOND_DEGREE_FAHRENHEIT = 'K82';

    /**
     * pound (avoirdupois) per second psi
     */
    public const REC20_POUND_AVOIRDUPOIS_PER_SECOND_PSI = 'K83';

    /**
     * pound per cubic yard
     */
    public const REC20_POUND_PER_CUBIC_YARD = 'K84';

    /**
     * pound-force per square foot
     */
    public const REC20_POUNDFORCE_PER_SQUARE_FOOT = 'K85';

    /**
     * pound-force per square inch degree Fahrenheit
     */
    public const REC20_POUNDFORCE_PER_SQUARE_INCH_DEGREE_FAHRENHEIT = 'K86';

    /**
     * psi cubic inch per second
     */
    public const REC20_PSI_CUBIC_INCH_PER_SECOND = 'K87';

    /**
     * psi litre per second
     */
    public const REC20_PSI_LITRE_PER_SECOND = 'K88';

    /**
     * psi cubic metre per second
     */
    public const REC20_PSI_CUBIC_METRE_PER_SECOND = 'K89';

    /**
     * psi cubic yard per second
     */
    public const REC20_PSI_CUBIC_YARD_PER_SECOND = 'K90';

    /**
     * pound-force second per square foot
     */
    public const REC20_POUNDFORCE_SECOND_PER_SQUARE_FOOT = 'K91';

    /**
     * pound-force second per square inch
     */
    public const REC20_POUNDFORCE_SECOND_PER_SQUARE_INCH = 'K92';

    /**
     * reciprocal psi
     */
    public const REC20_RECIPROCAL_PSI = 'K93';

    /**
     * quart (UK liquid) per day
     */
    public const REC20_QUART_UK_LIQUID_PER_DAY = 'K94';

    /**
     * quart (UK liquid) per hour
     */
    public const REC20_QUART_UK_LIQUID_PER_HOUR = 'K95';

    /**
     * quart (UK liquid) per minute
     */
    public const REC20_QUART_UK_LIQUID_PER_MINUTE = 'K96';

    /**
     * quart (UK liquid) per second
     */
    public const REC20_QUART_UK_LIQUID_PER_SECOND = 'K97';

    /**
     * quart (US liquid) per day
     */
    public const REC20_QUART_US_LIQUID_PER_DAY = 'K98';

    /**
     * quart (US liquid) per hour
     */
    public const REC20_QUART_US_LIQUID_PER_HOUR = 'K99';

    /**
     * cake
     */
    public const REC20_CAKE = 'KA';

    /**
     * katal
     */
    public const REC20_KATAL = 'KAT';

    /**
     * kilocharacter
     */
    public const REC20_KILOCHARACTER = 'KB';

    /**
     * kilobar
     */
    public const REC20_KILOBAR = 'KBA';

    /**
     * kilogram of choline chloride
     */
    public const REC20_KILOGRAM_OF_CHOLINE_CHLORIDE = 'KCC';

    /**
     * kilogram drained net weight
     */
    public const REC20_KILOGRAM_DRAINED_NET_WEIGHT = 'KDW';

    /**
     * kelvin
     */
    public const REC20_KELVIN = 'KEL';

    /**
     * kilogram
     */
    public const REC20_KILOGRAM = 'KGM';

    /**
     * kilogram per second
     */
    public const REC20_KILOGRAM_PER_SECOND = 'KGS';

    /**
     * kilogram of hydrogen peroxide
     */
    public const REC20_KILOGRAM_OF_HYDROGEN_PEROXIDE = 'KHY';

    /**
     * kilohertz
     */
    public const REC20_KILOHERTZ = 'KHZ';

    /**
     * kilogram per millimetre width
     */
    public const REC20_KILOGRAM_PER_MILLIMETRE_WIDTH = 'KI';

    /**
     * kilogram, including container
     */
    public const REC20_KILOGRAM_INCLUDING_CONTAINER = 'KIC';

    /**
     * kilogram, including inner packaging
     */
    public const REC20_KILOGRAM_INCLUDING_INNER_PACKAGING = 'KIP';

    /**
     * kilosegment
     */
    public const REC20_KILOSEGMENT = 'KJ';

    /**
     * kilojoule
     */
    public const REC20_KILOJOULE = 'KJO';

    /**
     * kilogram per metre
     */
    public const REC20_KILOGRAM_PER_METRE = 'KL';

    /**
     * lactic dry material percentage
     */
    public const REC20_LACTIC_DRY_MATERIAL_PERCENTAGE = 'KLK';

    /**
     * kilolux
     */
    public const REC20_KILOLUX = 'KLX';

    /**
     * kilogram of methylamine
     */
    public const REC20_KILOGRAM_OF_METHYLAMINE = 'KMA';

    /**
     * kilometre per hour
     */
    public const REC20_KILOMETRE_PER_HOUR = 'KMH';

    /**
     * square kilometre
     */
    public const REC20_SQUARE_KILOMETRE = 'KMK';

    /**
     * kilogram per cubic metre
     */
    public const REC20_KILOGRAM_PER_CUBIC_METRE = 'KMQ';

    /**
     * kilometre
     */
    public const REC20_KILOMETRE = 'KMT';

    /**
     * kilogram of nitrogen
     */
    public const REC20_KILOGRAM_OF_NITROGEN = 'KNI';

    /**
     * kilonewton per square metre
     */
    public const REC20_KILONEWTON_PER_SQUARE_METRE = 'KNM';

    /**
     * kilogram named substance
     */
    public const REC20_KILOGRAM_NAMED_SUBSTANCE = 'KNS';

    /**
     * knot
     */
    public const REC20_KNOT = 'KNT';

    /**
     * milliequivalence caustic potash per gram of product
     */
    public const REC20_MILLIEQUIVALENCE_CAUSTIC_POTASH_PER_GRAM_OF_PRODUCT = 'KO';

    /**
     * kilopascal
     */
    public const REC20_KILOPASCAL = 'KPA';

    /**
     * kilogram of potassium hydroxide (caustic potash)
     */
    public const REC20_KILOGRAM_OF_POTASSIUM_HYDROXIDE_CAUSTIC_POTASH = 'KPH';

    /**
     * kilogram of potassium oxide
     */
    public const REC20_KILOGRAM_OF_POTASSIUM_OXIDE = 'KPO';

    /**
     * kilogram of phosphorus pentoxide (phosphoric anhydride)
     */
    public const REC20_KILOGRAM_OF_PHOSPHORUS_PENTOXIDE_PHOSPHORIC_ANHYDRIDE = 'KPP';

    /**
     * kiloroentgen
     */
    public const REC20_KILOROENTGEN = 'KR';

    /**
     * kilogram of substance 90 % dry
     */
    public const REC20_KILOGRAM_OF_SUBSTANCE_90__DRY = 'KSD';

    /**
     * kilogram of sodium hydroxide (caustic soda)
     */
    public const REC20_KILOGRAM_OF_SODIUM_HYDROXIDE_CAUSTIC_SODA = 'KSH';

    /**
     * kit
     */
    public const REC20_KIT = 'KT';

    /**
     * kilotonne
     */
    public const REC20_KILOTONNE = 'KTN';

    /**
     * kilogram of uranium
     */
    public const REC20_KILOGRAM_OF_URANIUM = 'KUR';

    /**
     * kilovolt - ampere
     */
    public const REC20_KILOVOLT__AMPERE = 'KVA';

    /**
     * kilovar
     */
    public const REC20_KILOVAR = 'KVR';

    /**
     * kilovolt
     */
    public const REC20_KILOVOLT = 'KVT';

    /**
     * kilogram per millimetre
     */
    public const REC20_KILOGRAM_PER_MILLIMETRE = 'KW';

    /**
     * kilowatt hour
     */
    public const REC20_KILOWATT_HOUR = 'KWH';

    /**
     * Kilowatt hour per normalized cubic metre
     */
    public const REC20_KILOWATT_HOUR_PER_NORMALIZED_CUBIC_METRE = 'KWN';

    /**
     * kilogram of tungsten trioxide
     */
    public const REC20_KILOGRAM_OF_TUNGSTEN_TRIOXIDE = 'KWO';

    /**
     * Kilowatt hour per standard cubic metre
     */
    public const REC20_KILOWATT_HOUR_PER_STANDARD_CUBIC_METRE = 'KWS';

    /**
     * kilowatt
     */
    public const REC20_KILOWATT = 'KWT';

    /**
     * millilitre per kilogram
     */
    public const REC20_MILLILITRE_PER_KILOGRAM = 'KX';

    /**
     * quart (US liquid) per minute
     */
    public const REC20_QUART_US_LIQUID_PER_MINUTE = 'L10';

    /**
     * quart (US liquid) per second
     */
    public const REC20_QUART_US_LIQUID_PER_SECOND = 'L11';

    /**
     * metre per second kelvin
     */
    public const REC20_METRE_PER_SECOND_KELVIN = 'L12';

    /**
     * metre per second bar
     */
    public const REC20_METRE_PER_SECOND_BAR = 'L13';

    /**
     * square metre hour degree Celsius per kilocalorie (international table)
     */
    public const REC20_SQUARE_METRE_HOUR_DEGREE_CELSIUS_PER_KILOCALORIE_INTERNATIONAL_TABLE = 'L14';

    /**
     * millipascal second per kelvin
     */
    public const REC20_MILLIPASCAL_SECOND_PER_KELVIN = 'L15';

    /**
     * millipascal second per bar
     */
    public const REC20_MILLIPASCAL_SECOND_PER_BAR = 'L16';

    /**
     * milligram per cubic metre kelvin
     */
    public const REC20_MILLIGRAM_PER_CUBIC_METRE_KELVIN = 'L17';

    /**
     * milligram per cubic metre bar
     */
    public const REC20_MILLIGRAM_PER_CUBIC_METRE_BAR = 'L18';

    /**
     * millilitre per litre
     */
    public const REC20_MILLILITRE_PER_LITRE = 'L19';

    /**
     * litre per minute
     */
    public const REC20_LITRE_PER_MINUTE = 'L2';

    /**
     * reciprocal cubic millimetre
     */
    public const REC20_RECIPROCAL_CUBIC_MILLIMETRE = 'L20';

    /**
     * cubic millimetre per cubic metre
     */
    public const REC20_CUBIC_MILLIMETRE_PER_CUBIC_METRE = 'L21';

    /**
     * mole per hour
     */
    public const REC20_MOLE_PER_HOUR = 'L23';

    /**
     * mole per kilogram kelvin
     */
    public const REC20_MOLE_PER_KILOGRAM_KELVIN = 'L24';

    /**
     * mole per kilogram bar
     */
    public const REC20_MOLE_PER_KILOGRAM_BAR = 'L25';

    /**
     * mole per litre kelvin
     */
    public const REC20_MOLE_PER_LITRE_KELVIN = 'L26';

    /**
     * mole per litre bar
     */
    public const REC20_MOLE_PER_LITRE_BAR = 'L27';

    /**
     * mole per cubic metre kelvin
     */
    public const REC20_MOLE_PER_CUBIC_METRE_KELVIN = 'L28';

    /**
     * mole per cubic metre bar
     */
    public const REC20_MOLE_PER_CUBIC_METRE_BAR = 'L29';

    /**
     * mole per minute
     */
    public const REC20_MOLE_PER_MINUTE = 'L30';

    /**
     * milliroentgen aequivalent men
     */
    public const REC20_MILLIROENTGEN_AEQUIVALENT_MEN = 'L31';

    /**
     * nanogram per kilogram
     */
    public const REC20_NANOGRAM_PER_KILOGRAM = 'L32';

    /**
     * ounce (avoirdupois) per day
     */
    public const REC20_OUNCE_AVOIRDUPOIS_PER_DAY = 'L33';

    /**
     * ounce (avoirdupois) per hour
     */
    public const REC20_OUNCE_AVOIRDUPOIS_PER_HOUR = 'L34';

    /**
     * ounce (avoirdupois) per minute
     */
    public const REC20_OUNCE_AVOIRDUPOIS_PER_MINUTE = 'L35';

    /**
     * ounce (avoirdupois) per second
     */
    public const REC20_OUNCE_AVOIRDUPOIS_PER_SECOND = 'L36';

    /**
     * ounce (avoirdupois) per gallon (UK)
     */
    public const REC20_OUNCE_AVOIRDUPOIS_PER_GALLON_UK = 'L37';

    /**
     * ounce (avoirdupois) per gallon (US)
     */
    public const REC20_OUNCE_AVOIRDUPOIS_PER_GALLON_US = 'L38';

    /**
     * ounce (avoirdupois) per cubic inch
     */
    public const REC20_OUNCE_AVOIRDUPOIS_PER_CUBIC_INCH = 'L39';

    /**
     * ounce (avoirdupois)-force
     */
    public const REC20_OUNCE_AVOIRDUPOISFORCE = 'L40';

    /**
     * ounce (avoirdupois)-force inch
     */
    public const REC20_OUNCE_AVOIRDUPOISFORCE_INCH = 'L41';

    /**
     * picosiemens per metre
     */
    public const REC20_PICOSIEMENS_PER_METRE = 'L42';

    /**
     * peck (UK)
     */
    public const REC20_PECK_UK = 'L43';

    /**
     * peck (UK) per day
     */
    public const REC20_PECK_UK_PER_DAY = 'L44';

    /**
     * peck (UK) per hour
     */
    public const REC20_PECK_UK_PER_HOUR = 'L45';

    /**
     * peck (UK) per minute
     */
    public const REC20_PECK_UK_PER_MINUTE = 'L46';

    /**
     * peck (UK) per second
     */
    public const REC20_PECK_UK_PER_SECOND = 'L47';

    /**
     * peck (US dry) per day
     */
    public const REC20_PECK_US_DRY_PER_DAY = 'L48';

    /**
     * peck (US dry) per hour
     */
    public const REC20_PECK_US_DRY_PER_HOUR = 'L49';

    /**
     * peck (US dry) per minute
     */
    public const REC20_PECK_US_DRY_PER_MINUTE = 'L50';

    /**
     * peck (US dry) per second
     */
    public const REC20_PECK_US_DRY_PER_SECOND = 'L51';

    /**
     * psi per psi
     */
    public const REC20_PSI_PER_PSI = 'L52';

    /**
     * pint (UK) per day
     */
    public const REC20_PINT_UK_PER_DAY = 'L53';

    /**
     * pint (UK) per hour
     */
    public const REC20_PINT_UK_PER_HOUR = 'L54';

    /**
     * pint (UK) per minute
     */
    public const REC20_PINT_UK_PER_MINUTE = 'L55';

    /**
     * pint (UK) per second
     */
    public const REC20_PINT_UK_PER_SECOND = 'L56';

    /**
     * pint (US liquid) per day
     */
    public const REC20_PINT_US_LIQUID_PER_DAY = 'L57';

    /**
     * pint (US liquid) per hour
     */
    public const REC20_PINT_US_LIQUID_PER_HOUR = 'L58';

    /**
     * pint (US liquid) per minute
     */
    public const REC20_PINT_US_LIQUID_PER_MINUTE = 'L59';

    /**
     * pint (US liquid) per second
     */
    public const REC20_PINT_US_LIQUID_PER_SECOND = 'L60';

    /**
     * slug per day
     */
    public const REC20_SLUG_PER_DAY = 'L63';

    /**
     * slug per foot second
     */
    public const REC20_SLUG_PER_FOOT_SECOND = 'L64';

    /**
     * slug per cubic foot
     */
    public const REC20_SLUG_PER_CUBIC_FOOT = 'L65';

    /**
     * slug per hour
     */
    public const REC20_SLUG_PER_HOUR = 'L66';

    /**
     * slug per minute
     */
    public const REC20_SLUG_PER_MINUTE = 'L67';

    /**
     * slug per second
     */
    public const REC20_SLUG_PER_SECOND = 'L68';

    /**
     * tonne per kelvin
     */
    public const REC20_TONNE_PER_KELVIN = 'L69';

    /**
     * tonne per bar
     */
    public const REC20_TONNE_PER_BAR = 'L70';

    /**
     * tonne per day
     */
    public const REC20_TONNE_PER_DAY = 'L71';

    /**
     * tonne per day kelvin
     */
    public const REC20_TONNE_PER_DAY_KELVIN = 'L72';

    /**
     * tonne per day bar
     */
    public const REC20_TONNE_PER_DAY_BAR = 'L73';

    /**
     * tonne per hour kelvin
     */
    public const REC20_TONNE_PER_HOUR_KELVIN = 'L74';

    /**
     * tonne per hour bar
     */
    public const REC20_TONNE_PER_HOUR_BAR = 'L75';

    /**
     * tonne per cubic metre kelvin
     */
    public const REC20_TONNE_PER_CUBIC_METRE_KELVIN = 'L76';

    /**
     * tonne per cubic metre bar
     */
    public const REC20_TONNE_PER_CUBIC_METRE_BAR = 'L77';

    /**
     * tonne per minute
     */
    public const REC20_TONNE_PER_MINUTE = 'L78';

    /**
     * tonne per minute kelvin
     */
    public const REC20_TONNE_PER_MINUTE_KELVIN = 'L79';

    /**
     * tonne per minute bar
     */
    public const REC20_TONNE_PER_MINUTE_BAR = 'L80';

    /**
     * tonne per second
     */
    public const REC20_TONNE_PER_SECOND = 'L81';

    /**
     * tonne per second kelvin
     */
    public const REC20_TONNE_PER_SECOND_KELVIN = 'L82';

    /**
     * tonne per second bar
     */
    public const REC20_TONNE_PER_SECOND_BAR = 'L83';

    /**
     * ton (UK shipping)
     */
    public const REC20_TON_UK_SHIPPING = 'L84';

    /**
     * ton long per day
     */
    public const REC20_TON_LONG_PER_DAY = 'L85';

    /**
     * ton (US shipping)
     */
    public const REC20_TON_US_SHIPPING = 'L86';

    /**
     * ton short per degree Fahrenheit
     */
    public const REC20_TON_SHORT_PER_DEGREE_FAHRENHEIT = 'L87';

    /**
     * ton short per day
     */
    public const REC20_TON_SHORT_PER_DAY = 'L88';

    /**
     * ton short per hour degree Fahrenheit
     */
    public const REC20_TON_SHORT_PER_HOUR_DEGREE_FAHRENHEIT = 'L89';

    /**
     * ton short per hour psi
     */
    public const REC20_TON_SHORT_PER_HOUR_PSI = 'L90';

    /**
     * ton short per psi
     */
    public const REC20_TON_SHORT_PER_PSI = 'L91';

    /**
     * ton (UK long) per cubic yard
     */
    public const REC20_TON_UK_LONG_PER_CUBIC_YARD = 'L92';

    /**
     * ton (US short) per cubic yard
     */
    public const REC20_TON_US_SHORT_PER_CUBIC_YARD = 'L93';

    /**
     * ton-force (US short)
     */
    public const REC20_TONFORCE_US_SHORT = 'L94';

    /**
     * common year
     */
    public const REC20_COMMON_YEAR = 'L95';

    /**
     * sidereal year
     */
    public const REC20_SIDEREAL_YEAR = 'L96';

    /**
     * yard per degree Fahrenheit
     */
    public const REC20_YARD_PER_DEGREE_FAHRENHEIT = 'L98';

    /**
     * yard per psi
     */
    public const REC20_YARD_PER_PSI = 'L99';

    /**
     * pound per cubic inch
     */
    public const REC20_POUND_PER_CUBIC_INCH = 'LA';

    /**
     * lactose excess percentage
     */
    public const REC20_LACTOSE_EXCESS_PERCENTAGE = 'LAC';

    /**
     * pound
     */
    public const REC20_POUND = 'LBR';

    /**
     * troy pound (US)
     */
    public const REC20_TROY_POUND_US = 'LBT';

    /**
     * litre per day
     */
    public const REC20_LITRE_PER_DAY = 'LD';

    /**
     * leaf
     */
    public const REC20_LEAF = 'LEF';

    /**
     * linear foot
     */
    public const REC20_LINEAR_FOOT = 'LF';

    /**
     * labour hour
     */
    public const REC20_LABOUR_HOUR = 'LH';

    /**
     * link
     */
    public const REC20_LINK = 'LK';

    /**
     * linear metre
     */
    public const REC20_LINEAR_METRE = 'LM';

    /**
     * length
     */
    public const REC20_LENGTH = 'LN';

    /**
     * lot  [unit of procurement]
     */
    public const REC20_LOT__UNIT_OF_PROCUREMENT = 'LO';

    /**
     * liquid pound
     */
    public const REC20_LIQUID_POUND = 'LP';

    /**
     * litre of pure alcohol
     */
    public const REC20_LITRE_OF_PURE_ALCOHOL = 'LPA';

    /**
     * layer
     */
    public const REC20_LAYER = 'LR';

    /**
     * lump sum
     */
    public const REC20_LUMP_SUM = 'LS';

    /**
     * ton (UK) or long ton (US)
     */
    public const REC20_TON_UK_OR_LONG_TON_US = 'LTN';

    /**
     * litre
     */
    public const REC20_LITRE = 'LTR';

    /**
     * metric ton, lubricating oil
     */
    public const REC20_METRIC_TON_LUBRICATING_OIL = 'LUB';

    /**
     * lumen
     */
    public const REC20_LUMEN = 'LUM';

    /**
     * lux
     */
    public const REC20_LUX = 'LUX';

    /**
     * linear yard
     */
    public const REC20_LINEAR_YARD = 'LY';

    /**
     * milligram per litre
     */
    public const REC20_MILLIGRAM_PER_LITRE = 'M1';

    /**
     * reciprocal cubic yard
     */
    public const REC20_RECIPROCAL_CUBIC_YARD = 'M10';

    /**
     * cubic yard per degree Fahrenheit
     */
    public const REC20_CUBIC_YARD_PER_DEGREE_FAHRENHEIT = 'M11';

    /**
     * cubic yard per day
     */
    public const REC20_CUBIC_YARD_PER_DAY = 'M12';

    /**
     * cubic yard per hour
     */
    public const REC20_CUBIC_YARD_PER_HOUR = 'M13';

    /**
     * cubic yard per psi
     */
    public const REC20_CUBIC_YARD_PER_PSI = 'M14';

    /**
     * cubic yard per minute
     */
    public const REC20_CUBIC_YARD_PER_MINUTE = 'M15';

    /**
     * cubic yard per second
     */
    public const REC20_CUBIC_YARD_PER_SECOND = 'M16';

    /**
     * kilohertz metre
     */
    public const REC20_KILOHERTZ_METRE = 'M17';

    /**
     * gigahertz metre
     */
    public const REC20_GIGAHERTZ_METRE = 'M18';

    /**
     * Beaufort
     */
    public const REC20_BEAUFORT = 'M19';

    /**
     * reciprocal megakelvin or megakelvin to the power minus one
     */
    public const REC20_RECIPROCAL_MEGAKELVIN_OR_MEGAKELVIN_TO_THE_POWER_MINUS_ONE = 'M20';

    /**
     * reciprocal kilovolt - ampere reciprocal hour
     */
    public const REC20_RECIPROCAL_KILOVOLT__AMPERE_RECIPROCAL_HOUR = 'M21';

    /**
     * millilitre per square centimetre minute
     */
    public const REC20_MILLILITRE_PER_SQUARE_CENTIMETRE_MINUTE = 'M22';

    /**
     * newton per centimetre
     */
    public const REC20_NEWTON_PER_CENTIMETRE = 'M23';

    /**
     * ohm kilometre
     */
    public const REC20_OHM_KILOMETRE = 'M24';

    /**
     * percent per degree Celsius
     */
    public const REC20_PERCENT_PER_DEGREE_CELSIUS = 'M25';

    /**
     * gigaohm per metre
     */
    public const REC20_GIGAOHM_PER_METRE = 'M26';

    /**
     * megahertz metre
     */
    public const REC20_MEGAHERTZ_METRE = 'M27';

    /**
     * kilogram per kilogram
     */
    public const REC20_KILOGRAM_PER_KILOGRAM = 'M29';

    /**
     * reciprocal volt - ampere reciprocal second
     */
    public const REC20_RECIPROCAL_VOLT__AMPERE_RECIPROCAL_SECOND = 'M30';

    /**
     * kilogram per kilometre
     */
    public const REC20_KILOGRAM_PER_KILOMETRE = 'M31';

    /**
     * pascal second per litre
     */
    public const REC20_PASCAL_SECOND_PER_LITRE = 'M32';

    /**
     * millimole per litre
     */
    public const REC20_MILLIMOLE_PER_LITRE = 'M33';

    /**
     * newton metre per square metre
     */
    public const REC20_NEWTON_METRE_PER_SQUARE_METRE = 'M34';

    /**
     * millivolt - ampere
     */
    public const REC20_MILLIVOLT__AMPERE = 'M35';

    /**
     * 30-day month
     */
    public const REC20_30DAY_MONTH = 'M36';

    /**
     * actual/360
     */
    public const REC20_ACTUAL_360 = 'M37';

    /**
     * kilometre per second squared
     */
    public const REC20_KILOMETRE_PER_SECOND_SQUARED = 'M38';

    /**
     * centimetre per second squared
     */
    public const REC20_CENTIMETRE_PER_SECOND_SQUARED = 'M39';

    /**
     * monetary value
     */
    public const REC20_MONETARY_VALUE = 'M4';

    /**
     * yard per second squared
     */
    public const REC20_YARD_PER_SECOND_SQUARED = 'M40';

    /**
     * millimetre per second squared
     */
    public const REC20_MILLIMETRE_PER_SECOND_SQUARED = 'M41';

    /**
     * mile (statute mile) per second squared
     */
    public const REC20_MILE_STATUTE_MILE_PER_SECOND_SQUARED = 'M42';

    /**
     * mil
     */
    public const REC20_MIL = 'M43';

    /**
     * revolution
     */
    public const REC20_REVOLUTION = 'M44';

    /**
     * degree [unit of angle] per second squared
     */
    public const REC20_DEGREE_UNIT_OF_ANGLE_PER_SECOND_SQUARED = 'M45';

    /**
     * revolution per minute
     */
    public const REC20_REVOLUTION_PER_MINUTE = 'M46';

    /**
     * circular mil
     */
    public const REC20_CIRCULAR_MIL = 'M47';

    /**
     * square mile (based on U.S. survey foot)
     */
    public const REC20_SQUARE_MILE_BASED_ON_US_SURVEY_FOOT = 'M48';

    /**
     * chain (based on U.S. survey foot)
     */
    public const REC20_CHAIN_BASED_ON_US_SURVEY_FOOT = 'M49';

    /**
     * microcurie
     */
    public const REC20_MICROCURIE = 'M5';

    /**
     * furlong
     */
    public const REC20_FURLONG = 'M50';

    /**
     * foot (U.S. survey)
     */
    public const REC20_FOOT_US_SURVEY = 'M51';

    /**
     * mile (based on U.S. survey foot)
     */
    public const REC20_MILE_BASED_ON_US_SURVEY_FOOT = 'M52';

    /**
     * metre per pascal
     */
    public const REC20_METRE_PER_PASCAL = 'M53';

    /**
     * metre per radiant
     */
    public const REC20_METRE_PER_RADIANT = 'M55';

    /**
     * shake
     */
    public const REC20_SHAKE = 'M56';

    /**
     * mile per minute
     */
    public const REC20_MILE_PER_MINUTE = 'M57';

    /**
     * mile per second
     */
    public const REC20_MILE_PER_SECOND = 'M58';

    /**
     * metre per second pascal
     */
    public const REC20_METRE_PER_SECOND_PASCAL = 'M59';

    /**
     * metre per hour
     */
    public const REC20_METRE_PER_HOUR = 'M60';

    /**
     * inch per year
     */
    public const REC20_INCH_PER_YEAR = 'M61';

    /**
     * kilometre per second
     */
    public const REC20_KILOMETRE_PER_SECOND = 'M62';

    /**
     * inch per minute
     */
    public const REC20_INCH_PER_MINUTE = 'M63';

    /**
     * yard per second
     */
    public const REC20_YARD_PER_SECOND = 'M64';

    /**
     * yard per minute
     */
    public const REC20_YARD_PER_MINUTE = 'M65';

    /**
     * yard per hour
     */
    public const REC20_YARD_PER_HOUR = 'M66';

    /**
     * acre-foot (based on U.S. survey foot)
     */
    public const REC20_ACREFOOT_BASED_ON_US_SURVEY_FOOT = 'M67';

    /**
     * cord (128 ft3)
     */
    public const REC20_CORD_128_FT3 = 'M68';

    /**
     * cubic mile (UK statute)
     */
    public const REC20_CUBIC_MILE_UK_STATUTE = 'M69';

    /**
     * micro-inch
     */
    public const REC20_MICROINCH = 'M7';

    /**
     * ton, register
     */
    public const REC20_TON_REGISTER = 'M70';

    /**
     * cubic metre per pascal
     */
    public const REC20_CUBIC_METRE_PER_PASCAL = 'M71';

    /**
     * bel
     */
    public const REC20_BEL = 'M72';

    /**
     * kilogram per cubic metre pascal
     */
    public const REC20_KILOGRAM_PER_CUBIC_METRE_PASCAL = 'M73';

    /**
     * kilogram per pascal
     */
    public const REC20_KILOGRAM_PER_PASCAL = 'M74';

    /**
     * kilopound-force
     */
    public const REC20_KILOPOUNDFORCE = 'M75';

    /**
     * poundal
     */
    public const REC20_POUNDAL = 'M76';

    /**
     * kilogram metre per second squared
     */
    public const REC20_KILOGRAM_METRE_PER_SECOND_SQUARED = 'M77';

    /**
     * pond
     */
    public const REC20_POND = 'M78';

    /**
     * square foot per hour
     */
    public const REC20_SQUARE_FOOT_PER_HOUR = 'M79';

    /**
     * stokes per pascal
     */
    public const REC20_STOKES_PER_PASCAL = 'M80';

    /**
     * square centimetre per second
     */
    public const REC20_SQUARE_CENTIMETRE_PER_SECOND = 'M81';

    /**
     * square metre per second pascal
     */
    public const REC20_SQUARE_METRE_PER_SECOND_PASCAL = 'M82';

    /**
     * denier
     */
    public const REC20_DENIER = 'M83';

    /**
     * pound per yard
     */
    public const REC20_POUND_PER_YARD = 'M84';

    /**
     * ton, assay
     */
    public const REC20_TON_ASSAY = 'M85';

    /**
     * pfund
     */
    public const REC20_PFUND = 'M86';

    /**
     * kilogram per second pascal
     */
    public const REC20_KILOGRAM_PER_SECOND_PASCAL = 'M87';

    /**
     * tonne per month
     */
    public const REC20_TONNE_PER_MONTH = 'M88';

    /**
     * tonne per year
     */
    public const REC20_TONNE_PER_YEAR = 'M89';

    /**
     * million Btu per 1000 cubic foot
     */
    public const REC20_MILLION_BTU_PER_1000_CUBIC_FOOT = 'M9';

    /**
     * kilopound per hour
     */
    public const REC20_KILOPOUND_PER_HOUR = 'M90';

    /**
     * pound per pound
     */
    public const REC20_POUND_PER_POUND = 'M91';

    /**
     * pound-force foot
     */
    public const REC20_POUNDFORCE_FOOT = 'M92';

    /**
     * newton metre per radian
     */
    public const REC20_NEWTON_METRE_PER_RADIAN = 'M93';

    /**
     * kilogram metre
     */
    public const REC20_KILOGRAM_METRE = 'M94';

    /**
     * poundal foot
     */
    public const REC20_POUNDAL_FOOT = 'M95';

    /**
     * poundal inch
     */
    public const REC20_POUNDAL_INCH = 'M96';

    /**
     * dyne metre
     */
    public const REC20_DYNE_METRE = 'M97';

    /**
     * kilogram centimetre per second
     */
    public const REC20_KILOGRAM_CENTIMETRE_PER_SECOND = 'M98';

    /**
     * gram centimetre per second
     */
    public const REC20_GRAM_CENTIMETRE_PER_SECOND = 'M99';

    /**
     * megavolt ampere reactive hour
     */
    public const REC20_MEGAVOLT_AMPERE_REACTIVE_HOUR = 'MAH';

    /**
     * megalitre
     */
    public const REC20_MEGALITRE = 'MAL';

    /**
     * megametre
     */
    public const REC20_MEGAMETRE = 'MAM';

    /**
     * megavar
     */
    public const REC20_MEGAVAR = 'MAR';

    /**
     * megawatt
     */
    public const REC20_MEGAWATT = 'MAW';

    /**
     * thousand standard brick equivalent
     */
    public const REC20_THOUSAND_STANDARD_BRICK_EQUIVALENT = 'MBE';

    /**
     * thousand board foot
     */
    public const REC20_THOUSAND_BOARD_FOOT = 'MBF';

    /**
     * millibar
     */
    public const REC20_MILLIBAR = 'MBR';

    /**
     * microgram
     */
    public const REC20_MICROGRAM = 'MC';

    /**
     * millicurie
     */
    public const REC20_MILLICURIE = 'MCU';

    /**
     * air dry metric ton
     */
    public const REC20_AIR_DRY_METRIC_TON = 'MD';

    /**
     * milligram
     */
    public const REC20_MILLIGRAM = 'MGM';

    /**
     * megahertz
     */
    public const REC20_MEGAHERTZ = 'MHZ';

    /**
     * square mile (statute mile)
     */
    public const REC20_SQUARE_MILE_STATUTE_MILE = 'MIK';

    /**
     * thousand
     */
    public const REC20_THOUSAND = 'MIL';

    /**
     * minute [unit of time]
     */
    public const REC20_MINUTE_UNIT_OF_TIME = 'MIN';

    /**
     * million
     */
    public const REC20_MILLION = 'MIO';

    /**
     * million international unit
     */
    public const REC20_MILLION_INTERNATIONAL_UNIT = 'MIU';

    /**
     * milliard
     */
    public const REC20_MILLIARD = 'MLD';

    /**
     * millilitre
     */
    public const REC20_MILLILITRE = 'MLT';

    /**
     * square millimetre
     */
    public const REC20_SQUARE_MILLIMETRE = 'MMK';

    /**
     * cubic millimetre
     */
    public const REC20_CUBIC_MILLIMETRE = 'MMQ';

    /**
     * millimetre
     */
    public const REC20_MILLIMETRE = 'MMT';

    /**
     * kilogram, dry weight
     */
    public const REC20_KILOGRAM_DRY_WEIGHT = 'MND';

    /**
     * month
     */
    public const REC20_MONTH = 'MON';

    /**
     * megapascal
     */
    public const REC20_MEGAPASCAL = 'MPA';

    /**
     * cubic metre per hour
     */
    public const REC20_CUBIC_METRE_PER_HOUR = 'MQH';

    /**
     * cubic metre per second
     */
    public const REC20_CUBIC_METRE_PER_SECOND = 'MQS';

    /**
     * metre per second squared
     */
    public const REC20_METRE_PER_SECOND_SQUARED = 'MSK';

    /**
     * square metre
     */
    public const REC20_SQUARE_METRE = 'MTK';

    /**
     * cubic metre
     */
    public const REC20_CUBIC_METRE = 'MTQ';

    /**
     * metre
     */
    public const REC20_METRE = 'MTR';

    /**
     * metre per second
     */
    public const REC20_METRE_PER_SECOND = 'MTS';

    /**
     * megavolt - ampere
     */
    public const REC20_MEGAVOLT__AMPERE = 'MVA';

    /**
     * megawatt hour (1000 kW.h)
     */
    public const REC20_MEGAWATT_HOUR_1000KWH = 'MWH';

    /**
     * pen calorie
     */
    public const REC20_PEN_CALORIE = 'N1';

    /**
     * pound foot per second
     */
    public const REC20_POUND_FOOT_PER_SECOND = 'N10';

    /**
     * pound inch per second
     */
    public const REC20_POUND_INCH_PER_SECOND = 'N11';

    /**
     * Pferdestaerke
     */
    public const REC20_PFERDESTAERKE = 'N12';

    /**
     * centimetre of mercury (0 ºC)
     */
    public const REC20_CENTIMETRE_OF_MERCURY_0_C = 'N13';

    /**
     * centimetre of water (4 ºC)
     */
    public const REC20_CENTIMETRE_OF_WATER_4_C = 'N14';

    /**
     * foot of water (39.2 ºF)
     */
    public const REC20_FOOT_OF_WATER_392_F = 'N15';

    /**
     * inch of mercury (32 ºF)
     */
    public const REC20_INCH_OF_MERCURY_32_F = 'N16';

    /**
     * inch of mercury (60 ºF)
     */
    public const REC20_INCH_OF_MERCURY_60_F = 'N17';

    /**
     * inch of water (39.2 ºF)
     */
    public const REC20_INCH_OF_WATER_392_F = 'N18';

    /**
     * inch of water (60 ºF)
     */
    public const REC20_INCH_OF_WATER_60_F = 'N19';

    /**
     * kip per square inch
     */
    public const REC20_KIP_PER_SQUARE_INCH = 'N20';

    /**
     * poundal per square foot
     */
    public const REC20_POUNDAL_PER_SQUARE_FOOT = 'N21';

    /**
     * ounce (avoirdupois) per square inch
     */
    public const REC20_OUNCE_AVOIRDUPOIS_PER_SQUARE_INCH = 'N22';

    /**
     * conventional metre of water
     */
    public const REC20_CONVENTIONAL_METRE_OF_WATER = 'N23';

    /**
     * gram per square millimetre
     */
    public const REC20_GRAM_PER_SQUARE_MILLIMETRE = 'N24';

    /**
     * pound per square yard
     */
    public const REC20_POUND_PER_SQUARE_YARD = 'N25';

    /**
     * poundal per square inch
     */
    public const REC20_POUNDAL_PER_SQUARE_INCH = 'N26';

    /**
     * foot to the fourth power
     */
    public const REC20_FOOT_TO_THE_FOURTH_POWER = 'N27';

    /**
     * cubic decimetre per kilogram
     */
    public const REC20_CUBIC_DECIMETRE_PER_KILOGRAM = 'N28';

    /**
     * cubic foot per pound
     */
    public const REC20_CUBIC_FOOT_PER_POUND = 'N29';

    /**
     * print point
     */
    public const REC20_PRINT_POINT = 'N3';

    /**
     * cubic inch per pound
     */
    public const REC20_CUBIC_INCH_PER_POUND = 'N30';

    /**
     * kilonewton per metre
     */
    public const REC20_KILONEWTON_PER_METRE = 'N31';

    /**
     * poundal per inch
     */
    public const REC20_POUNDAL_PER_INCH = 'N32';

    /**
     * pound-force per yard
     */
    public const REC20_POUNDFORCE_PER_YARD = 'N33';

    /**
     * poundal second per square foot
     */
    public const REC20_POUNDAL_SECOND_PER_SQUARE_FOOT = 'N34';

    /**
     * poise per pascal
     */
    public const REC20_POISE_PER_PASCAL = 'N35';

    /**
     * newton second per square metre
     */
    public const REC20_NEWTON_SECOND_PER_SQUARE_METRE = 'N36';

    /**
     * kilogram per metre second
     */
    public const REC20_KILOGRAM_PER_METRE_SECOND = 'N37';

    /**
     * kilogram per metre minute
     */
    public const REC20_KILOGRAM_PER_METRE_MINUTE = 'N38';

    /**
     * kilogram per metre day
     */
    public const REC20_KILOGRAM_PER_METRE_DAY = 'N39';

    /**
     * kilogram per metre hour
     */
    public const REC20_KILOGRAM_PER_METRE_HOUR = 'N40';

    /**
     * gram per centimetre second
     */
    public const REC20_GRAM_PER_CENTIMETRE_SECOND = 'N41';

    /**
     * poundal second per square inch
     */
    public const REC20_POUNDAL_SECOND_PER_SQUARE_INCH = 'N42';

    /**
     * pound per foot minute
     */
    public const REC20_POUND_PER_FOOT_MINUTE = 'N43';

    /**
     * pound per foot day
     */
    public const REC20_POUND_PER_FOOT_DAY = 'N44';

    /**
     * cubic metre per second pascal
     */
    public const REC20_CUBIC_METRE_PER_SECOND_PASCAL = 'N45';

    /**
     * foot poundal
     */
    public const REC20_FOOT_POUNDAL = 'N46';

    /**
     * inch poundal
     */
    public const REC20_INCH_POUNDAL = 'N47';

    /**
     * watt per square centimetre
     */
    public const REC20_WATT_PER_SQUARE_CENTIMETRE = 'N48';

    /**
     * watt per square inch
     */
    public const REC20_WATT_PER_SQUARE_INCH = 'N49';

    /**
     * British thermal unit (international table) per square foot hour
     */
    public const REC20_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_SQUARE_FOOT_HOUR = 'N50';

    /**
     * British thermal unit (thermochemical) per square foot hour
     */
    public const REC20_BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_SQUARE_FOOT_HOUR = 'N51';

    /**
     * British thermal unit (thermochemical) per square foot minute
     */
    public const REC20_BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_SQUARE_FOOT_MINUTE = 'N52';

    /**
     * British thermal unit (international table) per square foot second
     */
    public const REC20_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_SQUARE_FOOT_SECOND = 'N53';

    /**
     * British thermal unit (thermochemical) per square foot second
     */
    public const REC20_BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_SQUARE_FOOT_SECOND = 'N54';

    /**
     * British thermal unit (international table) per square inch second
     */
    public const REC20_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_SQUARE_INCH_SECOND = 'N55';

    /**
     * calorie (thermochemical) per square centimetre minute
     */
    public const REC20_CALORIE_THERMOCHEMICAL_PER_SQUARE_CENTIMETRE_MINUTE = 'N56';

    /**
     * calorie (thermochemical) per square centimetre second
     */
    public const REC20_CALORIE_THERMOCHEMICAL_PER_SQUARE_CENTIMETRE_SECOND = 'N57';

    /**
     * British thermal unit (international table) per cubic foot
     */
    public const REC20_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_CUBIC_FOOT = 'N58';

    /**
     * British thermal unit (thermochemical) per cubic foot
     */
    public const REC20_BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_CUBIC_FOOT = 'N59';

    /**
     * British thermal unit (international table) per degree Fahrenheit
     */
    public const REC20_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_DEGREE_FAHRENHEIT = 'N60';

    /**
     * British thermal unit (thermochemical) per degree Fahrenheit
     */
    public const REC20_BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_DEGREE_FAHRENHEIT = 'N61';

    /**
     * British thermal unit (international table) per degree Rankine
     */
    public const REC20_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_DEGREE_RANKINE = 'N62';

    /**
     * British thermal unit (thermochemical) per degree Rankine
     */
    public const REC20_BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_DEGREE_RANKINE = 'N63';

    /**
     * British thermal unit (thermochemical) per pound degree Rankine
     */
    public const REC20_BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_POUND_DEGREE_RANKINE = 'N64';

    /**
     * kilocalorie (international table) per gram kelvin
     */
    public const REC20_KILOCALORIE_INTERNATIONAL_TABLE_PER_GRAM_KELVIN = 'N65';

    /**
     * British thermal unit (39 ºF)
     */
    public const REC20_BRITISH_THERMAL_UNIT_39_F = 'N66';

    /**
     * British thermal unit (59 ºF)
     */
    public const REC20_BRITISH_THERMAL_UNIT_59_F = 'N67';

    /**
     * British thermal unit (60 ºF)
     */
    public const REC20_BRITISH_THERMAL_UNIT_60_F = 'N68';

    /**
     * calorie (20 ºC)
     */
    public const REC20_CALORIE_20_C = 'N69';

    /**
     * quad (1015 BtuIT)
     */
    public const REC20_QUAD_1015_BTUIT = 'N70';

    /**
     * therm (EC)
     */
    public const REC20_THERM_EC = 'N71';

    /**
     * therm (U.S.)
     */
    public const REC20_THERM_US = 'N72';

    /**
     * British thermal unit (thermochemical) per pound
     */
    public const REC20_BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_POUND = 'N73';

    /**
     * British thermal unit (international table) per hour square foot degree
     * Fahrenheit
     */
    public const REC20_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_HOUR_SQUARE_FOOT_DEGREE_FAHRENHEIT = 'N74';

    /**
     * British thermal unit (thermochemical) per hour square foot degree
     * Fahrenheit
     */
    public const REC20_BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_HOUR_SQUARE_FOOT_DEGREE_FAHRENHEIT = 'N75';

    /**
     * British thermal unit (international table) per second square foot
     * degree Fahrenheit
     */
    public const REC20_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_SECOND_SQUARE_FOOT_DEGREE_FAHRENHEIT = 'N76';

    /**
     * British thermal unit (thermochemical) per second square foot degree
     * Fahrenheit
     */
    public const REC20_BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_SECOND_SQUARE_FOOT_DEGREE_FAHRENHEIT = 'N77';

    /**
     * kilowatt per square metre kelvin
     */
    public const REC20_KILOWATT_PER_SQUARE_METRE_KELVIN = 'N78';

    /**
     * kelvin per pascal
     */
    public const REC20_KELVIN_PER_PASCAL = 'N79';

    /**
     * watt per metre degree Celsius
     */
    public const REC20_WATT_PER_METRE_DEGREE_CELSIUS = 'N80';

    /**
     * kilowatt per metre kelvin
     */
    public const REC20_KILOWATT_PER_METRE_KELVIN = 'N81';

    /**
     * kilowatt per metre degree Celsius
     */
    public const REC20_KILOWATT_PER_METRE_DEGREE_CELSIUS = 'N82';

    /**
     * metre per degree Celcius metre
     */
    public const REC20_METRE_PER_DEGREE_CELCIUS_METRE = 'N83';

    /**
     * degree Fahrenheit hour per British thermal unit (international table)
     */
    public const REC20_DEGREE_FAHRENHEIT_HOUR_PER_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE = 'N84';

    /**
     * degree Fahrenheit hour per British thermal unit (thermochemical)
     */
    public const REC20_DEGREE_FAHRENHEIT_HOUR_PER_BRITISH_THERMAL_UNIT_THERMOCHEMICAL = 'N85';

    /**
     * degree Fahrenheit second per British thermal unit (international
     * table)
     */
    public const REC20_DEGREE_FAHRENHEIT_SECOND_PER_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE = 'N86';

    /**
     * degree Fahrenheit second per British thermal unit (thermochemical)
     */
    public const REC20_DEGREE_FAHRENHEIT_SECOND_PER_BRITISH_THERMAL_UNIT_THERMOCHEMICAL = 'N87';

    /**
     * degree Fahrenheit hour square foot per British thermal unit
     * (international table) inch
     */
    public const REC20_DEGREE_FAHRENHEIT_HOUR_SQUARE_FOOT_PER_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_INCH = 'N88';

    /**
     * degree Fahrenheit hour square foot per British thermal unit
     * (thermochemical) inch
     */
    public const REC20_DEGREE_FAHRENHEIT_HOUR_SQUARE_FOOT_PER_BRITISH_THERMAL_UNIT_THERMOCHEMICAL_INCH = 'N89';

    /**
     * kilofarad
     */
    public const REC20_KILOFARAD = 'N90';

    /**
     * reciprocal joule
     */
    public const REC20_RECIPROCAL_JOULE = 'N91';

    /**
     * picosiemens
     */
    public const REC20_PICOSIEMENS = 'N92';

    /**
     * ampere per pascal
     */
    public const REC20_AMPERE_PER_PASCAL = 'N93';

    /**
     * franklin
     */
    public const REC20_FRANKLIN = 'N94';

    /**
     * ampere minute
     */
    public const REC20_AMPERE_MINUTE = 'N95';

    /**
     * biot
     */
    public const REC20_BIOT = 'N96';

    /**
     * gilbert
     */
    public const REC20_GILBERT = 'N97';

    /**
     * volt per pascal
     */
    public const REC20_VOLT_PER_PASCAL = 'N98';

    /**
     * picovolt
     */
    public const REC20_PICOVOLT = 'N99';

    /**
     * milligram per kilogram
     */
    public const REC20_MILLIGRAM_PER_KILOGRAM = 'NA';

    /**
     * number of articles
     */
    public const REC20_NUMBER_OF_ARTICLES = 'NAR';

    /**
     * number of cells
     */
    public const REC20_NUMBER_OF_CELLS = 'NCL';

    /**
     * newton
     */
    public const REC20_NEWTON = 'NEW';

    /**
     * message
     */
    public const REC20_MESSAGE = 'NF';

    /**
     * nil
     */
    public const REC20_NIL = 'NIL';

    /**
     * number of international units
     */
    public const REC20_NUMBER_OF_INTERNATIONAL_UNITS = 'NIU';

    /**
     * load
     */
    public const REC20_LOAD = 'NL';

    /**
     * Normalised cubic metre
     */
    public const REC20_NORMALISED_CUBIC_METRE = 'NM3';

    /**
     * nautical mile
     */
    public const REC20_NAUTICAL_MILE = 'NMI';

    /**
     * number of packs
     */
    public const REC20_NUMBER_OF_PACKS = 'NMP';

    /**
     * number of parts
     */
    public const REC20_NUMBER_OF_PARTS = 'NPT';

    /**
     * net ton
     */
    public const REC20_NET_TON = 'NT';

    /**
     * newton metre
     */
    public const REC20_NEWTON_METRE = 'NU';

    /**
     * part per thousand
     */
    public const REC20_PART_PER_THOUSAND = 'NX';

    /**
     * panel
     */
    public const REC20_PANEL = 'OA';

    /**
     * ozone depletion equivalent
     */
    public const REC20_OZONE_DEPLETION_EQUIVALENT = 'ODE';

    /**
     * ODS Grams
     */
    public const REC20_ODS_GRAMS = 'ODG';

    /**
     * ODS Kilograms
     */
    public const REC20_ODS_KILOGRAMS = 'ODK';

    /**
     * ODS Milligrams
     */
    public const REC20_ODS_MILLIGRAMS = 'ODM';

    /**
     * ohm
     */
    public const REC20_OHM = 'OHM';

    /**
     * ounce per square yard
     */
    public const REC20_OUNCE_PER_SQUARE_YARD = 'ON';

    /**
     * ounce (avoirdupois)
     */
    public const REC20_OUNCE_AVOIRDUPOIS = 'ONZ';

    /**
     * oscillations per minute
     */
    public const REC20_OSCILLATIONS_PER_MINUTE = 'OPM';

    /**
     * overtime hour
     */
    public const REC20_OVERTIME_HOUR = 'OT';

    /**
     * fluid ounce (US)
     */
    public const REC20_FLUID_OUNCE_US = 'OZA';

    /**
     * fluid ounce (UK)
     */
    public const REC20_FLUID_OUNCE_UK = 'OZI';

    /**
     * percent
     */
    public const REC20_PERCENT = 'P1';

    /**
     * coulomb per metre
     */
    public const REC20_COULOMB_PER_METRE = 'P10';

    /**
     * kiloweber
     */
    public const REC20_KILOWEBER = 'P11';

    /**
     * gamma
     */
    public const REC20_GAMMA = 'P12';

    /**
     * kilotesla
     */
    public const REC20_KILOTESLA = 'P13';

    /**
     * joule per second
     */
    public const REC20_JOULE_PER_SECOND = 'P14';

    /**
     * joule per minute
     */
    public const REC20_JOULE_PER_MINUTE = 'P15';

    /**
     * joule per hour
     */
    public const REC20_JOULE_PER_HOUR = 'P16';

    /**
     * joule per day
     */
    public const REC20_JOULE_PER_DAY = 'P17';

    /**
     * kilojoule per second
     */
    public const REC20_KILOJOULE_PER_SECOND = 'P18';

    /**
     * kilojoule per minute
     */
    public const REC20_KILOJOULE_PER_MINUTE = 'P19';

    /**
     * pound per foot
     */
    public const REC20_POUND_PER_FOOT = 'P2';

    /**
     * kilojoule per hour
     */
    public const REC20_KILOJOULE_PER_HOUR = 'P20';

    /**
     * kilojoule per day
     */
    public const REC20_KILOJOULE_PER_DAY = 'P21';

    /**
     * nanoohm
     */
    public const REC20_NANOOHM = 'P22';

    /**
     * ohm circular-mil per foot
     */
    public const REC20_OHM_CIRCULARMIL_PER_FOOT = 'P23';

    /**
     * kilohenry
     */
    public const REC20_KILOHENRY = 'P24';

    /**
     * lumen per square foot
     */
    public const REC20_LUMEN_PER_SQUARE_FOOT = 'P25';

    /**
     * phot
     */
    public const REC20_PHOT = 'P26';

    /**
     * footcandle
     */
    public const REC20_FOOTCANDLE = 'P27';

    /**
     * candela per square inch
     */
    public const REC20_CANDELA_PER_SQUARE_INCH = 'P28';

    /**
     * footlambert
     */
    public const REC20_FOOTLAMBERT = 'P29';

    /**
     * lambert
     */
    public const REC20_LAMBERT = 'P30';

    /**
     * stilb
     */
    public const REC20_STILB = 'P31';

    /**
     * candela per square foot
     */
    public const REC20_CANDELA_PER_SQUARE_FOOT = 'P32';

    /**
     * kilocandela
     */
    public const REC20_KILOCANDELA = 'P33';

    /**
     * millicandela
     */
    public const REC20_MILLICANDELA = 'P34';

    /**
     * Hefner-Kerze
     */
    public const REC20_HEFNERKERZE = 'P35';

    /**
     * international candle
     */
    public const REC20_INTERNATIONAL_CANDLE = 'P36';

    /**
     * British thermal unit (international table) per square foot
     */
    public const REC20_BRITISH_THERMAL_UNIT_INTERNATIONAL_TABLE_PER_SQUARE_FOOT = 'P37';

    /**
     * British thermal unit (thermochemical) per square foot
     */
    public const REC20_BRITISH_THERMAL_UNIT_THERMOCHEMICAL_PER_SQUARE_FOOT = 'P38';

    /**
     * calorie (thermochemical) per square centimetre
     */
    public const REC20_CALORIE_THERMOCHEMICAL_PER_SQUARE_CENTIMETRE = 'P39';

    /**
     * langley
     */
    public const REC20_LANGLEY = 'P40';

    /**
     * decade (logarithmic)
     */
    public const REC20_DECADE_LOGARITHMIC = 'P41';

    /**
     * pascal squared second
     */
    public const REC20_PASCAL_SQUARED_SECOND = 'P42';

    /**
     * bel per metre
     */
    public const REC20_BEL_PER_METRE = 'P43';

    /**
     * pound mole
     */
    public const REC20_POUND_MOLE = 'P44';

    /**
     * pound mole per second
     */
    public const REC20_POUND_MOLE_PER_SECOND = 'P45';

    /**
     * pound mole per minute
     */
    public const REC20_POUND_MOLE_PER_MINUTE = 'P46';

    /**
     * kilomole per kilogram
     */
    public const REC20_KILOMOLE_PER_KILOGRAM = 'P47';

    /**
     * pound mole per pound
     */
    public const REC20_POUND_MOLE_PER_POUND = 'P48';

    /**
     * newton square metre per ampere
     */
    public const REC20_NEWTON_SQUARE_METRE_PER_AMPERE = 'P49';

    /**
     * five pack
     */
    public const REC20_FIVE_PACK = 'P5';

    /**
     * weber metre
     */
    public const REC20_WEBER_METRE = 'P50';

    /**
     * mol per kilogram pascal
     */
    public const REC20_MOL_PER_KILOGRAM_PASCAL = 'P51';

    /**
     * mol per cubic metre pascal
     */
    public const REC20_MOL_PER_CUBIC_METRE_PASCAL = 'P52';

    /**
     * unit pole
     */
    public const REC20_UNIT_POLE = 'P53';

    /**
     * milligray per second
     */
    public const REC20_MILLIGRAY_PER_SECOND = 'P54';

    /**
     * microgray per second
     */
    public const REC20_MICROGRAY_PER_SECOND = 'P55';

    /**
     * nanogray per second
     */
    public const REC20_NANOGRAY_PER_SECOND = 'P56';

    /**
     * gray per minute
     */
    public const REC20_GRAY_PER_MINUTE = 'P57';

    /**
     * milligray per minute
     */
    public const REC20_MILLIGRAY_PER_MINUTE = 'P58';

    /**
     * microgray per minute
     */
    public const REC20_MICROGRAY_PER_MINUTE = 'P59';

    /**
     * nanogray per minute
     */
    public const REC20_NANOGRAY_PER_MINUTE = 'P60';

    /**
     * gray per hour
     */
    public const REC20_GRAY_PER_HOUR = 'P61';

    /**
     * milligray per hour
     */
    public const REC20_MILLIGRAY_PER_HOUR = 'P62';

    /**
     * microgray per hour
     */
    public const REC20_MICROGRAY_PER_HOUR = 'P63';

    /**
     * nanogray per hour
     */
    public const REC20_NANOGRAY_PER_HOUR = 'P64';

    /**
     * sievert per second
     */
    public const REC20_SIEVERT_PER_SECOND = 'P65';

    /**
     * millisievert per second
     */
    public const REC20_MILLISIEVERT_PER_SECOND = 'P66';

    /**
     * microsievert per second
     */
    public const REC20_MICROSIEVERT_PER_SECOND = 'P67';

    /**
     * nanosievert per second
     */
    public const REC20_NANOSIEVERT_PER_SECOND = 'P68';

    /**
     * rem per second
     */
    public const REC20_REM_PER_SECOND = 'P69';

    /**
     * sievert per hour
     */
    public const REC20_SIEVERT_PER_HOUR = 'P70';

    /**
     * millisievert per hour
     */
    public const REC20_MILLISIEVERT_PER_HOUR = 'P71';

    /**
     * microsievert per hour
     */
    public const REC20_MICROSIEVERT_PER_HOUR = 'P72';

    /**
     * nanosievert per hour
     */
    public const REC20_NANOSIEVERT_PER_HOUR = 'P73';

    /**
     * sievert per minute
     */
    public const REC20_SIEVERT_PER_MINUTE = 'P74';

    /**
     * millisievert per minute
     */
    public const REC20_MILLISIEVERT_PER_MINUTE = 'P75';

    /**
     * microsievert per minute
     */
    public const REC20_MICROSIEVERT_PER_MINUTE = 'P76';

    /**
     * nanosievert per minute
     */
    public const REC20_NANOSIEVERT_PER_MINUTE = 'P77';

    /**
     * reciprocal square inch
     */
    public const REC20_RECIPROCAL_SQUARE_INCH = 'P78';

    /**
     * pascal square metre per kilogram
     */
    public const REC20_PASCAL_SQUARE_METRE_PER_KILOGRAM = 'P79';

    /**
     * millipascal per metre
     */
    public const REC20_MILLIPASCAL_PER_METRE = 'P80';

    /**
     * kilopascal per metre
     */
    public const REC20_KILOPASCAL_PER_METRE = 'P81';

    /**
     * hectopascal per metre
     */
    public const REC20_HECTOPASCAL_PER_METRE = 'P82';

    /**
     * standard atmosphere per metre
     */
    public const REC20_STANDARD_ATMOSPHERE_PER_METRE = 'P83';

    /**
     * technical atmosphere per metre
     */
    public const REC20_TECHNICAL_ATMOSPHERE_PER_METRE = 'P84';

    /**
     * torr per metre
     */
    public const REC20_TORR_PER_METRE = 'P85';

    /**
     * psi per inch
     */
    public const REC20_PSI_PER_INCH = 'P86';

    /**
     * cubic metre per second square metre
     */
    public const REC20_CUBIC_METRE_PER_SECOND_SQUARE_METRE = 'P87';

    /**
     * rhe
     */
    public const REC20_RHE = 'P88';

    /**
     * pound-force foot per inch
     */
    public const REC20_POUNDFORCE_FOOT_PER_INCH = 'P89';

    /**
     * pound-force inch per inch
     */
    public const REC20_POUNDFORCE_INCH_PER_INCH = 'P90';

    /**
     * perm (0 ºC)
     */
    public const REC20_PERM_0_C = 'P91';

    /**
     * perm (23 ºC)
     */
    public const REC20_PERM_23_C = 'P92';

    /**
     * byte per second
     */
    public const REC20_BYTE_PER_SECOND = 'P93';

    /**
     * kilobyte per second
     */
    public const REC20_KILOBYTE_PER_SECOND = 'P94';

    /**
     * megabyte per second
     */
    public const REC20_MEGABYTE_PER_SECOND = 'P95';

    /**
     * reciprocal volt
     */
    public const REC20_RECIPROCAL_VOLT = 'P96';

    /**
     * reciprocal radian
     */
    public const REC20_RECIPROCAL_RADIAN = 'P97';

    /**
     * pascal to the power sum of stoichiometric numbers
     */
    public const REC20_PASCAL_TO_THE_POWER_SUM_OF_STOICHIOMETRIC_NUMBERS = 'P98';

    /**
     * mole per cubiv metre to the power sum of stoichiometric numbers
     */
    public const REC20_MOLE_PER_CUBIV_METRE_TO_THE_POWER_SUM_OF_STOICHIOMETRIC_NUMBERS = 'P99';

    /**
     * pascal
     */
    public const REC20_PASCAL = 'PAL';

    /**
     * pad
     */
    public const REC20_PAD = 'PD';

    /**
     * proof litre
     */
    public const REC20_PROOF_LITRE = 'PFL';

    /**
     * proof gallon
     */
    public const REC20_PROOF_GALLON = 'PGL';

    /**
     * pitch
     */
    public const REC20_PITCH = 'PI';

    /**
     * degree Plato
     */
    public const REC20_DEGREE_PLATO = 'PLA';

    /**
     * pound per inch of length
     */
    public const REC20_POUND_PER_INCH_OF_LENGTH = 'PO';

    /**
     * page per inch
     */
    public const REC20_PAGE_PER_INCH = 'PQ';

    /**
     * pair
     */
    public const REC20_PAIR = 'PR';

    /**
     * pound-force per square inch
     */
    public const REC20_POUNDFORCE_PER_SQUARE_INCH = 'PS';

    /**
     * dry pint (US)
     */
    public const REC20_DRY_PINT_US = 'PTD';

    /**
     * pint (UK)
     */
    public const REC20_PINT_UK = 'PTI';

    /**
     * liquid pint (US)
     */
    public const REC20_LIQUID_PINT_US = 'PTL';

    /**
     * portion
     */
    public const REC20_PORTION = 'PTN';

    /**
     * joule per tesla
     */
    public const REC20_JOULE_PER_TESLA = 'Q10';

    /**
     * erlang
     */
    public const REC20_ERLANG = 'Q11';

    /**
     * octet
     */
    public const REC20_OCTET = 'Q12';

    /**
     * octet per second
     */
    public const REC20_OCTET_PER_SECOND = 'Q13';

    /**
     * shannon
     */
    public const REC20_SHANNON = 'Q14';

    /**
     * hartley
     */
    public const REC20_HARTLEY = 'Q15';

    /**
     * natural unit of information
     */
    public const REC20_NATURAL_UNIT_OF_INFORMATION = 'Q16';

    /**
     * shannon per second
     */
    public const REC20_SHANNON_PER_SECOND = 'Q17';

    /**
     * hartley per second
     */
    public const REC20_HARTLEY_PER_SECOND = 'Q18';

    /**
     * natural unit of information per second
     */
    public const REC20_NATURAL_UNIT_OF_INFORMATION_PER_SECOND = 'Q19';

    /**
     * second per kilogramm
     */
    public const REC20_SECOND_PER_KILOGRAMM = 'Q20';

    /**
     * watt square metre
     */
    public const REC20_WATT_SQUARE_METRE = 'Q21';

    /**
     * second per radian cubic metre
     */
    public const REC20_SECOND_PER_RADIAN_CUBIC_METRE = 'Q22';

    /**
     * weber to the power minus one
     */
    public const REC20_WEBER_TO_THE_POWER_MINUS_ONE = 'Q23';

    /**
     * reciprocal inch
     */
    public const REC20_RECIPROCAL_INCH = 'Q24';

    /**
     * dioptre
     */
    public const REC20_DIOPTRE = 'Q25';

    /**
     * one per one
     */
    public const REC20_ONE_PER_ONE = 'Q26';

    /**
     * newton metre per metre
     */
    public const REC20_NEWTON_METRE_PER_METRE = 'Q27';

    /**
     * kilogram per square metre pascal second
     */
    public const REC20_KILOGRAM_PER_SQUARE_METRE_PASCAL_SECOND = 'Q28';

    /**
     * microgram per hectogram
     */
    public const REC20_MICROGRAM_PER_HECTOGRAM = 'Q29';

    /**
     * pH (potential of Hydrogen)
     */
    public const REC20_PH_POTENTIAL_OF_HYDROGEN = 'Q30';

    /**
     * kilojoule per gram
     */
    public const REC20_KILOJOULE_PER_GRAM = 'Q31';

    /**
     * femtolitre
     */
    public const REC20_FEMTOLITRE = 'Q32';

    /**
     * picolitre
     */
    public const REC20_PICOLITRE = 'Q33';

    /**
     * nanolitre
     */
    public const REC20_NANOLITRE = 'Q34';

    /**
     * megawatts per minute
     */
    public const REC20_MEGAWATTS_PER_MINUTE = 'Q35';

    /**
     * square metre per cubic metre
     */
    public const REC20_SQUARE_METRE_PER_CUBIC_METRE = 'Q36';

    /**
     * Standard cubic metre per day
     */
    public const REC20_STANDARD_CUBIC_METRE_PER_DAY = 'Q37';

    /**
     * Standard cubic metre per hour
     */
    public const REC20_STANDARD_CUBIC_METRE_PER_HOUR = 'Q38';

    /**
     * Normalized cubic metre per day
     */
    public const REC20_NORMALIZED_CUBIC_METRE_PER_DAY = 'Q39';

    /**
     * Normalized cubic metre per hour
     */
    public const REC20_NORMALIZED_CUBIC_METRE_PER_HOUR = 'Q40';

    /**
     * Joule per normalised cubic metre
     */
    public const REC20_JOULE_PER_NORMALISED_CUBIC_METRE = 'Q41';

    /**
     * Joule per standard cubic metre
     */
    public const REC20_JOULE_PER_STANDARD_CUBIC_METRE = 'Q42';

    /**
     * meal
     */
    public const REC20_MEAL = 'Q3';

    /**
     * page - facsimile
     */
    public const REC20_PAGE__FACSIMILE = 'QA';

    /**
     * quarter (of a year)
     */
    public const REC20_QUARTER_OF_A_YEAR = 'QAN';

    /**
     * page - hardcopy
     */
    public const REC20_PAGE__HARDCOPY = 'QB';

    /**
     * quire
     */
    public const REC20_QUIRE = 'QR';

    /**
     * dry quart (US)
     */
    public const REC20_DRY_QUART_US = 'QTD';

    /**
     * quart (UK)
     */
    public const REC20_QUART_UK = 'QTI';

    /**
     * liquid quart (US)
     */
    public const REC20_LIQUID_QUART_US = 'QTL';

    /**
     * quarter (UK)
     */
    public const REC20_QUARTER_UK = 'QTR';

    /**
     * pica
     */
    public const REC20_PICA = 'R1';

    /**
     * thousand cubic metre
     */
    public const REC20_THOUSAND_CUBIC_METRE = 'R9';

    /**
     * running or operating hour
     */
    public const REC20_RUNNING_OR_OPERATING_HOUR = 'RH';

    /**
     * ream
     */
    public const REC20_REAM = 'RM';

    /**
     * room
     */
    public const REC20_ROOM = 'ROM';

    /**
     * pound per ream
     */
    public const REC20_POUND_PER_REAM = 'RP';

    /**
     * revolutions per minute
     */
    public const REC20_REVOLUTIONS_PER_MINUTE = 'RPM';

    /**
     * revolutions per second
     */
    public const REC20_REVOLUTIONS_PER_SECOND = 'RPS';

    /**
     * revenue ton mile
     */
    public const REC20_REVENUE_TON_MILE = 'RT';

    /**
     * square foot per second
     */
    public const REC20_SQUARE_FOOT_PER_SECOND = 'S3';

    /**
     * square metre per second
     */
    public const REC20_SQUARE_METRE_PER_SECOND = 'S4';

    /**
     * half year (6 months)
     */
    public const REC20_HALF_YEAR_6_MONTHS = 'SAN';

    /**
     * score
     */
    public const REC20_SCORE = 'SCO';

    /**
     * scruple
     */
    public const REC20_SCRUPLE = 'SCR';

    /**
     * second [unit of time]
     */
    public const REC20_SECOND_UNIT_OF_TIME = 'SEC';

    /**
     * set
     */
    public const REC20_SET = 'SET';

    /**
     * segment
     */
    public const REC20_SEGMENT = 'SG';

    /**
     * siemens
     */
    public const REC20_SIEMENS = 'SIE';

    /**
     * Standard cubic metre
     */
    public const REC20_STANDARD_CUBIC_METRE = 'SM3';

    /**
     * mile (statute mile)
     */
    public const REC20_MILE_STATUTE_MILE = 'SMI';

    /**
     * square
     */
    public const REC20_SQUARE = 'SQ';

    /**
     * square, roofing
     */
    public const REC20_SQUARE_ROOFING = 'SQR';

    /**
     * strip
     */
    public const REC20_STRIP = 'SR';

    /**
     * stick
     */
    public const REC20_STICK = 'STC';

    /**
     * stone (UK)
     */
    public const REC20_STONE_UK = 'STI';

    /**
     * stick, cigarette
     */
    public const REC20_STICK_CIGARETTE = 'STK';

    /**
     * standard litre
     */
    public const REC20_STANDARD_LITRE = 'STL';

    /**
     * ton (US) or short ton (UK/US)
     */
    public const REC20_TON_US_OR_SHORT_TON_UK_US = 'STN';

    /**
     * straw
     */
    public const REC20_STRAW = 'STW';

    /**
     * skein
     */
    public const REC20_SKEIN = 'SW';

    /**
     * shipment
     */
    public const REC20_SHIPMENT = 'SX';

    /**
     * syringe
     */
    public const REC20_SYRINGE = 'SYR';

    /**
     * telecommunication line in service
     */
    public const REC20_TELECOMMUNICATION_LINE_IN_SERVICE = 'T0';

    /**
     * thousand piece
     */
    public const REC20_THOUSAND_PIECE = 'T3';

    /**
     * kiloampere hour (thousand ampere hour)
     */
    public const REC20_KILOAMPERE_HOUR_THOUSAND_AMPERE_HOUR = 'TAH';

    /**
     * total acid number
     */
    public const REC20_TOTAL_ACID_NUMBER = 'TAN';

    /**
     * thousand square inch
     */
    public const REC20_THOUSAND_SQUARE_INCH = 'TI';

    /**
     * metric ton, including container
     */
    public const REC20_METRIC_TON_INCLUDING_CONTAINER = 'TIC';

    /**
     * metric ton, including inner packaging
     */
    public const REC20_METRIC_TON_INCLUDING_INNER_PACKAGING = 'TIP';

    /**
     * tonne kilometre
     */
    public const REC20_TONNE_KILOMETRE = 'TKM';

    /**
     * kilogram of imported meat, less offal
     */
    public const REC20_KILOGRAM_OF_IMPORTED_MEAT_LESS_OFFAL = 'TMS';

    /**
     * tonne (metric ton)
     */
    public const REC20_TONNE_METRIC_TON = 'TNE';

    /**
     * ten pack
     */
    public const REC20_TEN_PACK = 'TP';

    /**
     * teeth per inch
     */
    public const REC20_TEETH_PER_INCH = 'TPI';

    /**
     * ten pair
     */
    public const REC20_TEN_PAIR = 'TPR';

    /**
     * thousand cubic metre per day
     */
    public const REC20_THOUSAND_CUBIC_METRE_PER_DAY = 'TQD';

    /**
     * trillion (EUR)
     */
    public const REC20_TRILLION_EUR = 'TRL';

    /**
     * ten set
     */
    public const REC20_TEN_SET = 'TST';

    /**
     * ten thousand sticks
     */
    public const REC20_TEN_THOUSAND_STICKS = 'TTS';

    /**
     * treatment
     */
    public const REC20_TREATMENT = 'U1';

    /**
     * tablet
     */
    public const REC20_TABLET = 'U2';

    /**
     * telecommunication line in service average
     */
    public const REC20_TELECOMMUNICATION_LINE_IN_SERVICE_AVERAGE = 'UB';

    /**
     * telecommunication port
     */
    public const REC20_TELECOMMUNICATION_PORT = 'UC';

    /**
     * volt - ampere per kilogram
     */
    public const REC20_VOLT__AMPERE_PER_KILOGRAM = 'VA';

    /**
     * volt
     */
    public const REC20_VOLT = 'VLT';

    /**
     * percent volume
     */
    public const REC20_PERCENT_VOLUME = 'VP';

    /**
     * wet kilo
     */
    public const REC20_WET_KILO = 'W2';

    /**
     * watt per kilogram
     */
    public const REC20_WATT_PER_KILOGRAM = 'WA';

    /**
     * wet pound
     */
    public const REC20_WET_POUND = 'WB';

    /**
     * cord
     */
    public const REC20_CORD = 'WCD';

    /**
     * wet ton
     */
    public const REC20_WET_TON = 'WE';

    /**
     * weber
     */
    public const REC20_WEBER = 'WEB';

    /**
     * week
     */
    public const REC20_WEEK = 'WEE';

    /**
     * wine gallon
     */
    public const REC20_WINE_GALLON = 'WG';

    /**
     * watt hour
     */
    public const REC20_WATT_HOUR = 'WHR';

    /**
     * working month
     */
    public const REC20_WORKING_MONTH = 'WM';

    /**
     * standard
     */
    public const REC20_STANDARD = 'WSD';

    /**
     * watt
     */
    public const REC20_WATT = 'WTT';

    /**
     * Gunter's chain
     */
    public const REC20_GUNTERS_CHAIN = 'X1';

    /**
     * square yard
     */
    public const REC20_SQUARE_YARD = 'YDK';

    /**
     * cubic yard
     */
    public const REC20_CUBIC_YARD = 'YDQ';

    /**
     * yard
     */
    public const REC20_YARD = 'YRD';

    /**
     * hanging container
     */
    public const REC20_HANGING_CONTAINER = 'Z11';

    /**
     * page
     */
    public const REC20_PAGE = 'ZP';

    /**
     * mutually defined
     */
    public const REC20_MUTUALLY_DEFINED = 'ZZ';

    /**
     * Drum, steel
     */
    public const REC21_DRUM_STEEL = 'X1A';

    /**
     * Drum, aluminium
     */
    public const REC21_DRUM_ALUMINIUM = 'X1B';

    /**
     * Drum, plywood
     */
    public const REC21_DRUM_PLYWOOD = 'X1D';

    /**
     * Container, flexible
     */
    public const REC21_CONTAINER_FLEXIBLE = 'X1F';

    /**
     * Drum, fibre
     */
    public const REC21_DRUM_FIBRE = 'X1G';

    /**
     * Drum, wooden
     */
    public const REC21_DRUM_WOODEN = 'X1W';

    /**
     * Barrel, wooden
     */
    public const REC21_BARREL_WOODEN = 'X2C';

    /**
     * Jerrican, steel
     */
    public const REC21_JERRICAN_STEEL = 'X3A';

    /**
     * Jerrican, plastic
     */
    public const REC21_JERRICAN_PLASTIC = 'X3H';

    /**
     * Bag, super bulk
     */
    public const REC21_BAG_SUPER_BULK = 'X43';

    /**
     * Bag, polybag
     */
    public const REC21_BAG_POLYBAG = 'X44';

    /**
     * Box, steel
     */
    public const REC21_BOX_STEEL = 'X4A';

    /**
     * Box, aluminium
     */
    public const REC21_BOX_ALUMINIUM = 'X4B';

    /**
     * Box, natural wood
     */
    public const REC21_BOX_NATURAL_WOOD = 'X4C';

    /**
     * Box, plywood
     */
    public const REC21_BOX_PLYWOOD = 'X4D';

    /**
     * Box, reconstituted wood
     */
    public const REC21_BOX_RECONSTITUTED_WOOD = 'X4F';

    /**
     * Box, fibreboard
     */
    public const REC21_BOX_FIBREBOARD = 'X4G';

    /**
     * Box, plastic
     */
    public const REC21_BOX_PLASTIC = 'X4H';

    /**
     * Bag, woven plastic
     */
    public const REC21_BAG_WOVEN_PLASTIC = 'X5H';

    /**
     * Bag, textile
     */
    public const REC21_BAG_TEXTILE = 'X5L';

    /**
     * Bag, paper
     */
    public const REC21_BAG_PAPER = 'X5M';

    /**
     * Composite packaging, plastic receptacle
     */
    public const REC21_COMPOSITE_PACKAGING_PLASTIC_RECEPTACLE = 'X6H';

    /**
     * Composite packaging, glass receptacle
     */
    public const REC21_COMPOSITE_PACKAGING_GLASS_RECEPTACLE = 'X6P';

    /**
     * Case, car
     */
    public const REC21_CASE_CAR = 'X7A';

    /**
     * Case, wooden
     */
    public const REC21_CASE_WOODEN = 'X7B';

    /**
     * Pallet, wooden
     */
    public const REC21_PALLET_WOODEN = 'X8A';

    /**
     * Crate, wooden
     */
    public const REC21_CRATE_WOODEN = 'X8B';

    /**
     * Bundle, wooden
     */
    public const REC21_BUNDLE_WOODEN = 'X8C';

    /**
     * Intermediate bulk container, rigid plastic
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_RIGID_PLASTIC = 'XAA';

    /**
     * Receptacle, fibre
     */
    public const REC21_RECEPTACLE_FIBRE = 'XAB';

    /**
     * Receptacle, paper
     */
    public const REC21_RECEPTACLE_PAPER = 'XAC';

    /**
     * Receptacle, wooden
     */
    public const REC21_RECEPTACLE_WOODEN = 'XAD';

    /**
     * Aerosol
     */
    public const REC21_AEROSOL = 'XAE';

    /**
     * Pallet, modular, collars 80cms * 60cms
     */
    public const REC21_PALLET_MODULAR_COLLARS_80CMS__60CMS = 'XAF';

    /**
     * Pallet, shrinkwrapped
     */
    public const REC21_PALLET_SHRINKWRAPPED = 'XAG';

    /**
     * Pallet, 100cms * 110cms
     */
    public const REC21_PALLET_100CMS__110CMS = 'XAH';

    /**
     * Clamshell
     */
    public const REC21_CLAMSHELL = 'XAI';

    /**
     * Cone
     */
    public const REC21_CONE = 'XAJ';

    /**
     * Ball
     */
    public const REC21_BALL = 'XAL';

    /**
     * Ampoule, non-protected
     */
    public const REC21_AMPOULE_NONPROTECTED = 'XAM';

    /**
     * Ampoule, protected
     */
    public const REC21_AMPOULE_PROTECTED = 'XAP';

    /**
     * Atomizer
     */
    public const REC21_ATOMIZER = 'XAT';

    /**
     * Capsule
     */
    public const REC21_CAPSULE = 'XAV';

    /**
     * Belt
     */
    public const REC21_BELT = 'XB4';

    /**
     * Barrel
     */
    public const REC21_BARREL = 'XBA';

    /**
     * Bobbin
     */
    public const REC21_BOBBIN = 'XBB';

    /**
     * Bottlecrate / bottlerack
     */
    public const REC21_BOTTLECRATE___BOTTLERACK = 'XBC';

    /**
     * Board
     */
    public const REC21_BOARD = 'XBD';

    /**
     * Bundle
     */
    public const REC21_BUNDLE = 'XBE';

    /**
     * Balloon, non-protected
     */
    public const REC21_BALLOON_NONPROTECTED = 'XBF';

    /**
     * Bag
     */
    public const REC21_BAG = 'XBG';

    /**
     * Bunch
     */
    public const REC21_BUNCH = 'XBH';

    /**
     * Bin
     */
    public const REC21_BIN = 'XBI';

    /**
     * Bucket
     */
    public const REC21_BUCKET = 'XBJ';

    /**
     * Basket
     */
    public const REC21_BASKET = 'XBK';

    /**
     * Bale, compressed
     */
    public const REC21_BALE_COMPRESSED = 'XBL';

    /**
     * Basin
     */
    public const REC21_BASIN = 'XBM';

    /**
     * Bale, non-compressed
     */
    public const REC21_BALE_NONCOMPRESSED = 'XBN';

    /**
     * Bottle, non-protected, cylindrical
     */
    public const REC21_BOTTLE_NONPROTECTED_CYLINDRICAL = 'XBO';

    /**
     * Balloon, protected
     */
    public const REC21_BALLOON_PROTECTED = 'XBP';

    /**
     * Bottle, protected cylindrical
     */
    public const REC21_BOTTLE_PROTECTED_CYLINDRICAL = 'XBQ';

    /**
     * Bar
     */
    public const REC21_BAR = 'XBR';

    /**
     * Bottle, non-protected, bulbous
     */
    public const REC21_BOTTLE_NONPROTECTED_BULBOUS = 'XBS';

    /**
     * Bolt
     */
    public const REC21_BOLT = 'XBT';

    /**
     * Butt
     */
    public const REC21_BUTT = 'XBU';

    /**
     * Bottle, protected bulbous
     */
    public const REC21_BOTTLE_PROTECTED_BULBOUS = 'XBV';

    /**
     * Box, for liquids
     */
    public const REC21_BOX_FOR_LIQUIDS = 'XBW';

    /**
     * Box
     */
    public const REC21_BOX = 'XBX';

    /**
     * Board, in bundle/bunch/truss
     */
    public const REC21_BOARD_IN_BUNDLE_BUNCH_TRUSS = 'XBY';

    /**
     * Bars, in bundle/bunch/truss
     */
    public const REC21_BARS_IN_BUNDLE_BUNCH_TRUSS = 'XBZ';

    /**
     * Can, rectangular
     */
    public const REC21_CAN_RECTANGULAR = 'XCA';

    /**
     * Crate, beer
     */
    public const REC21_CRATE_BEER = 'XCB';

    /**
     * Churn
     */
    public const REC21_CHURN = 'XCC';

    /**
     * Can, with handle and spout
     */
    public const REC21_CAN_WITH_HANDLE_AND_SPOUT = 'XCD';

    /**
     * Creel
     */
    public const REC21_CREEL = 'XCE';

    /**
     * Coffer
     */
    public const REC21_COFFER = 'XCF';

    /**
     * Cage
     */
    public const REC21_CAGE = 'XCG';

    /**
     * Chest
     */
    public const REC21_CHEST = 'XCH';

    /**
     * Canister
     */
    public const REC21_CANISTER = 'XCI';

    /**
     * Coffin
     */
    public const REC21_COFFIN = 'XCJ';

    /**
     * Cask
     */
    public const REC21_CASK = 'XCK';

    /**
     * Coil
     */
    public const REC21_COIL = 'XCL';

    /**
     * Card
     */
    public const REC21_CARD = 'XCM';

    /**
     * Container, not otherwise specified as transport equipment
     */
    public const REC21_CONTAINER_NOT_OTHERWISE_SPECIFIED_AS_TRANSPORT_EQUIPMENT = 'XCN';

    /**
     * Carboy, non-protected
     */
    public const REC21_CARBOY_NONPROTECTED = 'XCO';

    /**
     * Carboy, protected
     */
    public const REC21_CARBOY_PROTECTED = 'XCP';

    /**
     * Cartridge
     */
    public const REC21_CARTRIDGE = 'XCQ';

    /**
     * Crate
     */
    public const REC21_CRATE = 'XCR';

    /**
     * Case
     */
    public const REC21_CASE = 'XCS';

    /**
     * Carton
     */
    public const REC21_CARTON = 'XCT';

    /**
     * Cup
     */
    public const REC21_CUP = 'XCU';

    /**
     * Cover
     */
    public const REC21_COVER = 'XCV';

    /**
     * Cage, roll
     */
    public const REC21_CAGE_ROLL = 'XCW';

    /**
     * Can, cylindrical
     */
    public const REC21_CAN_CYLINDRICAL = 'XCX';

    /**
     * Cylinder
     */
    public const REC21_CYLINDER = 'XCY';

    /**
     * Canvas
     */
    public const REC21_CANVAS = 'XCZ';

    /**
     * Crate, multiple layer, plastic
     */
    public const REC21_CRATE_MULTIPLE_LAYER_PLASTIC = 'XDA';

    /**
     * Crate, multiple layer, wooden
     */
    public const REC21_CRATE_MULTIPLE_LAYER_WOODEN = 'XDB';

    /**
     * Crate, multiple layer, cardboard
     */
    public const REC21_CRATE_MULTIPLE_LAYER_CARDBOARD = 'XDC';

    /**
     * Cage, Commonwealth Handling Equipment Pool  (CHEP)
     */
    public const REC21_CAGE_COMMONWEALTH_HANDLING_EQUIPMENT_POOL__CHEP = 'XDG';

    /**
     * Box, Commonwealth Handling Equipment Pool (CHEP), Eurobox
     */
    public const REC21_BOX_COMMONWEALTH_HANDLING_EQUIPMENT_POOL_CHEP_EUROBOX = 'XDH';

    /**
     * Drum, iron
     */
    public const REC21_DRUM_IRON = 'XDI';

    /**
     * Demijohn, non-protected
     */
    public const REC21_DEMIJOHN_NONPROTECTED = 'XDJ';

    /**
     * Crate, bulk, cardboard
     */
    public const REC21_CRATE_BULK_CARDBOARD = 'XDK';

    /**
     * Crate, bulk, plastic
     */
    public const REC21_CRATE_BULK_PLASTIC = 'XDL';

    /**
     * Crate, bulk, wooden
     */
    public const REC21_CRATE_BULK_WOODEN = 'XDM';

    /**
     * Dispenser
     */
    public const REC21_DISPENSER = 'XDN';

    /**
     * Demijohn, protected
     */
    public const REC21_DEMIJOHN_PROTECTED = 'XDP';

    /**
     * Drum
     */
    public const REC21_DRUM = 'XDR';

    /**
     * Tray, one layer no cover, plastic
     */
    public const REC21_TRAY_ONE_LAYER_NO_COVER_PLASTIC = 'XDS';

    /**
     * Tray, one layer no cover, wooden
     */
    public const REC21_TRAY_ONE_LAYER_NO_COVER_WOODEN = 'XDT';

    /**
     * Tray, one layer no cover, polystyrene
     */
    public const REC21_TRAY_ONE_LAYER_NO_COVER_POLYSTYRENE = 'XDU';

    /**
     * Tray, one layer no cover, cardboard
     */
    public const REC21_TRAY_ONE_LAYER_NO_COVER_CARDBOARD = 'XDV';

    /**
     * Tray, two layers no cover, plastic tray
     */
    public const REC21_TRAY_TWO_LAYERS_NO_COVER_PLASTIC_TRAY = 'XDW';

    /**
     * Tray, two layers no cover, wooden
     */
    public const REC21_TRAY_TWO_LAYERS_NO_COVER_WOODEN = 'XDX';

    /**
     * Tray, two layers no cover, cardboard
     */
    public const REC21_TRAY_TWO_LAYERS_NO_COVER_CARDBOARD = 'XDY';

    /**
     * Bag, plastic
     */
    public const REC21_BAG_PLASTIC = 'XEC';

    /**
     * Case, with pallet base
     */
    public const REC21_CASE_WITH_PALLET_BASE = 'XED';

    /**
     * Case, with pallet base, wooden
     */
    public const REC21_CASE_WITH_PALLET_BASE_WOODEN = 'XEE';

    /**
     * Case, with pallet base, cardboard
     */
    public const REC21_CASE_WITH_PALLET_BASE_CARDBOARD = 'XEF';

    /**
     * Case, with pallet base, plastic
     */
    public const REC21_CASE_WITH_PALLET_BASE_PLASTIC = 'XEG';

    /**
     * Case, with pallet base, metal
     */
    public const REC21_CASE_WITH_PALLET_BASE_METAL = 'XEH';

    /**
     * Case, isothermic
     */
    public const REC21_CASE_ISOTHERMIC = 'XEI';

    /**
     * Envelope
     */
    public const REC21_ENVELOPE = 'XEN';

    /**
     * Flexibag
     */
    public const REC21_FLEXIBAG = 'XFB';

    /**
     * Crate, fruit
     */
    public const REC21_CRATE_FRUIT = 'XFC';

    /**
     * Crate, framed
     */
    public const REC21_CRATE_FRAMED = 'XFD';

    /**
     * Flexitank
     */
    public const REC21_FLEXITANK = 'XFE';

    /**
     * Firkin
     */
    public const REC21_FIRKIN = 'XFI';

    /**
     * Flask
     */
    public const REC21_FLASK = 'XFL';

    /**
     * Footlocker
     */
    public const REC21_FOOTLOCKER = 'XFO';

    /**
     * Filmpack
     */
    public const REC21_FILMPACK = 'XFP';

    /**
     * Frame
     */
    public const REC21_FRAME = 'XFR';

    /**
     * Foodtainer
     */
    public const REC21_FOODTAINER = 'XFT';

    /**
     * Cart, flatbed
     */
    public const REC21_CART_FLATBED = 'XFW';

    /**
     * Bag, flexible container
     */
    public const REC21_BAG_FLEXIBLE_CONTAINER = 'XFX';

    /**
     * Bottle, gas
     */
    public const REC21_BOTTLE_GAS = 'XGB';

    /**
     * Girder
     */
    public const REC21_GIRDER = 'XGI';

    /**
     * Container, gallon
     */
    public const REC21_CONTAINER_GALLON = 'XGL';

    /**
     * Receptacle, glass
     */
    public const REC21_RECEPTACLE_GLASS = 'XGR';

    /**
     * Tray, containing horizontally stacked flat items
     */
    public const REC21_TRAY_CONTAINING_HORIZONTALLY_STACKED_FLAT_ITEMS = 'XGU';

    /**
     * Bag, gunny
     */
    public const REC21_BAG_GUNNY = 'XGY';

    /**
     * Girders, in bundle/bunch/truss
     */
    public const REC21_GIRDERS_IN_BUNDLE_BUNCH_TRUSS = 'XGZ';

    /**
     * Basket, with handle, plastic
     */
    public const REC21_BASKET_WITH_HANDLE_PLASTIC = 'XHA';

    /**
     * Basket, with handle, wooden
     */
    public const REC21_BASKET_WITH_HANDLE_WOODEN = 'XHB';

    /**
     * Basket, with handle, cardboard
     */
    public const REC21_BASKET_WITH_HANDLE_CARDBOARD = 'XHC';

    /**
     * Hogshead
     */
    public const REC21_HOGSHEAD = 'XHG';

    /**
     * Hanger
     */
    public const REC21_HANGER = 'XHN';

    /**
     * Hamper
     */
    public const REC21_HAMPER = 'XHR';

    /**
     * Package, display, wooden
     */
    public const REC21_PACKAGE_DISPLAY_WOODEN = 'XIA';

    /**
     * Package, display, cardboard
     */
    public const REC21_PACKAGE_DISPLAY_CARDBOARD = 'XIB';

    /**
     * Package, display, plastic
     */
    public const REC21_PACKAGE_DISPLAY_PLASTIC = 'XIC';

    /**
     * Package, display, metal
     */
    public const REC21_PACKAGE_DISPLAY_METAL = 'XID';

    /**
     * Package, show
     */
    public const REC21_PACKAGE_SHOW = 'XIE';

    /**
     * Package, flow
     */
    public const REC21_PACKAGE_FLOW = 'XIF';

    /**
     * Package, paper wrapped
     */
    public const REC21_PACKAGE_PAPER_WRAPPED = 'XIG';

    /**
     * Drum, plastic
     */
    public const REC21_DRUM_PLASTIC = 'XIH';

    /**
     * Package, cardboard, with bottle grip-holes
     */
    public const REC21_PACKAGE_CARDBOARD_WITH_BOTTLE_GRIPHOLES = 'XIK';

    /**
     * Tray, rigid, lidded stackable (CEN TS 14482:2002)
     */
    public const REC21_TRAY_RIGID_LIDDED_STACKABLE_CEN_TS_144822002 = 'XIL';

    /**
     * Ingot
     */
    public const REC21_INGOT = 'XIN';

    /**
     * Ingots, in bundle/bunch/truss
     */
    public const REC21_INGOTS_IN_BUNDLE_BUNCH_TRUSS = 'XIZ';

    /**
     * Bag, jumbo
     */
    public const REC21_BAG_JUMBO = 'XJB';

    /**
     * Jerrican, rectangular
     */
    public const REC21_JERRICAN_RECTANGULAR = 'XJC';

    /**
     * Jug
     */
    public const REC21_JUG = 'XJG';

    /**
     * Jar
     */
    public const REC21_JAR = 'XJR';

    /**
     * Jutebag
     */
    public const REC21_JUTEBAG = 'XJT';

    /**
     * Jerrican, cylindrical
     */
    public const REC21_JERRICAN_CYLINDRICAL = 'XJY';

    /**
     * Keg
     */
    public const REC21_KEG = 'XKG';

    /**
     * Kit
     */
    public const REC21_KIT = 'XKI';

    /**
     * Luggage
     */
    public const REC21_LUGGAGE = 'XLE';

    /**
     * Log
     */
    public const REC21_LOG = 'XLG';

    /**
     * Lot
     */
    public const REC21_LOT = 'XLT';

    /**
     * Lug
     */
    public const REC21_LUG = 'XLU';

    /**
     * Liftvan
     */
    public const REC21_LIFTVAN = 'XLV';

    /**
     * Logs, in bundle/bunch/truss
     */
    public const REC21_LOGS_IN_BUNDLE_BUNCH_TRUSS = 'XLZ';

    /**
     * Crate, metal
     */
    public const REC21_CRATE_METAL = 'XMA';

    /**
     * Bag, multiply
     */
    public const REC21_BAG_MULTIPLY = 'XMB';

    /**
     * Crate, milk
     */
    public const REC21_CRATE_MILK = 'XMC';

    /**
     * Container, metal
     */
    public const REC21_CONTAINER_METAL = 'XME';

    /**
     * Receptacle, metal
     */
    public const REC21_RECEPTACLE_METAL = 'XMR';

    /**
     * Sack, multi-wall
     */
    public const REC21_SACK_MULTIWALL = 'XMS';

    /**
     * Mat
     */
    public const REC21_MAT = 'XMT';

    /**
     * Receptacle, plastic wrapped
     */
    public const REC21_RECEPTACLE_PLASTIC_WRAPPED = 'XMW';

    /**
     * Matchbox
     */
    public const REC21_MATCHBOX = 'XMX';

    /**
     * Not available
     */
    public const REC21_NOT_AVAILABLE = 'XNA';

    /**
     * Unpacked or unpackaged
     */
    public const REC21_UNPACKED_OR_UNPACKAGED = 'XNE';

    /**
     * Unpacked or unpackaged, single unit
     */
    public const REC21_UNPACKED_OR_UNPACKAGED_SINGLE_UNIT = 'XNF';

    /**
     * Unpacked or unpackaged, multiple units
     */
    public const REC21_UNPACKED_OR_UNPACKAGED_MULTIPLE_UNITS = 'XNG';

    /**
     * Nest
     */
    public const REC21_NEST = 'XNS';

    /**
     * Net
     */
    public const REC21_NET = 'XNT';

    /**
     * Net, tube, plastic
     */
    public const REC21_NET_TUBE_PLASTIC = 'XNU';

    /**
     * Net, tube, textile
     */
    public const REC21_NET_TUBE_TEXTILE = 'XNV';

    /**
     * Pallet, CHEP 40 cm x 60 cm
     */
    public const REC21_PALLET_CHEP_40_CM_X_60_CM = 'XOA';

    /**
     * Pallet, CHEP 80 cm x 120 cm
     */
    public const REC21_PALLET_CHEP_80_CM_X_120_CM = 'XOB';

    /**
     * Pallet, CHEP 100 cm x 120 cm
     */
    public const REC21_PALLET_CHEP_100_CM_X_120_CM = 'XOC';

    /**
     * Pallet, AS 4068-1993
     */
    public const REC21_PALLET_AS_40681993 = 'XOD';

    /**
     * Pallet, ISO T11
     */
    public const REC21_PALLET_ISO_T11 = 'XOE';

    /**
     * Platform, unspecified weight or dimension
     */
    public const REC21_PLATFORM_UNSPECIFIED_WEIGHT_OR_DIMENSION = 'XOF';

    /**
     * Block
     */
    public const REC21_BLOCK = 'XOK';

    /**
     * Octabin
     */
    public const REC21_OCTABIN = 'XOT';

    /**
     * Container, outer
     */
    public const REC21_CONTAINER_OUTER = 'XOU';

    /**
     * Pan
     */
    public const REC21_PAN = 'XP2';

    /**
     * Packet
     */
    public const REC21_PACKET = 'XPA';

    /**
     * Pallet, box Combined open-ended box and pallet
     */
    public const REC21_PALLET_BOX_COMBINED_OPENENDED_BOX_AND_PALLET = 'XPB';

    /**
     * Parcel
     */
    public const REC21_PARCEL = 'XPC';

    /**
     * Pallet, modular, collars 80cms * 100cms
     */
    public const REC21_PALLET_MODULAR_COLLARS_80CMS__100CMS = 'XPD';

    /**
     * Pallet, modular, collars 80cms * 120cms
     */
    public const REC21_PALLET_MODULAR_COLLARS_80CMS__120CMS = 'XPE';

    /**
     * Pen
     */
    public const REC21_PEN = 'XPF';

    /**
     * Plate
     */
    public const REC21_PLATE = 'XPG';

    /**
     * Pitcher
     */
    public const REC21_PITCHER = 'XPH';

    /**
     * Pipe
     */
    public const REC21_PIPE = 'XPI';

    /**
     * Punnet
     */
    public const REC21_PUNNET = 'XPJ';

    /**
     * Package
     */
    public const REC21_PACKAGE = 'XPK';

    /**
     * Pail
     */
    public const REC21_PAIL = 'XPL';

    /**
     * Plank
     */
    public const REC21_PLANK = 'XPN';

    /**
     * Pouch
     */
    public const REC21_POUCH = 'XPO';

    /**
     * Piece
     */
    public const REC21_PIECE = 'XPP';

    /**
     * Receptacle, plastic
     */
    public const REC21_RECEPTACLE_PLASTIC = 'XPR';

    /**
     * Pot
     */
    public const REC21_POT = 'XPT';

    /**
     * Tray
     */
    public const REC21_TRAY = 'XPU';

    /**
     * Pipes, in bundle/bunch/truss
     */
    public const REC21_PIPES_IN_BUNDLE_BUNCH_TRUSS = 'XPV';

    /**
     * Pallet
     */
    public const REC21_PALLET = 'XPX';

    /**
     * Plates, in bundle/bunch/truss
     */
    public const REC21_PLATES_IN_BUNDLE_BUNCH_TRUSS = 'XPY';

    /**
     * Planks, in bundle/bunch/truss
     */
    public const REC21_PLANKS_IN_BUNDLE_BUNCH_TRUSS = 'XPZ';

    /**
     * Drum, steel, non-removable head
     */
    public const REC21_DRUM_STEEL_NONREMOVABLE_HEAD = 'XQA';

    /**
     * Drum, steel, removable head
     */
    public const REC21_DRUM_STEEL_REMOVABLE_HEAD = 'XQB';

    /**
     * Drum, aluminium, non-removable head
     */
    public const REC21_DRUM_ALUMINIUM_NONREMOVABLE_HEAD = 'XQC';

    /**
     * Drum, aluminium, removable head
     */
    public const REC21_DRUM_ALUMINIUM_REMOVABLE_HEAD = 'XQD';

    /**
     * Drum, plastic, non-removable head
     */
    public const REC21_DRUM_PLASTIC_NONREMOVABLE_HEAD = 'XQF';

    /**
     * Drum, plastic, removable head
     */
    public const REC21_DRUM_PLASTIC_REMOVABLE_HEAD = 'XQG';

    /**
     * Barrel, wooden, bung type
     */
    public const REC21_BARREL_WOODEN_BUNG_TYPE = 'XQH';

    /**
     * Barrel, wooden, removable head
     */
    public const REC21_BARREL_WOODEN_REMOVABLE_HEAD = 'XQJ';

    /**
     * Jerrican, steel, non-removable head
     */
    public const REC21_JERRICAN_STEEL_NONREMOVABLE_HEAD = 'XQK';

    /**
     * Jerrican, steel, removable head
     */
    public const REC21_JERRICAN_STEEL_REMOVABLE_HEAD = 'XQL';

    /**
     * Jerrican, plastic, non-removable head
     */
    public const REC21_JERRICAN_PLASTIC_NONREMOVABLE_HEAD = 'XQM';

    /**
     * Jerrican, plastic, removable head
     */
    public const REC21_JERRICAN_PLASTIC_REMOVABLE_HEAD = 'XQN';

    /**
     * Box, wooden, natural wood, ordinary
     */
    public const REC21_BOX_WOODEN_NATURAL_WOOD_ORDINARY = 'XQP';

    /**
     * Box, wooden, natural wood, with sift proof walls
     */
    public const REC21_BOX_WOODEN_NATURAL_WOOD_WITH_SIFT_PROOF_WALLS = 'XQQ';

    /**
     * Box, plastic, expanded
     */
    public const REC21_BOX_PLASTIC_EXPANDED = 'XQR';

    /**
     * Box, plastic, solid
     */
    public const REC21_BOX_PLASTIC_SOLID = 'XQS';

    /**
     * Rod
     */
    public const REC21_ROD = 'XRD';

    /**
     * Ring
     */
    public const REC21_RING = 'XRG';

    /**
     * Rack, clothing hanger
     */
    public const REC21_RACK_CLOTHING_HANGER = 'XRJ';

    /**
     * Rack
     */
    public const REC21_RACK = 'XRK';

    /**
     * Reel
     */
    public const REC21_REEL = 'XRL';

    /**
     * Roll
     */
    public const REC21_ROLL = 'XRO';

    /**
     * Rednet
     */
    public const REC21_REDNET = 'XRT';

    /**
     * Rods, in bundle/bunch/truss
     */
    public const REC21_RODS_IN_BUNDLE_BUNCH_TRUSS = 'XRZ';

    /**
     * Sack
     */
    public const REC21_SACK = 'XSA';

    /**
     * Slab
     */
    public const REC21_SLAB = 'XSB';

    /**
     * Crate, shallow
     */
    public const REC21_CRATE_SHALLOW = 'XSC';

    /**
     * Spindle
     */
    public const REC21_SPINDLE = 'XSD';

    /**
     * Sea-chest
     */
    public const REC21_SEACHEST = 'XSE';

    /**
     * Sachet
     */
    public const REC21_SACHET = 'XSH';

    /**
     * Skid
     */
    public const REC21_SKID = 'XSI';

    /**
     * Case, skeleton
     */
    public const REC21_CASE_SKELETON = 'XSK';

    /**
     * Slipsheet
     */
    public const REC21_SLIPSHEET = 'XSL';

    /**
     * Sheetmetal
     */
    public const REC21_SHEETMETAL = 'XSM';

    /**
     * Spool
     */
    public const REC21_SPOOL = 'XSO';

    /**
     * Sheet, plastic wrapping
     */
    public const REC21_SHEET_PLASTIC_WRAPPING = 'XSP';

    /**
     * Case, steel
     */
    public const REC21_CASE_STEEL = 'XSS';

    /**
     * Sheet
     */
    public const REC21_SHEET = 'XST';

    /**
     * Suitcase
     */
    public const REC21_SUITCASE = 'XSU';

    /**
     * Envelope, steel
     */
    public const REC21_ENVELOPE_STEEL = 'XSV';

    /**
     * Shrinkwrapped
     */
    public const REC21_SHRINKWRAPPED = 'XSW';

    /**
     * Sleeve
     */
    public const REC21_SLEEVE = 'XSY';

    /**
     * Sheets, in bundle/bunch/truss
     */
    public const REC21_SHEETS_IN_BUNDLE_BUNCH_TRUSS = 'XSZ';

    /**
     * Tablet
     */
    public const REC21_TABLET = 'XT1';

    /**
     * Tub
     */
    public const REC21_TUB = 'XTB';

    /**
     * Tea-chest
     */
    public const REC21_TEACHEST = 'XTC';

    /**
     * Tube, collapsible
     */
    public const REC21_TUBE_COLLAPSIBLE = 'XTD';

    /**
     * Tyre
     */
    public const REC21_TYRE = 'XTE';

    /**
     * Tank container, generic
     */
    public const REC21_TANK_CONTAINER_GENERIC = 'XTG';

    /**
     * Tierce
     */
    public const REC21_TIERCE = 'XTI';

    /**
     * Tank, rectangular
     */
    public const REC21_TANK_RECTANGULAR = 'XTK';

    /**
     * Tub, with lid
     */
    public const REC21_TUB_WITH_LID = 'XTL';

    /**
     * Tin
     */
    public const REC21_TIN = 'XTN';

    /**
     * Tun
     */
    public const REC21_TUN = 'XTO';

    /**
     * Trunk
     */
    public const REC21_TRUNK = 'XTR';

    /**
     * Truss
     */
    public const REC21_TRUSS = 'XTS';

    /**
     * Bag, tote
     */
    public const REC21_BAG_TOTE = 'XTT';

    /**
     * Tube
     */
    public const REC21_TUBE = 'XTU';

    /**
     * Tube, with nozzle
     */
    public const REC21_TUBE_WITH_NOZZLE = 'XTV';

    /**
     * Pallet, triwall
     */
    public const REC21_PALLET_TRIWALL = 'XTW';

    /**
     * Tank, cylindrical
     */
    public const REC21_TANK_CYLINDRICAL = 'XTY';

    /**
     * Tubes, in bundle/bunch/truss
     */
    public const REC21_TUBES_IN_BUNDLE_BUNCH_TRUSS = 'XTZ';

    /**
     * Uncaged
     */
    public const REC21_UNCAGED = 'XUC';

    /**
     * Unit
     */
    public const REC21_UNIT = 'XUN';

    /**
     * Vat
     */
    public const REC21_VAT = 'XVA';

    /**
     * Bulk, gas (at 1031 mbar and 15°C)
     */
    public const REC21_BULK_GAS_AT_1031_MBAR_AND_15C = 'XVG';

    /**
     * Vial
     */
    public const REC21_VIAL = 'XVI';

    /**
     * Vanpack
     */
    public const REC21_VANPACK = 'XVK';

    /**
     * Bulk, liquid
     */
    public const REC21_BULK_LIQUID = 'XVL';

    /**
     * Bulk, solid, large particles (“nodules”)
     */
    public const REC21_BULK_SOLID_LARGE_PARTICLES_NODULES = 'XVO';

    /**
     * Vacuum-packed
     */
    public const REC21_VACUUMPACKED = 'XVP';

    /**
     * Bulk, liquefied gas (at abnormal temperature/pressure)
     */
    public const REC21_BULK_LIQUEFIED_GAS_AT_ABNORMAL_TEMPERATURE_PRESSURE = 'XVQ';

    /**
     * Vehicle
     */
    public const REC21_VEHICLE = 'XVN';

    /**
     * Bulk, solid, granular particles (“grains”)
     */
    public const REC21_BULK_SOLID_GRANULAR_PARTICLES_GRAINS = 'XVR';

    /**
     * Bulk, scrap metal
     */
    public const REC21_BULK_SCRAP_METAL = 'XVS';

    /**
     * Bulk, solid, fine particles (“powders”)
     */
    public const REC21_BULK_SOLID_FINE_PARTICLES_POWDERS = 'XVY';

    /**
     * Intermediate bulk container
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER = 'XWA';

    /**
     * Wickerbottle
     */
    public const REC21_WICKERBOTTLE = 'XWB';

    /**
     * Intermediate bulk container, steel
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_STEEL = 'XWC';

    /**
     * Intermediate bulk container, aluminium
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_ALUMINIUM = 'XWD';

    /**
     * Intermediate bulk container, metal
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_METAL = 'XWF';

    /**
     * Intermediate bulk container, steel, pressurised > 10 kpa
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_STEEL_PRESSURISED__10_KPA = 'XWG';

    /**
     * Intermediate bulk container, aluminium, pressurised > 10 kpa
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_ALUMINIUM_PRESSURISED__10_KPA = 'XWH';

    /**
     * Intermediate bulk container, metal, pressure 10 kpa
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_METAL_PRESSURE_10_KPA = 'XWJ';

    /**
     * Intermediate bulk container, steel, liquid
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_STEEL_LIQUID = 'XWK';

    /**
     * Intermediate bulk container, aluminium, liquid
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_ALUMINIUM_LIQUID = 'XWL';

    /**
     * Intermediate bulk container, metal, liquid
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_METAL_LIQUID = 'XWM';

    /**
     * Intermediate bulk container, woven plastic, without coat/liner
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_WOVEN_PLASTIC_WITHOUT_COAT_LINER = 'XWN';

    /**
     * Intermediate bulk container, woven plastic, coated
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_WOVEN_PLASTIC_COATED = 'XWP';

    /**
     * Intermediate bulk container, woven plastic, with liner
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_WOVEN_PLASTIC_WITH_LINER = 'XWQ';

    /**
     * Intermediate bulk container, woven plastic, coated and liner
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_WOVEN_PLASTIC_COATED_AND_LINER = 'XWR';

    /**
     * Intermediate bulk container, plastic film
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_PLASTIC_FILM = 'XWS';

    /**
     * Intermediate bulk container, textile with out coat/liner
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_TEXTILE_WITH_OUT_COAT_LINER = 'XWT';

    /**
     * Intermediate bulk container, natural wood, with inner liner
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_NATURAL_WOOD_WITH_INNER_LINER = 'XWU';

    /**
     * Intermediate bulk container, textile, coated
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_TEXTILE_COATED = 'XWV';

    /**
     * Intermediate bulk container, textile, with liner
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_TEXTILE_WITH_LINER = 'XWW';

    /**
     * Intermediate bulk container, textile, coated and liner
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_TEXTILE_COATED_AND_LINER = 'XWX';

    /**
     * Intermediate bulk container, plywood, with inner liner
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_PLYWOOD_WITH_INNER_LINER = 'XWY';

    /**
     * Intermediate bulk container, reconstituted wood, with inner liner
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_RECONSTITUTED_WOOD_WITH_INNER_LINER = 'XWZ';

    /**
     * Bag, woven plastic, without inner coat/liner
     */
    public const REC21_BAG_WOVEN_PLASTIC_WITHOUT_INNER_COAT_LINER = 'XXA';

    /**
     * Bag, woven plastic, sift proof
     */
    public const REC21_BAG_WOVEN_PLASTIC_SIFT_PROOF = 'XXB';

    /**
     * Bag, woven plastic, water resistant
     */
    public const REC21_BAG_WOVEN_PLASTIC_WATER_RESISTANT = 'XXC';

    /**
     * Bag, plastics film
     */
    public const REC21_BAG_PLASTICS_FILM = 'XXD';

    /**
     * Bag, textile, without inner coat/liner
     */
    public const REC21_BAG_TEXTILE_WITHOUT_INNER_COAT_LINER = 'XXF';

    /**
     * Bag, textile, sift proof
     */
    public const REC21_BAG_TEXTILE_SIFT_PROOF = 'XXG';

    /**
     * Bag, textile, water resistant
     */
    public const REC21_BAG_TEXTILE_WATER_RESISTANT = 'XXH';

    /**
     * Bag, paper, multi-wall
     */
    public const REC21_BAG_PAPER_MULTIWALL = 'XXJ';

    /**
     * Bag, paper, multi-wall, water resistant
     */
    public const REC21_BAG_PAPER_MULTIWALL_WATER_RESISTANT = 'XXK';

    /**
     * Composite packaging, plastic receptacle in steel drum
     */
    public const REC21_COMPOSITE_PACKAGING_PLASTIC_RECEPTACLE_IN_STEEL_DRUM = 'XYA';

    /**
     * Composite packaging, plastic receptacle in steel crate box
     */
    public const REC21_COMPOSITE_PACKAGING_PLASTIC_RECEPTACLE_IN_STEEL_CRATE_BOX = 'XYB';

    /**
     * Composite packaging, plastic receptacle in aluminium drum
     */
    public const REC21_COMPOSITE_PACKAGING_PLASTIC_RECEPTACLE_IN_ALUMINIUM_DRUM = 'XYC';

    /**
     * Composite packaging, plastic receptacle in aluminium crate
     */
    public const REC21_COMPOSITE_PACKAGING_PLASTIC_RECEPTACLE_IN_ALUMINIUM_CRATE = 'XYD';

    /**
     * Composite packaging, plastic receptacle in wooden box
     */
    public const REC21_COMPOSITE_PACKAGING_PLASTIC_RECEPTACLE_IN_WOODEN_BOX = 'XYF';

    /**
     * Composite packaging, plastic receptacle in plywood drum
     */
    public const REC21_COMPOSITE_PACKAGING_PLASTIC_RECEPTACLE_IN_PLYWOOD_DRUM = 'XYG';

    /**
     * Composite packaging, plastic receptacle in plywood box
     */
    public const REC21_COMPOSITE_PACKAGING_PLASTIC_RECEPTACLE_IN_PLYWOOD_BOX = 'XYH';

    /**
     * Composite packaging, plastic receptacle in fibre drum
     */
    public const REC21_COMPOSITE_PACKAGING_PLASTIC_RECEPTACLE_IN_FIBRE_DRUM = 'XYJ';

    /**
     * Composite packaging, plastic receptacle in fibreboard box
     */
    public const REC21_COMPOSITE_PACKAGING_PLASTIC_RECEPTACLE_IN_FIBREBOARD_BOX = 'XYK';

    /**
     * Composite packaging, plastic receptacle in plastic drum
     */
    public const REC21_COMPOSITE_PACKAGING_PLASTIC_RECEPTACLE_IN_PLASTIC_DRUM = 'XYL';

    /**
     * Composite packaging, plastic receptacle in solid plastic box
     */
    public const REC21_COMPOSITE_PACKAGING_PLASTIC_RECEPTACLE_IN_SOLID_PLASTIC_BOX = 'XYM';

    /**
     * Composite packaging, glass receptacle in steel drum
     */
    public const REC21_COMPOSITE_PACKAGING_GLASS_RECEPTACLE_IN_STEEL_DRUM = 'XYN';

    /**
     * Composite packaging, glass receptacle in steel crate box
     */
    public const REC21_COMPOSITE_PACKAGING_GLASS_RECEPTACLE_IN_STEEL_CRATE_BOX = 'XYP';

    /**
     * Composite packaging, glass receptacle in aluminium drum
     */
    public const REC21_COMPOSITE_PACKAGING_GLASS_RECEPTACLE_IN_ALUMINIUM_DRUM = 'XYQ';

    /**
     * Composite packaging, glass receptacle in aluminium crate
     */
    public const REC21_COMPOSITE_PACKAGING_GLASS_RECEPTACLE_IN_ALUMINIUM_CRATE = 'XYR';

    /**
     * Composite packaging, glass receptacle in wooden box
     */
    public const REC21_COMPOSITE_PACKAGING_GLASS_RECEPTACLE_IN_WOODEN_BOX = 'XYS';

    /**
     * Composite packaging, glass receptacle in plywood drum
     */
    public const REC21_COMPOSITE_PACKAGING_GLASS_RECEPTACLE_IN_PLYWOOD_DRUM = 'XYT';

    /**
     * Composite packaging, glass receptacle in wickerwork hamper
     */
    public const REC21_COMPOSITE_PACKAGING_GLASS_RECEPTACLE_IN_WICKERWORK_HAMPER = 'XYV';

    /**
     * Composite packaging, glass receptacle in fibre drum
     */
    public const REC21_COMPOSITE_PACKAGING_GLASS_RECEPTACLE_IN_FIBRE_DRUM = 'XYW';

    /**
     * Composite packaging, glass receptacle in fibreboard box
     */
    public const REC21_COMPOSITE_PACKAGING_GLASS_RECEPTACLE_IN_FIBREBOARD_BOX = 'XYX';

    /**
     * Composite packaging, glass receptacle in expandable plastic pack
     */
    public const REC21_COMPOSITE_PACKAGING_GLASS_RECEPTACLE_IN_EXPANDABLE_PLASTIC_PACK = 'XYY';

    /**
     * Composite packaging, glass receptacle in solid plastic pack
     */
    public const REC21_COMPOSITE_PACKAGING_GLASS_RECEPTACLE_IN_SOLID_PLASTIC_PACK = 'XYZ';

    /**
     * Intermediate bulk container, paper, multi-wall
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_PAPER_MULTIWALL = 'XZA';

    /**
     * Bag, large
     */
    public const REC21_BAG_LARGE = 'XZB';

    /**
     * Intermediate bulk container, paper, multi-wall, water resistant
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_PAPER_MULTIWALL_WATER_RESISTANT = 'XZC';

    /**
     * Intermediate bulk container, rigid plastic, with structural equipment,
     * solids
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_RIGID_PLASTIC_WITH_STRUCTURAL_EQUIPMENT_SOLIDS = 'XZD';

    /**
     * Intermediate bulk container, rigid plastic, freestanding, solids
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_RIGID_PLASTIC_FREESTANDING_SOLIDS = 'XZF';

    /**
     * Intermediate bulk container, rigid plastic, with structural equipment,
     * pressurised
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_RIGID_PLASTIC_WITH_STRUCTURAL_EQUIPMENT_PRESSURISED = 'XZG';

    /**
     * Intermediate bulk container, rigid plastic, freestanding, pressurised
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_RIGID_PLASTIC_FREESTANDING_PRESSURISED = 'XZH';

    /**
     * Intermediate bulk container, rigid plastic, with structural equipment,
     * liquids
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_RIGID_PLASTIC_WITH_STRUCTURAL_EQUIPMENT_LIQUIDS = 'XZJ';

    /**
     * Intermediate bulk container, rigid plastic, freestanding, liquids
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_RIGID_PLASTIC_FREESTANDING_LIQUIDS = 'XZK';

    /**
     * Intermediate bulk container, composite, rigid plastic, solids
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_COMPOSITE_RIGID_PLASTIC_SOLIDS = 'XZL';

    /**
     * Intermediate bulk container, composite, flexible plastic, solids
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_COMPOSITE_FLEXIBLE_PLASTIC_SOLIDS = 'XZM';

    /**
     * Intermediate bulk container, composite, rigid plastic, pressurised
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_COMPOSITE_RIGID_PLASTIC_PRESSURISED = 'XZN';

    /**
     * Intermediate bulk container, composite, flexible plastic, pressurised
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_COMPOSITE_FLEXIBLE_PLASTIC_PRESSURISED = 'XZP';

    /**
     * Intermediate bulk container, composite, rigid plastic, liquids
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_COMPOSITE_RIGID_PLASTIC_LIQUIDS = 'XZQ';

    /**
     * Intermediate bulk container, composite, flexible plastic, liquids
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_COMPOSITE_FLEXIBLE_PLASTIC_LIQUIDS = 'XZR';

    /**
     * Intermediate bulk container, composite
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_COMPOSITE = 'XZS';

    /**
     * Intermediate bulk container, fibreboard
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_FIBREBOARD = 'XZT';

    /**
     * Intermediate bulk container, flexible
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_FLEXIBLE = 'XZU';

    /**
     * Intermediate bulk container, metal, other than steel
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_METAL_OTHER_THAN_STEEL = 'XZV';

    /**
     * Intermediate bulk container, natural wood
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_NATURAL_WOOD = 'XZW';

    /**
     * Intermediate bulk container, plywood
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_PLYWOOD = 'XZX';

    /**
     * Intermediate bulk container, reconstituted wood
     */
    public const REC21_INTERMEDIATE_BULK_CONTAINER_RECONSTITUTED_WOOD = 'XZY';

    /**
     * Mutually defined
     */
    public const REC21_MUTUALLY_DEFINED = 'XZZ';
}
