<?php

/**
 * This file is a part of horstoeko/zugferd.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace horstoeko\zugferd\codelists;

/**
 * Class representing the Electronic address scheme identifiers
 *
 * @category Zugferd
 * @package  Zugferd
 * @author   D. Erling <horstoeko@erling.com.de>
 * @license  https://opensource.org/licenses/MIT MIT
 * @link     https://github.com/horstoeko/zugferd
 */
class ZugferdSchemeIdentifiers
{
    /**
     * System Information et Repertoire des Entreprise et des Etablissements:
     * SIRENE
     */
    public const ISO_6523_0002 = '0002';

    /**
     * Codification Numerique des Etablissments Financiers En Belgique
     */
    public const ISO_6523_0003 = '0003';

    /**
     * NBS/OSI NETWORK
     */
    public const ISO_6523_0004 = '0004';

    /**
     * USA FED GOV OSI NETWORK
     */
    public const ISO_6523_0005 = '0005';

    /**
     * USA DOD OSI NETWORK
     */
    public const ISO_6523_0006 = '0006';

    /**
     * Organisationsnummer
     */
    public const ISO_6523_0007 = '0007';

    /**
     * LE NUMERO NATIONAL
     */
    public const ISO_6523_0008 = '0008';

    /**
     * SIRET-CODE
     */
    public const ISO_6523_0009 = '0009';

    /**
     * Organizational Identifiers for Structured Names under ISO 9541 Part 2
     */
    public const ISO_6523_0010 = '0010';

    /**
     * International Code Designator for the Identification of OSI-based,
     * Amateur Radio Organizations, Network Objects and Application Services.
     */
    public const ISO_6523_0011 = '0011';

    /**
     * European Computer Manufacturers Association: ECMA
     */
    public const ISO_6523_0012 = '0012';

    /**
     * VSA FTP CODE (FTP = File Transfer Protocol)
     */
    public const ISO_6523_0013 = '0013';

    /**
     * NIST/OSI Implememts' Workshop
     */
    public const ISO_6523_0014 = '0014';

    /**
     * Electronic Data Interchange: EDI
     */
    public const ISO_6523_0015 = '0015';

    /**
     * EWOS Object Identifiers
     */
    public const ISO_6523_0016 = '0016';

    /**
     * COMMON LANGUAGE
     */
    public const ISO_6523_0017 = '0017';

    /**
     * SNA/OSI Network
     */
    public const ISO_6523_0018 = '0018';

    /**
     * Air Transport Industry Services Communications Network
     */
    public const ISO_6523_0019 = '0019';

    /**
     * European Laboratory for Particle Physics: CERN
     */
    public const ISO_6523_0020 = '0020';

    /**
     * SOCIETY FOR WORLDWIDE INTERBANK FINANCIAL, TELECOMMUNICATION
     * S.W.I.F.T.
     */
    public const ISO_6523_0021 = '0021';

    /**
     * OSF Distributed Computing Object Identification
     */
    public const ISO_6523_0022 = '0022';

    /**
     * Nordic University and Research Network: NORDUnet
     */
    public const ISO_6523_0023 = '0023';

    /**
     * Digital Equipment Corporation: DEC
     */
    public const ISO_6523_0024 = '0024';

    /**
     * OSI ASIA-OCEANIA WORKSHOP
     */
    public const ISO_6523_0025 = '0025';

    /**
     * NATO ISO 6523 ICDE coding scheme
     */
    public const ISO_6523_0026 = '0026';

    /**
     * Aeronautical Telecommunications Network (ATN)
     */
    public const ISO_6523_0027 = '0027';

    /**
     * International Standard ISO 6523
     */
    public const ISO_6523_0028 = '0028';

    /**
     * The All-Union Classifier of Enterprises and Organisations
     */
    public const ISO_6523_0029 = '0029';

    /**
     * AT&T/OSI Network
     */
    public const ISO_6523_0030 = '0030';

    /**
     * EDI Partner Identification Code
     */
    public const ISO_6523_0031 = '0031';

    /**
     * Telecom Australia
     */
    public const ISO_6523_0032 = '0032';

    /**
     * S G W OSI Internetwork
     */
    public const ISO_6523_0033 = '0033';

    /**
     * Reuter Open Address Standard
     */
    public const ISO_6523_0034 = '0034';

    /**
     * ISO 6523 - ICD
     */
    public const ISO_6523_0035 = '0035';

    /**
     * TeleTrust Object Identifiers
     */
    public const ISO_6523_0036 = '0036';

    /**
     * LY-tunnus
     */
    public const ISO_6523_0037 = '0037';

    /**
     * The Australian GOSIP Network
     */
    public const ISO_6523_0038 = '0038';

    /**
     * The OZ DOD OSI Network
     */
    public const ISO_6523_0039 = '0039';

    /**
     * Unilever Group Companies
     */
    public const ISO_6523_0040 = '0040';

    /**
     * Citicorp Global Information Network
     */
    public const ISO_6523_0041 = '0041';

    /**
     * DBP Telekom Object Identifiers
     */
    public const ISO_6523_0042 = '0042';

    /**
     * HydroNETT
     */
    public const ISO_6523_0043 = '0043';

    /**
     * Thai Industrial Standards Institute (TISI)
     */
    public const ISO_6523_0044 = '0044';

    /**
     * ICI Company Identification System
     */
    public const ISO_6523_0045 = '0045';

    /**
     * FUNLOC
     */
    public const ISO_6523_0046 = '0046';

    /**
     * BULL ODI/DSA/UNIX Network
     */
    public const ISO_6523_0047 = '0047';

    /**
     * OSINZ
     */
    public const ISO_6523_0048 = '0048';

    /**
     * Auckland Area Health
     */
    public const ISO_6523_0049 = '0049';

    /**
     * Firmenich
     */
    public const ISO_6523_0050 = '0050';

    /**
     * AGFA-DIS
     */
    public const ISO_6523_0051 = '0051';

    /**
     * Society of Motion Picture and Television Engineers (SMPTE)
     */
    public const ISO_6523_0052 = '0052';

    /**
     * Migros_Network M_NETOPZ
     */
    public const ISO_6523_0053 = '0053';

    /**
     * ISO6523 - ICDPCR
     */
    public const ISO_6523_0054 = '0054';

    /**
     * Energy Net
     */
    public const ISO_6523_0055 = '0055';

    /**
     * Nokia Object Identifiers (NOI)
     */
    public const ISO_6523_0056 = '0056';

    /**
     * Saint Gobain
     */
    public const ISO_6523_0057 = '0057';

    /**
     * Siemens Corporate Network
     */
    public const ISO_6523_0058 = '0058';

    /**
     * DANZNET
     */
    public const ISO_6523_0059 = '0059';

    /**
     * Data Universal Numbering System (D-U-N-S Number)
     */
    public const ISO_6523_0060 = '0060';

    /**
     * SOFFEX OSI
     */
    public const ISO_6523_0061 = '0061';

    /**
     * KPN OVN
     */
    public const ISO_6523_0062 = '0062';

    /**
     * ascomOSINet
     */
    public const ISO_6523_0063 = '0063';

    /**
     * UTC: Uniforme Transport Code
     */
    public const ISO_6523_0064 = '0064';

    /**
     * SOLVAY OSI CODING
     */
    public const ISO_6523_0065 = '0065';

    /**
     * Roche Corporate Network
     */
    public const ISO_6523_0066 = '0066';

    /**
     * ZellwegerOSINet
     */
    public const ISO_6523_0067 = '0067';

    /**
     * Intel Corporation OSI
     */
    public const ISO_6523_0068 = '0068';

    /**
     * SITA Object Identifier Tree
     */
    public const ISO_6523_0069 = '0069';

    /**
     * DaimlerChrysler Corporate Network
     */
    public const ISO_6523_0070 = '0070';

    /**
     * LEGO /OSI NETWORK
     */
    public const ISO_6523_0071 = '0071';

    /**
     * NAVISTAR/OSI Network
     */
    public const ISO_6523_0072 = '0072';

    /**
     * ICD Formatted ATM address
     */
    public const ISO_6523_0073 = '0073';

    /**
     * ARINC
     */
    public const ISO_6523_0074 = '0074';

    /**
     * Alcanet/Alcatel-Alsthom Corporate Network
     */
    public const ISO_6523_0075 = '0075';

    /**
     * Sistema Italiano di Identificazione di ogetti gestito da UNINFO
     */
    public const ISO_6523_0076 = '0076';

    /**
     * Sistema Italiano di Indirizzamento di Reti OSI Gestito da UNINFO
     */
    public const ISO_6523_0077 = '0077';

    /**
     * Mitel terminal or switching equipment
     */
    public const ISO_6523_0078 = '0078';

    /**
     * ATM Forum
     */
    public const ISO_6523_0079 = '0079';

    /**
     * UK National Health Service Scheme, (EDIRA compliant)
     */
    public const ISO_6523_0080 = '0080';

    /**
     * International NSAP
     */
    public const ISO_6523_0081 = '0081';

    /**
     * Norwegian Telecommunications Authority's, NTA'S, EDI, identifier
     * scheme (EDIRA compliant)
     */
    public const ISO_6523_0082 = '0082';

    /**
     * Advanced Telecommunications Modules Limited, Corporate Network
     */
    public const ISO_6523_0083 = '0083';

    /**
     * Athens Chamber of Commerce & Industry Scheme (EDIRA compliant)
     */
    public const ISO_6523_0084 = '0084';

    /**
     * Swiss Chambers of Commerce Scheme (EDIRA) compliant
     */
    public const ISO_6523_0085 = '0085';

    /**
     * United States Council for International Business (USCIB) Scheme,
     * (EDIRA compliant)
     */
    public const ISO_6523_0086 = '0086';

    /**
     * National Federation of Chambers of Commerce & Industry of Belgium,
     * Scheme (EDIRA compliant)
     */
    public const ISO_6523_0087 = '0087';

    /**
     * EAN Location Code
     */
    public const ISO_6523_0088 = '0088';

    /**
     * The Association of British Chambers of Commerce Ltd. Scheme, (EDIRA
     * compliant)
     */
    public const ISO_6523_0089 = '0089';

    /**
     * Internet IP addressing - ISO 6523 ICD encoding
     */
    public const ISO_6523_0090 = '0090';

    /**
     * Cisco Sysytems / OSI Network
     */
    public const ISO_6523_0091 = '0091';

    /**
     * Revenue Canada Business Number Registration (EDIRA compliant)
     */
    public const ISO_6523_0093 = '0093';

    /**
     * DEUTSCHER INDUSTRIE- UND HANDELSTAG (DIHT) Scheme (EDIRA compliant)
     */
    public const ISO_6523_0094 = '0094';

    /**
     * Hewlett - Packard Company Internal AM Network
     */
    public const ISO_6523_0095 = '0095';

    /**
     * DANISH CHAMBER OF COMMERCE Scheme (EDIRA compliant)
     */
    public const ISO_6523_0096 = '0096';

    /**
     * FTI - Ediforum Italia, (EDIRA compliant)
     */
    public const ISO_6523_0097 = '0097';

    /**
     * CHAMBER OF COMMERCE TEL AVIV-JAFFA Scheme (EDIRA compliant)
     */
    public const ISO_6523_0098 = '0098';

    /**
     * Siemens Supervisory Systems Network
     */
    public const ISO_6523_0099 = '0099';

    /**
     * PNG_ICD Scheme
     */
    public const ISO_6523_0100 = '0100';

    /**
     * South African Code Allocation
     */
    public const ISO_6523_0101 = '0101';

    /**
     * HEAG
     */
    public const ISO_6523_0102 = '0102';

    /**
     * BT - ICD Coding System
     */
    public const ISO_6523_0104 = '0104';

    /**
     * Portuguese Chamber of Commerce and Industry Scheme (EDIRA compliant)
     */
    public const ISO_6523_0105 = '0105';

    /**
     * Vereniging van Kamers van Koophandel en Fabrieken in Nederland
     * (Association of Chambers of Commerce and Industry in the Netherlands),
     * Scheme (EDIRA compliant)
     */
    public const ISO_6523_0106 = '0106';

    /**
     * Association of Swedish Chambers of Commerce and Industry Scheme (EDIRA
     * compliant)
     */
    public const ISO_6523_0107 = '0107';

    /**
     * Australian Chambers of Commerce and Industry Scheme (EDIRA compliant)
     */
    public const ISO_6523_0108 = '0108';

    /**
     * BellSouth ICD AESA (ATM End System Address)
     */
    public const ISO_6523_0109 = '0109';

    /**
     * Bell Atlantic
     */
    public const ISO_6523_0110 = '0110';

    /**
     * Object Identifiers
     */
    public const ISO_6523_0111 = '0111';

    /**
     * ISO register for Standards producing Organizations
     */
    public const ISO_6523_0112 = '0112';

    /**
     * OriginNet
     */
    public const ISO_6523_0113 = '0113';

    /**
     * Check Point Software Technologies
     */
    public const ISO_6523_0114 = '0114';

    /**
     * Pacific Bell Data Communications Network
     */
    public const ISO_6523_0115 = '0115';

    /**
     * PSS Object Identifiers
     */
    public const ISO_6523_0116 = '0116';

    /**
     * STENTOR-ICD CODING SYSTEM
     */
    public const ISO_6523_0117 = '0117';

    /**
     * ATM-Network ZN'96
     */
    public const ISO_6523_0118 = '0118';

    /**
     * MCI / OSI Network
     */
    public const ISO_6523_0119 = '0119';

    /**
     * Advantis
     */
    public const ISO_6523_0120 = '0120';

    /**
     * Affable Software Data Interchange Codes
     */
    public const ISO_6523_0121 = '0121';

    /**
     * BB-DATA GmbH
     */
    public const ISO_6523_0122 = '0122';

    /**
     * BASF Company ATM-Network
     */
    public const ISO_6523_0123 = '0123';

    /**
     * IOTA Identifiers for Organizations for Telecommunications Addressing
     * using the ICD system format defined in ISO/IEC 8348
     */
    public const ISO_6523_0124 = '0124';

    /**
     * Henkel Corporate Network (H-Net)
     */
    public const ISO_6523_0125 = '0125';

    /**
     * GTE/OSI Network
     */
    public const ISO_6523_0126 = '0126';

    /**
     * Dresdner Bank Corporate Network
     */
    public const ISO_6523_0127 = '0127';

    /**
     * BCNR (Swiss Clearing Bank Number)
     */
    public const ISO_6523_0128 = '0128';

    /**
     * BPI (Swiss Business Partner Identification) code
     */
    public const ISO_6523_0129 = '0129';

    /**
     * Directorates of the European Commission
     */
    public const ISO_6523_0130 = '0130';

    /**
     * Code for the Identification of National Organizations
     */
    public const ISO_6523_0131 = '0131';

    /**
     * Certicom Object Identifiers
     */
    public const ISO_6523_0132 = '0132';

    /**
     * TC68 OID
     */
    public const ISO_6523_0133 = '0133';

    /**
     * Infonet Services Corporation
     */
    public const ISO_6523_0134 = '0134';

    /**
     * SIA Object Identifiers
     */
    public const ISO_6523_0135 = '0135';

    /**
     * Cable & Wireless Global ATM End-System Address Plan
     */
    public const ISO_6523_0136 = '0136';

    /**
     * Global AESA scheme
     */
    public const ISO_6523_0137 = '0137';

    /**
     * France Telecom ATM End System Address Plan
     */
    public const ISO_6523_0138 = '0138';

    /**
     * Savvis Communications AESA:.
     */
    public const ISO_6523_0139 = '0139';

    /**
     * Toshiba Organizations, Partners, And Suppliers' (TOPAS) Code
     */
    public const ISO_6523_0140 = '0140';

    /**
     * NATO Commercial and Government Entity system
     */
    public const ISO_6523_0141 = '0141';

    /**
     * SECETI Object Identifiers
     */
    public const ISO_6523_0142 = '0142';

    /**
     * EINESTEINet AG
     */
    public const ISO_6523_0143 = '0143';

    /**
     * DoDAAC (Department of Defense Activity Address Code)
     */
    public const ISO_6523_0144 = '0144';

    /**
     * DGCP (Direction Générale de la Comptabilité Publique)administrative
     * accounting identification scheme
     */
    public const ISO_6523_0145 = '0145';

    /**
     * DGI (Direction Générale des Impots) code
     */
    public const ISO_6523_0146 = '0146';

    /**
     * Standard Company Code
     */
    public const ISO_6523_0147 = '0147';

    /**
     * ITU (International Telecommunications Union)Data Network
     * Identification Codes (DNIC)
     */
    public const ISO_6523_0148 = '0148';

    /**
     * Global Business Identifier
     */
    public const ISO_6523_0149 = '0149';

    /**
     * Madge Networks Ltd- ICD ATM Addressing Scheme
     */
    public const ISO_6523_0150 = '0150';

    /**
     * Australian Business Number (ABN) Scheme
     */
    public const ISO_6523_0151 = '0151';

    /**
     * Edira Scheme Identifier Code
     */
    public const ISO_6523_0152 = '0152';

    /**
     * Concert Global Network Services ICD AESA
     */
    public const ISO_6523_0153 = '0153';

    /**
     * Identification number of economic subjects: (ICO)
     */
    public const ISO_6523_0154 = '0154';

    /**
     * Global Crossing AESA (ATM End System Address)
     */
    public const ISO_6523_0155 = '0155';

    /**
     * AUNA
     */
    public const ISO_6523_0156 = '0156';

    /**
     * ATM interconnection with the Dutch KPN Telecom
     */
    public const ISO_6523_0157 = '0157';

    /**
     * Identification number of economic subject (ICO) Act on State
     * Statistics of 29 November 2'001, § 27
     */
    public const ISO_6523_0158 = '0158';

    /**
     * ACTALIS Object Identifiers
     */
    public const ISO_6523_0159 = '0159';

    /**
     * GTIN - Global Trade Item Number
     */
    public const ISO_6523_0160 = '0160';

    /**
     * ECCMA Open Technical Directory
     */
    public const ISO_6523_0161 = '0161';

    /**
     * CEN/ISSS Object Identifier Scheme
     */
    public const ISO_6523_0162 = '0162';

    /**
     * US-EPA Facility Identifier
     */
    public const ISO_6523_0163 = '0163';

    /**
     * TELUS Corporation
     */
    public const ISO_6523_0164 = '0164';

    /**
     * FIEIE Object identifiers
     */
    public const ISO_6523_0165 = '0165';

    /**
     * Swissguide Identifier Scheme
     */
    public const ISO_6523_0166 = '0166';

    /**
     * Priority Telecom ATM End System Address Plan
     */
    public const ISO_6523_0167 = '0167';

    /**
     * Vodafone Ireland OSI Addressing
     */
    public const ISO_6523_0168 = '0168';

    /**
     * Swiss Federal Business Identification Number. Central Business names
     * Index (zefix) Identification Number
     */
    public const ISO_6523_0169 = '0169';

    /**
     * Teikoku Company Code
     */
    public const ISO_6523_0170 = '0170';

    /**
     * Luxembourg CP & CPS (Certification Policy and Certification Practice
     * Statement) Index
     */
    public const ISO_6523_0171 = '0171';

    /**
     * Project Group “Lists of Properties” (PROLIST®)
     */
    public const ISO_6523_0172 = '0172';

    /**
     * eCI@ss
     */
    public const ISO_6523_0173 = '0173';

    /**
     * StepNexus
     */
    public const ISO_6523_0174 = '0174';

    /**
     * Siemens AG
     */
    public const ISO_6523_0175 = '0175';

    /**
     * Paradine GmbH
     */
    public const ISO_6523_0176 = '0176';

    /**
     * Odette International Limited
     */
    public const ISO_6523_0177 = '0177';

    /**
     * Route1 MobiNET
     */
    public const ISO_6523_0178 = '0178';

    /**
     * Penango Object Identifiers
     */
    public const ISO_6523_0179 = '0179';

    /**
     * Lithuanian military PKI
     */
    public const ISO_6523_0180 = '0180';

    /**
     * Numéro d'identification suisse des enterprises (IDE), Swiss Unique
     * Business Identification Number (UIDB)
     */
    public const ISO_6523_0183 = '0183';

    /**
     * DIGSTORG
     */
    public const ISO_6523_0184 = '0184';

    /**
     * Perceval Object Code
     */
    public const ISO_6523_0185 = '0185';

    /**
     * TrustPoint Object Identifiers
     */
    public const ISO_6523_0186 = '0186';

    /**
     * Amazon Unique Identification Scheme
     */
    public const ISO_6523_0187 = '0187';

    /**
     * Corporate Number of The Social Security and Tax Number System
     */
    public const ISO_6523_0188 = '0188';

    /**
     * European Business Identifier (EBID)
     */
    public const ISO_6523_0189 = '0189';

    /**
     * Organisatie Indentificatie Nummer (OIN)
     */
    public const ISO_6523_0190 = '0190';

    /**
     * Company Code (Estonia)
     */
    public const ISO_6523_0191 = '0191';

    /**
     * Organisasjonsnummer
     */
    public const ISO_6523_0192 = '0192';

    /**
     * UBL.BE Party Identifier
     */
    public const ISO_6523_0193 = '0193';

    /**
     * KOIOS Open Technical Dictionary
     */
    public const ISO_6523_0194 = '0194';

    /**
     * Singapore Nationwide E-lnvoice Framework
     */
    public const ISO_6523_0195 = '0195';

    /**
     * Icelandic identifier - Íslensk kennitala
     */
    public const ISO_6523_0196 = '0196';

    /**
     * Name not known
     */
    public const ISO_6523_0197 = '0197';

    /**
     * ERSTORG
     */
    public const ISO_6523_0198 = '0198';

    /**
     * Legal Entity Identifier (LEI)
     */
    public const ISO_6523_0199 = '0199';

    /**
     * Legal entity code (Lithuania)
     */
    public const ISO_6523_0200 = '0200';

    /**
     * Codice Univoco Unità Organizzativa iPA
     */
    public const ISO_6523_0201 = '0201';

    /**
     * Indirizzo di Posta Elettronica Certificata
     */
    public const ISO_6523_0202 = '0202';

    /**
     * eDelivery Network Participant identifier
     */
    public const ISO_6523_0203 = '0203';

    /**
     * Leitweg-ID
     */
    public const ISO_6523_0204 = '0204';

    /**
     * CODDEST
     */
    public const ISO_6523_0205 = '0205';

    /**
     * Registre du Commerce et de l’Industrie : RCI
     */
    public const ISO_6523_0206 = '0206';

    /**
     * PiLog Ontology Codification Identifier (POCI)
     */
    public const ISO_6523_0207 = '0207';

    /**
     * Numero d'entreprise / ondernemingsnummer / Unternehmensnummer
     */
    public const ISO_6523_0208 = '0208';

    /**
     * GS1 identification keys
     */
    public const ISO_6523_0209 = '0209';

    /**
     * CODICE FISCALE
     */
    public const ISO_6523_0210 = '0210';

    /**
     * PARTITA IVA
     */
    public const ISO_6523_0211 = '0211';

    /**
     * Finnish Organization Identifier
     */
    public const ISO_6523_0212 = '0212';

    /**
     * Finnish Organization Value Add Tax Identifier
     */
    public const ISO_6523_0213 = '0213';
}
