<?php

/**
 * This file is a part of horstoeko/zugferd.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace horstoeko\zugferd\codelists;

/**
 * Class representing the Country Codes
 *
 * @category Zugferd
 * @package  Zugferd
 * @author   D. Erling <horstoeko@erling.com.de>
 * @license  https://opensource.org/licenses/MIT MIT
 * @link     https://github.com/horstoeko/zugferd
 */
class ZugferdCountryCodes
{
    /**
     * Andorra
     */
    public const ANDORRA = "AD";

    /**
     * United Arab Emirates (the)
     */
    public const UNITED_ARAB_EMIRATES_THE = "AE";

    /**
     * Afghanistan
     */
    public const AFGHANISTAN = "AF";

    /**
     * Antigua and Barbuda
     */
    public const ANTIGUA_AND_BARBUDA = "AG";

    /**
     * Anguilla
     */
    public const ANGUILLA = "AI";

    /**
     * Albania
     */
    public const ALBANIA = "AL";

    /**
     * Armenia
     */
    public const ARMENIA = "AM";

    /**
     * Angola
     */
    public const ANGOLA = "AO";

    /**
     * Antarctica
     */
    public const ANTARCTICA = "AQ";

    /**
     * Argentina
     */
    public const ARGENTINA = "AR";

    /**
     * American Samoa
     */
    public const AMERICAN_SAMOA = "AS";

    /**
     * Austria
     */
    public const AUSTRIA = "AT";

    /**
     * Australia
     */
    public const AUSTRALIA = "AU";

    /**
     * Aruba
     */
    public const ARUBA = "AW";

    /**
     * Åland Islands
     */
    public const LAND_ISLANDS = "AX";

    /**
     * Azerbaijan
     */
    public const AZERBAIJAN = "AZ";

    /**
     * Bosnia and Herzegovina
     */
    public const BOSNIA_AND_HERZEGOVINA = "BA";

    /**
     * Barbados
     */
    public const BARBADOS = "BB";

    /**
     * Bangladesh
     */
    public const BANGLADESH = "BD";

    /**
     * Belgium
     */
    public const BELGIUM = "BE";

    /**
     * Burkina Faso
     */
    public const BURKINA_FASO = "BF";

    /**
     * Bulgaria
     */
    public const BULGARIA = "BG";

    /**
     * Bahrain
     */
    public const BAHRAIN = "BH";

    /**
     * Burundi
     */
    public const BURUNDI = "BI";

    /**
     * Benin
     */
    public const BENIN = "BJ";

    /**
     * Saint Barthélemy
     */
    public const SAINT_BARTHLEMY = "BL";

    /**
     * Bermuda
     */
    public const BERMUDA = "BM";

    /**
     * Brunei Darussalam
     */
    public const BRUNEI_DARUSSALAM = "BN";

    /**
     * Bolivia (Plurinational State of)
     */
    public const BOLIVIA_PLURINATIONAL_STATE_OF = "BO";

    /**
     * Bonaire, Sint Eustatius and Saba
     */
    public const BONAIRE_SINT_EUSTATIUS_AND_SABA = "BQ";

    /**
     * Brazil
     */
    public const BRAZIL = "BR";

    /**
     * Bahamas (the)
     */
    public const BAHAMAS_THE = "BS";

    /**
     * Bhutan
     */
    public const BHUTAN = "BT";

    /**
     * Bouvet Island
     */
    public const BOUVET_ISLAND = "BV";

    /**
     * Botswana
     */
    public const BOTSWANA = "BW";

    /**
     * Belarus
     */
    public const BELARUS = "BY";

    /**
     * Belize
     */
    public const BELIZE = "BZ";

    /**
     * Canada
     */
    public const CANADA = "CA";

    /**
     * Cocos (Keeling) Islands (the)
     */
    public const COCOS_KEELING_ISLANDS_THE = "CC";

    /**
     * Congo (the Democratic Republic of the)
     */
    public const CONGO_THE_DEMOCRATIC_REPUBLIC_OF_THE = "CD";

    /**
     * Central African Republic (the)
     */
    public const CENTRAL_AFRICAN_REPUBLIC_THE = "CF";

    /**
     * Congo (the)
     */
    public const CONGO_THE = "CG";

    /**
     * Switzerland
     */
    public const SWITZERLAND = "CH";

    /**
     * Côte d'Ivoire
     */
    public const CTE_DIVOIRE = "CI";

    /**
     * Cook Islands (the)
     */
    public const COOK_ISLANDS_THE = "CK";

    /**
     * Chile
     */
    public const CHILE = "CL";

    /**
     * Cameroon
     */
    public const CAMEROON = "CM";

    /**
     * China
     */
    public const CHINA = "CN";

    /**
     * Colombia
     */
    public const COLOMBIA = "CO";

    /**
     * Costa Rica
     */
    public const COSTA_RICA = "CR";

    /**
     * Cuba
     */
    public const CUBA = "CU";

    /**
     * Cabo Verde
     */
    public const CABO_VERDE = "CV";

    /**
     * Curaçao
     */
    public const CURAAO = "CW";

    /**
     * Christmas Island
     */
    public const CHRISTMAS_ISLAND = "CX";

    /**
     * Cyprus
     */
    public const CYPRUS = "CY";

    /**
     * Czechia
     */
    public const CZECHIA = "CZ";

    /**
     * Germany
     */
    public const GERMANY = "DE";

    /**
     * Djibouti
     */
    public const DJIBOUTI = "DJ";

    /**
     * Denmark
     */
    public const DENMARK = "DK";

    /**
     * Dominica
     */
    public const DOMINICA = "DM";

    /**
     * Dominican Republic (the)
     */
    public const DOMINICAN_REPUBLIC_THE = "DO";

    /**
     * Algeria
     */
    public const ALGERIA = "DZ";

    /**
     * Ecuador
     */
    public const ECUADOR = "EC";

    /**
     * Estonia
     */
    public const ESTONIA = "EE";

    /**
     * Egypt
     */
    public const EGYPT = "EG";

    /**
     * Western Sahara*
     */
    public const WESTERN_SAHARA = "EH";

    /**
     * Eritrea
     */
    public const ERITREA = "ER";

    /**
     * Spain
     */
    public const SPAIN = "ES";

    /**
     * Ethiopia
     */
    public const ETHIOPIA = "ET";

    /**
     * Finland
     */
    public const FINLAND = "FI";

    /**
     * Fiji
     */
    public const FIJI = "FJ";

    /**
     * Falkland Islands (the) [Malvinas]
     */
    public const FALKLAND_ISLANDS_THE_MALVINAS = "FK";

    /**
     * Micronesia (Federated States of)
     */
    public const MICRONESIA_FEDERATED_STATES_OF = "FM";

    /**
     * Faroe Islands (the)
     */
    public const FAROE_ISLANDS_THE = "FO";

    /**
     * France
     */
    public const FRANCE = "FR";

    /**
     * Gabon
     */
    public const GABON = "GA";

    /**
     * United Kingdom of Great Britain and Northern Ireland (the)
     */
    public const UNITED_KINGDOM_OF_GREAT_BRITAIN_AND_NORTHERN_IRELAND_THE = "GB";

    /**
     * Grenada
     */
    public const GRENADA = "GD";

    /**
     * Georgia
     */
    public const GEORGIA = "GE";

    /**
     * French Guiana
     */
    public const FRENCH_GUIANA = "GF";

    /**
     * Guernsey
     */
    public const GUERNSEY = "GG";

    /**
     * Ghana
     */
    public const GHANA = "GH";

    /**
     * Gibraltar
     */
    public const GIBRALTAR = "GI";

    /**
     * Greenland
     */
    public const GREENLAND = "GL";

    /**
     * Gambia (the)
     */
    public const GAMBIA_THE = "GM";

    /**
     * Guinea
     */
    public const GUINEA = "GN";

    /**
     * Guadeloupe
     */
    public const GUADELOUPE = "GP";

    /**
     * Equatorial Guinea
     */
    public const EQUATORIAL_GUINEA = "GQ";

    /**
     * Greece
     */
    public const GREECE = "GR";

    /**
     * South Georgia and the South Sandwich Islands
     */
    public const SOUTH_GEORGIA_AND_THE_SOUTH_SANDWICH_ISLANDS = "GS";

    /**
     * Guatemala
     */
    public const GUATEMALA = "GT";

    /**
     * Guam
     */
    public const GUAM = "GU";

    /**
     * Guinea-Bissau
     */
    public const GUINEABISSAU = "GW";

    /**
     * Guyana
     */
    public const GUYANA = "GY";

    /**
     * Hong Kong
     */
    public const HONG_KONG = "HK";

    /**
     * Heard Island and McDonald Islands
     */
    public const HEARD_ISLAND_AND_MCDONALD_ISLANDS = "HM";

    /**
     * Honduras
     */
    public const HONDURAS = "HN";

    /**
     * Croatia
     */
    public const CROATIA = "HR";

    /**
     * Haiti
     */
    public const HAITI = "HT";

    /**
     * Hungary
     */
    public const HUNGARY = "HU";

    /**
     * Indonesia
     */
    public const INDONESIA = "ID";

    /**
     * Ireland
     */
    public const IRELAND = "IE";

    /**
     * Israel
     */
    public const ISRAEL = "IL";

    /**
     * Isle of Man
     */
    public const ISLE_OF_MAN = "IM";

    /**
     * India
     */
    public const INDIA = "IN";

    /**
     * British Indian Ocean Territory (the)
     */
    public const BRITISH_INDIAN_OCEAN_TERRITORY_THE = "IO";

    /**
     * Iraq
     */
    public const IRAQ = "IQ";

    /**
     * Iran (Islamic Republic of)
     */
    public const IRAN_ISLAMIC_REPUBLIC_OF = "IR";

    /**
     * Iceland
     */
    public const ICELAND = "IS";

    /**
     * Italy
     */
    public const ITALY = "IT";

    /**
     * Jersey
     */
    public const JERSEY = "JE";

    /**
     * Jamaica
     */
    public const JAMAICA = "JM";

    /**
     * Jordan
     */
    public const JORDAN = "JO";

    /**
     * Japan
     */
    public const JAPAN = "JP";

    /**
     * Kenya
     */
    public const KENYA = "KE";

    /**
     * Kyrgyzstan
     */
    public const KYRGYZSTAN = "KG";

    /**
     * Cambodia
     */
    public const CAMBODIA = "KH";

    /**
     * Kiribati
     */
    public const KIRIBATI = "KI";

    /**
     * Comoros (the)
     */
    public const COMOROS_THE = "KM";

    /**
     * Saint Kitts and Nevis
     */
    public const SAINT_KITTS_AND_NEVIS = "KN";

    /**
     * Korea (the Democratic People's Republic of)
     */
    public const KOREA_THE_DEMOCRATIC_PEOPLES_REPUBLIC_OF = "KP";

    /**
     * Korea (the Republic of)
     */
    public const KOREA_THE_REPUBLIC_OF = "KR";

    /**
     * Kuwait
     */
    public const KUWAIT = "KW";

    /**
     * Cayman Islands (the)
     */
    public const CAYMAN_ISLANDS_THE = "KY";

    /**
     * Kazakhstan
     */
    public const KAZAKHSTAN = "KZ";

    /**
     * Lao People's Democratic Republic (the)
     */
    public const LAO_PEOPLES_DEMOCRATIC_REPUBLIC_THE = "LA";

    /**
     * Lebanon
     */
    public const LEBANON = "LB";

    /**
     * Saint Lucia
     */
    public const SAINT_LUCIA = "LC";

    /**
     * Liechtenstein
     */
    public const LIECHTENSTEIN = "LI";

    /**
     * Sri Lanka
     */
    public const SRI_LANKA = "LK";

    /**
     * Liberia
     */
    public const LIBERIA = "LR";

    /**
     * Lesotho
     */
    public const LESOTHO = "LS";

    /**
     * Lithuania
     */
    public const LITHUANIA = "LT";

    /**
     * Luxembourg
     */
    public const LUXEMBOURG = "LU";

    /**
     * Latvia
     */
    public const LATVIA = "LV";

    /**
     * Libya
     */
    public const LIBYA = "LY";

    /**
     * Morocco
     */
    public const MOROCCO = "MA";

    /**
     * Monaco
     */
    public const MONACO = "MC";

    /**
     * Moldova (the Republic of)
     */
    public const MOLDOVA_THE_REPUBLIC_OF = "MD";

    /**
     * Montenegro
     */
    public const MONTENEGRO = "ME";

    /**
     * Saint Martin (French part)
     */
    public const SAINT_MARTIN_FRENCH_PART = "MF";

    /**
     * Madagascar
     */
    public const MADAGASCAR = "MG";

    /**
     * Marshall Islands (the)
     */
    public const MARSHALL_ISLANDS_THE = "MH";

    /**
     * North Macedonia
     */
    public const NORTH_MACEDONIA = "MK";

    /**
     * Mali
     */
    public const MALI = "ML";

    /**
     * Myanmar
     */
    public const MYANMAR = "MM";

    /**
     * Mongolia
     */
    public const MONGOLIA = "MN";

    /**
     * Macao
     */
    public const MACAO = "MO";

    /**
     * Northern Mariana Islands (the)
     */
    public const NORTHERN_MARIANA_ISLANDS_THE = "MP";

    /**
     * Martinique
     */
    public const MARTINIQUE = "MQ";

    /**
     * Mauritania
     */
    public const MAURITANIA = "MR";

    /**
     * Montserrat
     */
    public const MONTSERRAT = "MS";

    /**
     * Malta
     */
    public const MALTA = "MT";

    /**
     * Mauritius
     */
    public const MAURITIUS = "MU";

    /**
     * Maldives
     */
    public const MALDIVES = "MV";

    /**
     * Malawi
     */
    public const MALAWI = "MW";

    /**
     * Mexico
     */
    public const MEXICO = "MX";

    /**
     * Malaysia
     */
    public const MALAYSIA = "MY";

    /**
     * Mozambique
     */
    public const MOZAMBIQUE = "MZ";

    /**
     * Namibia
     */
    public const NAMIBIA = "NA";

    /**
     * New Caledonia
     */
    public const NEW_CALEDONIA = "NC";

    /**
     * Niger (the)
     */
    public const NIGER_THE = "NE";

    /**
     * Norfolk Island
     */
    public const NORFOLK_ISLAND = "NF";

    /**
     * Nigeria
     */
    public const NIGERIA = "NG";

    /**
     * Nicaragua
     */
    public const NICARAGUA = "NI";

    /**
     * Netherlands (the)
     */
    public const NETHERLANDS_THE = "NL";

    /**
     * Norway
     */
    public const NORWAY = "NO";

    /**
     * Nepal
     */
    public const NEPAL = "NP";

    /**
     * Nauru
     */
    public const NAURU = "NR";

    /**
     * Niue
     */
    public const NIUE = "NU";

    /**
     * New Zealand
     */
    public const NEW_ZEALAND = "NZ";

    /**
     * Oman
     */
    public const OMAN = "OM";

    /**
     * Panama
     */
    public const PANAMA = "PA";

    /**
     * Peru
     */
    public const PERU = "PE";

    /**
     * French Polynesia
     */
    public const FRENCH_POLYNESIA = "PF";

    /**
     * Papua New Guinea
     */
    public const PAPUA_NEW_GUINEA = "PG";

    /**
     * Philippines (the)
     */
    public const PHILIPPINES_THE = "PH";

    /**
     * Pakistan
     */
    public const PAKISTAN = "PK";

    /**
     * Poland
     */
    public const POLAND = "PL";

    /**
     * Saint Pierre and Miquelon
     */
    public const SAINT_PIERRE_AND_MIQUELON = "PM";

    /**
     * Pitcairn
     */
    public const PITCAIRN = "PN";

    /**
     * Puerto Rico
     */
    public const PUERTO_RICO = "PR";

    /**
     * Palestine, State of
     */
    public const PALESTINE_STATE_OF = "PS";

    /**
     * Portugal
     */
    public const PORTUGAL = "PT";

    /**
     * Palau
     */
    public const PALAU = "PW";

    /**
     * Paraguay
     */
    public const PARAGUAY = "PY";

    /**
     * Qatar
     */
    public const QATAR = "QA";

    /**
     * Réunion
     */
    public const RUNION = "RE";

    /**
     * Romania
     */
    public const ROMANIA = "RO";

    /**
     * Serbia
     */
    public const SERBIA = "RS";

    /**
     * Russian Federation (the)
     */
    public const RUSSIAN_FEDERATION_THE = "RU";

    /**
     * Rwanda
     */
    public const RWANDA = "RW";

    /**
     * Saudi Arabia
     */
    public const SAUDI_ARABIA = "SA";

    /**
     * Solomon Islands
     */
    public const SOLOMON_ISLANDS = "SB";

    /**
     * Seychelles
     */
    public const SEYCHELLES = "SC";

    /**
     * Sudan (the)
     */
    public const SUDAN_THE = "SD";

    /**
     * Sweden
     */
    public const SWEDEN = "SE";

    /**
     * Singapore
     */
    public const SINGAPORE = "SG";

    /**
     * Saint Helena, Ascension and Tristan da Cunha
     */
    public const SAINT_HELENA_ASCENSION_AND_TRISTAN_DA_CUNHA = "SH";

    /**
     * Slovenia
     */
    public const SLOVENIA = "SI";

    /**
     * Svalbard and Jan Mayen
     */
    public const SVALBARD_AND_JAN_MAYEN = "SJ";

    /**
     * Slovakia
     */
    public const SLOVAKIA = "SK";

    /**
     * Sierra Leone
     */
    public const SIERRA_LEONE = "SL";

    /**
     * San Marino
     */
    public const SAN_MARINO = "SM";

    /**
     * Senegal
     */
    public const SENEGAL = "SN";

    /**
     * Somalia
     */
    public const SOMALIA = "SO";

    /**
     * Suriname
     */
    public const SURINAME = "SR";

    /**
     * South Sudan
     */
    public const SOUTH_SUDAN = "SS";

    /**
     * Sao Tome and Principe
     */
    public const SAO_TOME_AND_PRINCIPE = "ST";

    /**
     * El Salvador
     */
    public const EL_SALVADOR = "SV";

    /**
     * Sint Maarten (Dutch part)
     */
    public const SINT_MAARTEN_DUTCH_PART = "SX";

    /**
     * Syrian Arab Republic (the)
     */
    public const SYRIAN_ARAB_REPUBLIC_THE = "SY";

    /**
     * Eswatini
     */
    public const ESWATINI = "SZ";

    /**
     * Turks and Caicos Islands (the)
     */
    public const TURKS_AND_CAICOS_ISLANDS_THE = "TC";

    /**
     * Chad
     */
    public const CHAD = "TD";

    /**
     * French Southern Territories (the)
     */
    public const FRENCH_SOUTHERN_TERRITORIES_THE = "TF";

    /**
     * Togo
     */
    public const TOGO = "TG";

    /**
     * Thailand
     */
    public const THAILAND = "TH";

    /**
     * Tajikistan
     */
    public const TAJIKISTAN = "TJ";

    /**
     * Tokelau
     */
    public const TOKELAU = "TK";

    /**
     * Timor-Leste
     */
    public const TIMORLESTE = "TL";

    /**
     * Turkmenistan
     */
    public const TURKMENISTAN = "TM";

    /**
     * Tunisia
     */
    public const TUNISIA = "TN";

    /**
     * Tonga
     */
    public const TONGA = "TO";

    /**
     * Turkey
     */
    public const TURKEY = "TR";

    /**
     * Trinidad and Tobago
     */
    public const TRINIDAD_AND_TOBAGO = "TT";

    /**
     * Tuvalu
     */
    public const TUVALU = "TV";

    /**
     * Taiwan (Province of China)
     */
    public const TAIWAN_PROVINCE_OF_CHINA = "TW";

    /**
     * Tanzania, the United Republic of
     */
    public const TANZANIA_THE_UNITED_REPUBLIC_OF = "TZ";

    /**
     * Ukraine
     */
    public const UKRAINE = "UA";

    /**
     * Uganda
     */
    public const UGANDA = "UG";

    /**
     * United States Minor Outlying Islands (the)
     */
    public const UNITED_STATES_MINOR_OUTLYING_ISLANDS_THE = "UM";

    /**
     * United States of America (the)
     */
    public const UNITED_STATES_OF_AMERICA_THE = "US";

    /**
     * Uruguay
     */
    public const URUGUAY = "UY";

    /**
     * Uzbekistan
     */
    public const UZBEKISTAN = "UZ";

    /**
     * Holy See (the)
     */
    public const HOLY_SEE_THE = "VA";

    /**
     * Saint Vincent and the Grenadines
     */
    public const SAINT_VINCENT_AND_THE_GRENADINES = "VC";

    /**
     * Venezuela (Bolivarian Republic of)
     */
    public const VENEZUELA_BOLIVARIAN_REPUBLIC_OF = "VE";

    /**
     * Virgin Islands (British)
     */
    public const VIRGIN_ISLANDS_BRITISH = "VG";

    /**
     * Virgin Islands (U.S.)
     */
    public const VIRGIN_ISLANDS_US = "VI";

    /**
     * Viet Nam
     */
    public const VIET_NAM = "VN";

    /**
     * Vanuatu
     */
    public const VANUATU = "VU";

    /**
     * Wallis and Futuna
     */
    public const WALLIS_AND_FUTUNA = "WF";

    /**
     * Samoa
     */
    public const SAMOA = "WS";

    /**
     * Yemen
     */
    public const YEMEN = "YE";

    /**
     * Mayotte
     */
    public const MAYOTTE = "YT";

    /**
     * South Africa
     */
    public const SOUTH_AFRICA = "ZA";

    /**
     * Zambia
     */
    public const ZAMBIA = "ZM";

    /**
     * Zimbabwe
     */
    public const ZIMBABWE = "ZW";

    /**
     * Kosovo
     */
    public const KOSOVO = "1A";
}
