<?php

/*
 *   This file is part of NOALYSS.
 *
 *   PhpCompta is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   PhpCompta is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with PhpCompta; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
// Copyright (2002-2021) Author Dany De Bontridder <danydb@noalyss.eu>

/**
 * @file
 * @brief Test DabaseCore
 */
use PHPUnit\Framework\TestCase;

/**
 * Generated by PHPUnit_SkeletonGenerator on 2016-02-11 at 15:41:40.
 */
class DatabaseCoreTest extends TestCase
{

    /**
     * @var Database
     */
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp():void
    {
        $noalyss_user = (defined("noalyss_user")) ? noalyss_user : phpcompta_user;
        $password = (defined("noalyss_password")) ? noalyss_password : phpcompta_password;
        $port = (defined("noalyss_psql_port")) ? noalyss_psql_port : phpcompta_psql_port;
        $host = (!defined("noalyss_psql_host")) ? '127.0.0.1' : noalyss_psql_host;
        $this->object=new DatabaseCore($noalyss_user, $password, sprintf("%sdossier%s",domaine,DOSSIER), $host, $port);
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown():void
    {
        
    }
    /**
     * 
     */
    public function testExec_SQL()
    {
        $this->assertEquals(DBVERSION,$this->object->get_value("select max(val) from version"),"check Version");
        $this->assertTrue(true,$this->object->get_is_open(),"Database open");
        
        
    }

    /**
     * @brief test the Query_to_CSV function
     * @testDox  query_to_csv
     * @return void
     */
    public function testQuery_to_csv()
    {
        $aheader=array();
        $aheader[]=array("title"=>"date","type"=>"date");
        $aheader[]=array("title"=>"Montant","type"=>"num");
        $aheader[]=array("title"=>"Label","type"=>"string");

        $ret=$this->object->exec_sql("select j_id,j_montant,j_text from jrnx where coalesce(j_text ,'') != '' order by j_id limit 10");
        ob_start();
        $this->object->query_to_csv($ret, $aheader);
        $p_content=ob_get_contents();
        ob_end_clean();
        $filename=__FUNCTION__."_result.txt";
        \Noalyss\Facility::save_file(__DIR__, $filename, $p_content);
        $this->assertFileExists(__DIR__."/$filename");
        $filesize=filesize(__DIR__."/$filename");
        $this->assertEquals(284, $filesize,"$filename has not 284 bytes");
        $this->assertStringContainsString("Documentation", $p_content,"$filename invalid content");

    }
    /**
     * @brief test the Query_to_CSV function
     * @testDox  query_to_csv
     * @return void
     */
    public function testQuery_to_csvSmallHeader()
    {
        $aheader=array();
        $aheader[]=array("title"=>"date","type"=>"date");
        $aheader[]=array("title"=>"Montant","type"=>"num");
        $aheader[]=array("title"=>"Label","type"=>"string");

        $ret=$this->object->exec_sql("
                    select j_id,j_montant,j_text,j_poste 
                    from 
                        jrnx 
                    where 
                        coalesce(j_text ,'') != '' order by j_id limit 10");
        ob_start();
        $this->object->query_to_csv($ret, $aheader);
        $p_content=ob_get_contents();
        ob_end_clean();
        $filename=__FUNCTION__."_result.txt";
        \Noalyss\Facility::save_file(__DIR__, $filename, $p_content);
        $this->assertFileExists(__DIR__."/$filename");
        $filesize=filesize(__DIR__."/$filename");
        $this->assertEquals(284, $filesize,"$filename has not 284 bytes");
        $this->assertStringContainsString("Documentation", $p_content,"$filename invalid content");

    }
    /**
     * @brief read / write large object
     * @testDox read and write - unlink large object
     * 
     */
    public function testWrite_Read_large_object()
    {
        $md5="965765540c1531370e5856ff81696107";
        $file=__DIR__."/file/developpement-widget.pdf";
        // step 1 : we create the large object
        $binary_data= file_get_contents($file);
        $this->assertEquals($md5,md5($binary_data)," error when reading  $file ");
        $oid = $this->object->lo_write($binary_data);
        $this->assertTrue ($oid != false , "writing in DB fails");
        // step 2 = read object
        $retrieve = $this->object->lo_read($oid);
        $this->assertEquals($md5,md5($retrieve)," error when retrieving file from db");
        
        $target=$file."retrieve.pdf";
        if ( file_exists($target) ) { unlink($target);}
        
        file_put_contents($target, $retrieve);
        $this->assertTrue(file_exists($target));
        
        if ( file_exists($target) ) { unlink($target);}

        $this->assertTrue( $this->object->lo_unlink($oid)," cannot unlink it");
        
        
    }
    /**
     * @brief import  export large objects
     * @testDox import and export large object
     * 
     */
    public function testImport_export_large_object()
    {
        $md5="965765540c1531370e5856ff81696107";
        $file=__DIR__."/file/developpement-widget.pdf";
        $this->object->start();
        $oid = $this->object->lo_import($file);
        $this->object->commit();
        $this->assertTrue(  $oid != false , "import of the file fails");
        $target=$file."-tmp";
        if ( file_exists($target) ) { unlink($target);}
        $this->object->start();
        $this->object->lo_export($oid , $file."-tmp");
        $this->object->commit();
        $this->assertTrue(file_exists($file."-tmp")," file not exported");
        if ( file_exists($target) ) { unlink($target);}
        $this->assertTrue( $this->object->lo_unlink($oid)," cannot unlink it");
    }
    
    public function testReplace() {
            $string=<<<EOF
        Lorem ipsum dolor sit amet consectetur adipiscing elit. Quisque faucibus ex sapien vitae pellentesque sem placerat. In id cursus mi pretium tellus duis convallis. Tempus leo eu aenean sed diam urna tempor. Pulvinar vivamus fringilla lacus nec metus bibendum egestas. Iaculis massa nisl malesuada lacinia integer nunc posuere. Ut hendrerit semper vel class aptent taciti sociosqu. Ad litora torquent per conubia nostra inceptos himenaeos.

Lorem ipsum dolor sit amet consectetur adipiscing elit. Quisque faucibus ex sapien vitae pellentesque sem placerat. In id cursus mi pretium tellus duis convallis. Tempus leo eu aenean sed diam urna tempor. Pulvinar vivamus fringilla lacus nec metus bibendum egestas. Iaculis massa nisl malesuada lacinia integer nunc posuere. Ut hendrerit semper vel class aptent taciti sociosqu. Ad litora torquent per conubia nostra inceptos himenaeos.

Lorem ipsum dolor sit amet consectetur adipiscing elit. Quisque faucibus ex sapien vitae pellentesque sem placerat. In id cursus mi pretium tellus duis convallis. Tempus leo eu aenean sed diam urna tempor. Pulvinar vivamus fringilla lacus nec metus bibendum egestas. Iaculis massa nisl malesuada lacinia integer nunc posuere. Ut hendrerit semper vel class aptent taciti sociosqu. Ad litora torquent per conubia nostra inceptos himenaeos.

Lorem ipsum dolor sit amet consectetur adipiscing elit. Quisque faucibus ex sapien vitae pellentesque sem placerat. In id cursus mi pretium tellus duis convallis. Tempus leo eu aenean sed diam urna tempor. Pulvinar vivamus fringilla lacus nec metus bibendum egestas. Iaculis massa nisl malesuada lacinia integer nunc posuere. Ut hendrerit semper vel class aptent taciti sociosqu. Ad litora torquent per conubia nostra inceptos himenaeos.

Lorem ipsum dolor sit amet consectetur adipiscing elit. Quisque faucibus ex sapien vitae pellentesque sem placerat. In id cursus mi pretium tellus duis convallis. Tempus leo eu aenean sed diam urna tempor. Pulvinar vivamus fringilla lacus nec metus bibendum egestas. Iaculis massa nisl malesuada lacinia integer nunc posuere. Ut hendrerit semper vel class aptent taciti sociosqu. Ad litora torquent per conubia nostra inceptos himenaeos.
                
EOF;                
        $md5=md5($string);
        $this->object->start();
        $oid=$this->object->lo_write($string);
        $this->object->commit();

        $this->object->start();
        $stringDB = $this->object->lo_read($oid);
        $this->object->commit();
        
        $this->assertEquals(md5($string),md5($stringDB)," error string from DB corrupted");
        
        $string = "second";
        $this->object->start();
        $this->object->lo_replace($string,$oid);
        $this->object->commit();
        
        $this->object->start();
        $stringDB = $this->object->lo_read($oid);
        var_dump($stringDB);
        $this->object->commit();
        
        $this->assertEquals(md5($string),md5($stringDB)," after lo_replace(), string from DB corrupted");
    }
            
}