<?php

/*
 *   This file is part of NOALYSS.
 *
 *   PhpCompta is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   PhpCompta is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with PhpCompta; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

// Copyright (2018) Author Dany De Bontridder <dany@alchimerys.be>

use PHPUnit\Framework\TestCase;
function trim_parameter($p_value){
    return;
}
/**
 * Generated by PHPUnit_SkeletonGenerator on 2017-11-26 at 11:24:04.
 */
class Noalyss_Parameter_FolderTest extends TestCase
{

    protected $object;
    private $a_param;
    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     * 
     */
    protected function setUp():void
    {
        global $g_connection, $g_user;
        $_REQUEST['gDossier']=DOSSIER;
        $g_connection=new Database(DOSSIER);
        $g_user=new Noalyss_user($g_connection);
        $this->object=new Noalyss_Parameter_Folder($g_connection);
        $this->a_param=explode(",","MY_COUNTRY,".                 
                                    "MY_DEFAULT_ROUND_ERROR_DEB,". 
                                    "MY_DEFAULT_ROUND_ERROR_CRED,".
                                    "MY_ANC_FILTER,".              
                                    "MY_NAME,".                    
                                    "MY_TVA,".                     
                                    "MY_STREET,".                  
                                    "MY_NUMBER,".                  
                                    "MY_POSTCODE,".                      
                                    "MY_PHONE,".                     
                                    "MY_COUNTRY,".                    
                                    "MY_CITY,".                 
                                    "MY_FAX,".                     
                                    "MY_ANALYTIC,".                
                                    "MY_STRICT,".                  
                                    "MY_TVA_USE,".                 
                                    "MY_PJ_SUGGEST,".              
                                    "MY_CHECK_PERIODE,".           
                                    "MY_DATE_SUGGEST,".            
                                    "MY_ALPHANUM,".                
                                    "MY_UPDLAB,".                  
                                    "MY_ANC_FILTER,".                  
                                    "MY_REPORT,".
                                    "MY_STOCK,".
                                    "MY_COUNTRY_CODE");
                
    }
    public function testNew()
    {
        global $g_connection ;
        $nb_param=count($this->a_param);
        $cnt=$g_connection->get_value("select count(*) from parameter where pr_id like 'MY_%'");
        $this->assertEquals($nb_param,$cnt,"Number of parameters");
        
    }
    /*
     * @covers Noalyss_Parameter_Folder::checkTest
     * 
     */
    public function testcheck()
    {
        
        $a=$this->object->check('MY_STRICT', 0);
        $this->assertEquals($a,"N");
        
    }
    /*
     * @covers Noalyss_Parameter_Folder::checkTest
     * 
     */
    public function testcheck_anc_filter()
    {
        
        try {
            $this->object->check_anc_filter('6,7');
            $this->assertTrue(TRUE);
        } catch (Exception $ex) {
            $this->assertTrue(FALSE,'6,7 is valid');
        }
        try {
            $this->object->check_anc_filter('6,7,8,2');
            $this->assertTrue(TRUE);
        } catch (Exception $ex) {
            $this->assertTrue(FALSE,'6,7,8,2 is valid');
        }
        try {
            $this->object->check_anc_filter('6,7,8,2,AA');
            $this->assertTrue(FALSE);
        } catch (Exception $ex) {
            $this->assertTrue(TRUE,'6,7,8,2 is not valid');
        }
        
    }
    /*
     * @covers Noalyss_Parameter_Folder::checkTest
     * 
     */
    public function testupdate()
    {
        $ok=0;
        try {
            $this->testsave();
        } catch (Exception $e)
        {
            $ok=1;
        }
        $this->assertEquals($ok,0);
    }
    /*
     * @covers Noalyss_Parameter_Folder::checkTest
     *
     */
    public function testsave()
    {
        global $g_connection;
        for ($e =0;$e < count($this->a_param);$e++)
        {

            $attr=$this->a_param[$e];

            $old=$this->object->$attr;
            switch ($attr)
            {
                case "MY_STRICT":
                   $this->object->$attr='Y';
                    break;
                case "MY_COUNTRY":
                    $this->object->MY_COUNTRY='XBE';
                    break;
                case "MY_ANC_FILTER":
                    $this->object->MY_ANC_FILTER='5,4';
                    break;
                default:
                    $this->object->$attr='000';
                    break;
            }
            $this->object->save($this->a_param[$e]);
            $cur_value=$g_connection->get_value('select pr_value from "parameter" where pr_id=$1',[$attr]);
            $this->assertTrue(($cur_value==$this->object->$attr),sprintf("failed : %s cur_value %s expected %s",$attr,$cur_value,$this->object->$attr));
            $this->assertTrue($cur_value != $old,sprintf( "failed : %s cur_value  %s old %s",$attr,$cur_value,$old));

            $this->object->$attr=$old;
            $this->object->save($this->a_param[$e]);
            $cur_value=$g_connection->get_value('select pr_value from "parameter" where pr_id=$1',[$attr]);
            $this->assertTrue($cur_value == $old,sprintf( "failed : %s  cur_value  %s old %s",$attr,$cur_value,$old));
        }
         
    }
    function testMatch_accounting()
    {
        $this->assertTrue($this->object->match_analytic("612"));
        $this->assertTrue($this->object->match_analytic("6"));
        $this->assertTrue($this->object->match_analytic("66"));
        $this->assertTrue($this->object->match_analytic("71"));
        $this->assertTrue($this->object->match_analytic("7"));
        $this->assertFalse($this->object->match_analytic("5"));
        // different class
        $this->object->MY_ANC_FILTER="62,71";
        $this->assertFalse($this->object->match_analytic("5"), "error 5 doesnt match {$this->object->MY_ANC_FILTER}");
        $this->assertFalse($this->object->match_analytic("61"),"error 61 doesnt match {$this->object->MY_ANC_FILTER}");
        $this->assertFalse($this->object->match_analytic("61A"),"error 61A doesnt match {$this->object->MY_ANC_FILTER}");
        $this->assertFalse($this->object->match_analytic("72"),"error 72 doesnt match {$this->object->MY_ANC_FILTER}");
        $this->assertFalse($this->object->match_analytic("73"),"error 73 doesnt match {$this->object->MY_ANC_FILTER}");
        $this->assertTrue($this->object->match_analytic("71"), "error 71  match {$this->object->MY_ANC_FILTER}");
        $this->assertTrue($this->object->match_analytic("62"), "error 62  match {$this->object->MY_ANC_FILTER}");
        $this->assertTrue($this->object->match_analytic("6234"), "error 6234  match {$this->object->MY_ANC_FILTER}");
        $this->assertTrue($this->object->match_analytic("62AA"), "error 62AA  match {$this->object->MY_ANC_FILTER}");

    }

}

?>
