<?php
use PHPUnit\Framework\TestCase;

/**
 * Generated by PHPUnit_SkeletonGenerator on 2014-11-08 at 14:23:52.
 */
class Anc_KeyTest extends TestCase
{

    /**
     * @var Anc_Key
     */
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp():void
    {
       
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown():void
    {
        
    }
    static function setUpBeforeClass():void
    {
//       require_once 'global.php';
//
//        global $g_connection;
//        $g_connection=Dossier::connect();
        
    }
    static function tearDownAfterClass():void
    {
        
    }
    /**
     * @brief test Key Available and save
     * @global type $g_connection
     * @global type $cn
     * @covers Anc_Key::key_available Anc_Key::save 
     */
    function testKeyAvailable()
    {
        require_once 'global.php';

        global $g_connection,$cn;
        $cn=Dossier::connect();
        
        // create several key
        $key1=new Anc_Key(-1);
        $key2=new Anc_Key(-1);
        
        $key1->save(array(
            "key"=>-1,
            'name_key'=>'Test.Key1',
            "description_key"=>"Description de la clef",
            "row"=>[-1,-1,-1,-1],
            "pa"=>[1],
            "po_id"=>array(
                        [1],
                        [2],
                        [3],
                        [4],
                ),
            "percent"=>[10,20,30,40],
            "jrn"=>[1,152,83]
            ));
        $key2->save(array(
            "key"=>-1,
            'name_key'=>'Test.Key2',
            "description_key"=>"Description de la clef",
            "row"=>[-1,-1,-1,-1],
            "pa"=>[1],
            "po_id"=>array(
                        [1],
                        [2],
                        [3],
                        [4],
                ),
            "percent"=>[10,20,30,40],
            "jrn"=>[152]
            ));
        $this->assertGreaterThan(-1,$key1->get_key()->getp("id")," Key not created");
        $this->assertEquals(1,$key1::key_available(1),"Ledger 1 incorrect number of key");
        $this->assertEquals(2,$key1::key_available(152),"Ledger 152 incorrect number of key");
        $this->assertEquals(1,$key1::key_available(83),"Ledger 83 incorrect number of key");
        $this->assertEquals(0,$key1::key_available(2),"Ledger 2 incorrect number of key");
        $key1->delete();
        $key2->delete();
        $this->assertEquals(1,$cn->get_value("select count(*) from key_distribution"),"ANC_KEY Cannot delete keys");
    }

}
