<?php
use PHPUnit\Framework\TestCase;

/**
 * Generated by PHPUnit_SkeletonGenerator on 2014-11-07 at 23:05:35.
 */
class Acc_Parm_CodeTest extends TestCase
{

    /**
     * @var Acc_Parm_Code
     */
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp():void
    {
        global $g_connection;
        $_REQUEST['gDossier'] = DOSSIER;
        $g_connection=new Database(DOSSIER);
        $this->object=new Acc_Parm_Code($g_connection);
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown():void
    {
        
    }

    /**
     * @covers Acc_Parm_Code::load_all
     * @todo   Implement testLoad_all().
     */
    public function testLoad_all()
    {

        $a_result=$this->object->load_all();
        $err=0;
        for ($i=0;$i<count($a_result);$i++)
        {
            $code=$a_result[$i]->p_code;
            if (! in_array($code, array('BANQUE','CAISSE','COMPTE_COURANT','COMPTE_TVA',
                'CUSTOMER','DEP_PRIV','DNA','SUPPLIER','TVA_DED_IMPOT','TVA_DNA','VENTE','VIREMENT_INTERNE')))
            {
             $err++;
             $this->assertNull('code inconnu'.$code);
            }
            
                
        }
        $this->assertEquals(0,$err);
        
        
    }

    /**
     * @covers Acc_Parm_Code::save
     * @todo   Implement testSave().
     */
    public function testSave()
    {
        global $g_connection;

        $this->object->save();
        $a=new Acc_Parm_Code($g_connection,'CAISSE');
        $save=clone ($a);
        $a->p_code='CAISSE';
        $a->p_comment='TEST';
        $a->p_value='5';
        $a->save();
        $test=new Acc_Parm_Code($g_connection,'CAISSE');
        $this->assertEquals($test->p_code,$a->p_code);
        $this->assertEquals($test->p_comment,$a->p_comment);
        $this->assertEquals($test->p_value,$a->p_value);
        $save->save();
    }

    /**
     * @covers Acc_Parm_Code::display
     * @todo   Implement testDisplay().
     */
    public function testDisplay()
    {
        $this->object->display();
        $this->assertTrue(TRUE);
    }

    /**
     * @covers Acc_Parm_Code::form
     * @todo   Implement testForm().
     */
    public function testForm()
    {
       $this->object->form();
       $this->assertTrue(TRUE);
    }

    /**
     * @covers Acc_Parm_Code::load
     * @todo   Implement testLoad().
     */
    public function testLoad()
    {
       $this->object->load();
       $this->object->p_code='CAISSE';
       $this->object->load();
       $this->assertTrue(TRUE);
    }

}
