<?php
use PHPUnit\Framework\TestCase;
use PHPUnit\Framework\Attributes\DataProvider;
/**
 * Generated by PHPUnit_SkeletonGenerator on 2016-02-13 at 00:41:50.
 * @backupGlobals enabled
 */
#[\AllowDynamicProperties]
class Acc_OperationTest extends TestCase
{
    /**
     * @var Acc_OperationTest
     */
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp():void
    {
         include 'global.php';
        global $g_connection,$g_user;
        $this->object = new Acc_Operation($g_connection);
       
        
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown():void
    {
    }

    /**
     *@covers Acc_Operation::seek_group
     */
    public function testSeek_group()
    {
        $this->object->jr_id=6;
        $r=$this->object->seek_group();
        $this->assertEquals(8,$r);
    }
    /**
     * @covers Acc_Operation::set_id
     * 
     */
    public function testSet_id()
    {
        $this->object->set_id(1000);
        $this->assertEquals(1000,$this->object->jr_id);
        try {
            $this->object->set_id('AB');
        } catch (Exception $e) {
            $this->assertEquals($e->getMessage(),'Acc_Operation::set_id , id invalide ');
        }
    }
    /**
     * @covers Acc_Operation::set_paid
     */
    function testSet_Paid()
    {
        $row=$this->object->db->get_array('select * from jrn where jr_rapt <> $1 limit 1',array('paid'));
        if ( ! $row ) {
            echo "Aucune ligne trouvée";
            $this->assertTrue(TRUE);    
        } else {
            $this->object->jr_id=$row[0]['jr_id'];  
            $this->object->set_paid();
            $status=$this->object->db->get_value ('select jr_rapt from jrn where jr_id=$1',array($row[0]['jr_id']));
            $this->assertEquals($status,'paid');
        }
        
    }
    /**
     * @covers Acc_Operation::get_amount
     */
    function testGet_Amount()
    {
        $row=$this->object->db->get_array('select * from jrn limit 1');
        if ( ! $row ) {
            echo "Aucune ligne trouvée";
            $this->assertTrue(FALSE);
        } else {
            $this->object->jr_id=$row[0]['jr_id'];  
            $amount=$this->object->get_amount();
            $this->assertEquals($amount,$row[0]['jr_montant']);
        }
        
    }
    /**
     * provide data for testAmount_Currency
     * @return type
     */
    public static function data_amount_currency()
    {
        return array(
            /* sale */
            array(659,146.95),
            array(657,146.95),
            array(649,0),
            /* purchase*/
            array(680,680.33),
            array(683,834.91),
            array(526,0),
            /* financial */
            array(658,146.95),
            array(684,200),
            array(685,300),
            /* misc operation */
            array(686,25.25),
            
        );
    }
    /**
     * @testdox acc_operation::get_amount_currency - sale-purchase-fin-misc
     * @covers Acc_Operation::get_amount_currency
     * @dataProvider data_amount_currency
     */
     #[DataProvider('data_amount_currency')]
    function testGet_AmountCurrency($p_jrn_id,$p_amount_currency)
    {
        global $g_connection;
        $acc_operation=new Acc_Detail($g_connection,$p_jrn_id);
        $acc_operation->get();
        $acc_operation->get_quant();
        $actual_amount=round($acc_operation->get_currency_amount(),2);
        $this->assertEquals($p_amount_currency,$actual_amount,"currency values doesn't match for $p_jrn_id");
    }

    /**
     * @testDox Test form_clone_operation SALE
     * @return void
     */
    function testForm_clone_operation_sale()
    {
        global $g_connection;
        //-----------------------------------
        // use  jr_id=160 : 5 rows
        //-----------------------------------
        $duplicate = new Acc_Operation($g_connection);
        $duplicate->jr_id=160;
        ob_start();

        $result=$duplicate->form_clone_operation("test");
        ob_end_clean();

        $this->assertTrue(stripos($result,'<input type="hidden" id="nb_item" name="nb_item" value="5">')>0, "jr_id = ".$duplicate->jr_id." sale : HTML doesnt contain nb_item = 5");
        //-----------------------------------
        // use  jr_id=910 : 1 rows
        //-----------------------------------
        $duplicate = new Acc_Operation($g_connection);
        $duplicate->jr_id=910;
        ob_start();
        $result=$duplicate->form_clone_operation("test");
        ob_end_clean();
        $this->assertStringContainsString(strtoupper('<input type="hidden" id="nb_item" name="nb_item" value="1">'), strtoupper($result));
        $this->assertStringContainsString(
            strtoupper('<input type="hidden" id="e_march0" name="e_march0" value="DEPLAC">')
            ,strtoupper($result),"jr_id = ".$duplicate->jr_id."");

        //-----------------------------------
        // use jr_id=659 VAT_SIDED
        //-----------------------------------
        $duplicate = new Acc_Operation($g_connection);
        $duplicate->jr_id=659;
        ob_start();
        $result=$duplicate->form_clone_operation("test");
        ob_end_clean();
        $this->assertStringContainsString(
            strtoupper('<input type="hidden" id="e_march0_tva_id" name="e_march0_tva_id" value="5">')
            , strtoupper($result),"jr_id = ".$duplicate->jr_id."");
        $this->assertStringContainsString(
        strtoupper('<input type="hidden" id="e_march0_tva_amount" name="e_march0_tva_amount" value="0">')
            , strtoupper($result),"jr_id = ".$duplicate->jr_id."");
        $this->assertStringContainsString(
            strtoupper( '<input type="hidden" id="e_march1_tva_amount" name="e_march1_tva_amount" value="88.392500">')
            , strtoupper($result),"jr_id = ".$duplicate->jr_id."");

        //-----------------------------------
        // use jr_id=in another currency
        //-----------------------------------
        $duplicate = new Acc_Operation($g_connection);
        $duplicate->jr_id=657;
        ob_start();
        $result=$duplicate->form_clone_operation("test");
        ob_end_clean();
        $this->assertStringContainsString(
            strtoupper('<input type="hidden" id="p_currency_code" name="p_currency_code" value="1">')
            , strtoupper($result),"jr_id = ".$duplicate->jr_id."");
        $this->assertStringContainsString(
            strtoupper('<input type="hidden" id="p_currency_rate" name="p_currency_rate" value="1.090000">')
            , strtoupper($result),"jr_id = ".$duplicate->jr_id."");
        $this->assertStringContainsString(
            strtoupper( '<input type="hidden" id="e_march0_price" name="e_march0_price" value="20.000000">')
            , strtoupper($result),"jr_id = ".$duplicate->jr_id."");
    }

    /**
     * @testDox Test form_clone_operation PURCHASE
     * @return void
     */
    function testForm_clone_operation_purchase()
    { global $g_connection;
        //-----------------------------------
        // use jr_id 158 4 rows
        //-----------------------------------
        $duplicate = new Acc_Operation($g_connection);
        $duplicate->jr_id=158;
        ob_start();

        $result=$duplicate->form_clone_operation("test");
        ob_end_clean();

        $this->assertTrue(stripos($result,'<input type="hidden" id="nb_item" name="nb_item" value="4">')>0
            , "purchase : HTML doesn't contain nb_item = 4 $result");

        $this->assertStringContainsString(
            strtoupper('<input type="hidden" id="e_march0" name="e_march0" value="DEPLAC1">')
            ,strtoupper($result));

        $this->assertStringContainsString(
            strtoupper('<input type="hidden" id="e_march3" name="e_march3" value="DOCUME">')
            ,strtoupper($result));
        //-----------------------------------
        // use jr_id 680 VAT_SIDED
        //-----------------------------------
        $duplicate = new Acc_Operation($g_connection);
        $duplicate->jr_id=680;
        ob_start();

        $result=strtoupper($duplicate->form_clone_operation("test"));
        ob_end_clean();

        $this->assertStringContainsString(
            strtoupper(        '<input type="hidden" id="e_march0_tva_amount" name="e_march0_tva_amount" value="0">'),
            $result);
        $this->assertStringContainsString(
            strtoupper('<input type="hidden" id="e_march0_tva_id" name="e_march0_tva_id" value="5">'),$result);
        $this->assertStringContainsString(
            strtoupper('<input type="hidden" id="e_march1_tva_id" name="e_march1_tva_id" value="4">'),$result);

        //-----------------------------------
        // use jr_id=in another currency
        //-----------------------------------
        $duplicate = new Acc_Operation($g_connection);
        $duplicate->jr_id=683;
        ob_start();
        $result=$duplicate->form_clone_operation("test");
        ob_end_clean();
        $this->assertStringContainsString(
            strtoupper('<input type="hidden" id="p_currency_code" name="p_currency_code" value="1">')
            , strtoupper($result));
        $this->assertStringContainsString(
            strtoupper('<input type="hidden" id="p_currency_rate" name="p_currency_rate" value="1.090000">')
            , strtoupper($result));
        $this->assertStringContainsString(
            strtoupper( '<INPUT TYPE="HIDDEN" ID="E_MARCH0_PRICE" NAME="E_MARCH0_PRICE" VALUE="18.250000">')
            , strtoupper($result));
    }
    /**
     * @testDox Test form_clone_operation MISC OP
     * @return void
     */
    function testForm_clone_operation_ods()
    {
        global $g_connection;
        // use jr_id 317 1 rows
        $duplicate = new Acc_Operation($g_connection);
        $duplicate->jr_id=317;
        ob_start();

        $result=strtoupper($duplicate->form_clone_operation("test"));
        ob_end_clean();
        $this->assertTrue(stripos($result,'<input type="hidden" id="nb_item" name="nb_item" value="3">')>0
            , "MO : HTML doesn't contain nb_item = 3 ");
        $this->assertStringContainsString(
            strtoupper('<input type="hidden" id="amount1" name="amount1" value="40.0000">')       ,
            $result);

    }
    /**
     * @testDox Test form_clone_operation FIN
     * @return void
     */
    function testForm_clone_operation_fin()
    {
        // use jr_id 250 1 rows
        global $g_connection;
        $duplicate = new Acc_Operation($g_connection);
        $duplicate->jr_id=250;
        ob_start();

        $result=strtoupper($duplicate->form_clone_operation("test"));
        ob_end_clean();

        $this->assertStringContainsString(
            strtoupper('<input type="hidden" id="e_other0_amount" name="e_other0_amount" value="3500.7800">')       ,
            $result);
        //-----------------------------------
        // use jr_id=in another currency
        //----------------------------------
        $duplicate->jr_id=658;
        ob_start();

        $result=strtoupper($duplicate->form_clone_operation("test"));
        ob_end_clean();
        $this->assertStringContainsString(
            strtoupper('<input type="hidden" id="e_other0_amount" name="e_other0_amount" value="146.950000">')       ,
            $result);
        $this->assertStringContainsString(
            strtoupper('<INPUT TYPE="HIDDEN" ID="P_CURRENCY_RATE" NAME="P_CURRENCY_RATE" VALUE="1.090000">')       ,
            $result);
    }

    function testUpdate_receipt() {
        global $g_connection;

        $receipt=$g_connection->get_value("select jr_pj_number from jrn where jr_id=250");
        // $this->assertEquals('BP19-1',$receipt,'Receipt number incorrect');
        $acc_operation=new Acc_Operation($g_connection);
        $acc_operation->set_id(250);
        $acc_operation->pj="";
        $acc_operation->update_receipt();
        $new_receipt=$g_connection->get_value("select jr_pj_number from jrn where jr_id=250");
        $this->assertTrue($new_receipt== null,'receipt not set to null ');

        $acc_operation->pj='BP-99';
        $acc_operation->update_receipt();
        $new_receipt=$g_connection->get_value("select jr_pj_number from jrn where jr_id=250");
        $this->assertTrue($new_receipt != null,'receipt not compute');
        $this->assertTrue($new_receipt =='BP-99',"[$new_receipt]".'receipt not set');

        // padding 5
        $ledger=new \Acc_Ledger($g_connection, 83);
        $save_prop=$ledger->get_propertie();
        $g_connection->exec_sql('update jrn_def set jrn_def_pj_padding = 5 where jrn_def_id=83');
        $acc_operation->pj=$ledger->guess_pj();
        $acc_operation->update_receipt();
        $new_receipt=$g_connection->get_value("select jr_pj_number from jrn where jr_id=250");
        $this->assertTrue($new_receipt =='BP19-00003',"[$new_receipt] receipt not set");

        // padding 3
        $g_connection->exec_sql('update jrn_def set jrn_def_pj_padding = 3 where jrn_def_id=83');
        $acc_operation->pj=$ledger->guess_pj();
        $acc_operation->update_receipt();
        $new_receipt=$g_connection->get_value("select jr_pj_number from jrn where jr_id=250");
        $this->assertTrue($new_receipt =='BP19-003',"[$new_receipt] receipt not set");

        // default no padding
        $g_connection->exec_sql('update jrn_def set jrn_def_pj_padding = 0 where jrn_def_id=83');
        $acc_operation->pj=$ledger->guess_pj();
        $acc_operation->update_receipt();
        $new_receipt=$g_connection->get_value("select jr_pj_number from jrn where jr_id=250");
        $this->assertTrue($new_receipt =='BP19-3',"[$new_receipt] receipt not set");

        // reset to original value
        $acc_operation->pj=$receipt;
        $acc_operation->update_receipt();
        $g_connection->exec_sql('update jrn_def set jrn_def_pj_padding = $1 where jrn_def_id=83',[$save_prop['jrn_def_pj_padding']        ]);


    }

}
