<?php
use PHPUnit\Framework\TestCase;
use PHPUnit\Framework\Attributes\DataProvider;
/**
 * Generated by PHPUnit_SkeletonGenerator on 2014-10-31 at 20:33:23.
 */
class Acc_ComputeTest extends TestCase
{

    /**
     * @var Acc_Compute
     */
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp():void
    {
        $this->object=new Acc_Compute;
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown():void
    {
        
    }
    public static function dataGet_parameter()
    {
        return array( array('amount'),
                        array('amount_vat'),
                        array('amount_vat_rate'),
                        array('nd_vat'),
                        array('nd_vat_rate'),
                        array('nd_ded_vat'),
                        array('nd_ded_vat_rate'),
                        array('amount_nd'),
                        array('amount_nd_rate'),
                        array('nd_vat_rate'),
                        array('amount_perso'),
                        array('amount_perso_rate')
                        
                                  );
    }
    /**
     * @covers Acc_Compute::get_parameter
     * @todo   Implement testGet_parameter().
     * @dataProvider dataGet_parameter
     */
     #[DataProvider('dataGet_parameter')]
    public function testGet_parameter($data)
    {
       $result=$data;
       $test=$data;
       $this->object->get_parameter($test);
       $this->assertEquals($test,$result);
    }

    /**
     * @covers Acc_Compute::set_parameter
     * @todo   Implement testSet_parameter().
     */
    public function testSet_parameter()
    {
        $this->object->set_parameter("nd_vat_rate",50);
         $this->assertTrue(true,true);
    }

    /**
     * @covers Acc_Compute::get_info
     * @todo   Implement testGet_info().
     */
    public function testGet_info()
    {
        $this->object->get_info();
        $this->assertTrue(true,true);
    }

    /**
     * @covers Acc_Compute::compute_vat
     * @todo   Implement testCompute_vat().
     */
    public function testCompute_vat()
    {
        $this->object->set_parameter('amount',1.23);
        $this->object->set_parameter('amount_vat_rate',0.21);
        $this->object->compute_vat();
        $this->assertEquals($this->object->amount_vat,0.26);
    }

    /**
     * @covers Acc_Compute::compute_nd
     * @todo   Implement testCompute_nd().
     */
    public function testCompute_nd()
    {
         $this->object->set_parameter('amount',1.23);
        $this->object->set_parameter('amount_vat_rate',0.21);
        $this->object->set_parameter('amount_nd_rate',50);
        $this->object->check=false;
        $this->object->compute_nd();
        $this->assertEquals($this->object->amount_nd,0.62);
    }

    /**
     * @covers Acc_Compute::compute_nd_vat
     * @todo   Implement testCompute_nd_vat().
     */
    public function testCompute_nd_vat()
    {
        $this->object->set_parameter('amount',1.23);
        $this->object->set_parameter('amount_vat_rate',0.21);
        $this->object->set_parameter('nd_vat_rate',50);
        $this->object->check=false;
        $this->object->compute_nd_vat();
        $this->assertEquals($this->object->nd_vat,0.13);
    }

    /**
     * @covers Acc_Compute::compute_ndded_vat
     * @todo   Implement testCompute_ndded_vat().
     */
    public function testCompute_ndded_vat()
    {
       $this->object->set_parameter('amount',1.23);
        $this->object->set_parameter('amount_vat_rate',0.21);
        $this->object->set_parameter('nd_ded_vat_rate',50);
        $this->object->check=false;
        $this->object->compute_ndded_vat();
        $this->assertEquals($this->object->nd_ded_vat,0.13);
    }

    /**
     * @covers Acc_Compute::compute_perso
     * @todo   Implement testCompute_perso().
     */
    public function testCompute_perso()
    {
        $this->object->set_parameter('amount',1.23);
        $this->object->set_parameter('amount_vat_rate',0.21);
        $this->object->set_parameter('amount_perso_rate',50);
        $this->object->compute_vat();
        $this->object->compute_perso();
        
        $this->assertEquals($this->object->amount_perso,0.62);
        $this->assertEquals($this->object->amount_vat,0.26);
    }

    /**
     * @covers Acc_Compute::correct
     * @todo   Implement testCorrect().
     */
    public function testCorrect()
    {
        $this->object->amount=100.0;
        $this->object->amount_perso=15.3333;
        $this->object->amount_vat=20.6666;
        $this->object->amount_nd_vat=1.5;
        $this->object->correct();
        $this->assertEquals($this->object->amount,84.6667);
        $this->assertEquals($this->object->amount_perso,15.3333);
        $this->assertEquals($this->object->amount_vat,20.67);
    }

    /**
     * @covers Acc_Compute::verify
     * @todo   Implement testVerify().
     */
    public function testVerify()
    {
        $this->object->verify();
        $new=new Acc_Compute();
        $this->object->verify($new);
        $this->assertTrue(TRUE);
    }

    /**
     * @covers Acc_Compute::display
     * @todo   Implement testDisplay().
     * Cannot be checked
     */
    public function testDisplay()
    {
        ob_start();
       $this->object->display();
       $result=ob_get_contents();
       ob_end_clean();
       $this->assertStringStartsWith("key amount Description amount value is 0<br>key amount_vat Description amount_vat value is 0<br>",$result);
       $this->assertStringEndsWith("<br>key amount_vat_currency Description amount_vat_currency value is 0<br>key currency_rate Description currency_rate value is 0<br>key autoreverse Description autoreverse value is 0<br>",$result);
    }

    public function testCompute()
    {
         print "**********************************************";
        print PHP_EOL;
        print "<h1> OUTPUT IN HTML , USE LYNX TO READ</h1>";
        print PHP_EOL;
        print " OR REDIRECT TO HTML";
        print PHP_EOL;
        print "**********************************************";
        print PHP_EOL;
        print "phpunit |lynx -stdin";
        print PHP_EOL;
        $a=new Acc_Compute();
        // Compute some operation to see if the computed amount are
        // correct

        //Test VAT
        $a->set_parameter('amount',1.23);
        $a->set_parameter('amount_vat_rate',0.21);


        $a->compute_vat();
        $this->assertEquals($a->amount_vat,0.26);
        try
        {
            $a->verify();
            $this->assertTrue(TRUE);
        }
        catch (Exception $exc)
        {
            echo $exc->getMessage();
            record_log($exc->getTraceAsString());
            $this->assertTrue(FALSE);
        }

        
        
        // Test VAT + perso
        $a=new Acc_Compute();
        $a->set_parameter('amount',1.23);
        $a->set_parameter('amount_vat_rate',0.21);
        $a->set_parameter('amount_perso_rate',0.5);
        $b=clone $a;
        $a->compute_vat();
        $this->assertEquals($a->amount_vat,0.26);
        $a->compute_perso();
        $this->assertEquals($a->amount_perso,0.01);
        $a->correct();
        $this->assertEquals($a->amount_vat,0.26);
        $this->assertEquals($a->amount_perso,0.01);
         
        $a->verify($b);
        
        // TEST VAT + ND
        // Test VAT + perso
        $a=new Acc_Compute();
        $a->set_parameter('amount',1.23);
        $a->set_parameter('amount_vat_rate',0.21);
        $a->set_parameter('nd_vat_rate',0.5);
        $b=clone $a;
        echo '<h1> Test VAT + ND VAT</h1>';
        echo '<h2> Data </h2>';
        $a->display();
        $a->compute_vat();
        $a->compute_nd_vat();
        $a->correct();
        echo '<h2> Result </h2>';
        $a->display();
        $a->verify($b);
        // TEST VAT + ND
        // Test VAT + perso
        $a=new Acc_Compute();
        $a->set_parameter('amount',1.23);
        $a->set_parameter('amount_vat_rate',0.21);
        $a->set_parameter('nd_vat_rate',0.5);
        $a->set_parameter('amount_perso_rate',0.5);

        $b=clone $a;
        echo '<h1> Test VAT + ND VAT + perso</h1>';
        echo '<h2> Data </h2>';
        $a->display();
        $a->compute_vat();
        $a->compute_perso();
        $a->compute_nd_vat();
        $a->correct();
        echo '<h2> Result </h2>';
        $a->display();
        $a->verify($b);
        // TEST VAT + ND
        $a=new Acc_Compute();
        $a->set_parameter('amount',1.23);
        $a->set_parameter('amount_vat_rate',0.21);
        $a->set_parameter('amount_nd_rate',0.5);

        $b=clone $a;
        echo '<h1> Test VAT + ND </h1>';
        echo '<h2> Data </h2>';
        $a->display();
        $a->compute_vat();
        $a->compute_nd();

        $a->compute_perso();
        $a->compute_nd_vat();
        $a->correct();
        echo '<h2> Result </h2>';
        $a->display();
        $a->verify($b);
        // TEST VAT + ND
        // + Perso
        $a=new Acc_Compute();
        $a->set_parameter('amount',1.23);
        $a->set_parameter('amount_vat_rate',0.21);
        $a->set_parameter('amount_nd_rate',0.5);
        $a->set_parameter('amount_perso_rate',0.2857);
        $b=clone $a;
        echo '<h1> Test VAT + ND  + Perso</h1>';
        echo '<h2> Data </h2>';
        $a->display();
        $a->compute_vat();
        $a->compute_nd();

        $a->compute_perso();
        $a->compute_nd_vat();
        $a->correct();
        echo '<h2> Result </h2>';
        $a->display();
        $a->verify($b);
// TEST VAT + ND
        // + Perso
        $a=new Acc_Compute();
        $a->set_parameter('amount',1.23);
        $a->set_parameter('amount_vat_rate',0.21);
        $a->set_parameter('nd_ded_vat_rate',0.5);

        $b=clone $a;
        echo '<h1> Test VAT   +  TVA ND DED</h1>';
        echo '<h2> Data </h2>';
        $a->display();
        $a->compute_vat();
        $a->compute_nd();

        $a->compute_perso();
        $a->compute_nd_vat();
        $a->compute_ndded_vat();
        $a->correct();
        echo '<h2> Result </h2>';
        $a->display();
        $a->verify($b);
    }
 
}
