<?php
use PHPUnit\Framework\TestCase;

/**
 * Generated by PHPUnit_SkeletonGenerator on 2014-10-31 at 20:33:22.
 */
class Acc_BalanceTest extends TestCase
{

    /**
     * @var Acc_Balance
     */
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp():void
    {
        global $g_connection, $g_parameter,$g_user;
        $_REQUEST['gDossier']=DOSSIER;
        $g_connection=new Database(DOSSIER);
        $g_parameter=new Noalyss_Parameter_Folder($g_connection);
        $this->object=new Acc_Balance($g_connection);
       
        
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown():void
    {
        
    }

    /**
     * @covers Acc_Balance::get_row
     */
    public function testGet_row()
    {
        global $g_connection,$g_user;
        $g_user=new Noalyss_user($g_connection,1);
        
        $max=$g_connection->get_value("select max(p_id) from parm_periode");
        $min=$g_connection->get_value("select min(p_id) from parm_periode");
	$this->object->jrn=NULL;
        $array=$this->object->get_row($min,$max);
	$this->assertEquals(35,count($array));
	$this->object->jrn=[2,4];
        $array=$this->object->get_row($min,$max);
	$this->assertEquals(16,count($array));

    }

    /**
     * @covers Acc_Balance::filter_cat
     */
    public function testFilter_cat()
    {
        $this->object->jrn=1;
        $this->object->filter_cat(array());
        $this->assertEquals($this->object->jrn,null);
        $this->object->filter_cat(array('2'=>'FIN'));
        sort($this->object->jrn);
        $this->assertEquals([1,83,152],$this->object->jrn);
        $this->object->filter_cat(array('1'=>'ACH','2'=>'FIN'));
        sort($this->object->jrn);
        $this->assertEquals([1,3,35,83,152],$this->object->jrn);
    }
    /**
     *@covers Acc_Balance::summary_add
     *@depend Acc_Balance::summary_init
     */
    public function testSummary_add()
    {
      $array=$this->object->summary_init();
      $result=$this->object->summary_add($array,'600',100,0);
      $this->assertEquals(100,$result['6']['deb']);

      $result=$this->object->summary_add($result,'6500',50,0);
      $this->assertEquals(150,$result['6']['deb']);
      
      $result=$this->object->summary_add($result,'2600',0,100);
      $this->assertEquals(100,$result['1_5']['cred']);
      $this->assertEquals(0,$result['1_5']['deb']);
      
      $result=$this->object->summary_add($result,'2400',100,0);
      $this->assertEquals(100,$result['1_5']['deb']);

      
    }
    /**
     *@covers Acc_Balance::summary_add
     *@depend Acc_Balance::summary_init
     */
    public function testSummary_display()
    {
      $array=$this->object->summary_init();

      $output='<table><tr><td  >Class 1-5</td><td   class="num">0,00</td><td  >=</td></tr><tr><td  >Class 6</td><td   class="num">0,00</td><td  >=</td></tr><tr><td  >Class 7</td><td   class="num">0,00</td><td  >=</td></tr><tr><td  >Solde 6/7</td><td   class="num">0,00</td><td  >=</td></tr></table>';
      $this->expectOutputString($output);
      $this->object->summary_display($array);

      
    }

    /**
     *@covers Acc_Balance::summary_init
     */
    public function testsummary_init()
    {
      $array=$this->object->summary_init();
      $this->assertTrue(isset($array['1_5']));
      $this->assertTrue(isset($array['6']));
      $this->assertTrue(isset($array['7']));
    }


}
