<?php

use PHPUnit\Framework\TestCase;
use PHPUnit\Framework\Attributes\DataProvider;
/**
 * Generated by PHPUnit_SkeletonGenerator on 2014-10-31 at 20:33:22.
 *
 */
class Acc_Account_LedgerTest extends TestCase
{

    /**
     * @var Acc_Account_Ledger
     */
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     * 
     */
    protected function setUp():void
    {
        global $g_connection, $g_parameter, $g_user;
        $_REQUEST['gDossier']=DOSSIER;
        $g_connection=new Database(DOSSIER);
        $g_parameter=new Noalyss_Parameter_Folder($g_connection);
        $g_user=new Noalyss_user($g_connection);
        $this->object=new Acc_Account_Ledger($g_connection, 400);
        $g_connection->exec_sql("update jrn_def set jrn_def_class_deb='4* 2*' where jrn_def_type='ODS'");
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown():void
    {
        
    }

    /**
     * @covers Acc_Account_Ledger::get_row
     */
    public function testGet_row()
    {
        $array=$this->object->get_row(92, 103);
        $this->assertEquals(count($array), 3);
    }

    /**
     * @return array : idx [ $accounting,$from_date,$to_date,$nb_row,$tot_deb,$tot_cred]
     */
    public static function dataGet_row_date()
    {
        $array=array(
             ['55000004','01.01.2019','31.12.2019',4,0,806.90]
          ,['55000005','01.01.2019','31.12.2019',3,3750.78,250.25]
          ,['4400005','01.01.2019','31.12.2019',17,806.90,1761.00]
          ,['4400005','01.03.2019','02.05.2019',9,602.19,848.80]
        );
        return $array;
    }
    /**
     * @brief test function Acc_Account_Ledger::get_row_date
     * @covers Acc_Account_Ledger::get_row_date
     * @dataProvider dataGet_row_date
     */
     #[DataProvider('dataGet_row_date')]
    public function testGetRowData($accounting,$from_date,$to_date,$nb_row,$tot_deb,$tot_cred)
    {
        global $g_connection;
        $g_connection->clear_all_prepare();
        $acc_account_ledger=new Acc_Account_Ledger( $g_connection, $accounting);
        $acc_account_ledger->get_row_date($from_date,$to_date);
        $nb_actual_row=count($acc_account_ledger->row);
        $this->assertEquals($nb_row,$nb_actual_row,"error received $nb_row rows");
        $this->assertEquals($tot_deb,$acc_account_ledger->tot_deb,"error amount incorrect received ".$acc_account_ledger->tot_deb);
        $this->assertEquals($tot_cred,$acc_account_ledger->tot_cred,"error amount incorrect received ".$acc_account_ledger->tot_cred);

    }
    /**
     * @covers Acc_Account_Ledger::get_row_date
     */
    public function testGet_row_date()
    {
        global $g_user, $g_connection;

        $accounting=new Acc_Account_Ledger($g_connection, '4511');
        $a_array=$accounting->get_row_date('01.01.2018', '31.12.2018', 0);
        $expected=array(
            0=>
            array(
                0=>
                array(
                    'j_id'=>'820',
                    'jr_id'=>'317',
                    'j_date_fmt'=>'01.01.2018',
                    'j_date'=>'2018-01-01',
                    'j_qcode'=>NULL,
                    'deb_montant'=>'0',
                    'cred_montant'=>'8.4000',
                    'description'=>'Ecriture d\'ouverture 2018 TVA à payer 21%',
                    'jrn_name'=>'Opération Diverses',
                    'j_debit'=>'f',
                    'jr_internal'=>'O000172',
                    'jr_pj_number'=>'ODS44',
                    'letter'=>NULL,
                    'pcm_lib'=>'TVA à payer 21%',
                    'jr_optype'=>'OPE',
                    'jr_tech_per'=>'92',
                    'p_exercice'=>'2018',
                    'jrn_def_name'=>'Opération Diverses',
                    'jrn_def_code'=>'O01',
                    'delta_letter'=>NULL,
                    'currency_rate' => '1.000000',
                    'currency_rate_ref' => '1.000000',
                    'currency_id' => '0',
                    'cr_code_iso' => 'EUR',
                    'j_montant' => '8.4000',
                    'oc_amount' => null,
                    'oc_vat_amount' => null
                    ,'op_analytic' => '0'

                ),
                1=>
                array(
                    'j_id'=>'6',
                    'jr_id'=>'2',
                    'j_date_fmt'=>'24.02.2018',
                    'j_date'=>'2018-02-24',
                    'j_qcode'=>NULL,
                    'deb_montant'=>'0',
                    'cred_montant'=>'8.4000',
                    'description'=>'Déplacement',
                    'jrn_name'=>'Vente',
                    'j_debit'=>'f',
                    'jr_internal'=>'V000002',
                    'jr_pj_number'=>'VEN2',
                    'letter'=>NULL,
                    'pcm_lib'=>'TVA à payer 21%',
                    'jr_optype'=>'NOR',
                    'jr_tech_per'=>'93',
                    'p_exercice'=>'2018',
                    'jrn_def_name'=>'Vente',
                    'jrn_def_code'=>'V01',
                    'delta_letter'=>NULL,
                    'currency_rate' => '1.000000'
                    ,'currency_rate_ref' => '1.000000'
                    ,'currency_id' => '0'
                    ,'cr_code_iso' => 'EUR'
                    ,'j_montant' => '8.4000'
                    ,'oc_amount' => null
                    ,'oc_vat_amount' => null
                    ,'op_analytic' => '0'


                ),
                2=>
                array(
                    'j_id'=>'9',
                    'jr_id'=>'3',
                    'j_date_fmt'=>'24.02.2018',
                    'j_date'=>'2018-02-24',
                    'j_qcode'=>NULL,
                    'deb_montant'=>'0',
                    'cred_montant'=>'5.2900',
                    'description'=>'Vente de marchandises',
                    'jrn_name'=>'Vente',
                    'j_debit'=>'f',
                    'jr_internal'=>'V000003',
                    'jr_pj_number'=>'VEN3',
                    'letter'=>NULL,
                    'pcm_lib'=>'TVA à payer 21%',
                    'jr_optype'=>'NOR',
                    'jr_tech_per'=>'93',
                    'p_exercice'=>'2018',
                    'jrn_def_name'=>'Vente',
                    'jrn_def_code'=>'V01',
                    'delta_letter'=>NULL,
                     'currency_rate' => '1.000000'
                    ,'currency_rate_ref' => '1.000000'
                    ,'currency_id' => '0'
                    ,'cr_code_iso' => 'EUR'
                    ,'j_montant' => '5.2900'
                    ,'oc_amount' => null
                    ,'oc_vat_amount' => null
                    ,'op_analytic' => '0'

                ),
                3=>
                array(
                    'j_id'=>'13',
                    'jr_id'=>'4',
                    'j_date_fmt'=>'24.02.2018',
                    'j_date'=>'2018-02-24',
                    'j_qcode'=>NULL,
                    'deb_montant'=>'0',
                    'cred_montant'=>'35.7400',
                    'description'=>'Vente de marchandises',
                    'jrn_name'=>'Vente',
                    'j_debit'=>'f',
                    'jr_internal'=>'V000004',
                    'jr_pj_number'=>'VEN4',
                    'letter'=>NULL,
                    'pcm_lib'=>'TVA à payer 21%',
                    'jr_optype'=>'NOR',
                    'jr_tech_per'=>'93',
                    'p_exercice'=>'2018',
                    'jrn_def_name'=>'Vente',
                    'jrn_def_code'=>'V01',
                    'delta_letter'=>NULL,
                     'currency_rate' => '1.000000',
                    'currency_rate_ref' => '1.000000',
                     'currency_id' => '0',
                     'cr_code_iso' => 'EUR',
                     'j_montant' => '35.7400',
                     'oc_amount' => null,
                     'oc_vat_amount' => null
                     ,'op_analytic' => '0'

                ),
                4=>
                array(
                    'j_id'=>'17',
                    'jr_id'=>'5',
                    'j_date_fmt'=>'24.04.2018',
                    'j_date'=>'2018-04-24',
                    'j_qcode'=>NULL,
                    'deb_montant'=>'0',
                    'cred_montant'=>'35.7400',
                    'description'=>'Marchandise et Déplacement',
                    'jrn_name'=>'Vente',
                    'j_debit'=>'f',
                    'jr_internal'=>'V000005',
                    'jr_pj_number'=>'VEN5',
                    'letter'=>NULL,
                    'pcm_lib'=>'TVA à payer 21%',
                    'jr_optype'=>'NOR',
                    'jr_tech_per'=>'95',
                    'p_exercice'=>'2018',
                    'jrn_def_name'=>'Vente',
                    'jrn_def_code'=>'V01',
                    'delta_letter'=>NULL,
                    'currency_rate' => '1.000000',
                    'currency_rate_ref' => '1.000000',
                    'currency_id' => '0',
                    'cr_code_iso' => 'EUR',
                    'j_montant' => '35.7400',
                    'oc_amount' => null,
                    'oc_vat_amount' => null
                    ,'op_analytic' => '0'
                ),
                5=>
                array(
                    'j_id'=>'818',
                    'jr_id'=>'316',
                    'j_date_fmt'=>'12.09.2018',
                    'j_date'=>'2018-09-12',
                    'j_qcode'=>NULL,
                    'deb_montant'=>'0',
                    'cred_montant'=>'21.0000',
                    'description'=>'Vente en OD TVA à payer 21%',
                    'jrn_name'=>'Opération Diverses',
                    'j_debit'=>'f',
                    'jr_internal'=>'O000171',
                    'jr_pj_number'=>'ODS43',
                    'letter'=>NULL,
                    'pcm_lib'=>'TVA à payer 21%',
                    'jr_optype'=>'NOR',
                    'jr_tech_per'=>'100',
                    'p_exercice'=>'2018',
                    'jrn_def_name'=>'Opération Diverses',
                    'jrn_def_code'=>'O01',
                    'delta_letter'=>NULL,
                    'currency_rate' => '1.000000',
                    'currency_rate_ref' => '1.000000',
                    'currency_id' => '0',
                    'cr_code_iso' => 'EUR',
                    'j_montant' => '21.0000',
                    'oc_amount' => null,
                    'oc_vat_amount' => null
                    ,'op_analytic' => '0'

                ),
            ),
            1=>'0',
            2=>'114.5700',
        );
        $this->assertEquals($expected, $a_array); 
    }

   static function dataGet_Name()
    {
        return array(
            array('10', 'Capital '),
            array('01', 'Poste inconnu')
        );
    }

    /**
     * @covers Acc_Account_Ledger::get_name
     * @dataProvider dataGet_Name
     */
     #[DataProvider('dataGet_Name')]
    public function testGet_name($id, $result)
    {
        $this->object->id=$id;
        $this->assertEquals($this->object->get_name(), $result);
    }

    /**
     * @covers Acc_Account_Ledger::do_exist
     * @dataProvider dataDo_exist
     */
     #[DataProvider('dataDo_exist')]
    public function testDo_exist($p_value, $result)
    {
        $this->object->id=$p_value;
        $this->assertEquals($this->object->do_exist(), $result);
    }

    static function dataDo_exist()
    {
        return array(
            array('400', 1),
            array('400A', 0),
            array('550', 1),
            array('60BXX', 0)
        );
    }

    /**
     * @covers Acc_Account_Ledger::load
     */
    public function testLoad()
    {
        $this->object->load();
        $this->assertTrue($this->object->id==400, "test load");
    }

    /**
     * @covers Acc_Account_Ledger::get_solde
     */
    public function testGet_solde()
    {
       global $g_connection;
       $accounting=new Acc_Account_Ledger($g_connection, '4511');
       $this->assertEquals(356.85,$accounting->get_solde(),"get_solde");
    }

    /**
     * @covers Acc_Account_Ledger::get_solde_detail
     */
    public function testGet_solde_detail()
    {
        global $g_connection;
        $accounting=new Acc_Account_Ledger($g_connection, '4511');
        $expected=array (
                        'debit' => '0',
                        'credit' => '356.8500',
                        'solde' => 356.85,
                      );
        $this->assertEquals($accounting->get_solde_detail(),$expected);
    }

    /**
     * @covers Acc_Account_Ledger::isTVA
     */
    public function testIsTVA()
    {
        $this->object->id="4111";
        $this->assertEquals($this->object->isTVA(), 1);
        $this->object->id=10;
        $this->assertEquals($this->object->isTVA(), 0);
    }

    /**
     * @covers Acc_Account_Ledger::HtmlTable
     */
    public function testHtmlTable()
    {
        $this->assertTrue(true, 'Ne peut être testé car vue HTML');
    }

    public static function dataGet_amount_side()
    {
        return array(
            array(0, "="),
            array(1000, 'D'),
            array(-1000, 'C'),
        );
    }

    /**
     * @covers Acc_Account_Ledger::get_amount_side
     * @dataProvider dataGet_amount_side
     */
     #[DataProvider('dataGet_amount_side')]
    public function testGet_amount_side($amount, $result)
    {
        $this->assertEquals($this->object->get_amount_side($amount), $result);
    }



    /**
     * @covers Acc_Account_Ledger::belong_ledger
     * @dataProvider DataBelong_ledger
     */
     #[DataProvider('DataBelong_ledger')]
    public function testBelong_ledger($p_jrn, $result)
    {
        $this->assertEquals($this->object->belong_ledger($p_jrn), $result);
    }

    static function DataBelong_ledger()
    {
        return array(
            array(-1, 0),
            array(1, -1),
            array(3, 0),
            array(2, -1),
            array(4, 0)
        );
    }

    public static function dataGet_account_ledger()
    {
        return array(
            array(0, array()),
            array(1, array()),
            array(2, array()),
            array(3, array()),
            array(4, array('4*','2*'))
        );
    }

    /**
     * @covers Acc_Account_Ledger::get_account_ledger
     * @dataProvider dataGet_account_ledger
     */
     #[DataProvider('dataGet_account_ledger')]
    public function testGet_account_ledger($p_jrn, $result)
    {
        $this->assertEquals($this->object->get_account_ledger($p_jrn), $result);
    }

    /**
     * @covers Acc_Account_Ledger::build_sql_account
     * @dataProvider DataBuild_Sql_account
     */
     #[DataProvider('DataBuild_Sql_account')]
    public function testBuild_sql_account($p_jrn, $result)
    {
        $value=$this->object->build_sql_account($p_jrn);
        $this->assertEquals(trim($value), $result);
    }

    public static function DataBuild_Sql_account()
    {
        return array(
            array(0, ""),
            array(1, ""),
            array(2, ""),
            array(3, ""),
            array(4, "pcm_val::text like '4%' or pcm_val::text like '2%'")
        );
    }

    static function  dataFind_Card()
    {
        return array(
            array('6191', '27'),
            array('6192', '28'),
            array('4400004', '25')
        );
    }

    /**
     * @covers Acc_Account_Ledger::find_card
     * @todo   Implement testFind_card().
     * @dataProvider dataFind_Card()
     */
     #[DataProvider('dataFind_Card')]
    public function testFind_card($p_value, $p_card)
    {
        $this->object->id=$p_value;
        $result=$this->object->find_card();
        $this->assertEquals($p_card, $result[0]['f_id']);
    }
    public static function dataGet_used_accounting()
    {
        $array=array(
            ["01.01.2020","31.12.2020",5,7,4]
            ,["01.01.2019","31.12.2020",5,7,10]
            ,["01.01.2019","31.12.2020",5,6,3]
            ,["01.01.2019","31.12.2020",5,5,0]
            ,["01.01.2019","31.12.2020",5,2,0]
            ,["01.01.2019","31.12.2020",5,2,0]
            ,["01.01.2019","31.14.2020",5,7,0]
            ,["01.13.2019","31.14.2020",5,7,0]
        );
        return $array;
    }
    /**
     * @brief test function Acc_Account_Ledger::get_used_accounting
     * @covers Acc_Account_Ledger::get_used_accounting
     * @dataProvider dataGet_used_accounting
     */
     #[DataProvider('dataGet_used_accounting')]
    public function testGet_UsedAcccounting($from_date,$to_date,$from_accounting,$to_accounting,$nb_accounting)
    {
        $a_result=Acc_Account_Ledger::get_used_accounting(from_date:$from_date
            ,to_date:$to_date
            ,from_accounting:$from_accounting
            ,to_accounting:$to_accounting);

        $this->assertEquals($nb_accounting,count($a_result)
            ,"number of accounting incorrect for (\$from_date,\$to_date,\$from_accounting,\$to_accounting,\$nb_accounting : ($from_date,$to_date,$from_accounting,$to_accounting,$nb_accounting");

    }
        /**
     * @return array : idx [ $accounting,$from_date,$to_date,$nb_row,$tot_deb,$tot_cred]
     */
    public static function dataRowNotLettered()
    {
        $array=array(
        ['4400005','01.01.2019','31.12.2019',9,0,954.10]
        ,['4400005','01.03.2019','02.05.2019',3,0,246.61]
        );
        return $array;
    }
    /**
     * @brief test function Acc_Account_Ledger::get_row_date only unlettered
     * @covers Acc_Account_Ledger::get_row_date
     * @dataProvider dataRowNotLettered
     */
     #[DataProvider('dataRowNotLettered')]
    public function testGetRowDataNotLetted($accounting,$from_date,$to_date,$nb_row,$tot_deb,$tot_cred)
    {
        global $g_connection;
        $g_connection->clear_all_prepare();
        $acc_account_ledger=new Acc_Account_Ledger( $g_connection, $accounting);
        $acc_account_ledger->get_row_date(p_from:$from_date,p_to:$to_date,let:2);
        $nb_actual_row=count($acc_account_ledger->row);
        $this->assertEquals($nb_row,$nb_actual_row,"error received $nb_row rows");
        $this->assertEquals($tot_deb,$acc_account_ledger->tot_deb,"error amount incorrect received ".$acc_account_ledger->tot_deb);
        $this->assertEquals($tot_cred,$acc_account_ledger->tot_cred,"error amount incorrect received ".$acc_account_ledger->tot_cred);

    }
}
