<?php

/*
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * 
 * Author : Dany De Bontridder danydb@noalyss.eu
 * Copyright (C) 2025 Dany De Bontridder <dany@alchimerys.be>
 * 
 */

/**
 * @file
 * @brief noalyss
 */
use PHPUnit\Framework\TestCase;


/**
 * @testdox Class InvoiceUBL21 : used for managing invoice format UBL21
 * @backupGlobals false
 * @coversDefaultClass InvoiceUBL21Test
 */
class FacturXTest extends TestCase {

    /**
     * @var Fiche
     */
    protected $object;
    protected $connection;

     /**
     * @testdox thx jr_id makes an $array
     * @covers \Noalyss\Invoice\XMLDocument\InvoiceUBL21::build_data
     */
    function testBuild_Data() {
       $cn=\Dossier::connect();
       $facturx=new \Noalyss\XMLDocument\FacturX($cn);
    }


    /**
     * @testdox Make an XML UBL21
     */
    function testDOMMake_XML()
    {

        $cn = \Dossier::connect();
        // clean data
        $cn->exec_sql('update jrn set jr_pj_name=null,jr_pj_type=null, jr_pj = null where jr_id=$1', [2]);

        /**
         * create PDF Invoice
         */
        $sold = new \Acc_Sold($cn, 2);
        $sold->get();
        $array = \Acc_Ledger_Sale::convert_to_array($sold);
        $array['gen_doc'] = -2; //<- Standard invoice
        $acc_document = new \Acc_Document($cn, 2);
        $acc_document->create_document($sold->det->jr_internal, $array);
        // verification du PDF dans DB
        $row = $cn->get_row("select jr_pj_name,jr_pj, jr_pj_type
                        from jrn 
                        where jr_id=$1
                    ", [2]);

        $this->assertTrue("inv-std-VEN2.pdf" == $row['jr_pj_name'], "Incorrect invoice name [{$row['jr_pj_name']}]");
        $this->assertTrue("application/pdf" == $row['jr_pj_type'], "Incorrect invoice type");
        $this->assertTrue($row['jr_pj'] != "", "OID not created");

        /**
         * create invoice PDF
         */
        $sold=new \Acc_Sold($cn,2);
        $sold->get();
        $array= \Acc_Ledger_Sale::convert_to_array($sold);
        $array['gen_doc']=-2; //<- Standard invoice
        $acc_document=new \Acc_Document($cn,2);
        $acc_document->create_document($sold->det->jr_internal, $array);
    // verification du PDF dans DB
        $row=$cn->get_row("select jr_pj_name,jr_pj, jr_pj_type
                    from jrn 
                    where jr_id=$1
                ",[2]);

        $this->assertTrue("inv-std-VEN2.pdf"==$row['jr_pj_name'],"Incorrect invoice name [{$row['jr_pj_name']}]");
        $this->assertTrue("application/pdf"==$row['jr_pj_type'],"Incorrect invoice type");
        $this->assertTrue($row['jr_pj'] != "","OID not created");
        // get the file 
        $cn->start();
        $pdf_filename= tempnam("/tmp", "phpunit");
        \Noalyss\Facility::save_file ('/tmp', __FUNCTION__.".txt", $pdf_filename);
        $acc_document->export_file($pdf_filename);
        $cn->commit();
        // make the facturX invoice
        $facturx = new \Noalyss\XMLDocument\FacturX($cn);
        $facturx->set_pdf_filename($pdf_filename);
        
        $xml = $facturx->create_invoice(2);
        $oid=$cn->lo_write($xml);
        $this->assertTrue($oid != false , "cannot save XML in DB");
        $acc_document->replace_receipt($oid);
        $file= \Noalyss\Facility::save_file('/tmp', 'facturX', $xml);
        
    }

    /**
     * @brief to verify : MY_COUNTRY_CODE, SIREN, SIRET
     * 
     */
    function testCompany_Data()
    {
       $cn=\Dossier::connect();
       $facturx=new \Noalyss\XMLDocument\FacturX($cn);
       $a_error=$facturx->check_company_data();
       $this->assertTrue(count($a_error)==8, "nb of error incorrect ".print_r($a_error,true));
    }

       function testCustomer_Data()
    {
       $cn=\Dossier::connect();
       $facturx=new \Noalyss\XMLDocument\FacturX($cn);
       $facturx->build_data(2);
       $customer=$facturx->get_data()['customer'];
       $a_error = $facturx->check_customer_data($customer['card_id']);
       print_r($a_error);
       $this->assertTrue(count($a_error)==6, "nb of error incorrect ,expected 6, received = ".print_r($a_error,true));
    }
}
