begin;

-- protect against wrong card in fiche_detail

CREATE OR REPLACE FUNCTION comptaproc.fiche_detail_check_qcode()
    RETURNS trigger
    LANGUAGE plpgsql
AS $function$
declare
    i record;
begin
    if NEW.ad_id=23 and NEW.ad_value != OLD.ad_value then
        update jrnx set j_qcode=NEW.ad_value where j_qcode = OLD.ad_value;
        update op_predef_detail set opd_poste=NEW.ad_value where opd_poste=OLD.ad_value;
        for i in select ad_id from attr_def where ad_type = 'card' or ad_id=25 loop
                update fiche_detail set ad_value=NEW.ad_value where ad_value=OLD.ad_value and ad_id=i.ad_id;
                if i.ad_id=19 then
                    update stock_goods set sg_code=NEW.ad_value where sg_code=OLD.ad_value;
                end if;

            end loop;
    end if;
    return NEW;
end;
$function$;

drop trigger if exists fiche_detail_check_qcode_trg on public.fiche_detail ;
drop function   if exists  comptaproc.fiche_detail_qcode_upd() cascade;

create trigger fiche_detail_check_qcode_trg before insert
    or update on
    public.fiche_detail for each row execute function comptaproc.fiche_detail_check_qcode();



update fiche_detail set ad_value=ad_value where ad_id in (select ad_id from attr_def where ad_type='card');

insert into parameter values ('MY_REPORT','Y') ON CONFLICT DO NOTHING;

update menu_ref set me_file='payment_method.inc.php' where me_code='CFGPAY';

update menu_ref set me_menu='Principal' where me_code='COMPANY';
update menu_ref set me_menu='Financier' where me_code='MENUFIN';

CREATE OR REPLACE FUNCTION comptaproc.set_tech_user()
    RETURNS trigger
AS $function$
declare
    /* variable */
    noalyss_user text;
begin
    new.tech_user := current_setting('noalyss.user_login');
    new.tech_date := now();
    return NEW;

exception when others then
    new.tech_date := now();
    new.tech_user := current_user;
    return NEW;
end ;
$function$
    LANGUAGE plpgsql;

drop table if exists operation_exercice_detail;
drop table if exists operation_exercice;

create table operation_exercice
(
    oe_id   bigint generated by default as identity  primary key,
    oe_date date null,
    oe_type text not null check  (oe_type = 'opening' or oe_type = 'closing'),
    oe_text text ,
    oe_dossier_id int not null,
    oe_exercice int not null,
    jr_internal text,
    oe_transfer_date timestamp,
    tech_user text,
    tech_date timestamp default  now()
);

create table operation_exercice_detail
(
    oed_id  bigint generated by default as identity  primary key,
    oe_id bigint references operation_exercice (oe_id) on update cascade on delete cascade not null,
    oed_poste account_type ,
    oed_qcode text ,
    oed_label text,
    oed_amount numeric (20,4),
    oed_debit bool
);

create trigger trg_set_tech_user  before insert or update on operation_exercice  for each row execute function comptaproc.set_tech_user();

update menu_ref set me_code='OPCL' , me_menu='Ouvert./Fermeture',me_file='operation_exercice.inc.php',me_description='Opération de cloture ou d''ouverture d''exercice'
                  ,me_description_etendue ='Ecriture d''ouverture ou de fermeture , , reporte les soldes des comptes de l''année passé du poste comptable 0xxx à 5xxxx sur l''année courante ou ferme les comptes de 6 à 7 de l''année '
where me_code='OPEN';

insert into version (val,v_description) values (191,'cloture-ouverture exercice-version 9112');
commit;