<?php
 #[AllowDynamicProperties] abstract class Table_Data_SQL extends Data_SQL { function __construct($p_cn, $p_id=-1) { parent::__construct($p_cn, $p_id); } public function __toString(): string { $ret=" members : "; foreach ($this->name as $name) { $ret.="[ $name => {$this->$name} ]"; } $ret.="| type ".var_export($this->type,true); $ret.="| default ".var_export($this->default,true); $ret.="| primary key ".$this->primary_key; $ret.="| date_format ".$this->date_format; $ret.="| a_virtual_col".var_export($this->a_virtual_col,true); return $ret; } public function insert() { $this->verify(); $sql="insert into ".$this->table." ( "; $sep=""; $par=""; $idx=1; $array=array(); foreach ($this->name as $key=> $value) { if (isset($this->default[$value])&&$this->default[$value]=="auto"&&$this->$value==null) continue; if ($value==$this->primary_key && $this->$value==-1 && isset($this->default[$value]) ) continue; $sql.=$sep.$value; switch ($this->type[$value]) { case "date": if ($this->date_format=="") throw new Exception('Format Date invalide'); $par .=$sep.'to_timestamp($'.$idx.",'".$this->date_format."')"; break; default: $par .= $sep."$".$idx; } $array[]=$this->$value; $sep=","; $idx++; } $sql.=") values (".$par.") returning ".$this->primary_key; $pk=$this->primary_key; $returning=$this->cn->get_value($sql, $array); $this->$pk=$returning; } public function delete() { $pk=$this->primary_key; $sql=" delete from ".$this->table." where ".$this->primary_key."= $1"; $this->cn->exec_sql($sql,array($this->$pk)); } function column_update($column_expr,$value) { $pk=$this->primary_key; $sql="update ".$this->table." set {$column_expr} where {$this->primary_key} = $2"; $this->cn->exec_sql($sql,[$value,$this->$pk]); return $this; } public function update() { $this->verify(); $pk=$this->primary_key; $sql="update ".$this->table."  "; $sep=""; $idx=1; $array=array(); $set=" set "; foreach ($this->name as $key=> $value) { if (isset($this->default[$value])&&$this->default[$value]=="auto") continue; switch ($this->type[$value]) { case "date": $par=$value.'=to_timestamp($'.$idx.",'".$this->date_format."')"; break; default: $par=$value."= $".$idx; } $sql.=$sep." $set ".$par; $array[]=$this->$value; $sep=","; $set=""; $idx++; } $array[]=$this->$pk; $sql.=" where ".$this->primary_key." = $".$idx; $this->cn->exec_sql($sql, $array); } public function load():bool { $pk=$this->primary_key; if (trim($this->$pk??"")==="" || $this->$pk===null) { $this->$pk=-1; return false; } $sql=$this->build_query(); $sql.=" where ".$this->primary_key." = $1"; $result=$this->cn->get_row($sql,array ($this->$pk)); if ($this->cn->count()==0) { $this->$pk=-1; return false; } foreach ($result as $key=> $value) { $this->$key=$value; } return true; } function seek($cond='', $p_array=null) { $sql=$this->build_query(); $sql.="  $cond "; $ret=$this->cn->exec_sql($sql, $p_array); return $ret; } public function count($p_where="",$p_array=null) { $count=$this->cn->get_value("select count(*) from $this->table ".$p_where,$p_array); return $count; } public function exist() { $pk=$this->primary_key; $count=$this->cn->get_value("select count(*) from ".$this->table." where ".$this->primary_key."=$1",array($this->$pk)); return $count; } public function build_query() { $sql=" select "; $sep=""; foreach ($this->name as $key) { switch ($this->type[$key]) { case "date": $sql .= $sep.'to_char('.$key.",'".$this->date_format."') as ".$key; break; default: $sql.=$sep.$key; } $sep=","; } $pk=$this->primary_key; if ( ! empty( $this->a_virtual_col)){ $nb_virtual_col=count($this->a_virtual_col); $a_col= array_keys($this->a_virtual_col); for ($x=0;$x<$nb_virtual_col ;$x++) { $col=$a_col[$x]; $expr=sprintf("$sep %s as %s ",$this->a_virtual_col[$col], $col); $sql.=" $expr "; } } $sql.=" from ".$this->table; return $sql; } public function get_all_to_array($p_key_col,$p_cond="",$p_array=NULL) { $ret=$this->seek($p_cond, $p_array); if ($ret==FALSE) return array(); $a_array=Database::fetch_all($ret); $nb_array=count($a_array); $a_result=array(); try { for ($i=0; $i<$nb_array; $i++) { if (!isset($a_array[$i][$p_key_col])) { throw new Exception("col not found ".$p_key_col); } $key=$a_array[$i][$p_key_col]; if ( isset ($a_result[$key]) ){ throw new Exception ("duplicate found col : $key"); } $a_result[$key]=$a_array[$i]; } } catch (Exception $exc) { record_log($exc); throw $exc; } return $a_result; } } ?>
