<?php
 require_once NOALYSS_INCLUDE . '/constant.php'; require_once NOALYSS_INCLUDE . '/lib/ac_common.php'; class DatabaseCore { protected $db; protected $ret; protected $is_open; public $sql; public $array; protected $dbname; protected $dbport; protected $dbhost; protected $dbuser; function __construct($p_user, $p_password, $p_dbname, $p_host, $p_port) { $this->db = @pg_connect("dbname=$p_dbname host='$p_host' user='$p_user'
                     password='$p_password' port=$p_port"); if ($this->db == false) { if ( DEBUGNOALYSS > 0 ) { echo '<h2 class="error">'._('Impossible de se connecter à postgreSql').'</h2>'; echo '<p>'; echo _("Vos paramètres sont incorrectes").": <br>"; echo "<br>"; printf (_("base de donnée  = %s"), $p_dbname)."<br>"; printf (_("Port %s"),$p_port )."<br>"; printf ( _("Utilisateur : %s"),$p_user )."<br>"; echo '</p>'; die(); } else { echo '<h2 class="error">' . _('Erreur de connexion !') . '</h2>'; $this->is_open = false; throw new Exception(_('Erreur Connexion')); } } $this->dbport=$p_port; $this->dbname=$p_dbname; $this->dbhost=$p_host; $this->dbuser=$p_user; $this->is_open = TRUE; $this->sql=""; } public function get_dbname() { return $this->dbname; } public function get_dbport() { return $this->dbport; } public function get_dbhost() { return $this->dbhost; } public function get_dbuser() { return $this->dbuser; } public function get_name () { return pg_dbname($this->db); } public function verify() { } function set_encoding($p_charset) { pg_set_client_encoding($this->db, $p_charset); } function get_encoding() { return pg_client_encoding($this->db); } public function get_db() { return $this->db; } public function set_db($db) { $this->db = $db; } public function get_ret() { return $this->ret; } public function set_ret($ret) { $this->ret = $ret; } public function get_is_open() { return $this->is_open; } public function set_is_open($is_open) { $this->is_open = $is_open; } public function get_sql() { return $this->sql; } public function set_sql($sql) { $this->sql=$sql; return $this; } function exec_sql($p_string, $p_array = null) { try { if (!$this->is_open) throw new Exception(' Database is closed'); $this->sql = $p_string; $this->array = $p_array; if ($p_array == null) { if ( DEBUGNOALYSS == 0 ) $this->ret = pg_query($this->db, $p_string); else $this->ret = @pg_query($this->db, $p_string); } else { $a = is_array($p_array); if (!is_array($p_array)) { throw new Exception(_("Erreur : exec_sql attend un array")); } if ( DEBUGNOALYSS == 0 ) $this->ret =@pg_query_params($this->db, $p_string, $p_array); else $this->ret = pg_query_params($this->db, $p_string, $p_array); } if ($this->ret == false) { $str_error = pg_last_error($this->db) ; throw new Exception("  SQL ERROR $p_string " . $str_error, 1); } } catch (Exception $a) { if ( DEBUGNOALYSS > 0 ) { print_r($p_string); print_r($p_array); echo $a->getMessage(); echo $a->getTraceAsString(); echo pg_last_error($this->db); } record_log($a); record_log($p_string); record_log($p_array); $this->rollback(); throw new \Exception("exec_sql fails",242,$a); } return $this->ret; } function count_sql($p_sql, $p_array = null) { $r_sql = $this->exec_sql($p_sql, $p_array); return pg_num_rows($r_sql); } function get_current_seq($p_seq) { $Res = $this->get_value("select currval('$p_seq') as seq"); return $Res; } function get_next_seq($p_seq) { $Res = $this->exec_sql("select nextval('$p_seq') as seq"); $seq = pg_fetch_array($Res, 0); return $seq['seq']; } function start() { $Res = $this->exec_sql("start transaction"); } function commit() { if (!$this->is_open) return; $Res = $this->exec_sql("commit"); } function rollback() { if (!$this->is_open) return; $Res = $this->exec_sql("rollback"); } function alter_seq($p_name, $min) { if ($min < 1) $min = 1; $Res = $this->exec_sql("alter sequence $p_name restart $min"); } function execute_script($script) { if ( DEBUGNOALYSS == 0 ) { ob_start(); } else { $debug = fopen("/tmp/debug_execute_script".uniqid().".log", "w+"); } $hf = fopen($script, 'r'); if ($hf == false) { throw new Exception ('Ne peut ouvrir ' . $script); } printf (" open %s <br>", $script); $sql = ""; $flag_function = false; while (!feof($hf)) { $buffer = fgets($hf); $buffer = str_replace('$BODY$', '$_$', $buffer); print $buffer . "<br>"; if (substr($buffer, 0, 2) == "--") { continue; } If (Strlen($buffer) == 0) { Continue; } if (strpos(strtolower($buffer), "create function") === 0) { echo "found a function"; $flag_function = true; $sql = $buffer; continue; } if (strpos(strtolower($buffer), "create or replace function") === 0) { echo "found a function"; $flag_function = true; $sql = $buffer; continue; } if ($flag_function == false && strpos($buffer, ';') == false) { $sql .= $buffer; continue; } if ($flag_function) { if (strpos(strtolower($buffer), "$$;") === false && strpos(strtolower($buffer), '$_$;') === false && strpos(strtolower($buffer), '$function$;') === false && strpos(strtolower($buffer), 'language plpgsql;') === false && strpos(strtolower($buffer), 'language plpgsql ;') === false ) { $sql .= $buffer; continue; } } else { $buffer = str_replace(';', '', $buffer); } $sql .= $buffer; if ( DEBUGNOALYSS > 0 ) fwrite($debug, $sql); if ($this->exec_sql($sql) == false) { $this->rollback(); if ( DEBUGNOALYSS == 0 ) ob_end_clean(); print "ERROR : $sql"; throw new Exception("ERROR : $sql"); } $sql = ""; $flag_function = false; print "<hr>"; } fclose($hf); if ( DEBUGNOALYSS == 0 ) ob_end_clean(); } function fetch($p_indice,$p_mode= PGSQL_ASSOC) { if ($this->ret == false) throw new Exception('this->ret is empty'); return pg_fetch_array($this->ret, $p_indice,$p_mode); } function size($p_ret = null) { if ($p_ret == null) return pg_num_rows($this->ret); else return pg_num_rows($p_ret); } function count($p_ret = null) { return $this->size($p_ret); } function get_value($p_sql, $p_array = null) { try { $this->ret = $this->exec_sql($p_sql, $p_array); $r = pg_num_rows($this->ret); if ($r == 0) return ""; if ($r > 1) { $array = pg_fetch_all($this->ret); throw new Exception("Attention $p_sql retourne " . pg_num_rows($this->ret) . "  valeurs " . var_export($p_array, true) . " values=" . var_export($array, true)); } $r = pg_fetch_row($this->ret, 0); return $r[0]; } catch (Exception $ex) { throw($ex); } } function get_affected() { return Database::num_row($this->ret); } function get_array($p_sql, $p_array = null,$p_mode=PGSQL_ASSOC) { $r = $this->exec_sql($p_sql, $p_array,$p_mode); if (pg_num_rows($r) == 0) return array(); $array = pg_fetch_all($r,$p_mode); return $array; } function get_row($p_sql, $p_array = NULL) { $array = $this->get_array($p_sql, $p_array); if (empty($array)) return null; if (count($array) == 1) return $array[0]; throw new Exception(_("Database:get_row retourne trop de lignes"), 100); } function create_sequence($p_name, $min = 1) { if ($min < 1) $min = 1; $sql = "create sequence " . $p_name . " minvalue $min"; $this->exec_sql($sql); } function exist_sequence($p_name) { $r = $this->count_sql("select relname from pg_class where relname=lower($1)", array($p_name)); if ($r == 0) return false; return true; } function exist_table($p_name, $p_schema = 'public') { $r = $this->count_sql("select table_name from information_schema.tables where table_schema=$1 and table_name=lower($2)", array($p_schema, $p_name)); if ($r == 0) return false; return true; } function exist_column($col, $table, $schema) { $r = $this->get_value('select count(*) from information_schema.columns where table_name=lower($1) and column_name=lower($2) and table_schema=lower($3)', array($col, $table, $schema)); if ($r > 0) return true; return false; } function exist_database($p_name) { $database_exist = $this->get_value('select count(*)
                from pg_catalog.pg_database where datname = lower($1)', array($p_name)); return $database_exist; } function exist_blob($p_oid) { $r = $this->get_value('select count(*) from pg_largeobject_metadata where oid=$1' , array($p_oid)); if ($r > 0) return true; else return false; } function exist_view($p_name) { $r = $this->count_sql("select viewname from pg_views where viewname=lower($1)", array($p_name)); if ($r == 0) return false; return true; } function exist_schema($p_name) { $r = $this->count_sql("select nspname from pg_namespace where nspname=lower($1)", array($p_name)); if ($r == 0) return false; return true; } function make_list($sql, $p_array = null) { if ($p_array == null) { $aArray = $this->get_array($sql); } else { $aArray = $this->get_array($sql, $p_array); } if (empty($aArray)) return ""; $aIdx = array_keys($aArray[0]); $idx = $aIdx[0]; $ret = ""; $f = ""; for ($i = 0; $i < count($aArray); $i++) { $row = $aArray[$i]; $ret .= $f . $aArray[$i][$idx]; $f = ','; } $ret = trim($ret, ','); return $ret; } function make_array($p_sql, $p_null = 0, $p_array = null) { $a = $this->exec_sql($p_sql, $p_array); $max = pg_num_rows($a); if ($max == 0 && $p_null == 0) return null; for ($i = 0; $i < $max; $i++) { $row = pg_fetch_row($a); $r[$i]['value'] = $row[0]; $r[$i]['label'] = h($row[1]); } if ($p_null == 1) { for ($i = $max; $i != 0; $i--) { $r[$i]['value'] = $r[$i - 1]['value']; $r[$i]['label'] = $r[$i - 1]['label']; } $r[0]['value'] = -1; $r[0]['label'] = " "; } return $r; } function upload($p_name,$only_oid = false) { $a=0; if ( $this->status() !== PGSQL_TRANSACTION_INTRANS ) { $a=1; $this->start(); } if ($_FILES[$p_name]["error"] == UPLOAD_ERR_NO_FILE) { \record_log("DC759: error upload file".var_export($_FILES, true)); if ( $a==1) { $this->rollback(); } return false; } $new_name = tempnam($_ENV['TMP'], $p_name); if ($_FILES[$p_name]["error"] > 0) { \record_log("DC740: error upload file".var_export($_FILES, true)); if ( $a==1) { $this->rollback(); } return false; } if (strlen($_FILES[$p_name]['tmp_name']) != 0) { if (move_uploaded_file($_FILES[$p_name]['tmp_name'], $new_name)) { $oid = pg_lo_import($this->db, $new_name); if ($oid == false) { \record_log("DC747: error upload file".var_export($_FILES, true). "SQL MESSAGE". pg_last_error($this->db)); $this->rollback(); return false; } if ( $a == 1 ) { $this->commit(); } if ($only_oid ){ return $oid; }else { return ["oid"=>$oid,'filename'=>$new_name]; } } else { \record_log("DC754: move_uploaded fails".var_export($_FILES, true)); $this->rollback(); return false; } } \record_log("DC576: Files error names empty".var_export($_FILES, true)); if ( $a == 1) { $this->commit(); } return false; } function lo_write($binary_data) { $a=0; if ( $this->status() !== PGSQL_TRANSACTION_INTRANS ) { $a=1; $this->start(); } $oid= pg_lo_create($this->db); if ( ($handle=pg_lo_open($this->db,$oid,"w")) == false ) { return false ;} pg_lo_write($handle, $binary_data); pg_lo_close($handle); if ( $a==1) { $this->commit(); } return $oid; } function lo_read($oid) { $a=0; if ( $this->status() !== PGSQL_TRANSACTION_INTRANS ) { $a=1; $this->start(); } $handle=pg_lo_open($this->db,$oid,"r"); if ( $handle == false ) { return false ;} pg_lo_seek($handle, 0, PGSQL_SEEK_END); $size= pg_lo_tell($handle); pg_lo_seek($handle, 0, PGSQL_SEEK_SET); $binary_data = pg_lo_read($handle,$size ); pg_lo_close($handle); if ( $a==1) { $this->commit(); } return $binary_data; } function lo_replace($binary_data, $oid) { $a = 0; if ($this->status() !== PGSQL_TRANSACTION_INTRANS) { $a = 1; $this->start(); } $handle = pg_lo_open($this->db, $oid, "w"); if ( $handle == false ) { return false ;} pg_lo_truncate($handle, 0); pg_lo_write($handle, $binary_data); pg_lo_close($handle); if ($a == 1) { $this->commit(); } return $oid; } static function num_row($ret) { return pg_num_rows($ret); } static function fetch_array($ret, $p_indice = 0,$p_mode=PGSQL_ASSOC) { return pg_fetch_array($ret, $p_indice,$p_mode); } static function fetch_all($ret,$p_mode= PGSQL_ASSOC) { return pg_fetch_all($ret,$p_mode); } static function fetch_result($ret, $p_row = 0, $p_col = 0) { return pg_fetch_result($ret, $p_row, $p_col); } static function fetch_row($ret, $p_row) { return pg_fetch_row($ret, $p_row); } function lo_unlink($p_oid) { if (!$this->exist_blob($p_oid)) return; return pg_lo_unlink($this->db, $p_oid); } function prepare($p_string, $p_sql) { return pg_prepare($this->db, $p_string, $p_sql); } function execute($p_string, $p_array) { $this->ret = pg_execute($this->db, $p_string, $p_array); return $this->ret; } function lo_export($p_oid, $tmp_file) { return pg_lo_export($this->db, $p_oid, $tmp_file); } function lo_import($p_filename) { return pg_lo_import($this->db, $p_filename); } static function escape_string($p_string) { static $cn=null; if ( $cn==null) $cn=new Database(); return pg_escape_string($cn->db,$p_string); } function close() { if ($this->is_open) pg_close($this->db); $this->is_open = FALSE; } function __toString() { return "database "; } static function test_me() { } function status() { return pg_transaction_status($this->db); } function clean_orphan_lob() { $sql = " 
                select table_schema,table_name,column_name 
                from 
                    information_schema.columns 
                where table_schema not in ('information_schema','pg_catalog') 
                and data_type='oid'"; $all_lob = "
            select oid,'N' as used from pg_largeobject_metadata
            "; $a_table = $this->get_array($sql); $a_lob = $this->get_array($all_lob); if ($a_table == false || $a_lob == false) return; $nb_lob = count($a_lob); $nb_table = count($a_table); for ($i = 0; $i < $nb_lob; $i++) { $lob = $a_lob[$i]['oid']; if ($a_lob[$i]['used'] == 'Y') continue; for ($j = 0; $j < $nb_table; $j++) { if ($a_lob[$i]['used'] == 'Y') continue; $check = $this->get_value(" select count(*) from " . $a_table[$j]['table_schema'] . "." . $a_table[$j]['table_name'] . " where " . $a_table[$j]['column_name'] . "=$1", array($lob)); if ($check != 0) $a_lob[$i]['used'] = 'Y'; } } for ($i = 0; $i < $nb_lob; $i++) { if ($a_lob[$i]['used'] == 'Y') continue; $this->lo_unlink($a_lob[$i]['oid']); } } function is_prepare($query_name) { $nb_prepared = $this->get_value("select count(*) from pg_prepared_statements where name=$1", [$query_name]); if ($nb_prepared == 0) return FALSE; return TRUE; } function query_to_csv($ret, $aheader) { $csv = new Noalyss_Csv("db-query"); $a_header = []; for ($i = 0; $i < count($aheader); $i++) { $a_header[] = $aheader[$i]['title']; } $csv->write_header($a_header); $nb = Database::num_row($ret); for ($i = 0; $i < $nb; $i++) { $row = Database::fetch_array($ret, $i); $e=0; foreach ($row as $row_item){ if ( $e >= count($a_header)) break; switch ($aheader[$e]['type']) { case 'num': $csv->add($row_item, "number"); break; default: $csv->add($row_item); } $e++; } $csv->write(); } } static function nb_column($p_ret) { return pg_num_fields($p_ret); } function search_sql_inject($p_sql) { $forbid_sql=array("update","delete","truncate","insert"); foreach ($forbid_sql as $forbid_key) { if (stripos($p_sql,$forbid_key) !== false) { throw new Exception(_("Possible SQL inject"),EXC_INVALID); } } } function clear_prepare($sql_name) { pg_exec($this->db,sprintf('DEALLOCATE "%s"'),DatabaseCore::escape_string($sql_name)); } function clear_all_prepare() { pg_exec($this->db,'DEALLOCATE ALL'); } } 