<?php
 class Tax_Summary { private $date_start; private $date_end; private $db; private $tva_type; function __construct(Database $db, $p_start, $p_end) { $this->db=$db; $this->set_date_start($p_start); $this->set_date_end($p_end); $this->set_tva_type("T"); } public function get_tva_type() { return $this->tva_type; } public function set_tva_type($tva_type) { $this->tva_type=$tva_type; return $this; } public function get_db() { return $this->db; } public function set_db($db) { $this->db=$db; return $this; } public function get_date_start() { return $this->date_start; } public function set_date_start($date_start) { if (isDate($date_start)==NULL) throw new Exception(_("Format date invalide").$date_start); $this->date_start=$date_start; return $this; } public function get_date_end() { return $this->date_end; } public function set_date_end($date_end) { if (isDate($date_end)==NULL) throw new Exception(_("Format date invalide").$date_end); $this->date_end=$date_end; return $this; } function check() { $sql="select count(*) 
             from 
                quant_sold
             where  
		    j_id  in (select j_id from jrnx 
			where 
	                   jrnx.j_jrn_def in (select jrn_def_id from jrn_def where jrn_def_type = 'VEN')
        	            and j_date >= to_date($1,'DD.MM.YYYY') 
                	    and j_date <= to_date($2,'DD.MM.YYYY') 
			)
                  "; $cnt=$this->db->get_value($sql, [$this->date_start, $this->date_end]); $cnt_ledger=$this->db->get_value("
            select count(*) from jrnx 
			    where 
	                   jrnx.j_jrn_def in (select jrn_def_id from jrn_def where jrn_def_type = 'VEN')
        	            and j_date >= to_date($1,'DD.MM.YYYY') 
                	    and j_date <= to_date($2,'DD.MM.YYYY') 
        ", [$this->date_start, $this->date_end]); if ($cnt==0 && $cnt_ledger !=0) { throw new Exception('TX148:'._("Données manquantes"),100); } $sql="select count(*) 
             from 
                quant_purchase
             where  
		    j_id  in (select j_id from jrnx 
			where 
	                   jrnx.j_jrn_def in (select jrn_def_id from jrn_def where jrn_def_type = 'ACH')
        	            and j_date >= to_date($1,'DD.MM.YYYY') 
                	    and j_date <= to_date($2,'DD.MM.YYYY') 
			)
                             "; $cnt=$this->db->get_value($sql, [$this->date_start, $this->date_end]); $cnt_ledger=$this->db->get_value("
            select count(*) from jrnx 
			    where 
	                   jrnx.j_jrn_def in (select jrn_def_id from jrn_def where jrn_def_type = 'ACH')
        	            and j_date >= to_date($1,'DD.MM.YYYY') 
                	    and j_date <= to_date($2,'DD.MM.YYYY') 
        ", [$this->date_start, $this->date_end]); if ($cnt ==0 && $cnt_ledger !=0) { throw new Exception('TX175'._("Données manquantes"),100); } } private function build_exigibility() { global $g_user; $sql_ledger=$g_user->get_ledger_sql('ALL', 3); } private function build_sql_purchase($p_group_ledger) { global $g_user; $sql_ledger=$g_user->get_ledger_sql('ACH', 3); $group_ledger=""; if ( $p_group_ledger ) { $group_ledger='j_jrn_def,'; } $sql="with detail_tva as (
                select 
                    sum(qp_vat) as amount_vat,
                    sum(qp_vat_sided) as amount_sided,
                    sum(qp_price) as amount_wovat,
                    sum(qp_nd_amount) as amount_noded_amount,
                    sum(qp_nd_tva) as amount_noded_tax,
                    sum(qp_nd_tva_recup) as amount_noded_return,
                    sum(qp_dep_priv) as amount_private,
                    {$group_ledger}
                    qp_vat_code
                from 
                    quant_purchase 
                    join tva_rate on (qp_vat_code=tva_rate.tva_id) 
                    join jrnx on (quant_purchase.j_id=jrnx.j_id)
                    join jrn_def on (jrn_def.jrn_def_id=jrnx.j_jrn_def)
                    join jrn on (jrn.jr_grpt_id=jrnx.j_grpt)
                "; if ( $this->tva_type=="O") { $sql=$sql."
                where 
                    j_date >= to_date($1,'DD.MM.YYYY') 
                    and j_date <= to_date($2,'DD.MM.YYYY') 
                    and {$sql_ledger}
                group by {$group_ledger} qp_vat_code)  "; } elseif ($this->tva_type=="P") { $sql=$sql." 
                where
                    coalesce(to_char(jr_date_paid,'YYYYMMDD'),'00000000') >= 
                                    to_char(to_date($1,'DD.MM.YYYY'),'YYYYMMDD') 
                    and coalesce(to_char(jr_date_paid,'YYYYMMDD'),'99999999') <= 
                                    to_char(to_date($2,'DD.MM.YYYY'),'YYYYMMDD') 
                    and {$sql_ledger}
                group by {$group_ledger} qp_vat_code)  "; }elseif ($this->tva_type=="T") { $sql=$sql."  where
                        (   tva_rate.tva_payment_purchase='P'
                            and coalesce(to_char(jr_date_paid,'YYYYMMDD'),'00000000') >= 
                                        to_char(to_date($1,'DD.MM.YYYY'),'YYYYMMDD') 
                            and coalesce(to_char(jr_date_paid,'YYYYMMDD'),'99999999') <= 
                                         to_char(to_date($2,'DD.MM.YYYY'),'YYYYMMDD') 
                            )
                         or
                        (   tva_rate.tva_payment_purchase='O'
                            and coalesce(to_char(jr_date,'YYYYMMDD'),'00000000') >= 
                                         to_char(to_date($1,'DD.MM.YYYY'),'YYYYMMDD') 
                            and coalesce(to_char(jr_date,'YYYYMMDD'),'99999999') <= 
                                         to_char(to_date($2,'DD.MM.YYYY'),'YYYYMMDD') 
                            )
                        and {$sql_ledger}
                    group by {$group_ledger} qp_vat_code) "; } else { throw new Exception(_("Exig TVA invalide"),1001); } return $sql; } private function build_sql_sale($p_group_ledger=TRUE) { global $g_user; $sql_ledger=$g_user->get_ledger_sql('VEN', 3); $group_ledger=""; if ( $p_group_ledger ) { $group_ledger='j_jrn_def,'; } $sql="with detail_tva as (
                    select 
                        sum(qs_vat) as amount_vat,
                        sum(qs_vat_sided) as amount_sided,
                        sum(qs_price) as amount_wovat,
                        {$group_ledger}
                        qs_vat_code
                    from 
                        quant_sold 
                        join tva_rate on (qs_vat_code=tva_rate.tva_id) 
                        join jrnx on (quant_sold.j_id=jrnx.j_id)
                        join jrn_def on (jrn_def.jrn_def_id=jrnx.j_jrn_def)
                        join jrn on (jrn.jr_grpt_id=jrnx.j_grpt)"; if ( $this->tva_type=="O") { $sql=$sql." 
                    where 
                        j_date >= to_date($1,'DD.MM.YYYY') 
                        and j_date <= to_date($2,'DD.MM.YYYY') 
                        and {$sql_ledger}
                    group by {$group_ledger} qs_vat_code)  "; } elseif ($this->tva_type=="P") { $sql=$sql." 
                    where
                        coalesce(to_char(jr_date_paid,'YYYYMMDD'),'00000000') >= 
                                    to_char(to_date($1,'DD.MM.YYYY'),'YYYYMMDD') 
                        and coalesce(to_char(jr_date_paid,'YYYYMMDD'),'99999999') <= 
                                    to_char(to_date($2,'DD.MM.YYYY'),'YYYYMMDD') 
                        and {$sql_ledger}
                    group by  {$group_ledger} qs_vat_code)  "; } elseif ($this->tva_type=="T") { $sql=$sql." 
                    where
                        (   tva_rate.tva_payment_sale='P'
                            and coalesce(to_char(jr_date_paid,'YYYYMMDD'),'00000000') >= 
                                        to_char(to_date($1,'DD.MM.YYYY'),'YYYYMMDD') 
                            and coalesce(to_char(jr_date_paid,'YYYYMMDD'),'99999999') <= 
                                         to_char(to_date($2,'DD.MM.YYYY'),'YYYYMMDD') 
                            )
                         or
                        (   tva_rate.tva_payment_sale='O'
                            and coalesce(to_char(jr_date,'YYYYMMDD'),'00000000') >= 
                                         to_char(to_date($1,'DD.MM.YYYY'),'YYYYMMDD') 
                            and coalesce(to_char(jr_date,'YYYYMMDD'),'99999999') <= 
                                         to_char(to_date($2,'DD.MM.YYYY'),'YYYYMMDD') 
                            )
                        and {$sql_ledger}
                    group by {$group_ledger} qs_vat_code)  
                   "; } else { throw new Exception(_("Exig TVA invalide"),1001); } return $sql; } function get_row_sale() { $sql=$this->build_sql_sale(TRUE); $sql.=" 
                    select jrn_def_name,
                        tva_code ||' ('||tva_rate.tva_label||')' tva_label,
                        qs_vat_code,
                        tva_rate,
                        tva_both_side,
                        amount_vat,
                        amount_wovat,
                        amount_sided,
                        tva_payment_sale as tva_type,
                        jrn_def.jrn_def_id
                    from
                        detail_tva 
                        join tva_rate on (tva_rate.tva_id=qs_vat_code)
                        join jrn_def on (jrn_def.jrn_def_id=j_jrn_def)
                    order by jrn_def.jrn_def_id,jrn_def_name, tva_code ||' ('||tva_rate.tva_label||')'"; $array=$this->db->get_array($sql, [$this->date_start, $this->date_end]); return $array; } function get_row_purchase() { $sql=$this->build_sql_purchase(TRUE)."
                select jrn_def_name,
                     tva_code ||' ('||tva_rate.tva_label||')' tva_label,
                    tva_rate,
                    tva_both_side,
                    qp_vat_code,
                    amount_vat,
                    amount_wovat,
                    amount_sided,
                    amount_noded_amount,
                    amount_noded_tax,
                    amount_noded_return,
                    amount_private,
                   jrn_def.jrn_def_id
                from
                    detail_tva 
                    join tva_rate on (tva_rate.tva_id=qp_vat_code)
                    join jrn_def on (jrn_def.jrn_def_id=j_jrn_def)
                order by  jrn_def.jrn_def_id,jrn_def_name, tva_code ||' ('||tva_rate.tva_label||')'"; $array=$this->db->get_array($sql, [$this->date_start, $this->date_end]); return $array; } function get_summary_sale() { $sql=$this->build_sql_sale(FALSE); $sql.="select 
                     tva_code ||' ('||tva_rate.tva_label||')' tva_label,
                    qs_vat_code,
                    tva_rate,
                    tva_both_side,
                    amount_vat,
                    amount_wovat,
                    amount_sided,
                    tva_rate.tva_payment_sale
                from
                    detail_tva 
                    join tva_rate on (tva_rate.tva_id=qs_vat_code)
                    order by  tva_code ||' ('||tva_rate.tva_label||')'"; $array=$this->db->get_array($sql, [$this->date_start, $this->date_end]); return $array; } function get_summary_purchase() { $sql=$this->build_sql_purchase(FALSE)."
                select 
                     tva_code ||' ('||tva_rate.tva_label||')' tva_label,
                    tva_rate,
                    tva_both_side,
                    qp_vat_code,
                    amount_vat,
                    amount_wovat,
                    amount_sided,
                    amount_noded_amount,
                    amount_noded_tax,
                    amount_noded_return,
                    amount_private
                from
                    detail_tva 
                    join tva_rate on (tva_rate.tva_id=qp_vat_code)
                order by  tva_code ||' ('||tva_rate.tva_label||')'"; $array=$this->db->get_array($sql, [$this->date_start, $this->date_end]); return $array; } function display() { require_once NOALYSS_INCLUDE."/template/tax_summary_display.php"; } function form_export_csv() { $id=uniqid("export_"); echo '<form method="GET" action="export.php" '; printf( 'id="%s"  onsubmit="download_document_form(\'%s\')">',$id,$id); echo Dossier::hidden(); echo HtmlInput::hidden("act", 'CSV:printtva'); echo HtmlInput::hidden("date_start", $this->date_start); echo HtmlInput::hidden("date_end", $this->date_end); echo HtmlInput::hidden("tva_type", $this->tva_type); echo HtmlInput::submit("CSV:printtva", _("Export CSV")); echo '</form>'; } function form_export_pdf() { $id=uniqid("export_"); echo '<form method="GET" action="export.php" '; printf( 'id="%s"  onsubmit="download_document_form(\'%s\')">',$id,$id); echo Dossier::hidden(); echo HtmlInput::hidden("act", 'PDF:printtva'); echo HtmlInput::hidden("date_start", $this->date_start); echo HtmlInput::hidden("date_end", $this->date_end); echo HtmlInput::hidden("tva_type", $this->tva_type); echo HtmlInput::submit("PDF:printtva", _("Export PDF")); echo '</form>'; } function build_link_detail($dossier_id,$dateStart,$DateeEd,$nLedger_id,$nVAT_id) { $js=sprintf("tax_detail_view('%s','%s','%s','%s','%s')", $dossier_id,$this->date_start,$this->date_end,$nLedger_id,$nVAT_id); return $js; } } 