<?php
 class PDF_Operation extends PDF { private $acc_detail; private $jr_id; private $pdf; var $cn; function __construct($p_cn, $pjr_id) { $this->cn = $p_cn; $this->jr_id = $pjr_id; $this->pdf = null; $acc_detail= new Acc_Operation($p_cn,$pjr_id); $acc_detail->set_id($pjr_id); $this->acc_detail=$acc_detail->get_quant(); } private function print_ledger_name() { $ledger = new Jrn_Def_sql($this->cn, $this->acc_detail->det->jr_def_id); return $ledger->jrn_def_name; } private function print_info() { $a_type=array( 'OTHER'=>_("Autre"), 'BON_COMMANDE'=>_("Bon de commande") ); foreach ($a_type as $key=>$label){ $other_info=$this->cn->get_value("select ji_value from jrn_info where jr_id=$1 and id_type=$2", [$this->acc_detail->jr_id,$key]); $this->pdf->write_cell(50, 6,$label); $this->pdf->write_cell(100, 6, $other_info); $this->pdf->line_new(4); } } private function print_operation_info() { $this->pdf->SetFont('DejaVu', '', 6); $this->pdf->write_cell(50, 6, _('Journal')); $this->pdf->write_cell(100, 6, $this->print_ledger_name()); $this->pdf->line_new(4); $this->pdf->write_cell(50, 6, _("Date")); $this->pdf->write_cell(100, 6, $this->acc_detail->det->jr_date); $this->pdf->line_new(4); $this->pdf->write_cell(50, 6, _("Echéance")); $this->pdf->write_cell(100, 6, $this->acc_detail->det->jr_ech); $this->pdf->line_new(4); $this->pdf->write_cell(50, 6, _("Paiement")); $this->pdf->write_cell(100, 6, $this->acc_detail->det->jr_date_paid); $this->pdf->line_new(4); $this->pdf->write_cell(50, 6, _("Numéro interne")); $this->pdf->write_cell(100, 6, $this->acc_detail->det->jr_internal); $this->pdf->line_new(4); $this->pdf->write_cell(50, 6, _("Pièce")); $this->pdf->write_cell(100, 6, $this->acc_detail->det->jr_pj_number); $this->pdf->line_new(4); $this->pdf->write_cell(50, 6, _("Commentaire")); $this->pdf->write_multi(130, 3 , $this->acc_detail->det->jr_comment); $this->pdf->line_new(4); $this->pdf->write_cell(50, 6, _("Nom document")); $this->pdf->write_cell(100, 6, $this->acc_detail->det->jr_pj_name); if ($this->acc_detail->det->currency_id != 0) { $currency=new Acc_Currency($this->cn,$this->acc_detail->det->currency_id); $this->pdf->line_new(4); $this->pdf->write_cell(50, 6, _("Devise")); $this->pdf->write_cell(50, 6, $currency->get_code()); $this->pdf->write_cell(25, 6, _("Taux utilisé")); $this->pdf->write_cell(30, 6,nb($this->acc_detail->det->currency_rate,4)); $this->pdf->write_cell(25, 6, _("Taux référence")); $this->pdf->write_cell(30, 6,nbm($this->acc_detail->det->currency_rate_ref,4)); $this->pdf->line_new(4); $this->pdf->write_cell(50, 6, _("Montant Devise")); $this->pdf->write_cell(50, 6, nb($this->acc_detail->get_currency_amount(),4)); } $this->pdf->line_new(4); $this->print_info(); $this->pdf->line_new(8); } private function print_operation_quant() { if ( $this->acc_detail->signature=='FIN' || $this->acc_detail->signature=="ODS") { return; } if ($this->acc_detail->signature=="ACH") { $tiers=_("Fournisseur"); $tiers_id=$this->acc_detail->det->array[0]['qp_supplier']; } else { $tiers=_("Client"); $tiers_id=$this->acc_detail->det->array[0]['qs_client']; } $this->pdf->SetFont('DejaVu', 'B', 10); $this->print_section(_("Résumé")); $fiche=new Fiche($this->cn,$tiers_id); $this->pdf->SetFont('DejaVu', 'B', 6); $this->pdf->write_cell(50, 6, $tiers); $this->pdf->write_cell(140, 6, $fiche->getName(). " ".$fiche->get_quick_code()); $this->pdf->line_new(4); if ($this->acc_detail->signature=="ACH") { $this->print_purchase(); } else { $this->print_sale(); } } private function str_vat($p_tva_id) { $tva= Acc_Tva::build($this->cn, $p_tva_id); $tva->load(); $auto=""; if ( $tva->tva_both_side==1) { $auto="(=0.0)"; } $ret=sprintf("%d %s %s",$p_tva_id,$tva->tva_label,$auto); return $ret; } private function print_sale() { $nb=count($this->acc_detail->det->array); $width=array(10,30,50,25,25,25,25); $sum_amount=0; $sum_vat=0; bcscale(4); $this->pdf->SetFont('DejaVu', 'B', 6); $this->pdf->write_cell($width[0],6,_("n°"),"B"); $this->pdf->write_cell($width[1],6,_("code"),"B"); $this->pdf->write_cell($width[2],6,_("Libellé"),"B"); $this->pdf->write_cell($width[3],6,_("Montant HTVA"),"B",0,"R"); $this->pdf->write_cell($width[4],6,_("TVA"),"B"); $this->pdf->write_cell($width[5],6,_("Montant TVA"),"B",0,"R"); $this->pdf->write_cell($width[6],6,_("Total"),"B",0,"R"); $this->pdf->line_new(6); $this->pdf->SetFont('DejaVu', '', 6); for ( $i=0;$i<$nb;$i++) { $row=$this->acc_detail->det->array[$i]; $fiche_id=$row['qs_fiche']; $fiche=new Fiche($this->cn,$fiche_id); $this->pdf->write_cell($width[0],6,$i+1); $this->pdf->write_cell($width[1],6,$fiche->get_quick_code()); $this->pdf->write_multi($width[2],3,$row['j_text']); $this->pdf->write_cell($width[3],6,nbm($row["qs_price"],2),"",0,"R"); $str=$this->str_vat($row["qs_vat_code"]); $this->pdf->write_cell($width[4],6,$str); $this->pdf->write_cell($width[5],6,nbm($row["qs_vat"],2),"",0,"R"); $this->pdf->write_cell($width[6],6,nbm(bcadd($row["qs_price"],$row["qs_vat"]),2),"",0,"R"); $this->pdf->line_new(6); $sum_amount=bcadd($sum_amount,$row["qs_price"]); $sum_vat=bcadd($sum_vat,$row["qs_vat"]); } $a=$b=0; $sum_other_tax=$this->print_other_tax(); $this->pdf->SetFont('DejaVu', 'B', 6); $this->pdf->write_cell($width[0],6,""); $this->pdf->write_cell($width[1],6,""); $this->pdf->write_cell($width[2],6,""); $this->pdf->write_cell($width[3],6,nbm($sum_amount,2),"",0,"R"); $this->pdf->write_cell($width[4],6,nbm($sum_other_tax,2),"",0,"R"); $this->pdf->write_cell($width[5],6,nbm($sum_vat,2),"",0,"R"); $sum_amount=bcadd($sum_other_tax,$sum_amount); $this->pdf->write_cell($width[6],6,nbm(bcadd($sum_amount,$sum_vat),2),"",0,"R"); $this->pdf->line_new(4); } private function print_purchase(){ $nb=count($this->acc_detail->det->array); $width=array(10,30,50,25,25,25,25); $sum_amount=0; $sum_vat=0; bcscale(4); $this->pdf->SetFont('DejaVu', 'B', 6); $this->pdf->write_cell($width[0],6,_("n°"),"B"); $this->pdf->write_cell($width[1],6,_("code"),"B"); $this->pdf->write_cell($width[2],6,_("Libellé"),"B"); $this->pdf->write_cell($width[3],6,_("Montant HTVA"),"B",0,"R"); $this->pdf->write_cell($width[4],6,_("TVA"),"B"); $this->pdf->write_cell($width[5],6,_("Montant TVA"),"B",0,"R"); $this->pdf->write_cell($width[6],6,_("Total"),"B",0,"R"); $this->pdf->line_new(6); $this->pdf->SetFont('DejaVu', '', 6); for ( $i=0;$i<$nb;$i++) { $row=$this->acc_detail->det->array[$i]; $fiche_id=$row['qp_fiche']; $fiche=new Fiche($this->cn,$fiche_id); $this->pdf->write_cell($width[0],6,$i+1); $this->pdf->write_cell($width[1],6,$fiche->get_quick_code()); $this->pdf->write_multi($width[2],3,$row['j_text']); $this->pdf->write_cell($width[3],6,nbm($row["qp_price"],2),"",0,"R"); $str=$this->str_vat($row["qp_vat_code"]); $this->pdf->write_cell($width[4],6,$str); $this->pdf->write_cell($width[5],6,nbm($row["qp_vat"],2),"",0,"R"); $this->pdf->write_cell($width[6],6,nbm(bcadd($row["qp_price"],$row["qp_vat"]),2),"",0,"R"); $this->pdf->line_new(6); $sum_amount=bcadd($sum_amount,$row["qp_price"]); $sum_vat=bcadd($sum_vat,$row["qp_vat"]); } $a=$b=0; $sum_other_tax=$this->print_other_tax(); $this->pdf->SetFont('DejaVu', 'B', 6); $this->pdf->write_cell($width[0],6,""); $this->pdf->write_cell($width[1],6,""); $this->pdf->write_cell($width[2],6,""); $this->pdf->write_cell($width[3],6,nbm($sum_amount,2),"",0,"R"); $this->pdf->write_cell($width[4],6,""); $this->pdf->write_cell($width[5],6,nbm($sum_vat,2),"",0,"R"); $this->pdf->write_cell($width[4],6,nbm($sum_other_tax,2),"",0,"R"); $sum_amount=bcadd($sum_other_tax,$sum_amount); $this->pdf->write_cell($width[6],6,nbm(bcadd($sum_amount,$sum_vat),2),"",0,"R"); $this->pdf->line_new(10); } private function print_section($p_section) { $this->pdf->SetFont('DejaVu', 'B', 10); $this->pdf->write_cell(60,8,$p_section,"1"); $this->pdf->line_new(8); } private function print_other_tax() { $width=array(10,80,25,25,25,25); $aOther_tax=Additional_Tax::get_by_operation($this->jr_id,$a,$b); $total=0; foreach ($aOther_tax as $other_tax) { $amount=$other_tax->getTaxAmount(); $total=bcadd($amount,$total,2); $this->pdf->write_cell($width[0],6,""); $this->pdf->write_cell($width[1],6,$other_tax->getAcLabel(). " ".$other_tax->getAcRate()."%"); $this->pdf->write_cell($width[3],6,""); $this->pdf->write_cell($width[2],6,nbm($amount,2),"",0,"R"); $this->pdf->write_cell($width[4],6,""); $this->pdf->write_cell($width[5],6,$total,"",0,"R"); $this->pdf->line_new(6); } return $total; } private function print_acc_writing(){ $obj1=new Acc_Operation($this->cn); $obj1->set_id($this->jr_id); $obj=$obj1->get(); $nb=count($obj->det->array); $this->print_section(_("Ecriture comptable")); bcscale(4); $width=array(10,40,40,50,30,10); $this->pdf->SetFont('DejaVu', 'B', 6); $this->pdf->write_cell($width[0],6,_("n°"),"B"); $this->pdf->write_cell($width[1],6,_("Poste comptable"),"B"); $this->pdf->write_cell($width[2],6,_("code"),"B"); $this->pdf->write_cell($width[3],6,_("Libellé"),"B"); $this->pdf->write_cell($width[4],6,_("Montant"),"B",0,"R"); $this->pdf->write_cell($width[5],6,_("D/C"),"B"); $this->pdf->line_new(6); $this->pdf->SetFont('DejaVu', '', 6); for ($i=0;$i<$nb;$i++){ $row=$obj->det->array[$i]; $this->pdf->write_cell($width[0],6,$row['j_id']); $this->pdf->write_cell($width[1],6,$row['j_poste']); $this->pdf->write_cell($width[2],6,$row["j_qcode"]); $str=$row["j_text"]; if (empty($str)){ if (empty($row["j_qcode"])) { $str=$this->cn->get_value("select pcm_lib from tmp_pcmn where pcm_val=$1", array($row["j_poste"])); } else { $str=$this->cn->get_value("select ad_value from fiche_detail where ad_id=1 and f_id=$1", array($row["f_id"])); } } $this->pdf->write_cell($width[3],6,$str); $this->pdf->write_cell($width[4],6,nbm($row["j_montant"],2),"",0,"R"); $deb=($row["j_debit"]=="t")?"D":"C"; $this->pdf->write_cell($width[5],6,$deb); $this->pdf->line_new(6); } } private function print_reconcilied_operation() { $a_reconcilied_operation=$this->cn->get_array("select jr_id,jra_concerned from jrn_rapt where jra_concerned=$1 or jr_id=$1", [$this->jr_id]); if ( empty ($a_reconcilied_operation)) { return; } $this->print_section(_("Opérations rapprochées")); foreach ($a_reconcilied_operation as $reconcilied_operation) { $op=($reconcilied_operation['jr_id']==$this->jr_id)?$reconcilied_operation['jra_concerned']:$reconcilied_operation['jr_id']; $operation=new PDF_Operation($this->cn,$op); $operation->pdf=$this->pdf; $operation->print_operation_info(); } } private function print_anc_header($pa_plan) { $nb=count($pa_plan); $this->pdf->SetFont('DejaVu', 'B', 8); $width=25; $this->pdf->fill_row(0); for ($i = 0; $i<$nb; $i++) { $this->pdf->write_cell($width,8,$pa_plan[$i]['pa_name']); } $this->pdf->write_cell($width,8,_('Montant'),0,0,'R'); $this->pdf->fill_row(1); $this->pdf->line_new(8); } private function print_anc_detail($p_j_id, $pa_plan) { $row_jrnx = $this->cn->get_row("select j_text , j_montant,j_qcode,j_poste from public.jrnx where j_id=$1", array($p_j_id)); $this->pdf->SetFont('DejaVu', 'B', 7); $this->pdf->write_cell(25, 8,$p_j_id); $this->pdf->write_cell(40, 8,$row_jrnx["j_poste"]); $this->pdf->write_cell(40, 8,$row_jrnx["j_qcode"]); $this->pdf->write_cell(40, 8,nbm($row_jrnx["j_montant"],2)); $this->pdf->line_new(8); $this->print_anc_header($pa_plan); $a_operation_analytique = $this->cn->get_array( "select oa_row,oa_positive,po_name,pa_id,po_id,oa_debit,
                    case when oa_positive='N' then oa_amount*(-1) 
                    else oa_amount end  as signed_amount
	from OPeration_analytique 
	left join public.poste_analytique using(po_id)
	left join public.plan_analytique using (pa_id)
            where 
                    j_id =$1
            order by oa_row,pa_id
                    ", array($p_j_id)); $this->pdf->SetFont('DejaVu', '', 6); $width = 25; $old_row = null; $nb_operation = count($a_operation_analytique); $idx_plan = 0; $cnt_plan = count($pa_plan); bcscale(4); $tot_anc=0; for ($i = 0; $i<$nb_operation; $i++) { $current_row = $a_operation_analytique[$i]; if ($old_row==null) $old_row = $current_row; if ($old_row['oa_row']!=$current_row['oa_row']) { if($idx_plan!=0) { for ($e = $idx_plan; $e<$cnt_plan; $e++) $this->pdf->write_cell($width, 8, "", 1,0, "c", 0); } $this->pdf->write_cell($width, 8, nbm($old_row["signed_amount"],2), 1,0, "R", 0); $tot_anc= bcadd($tot_anc, $old_row["signed_amount"]); $this->pdf->line_new(8); $idx_plan = 0; } if ($current_row['pa_id']==$pa_plan[$idx_plan]['pa_id']) { $this->pdf->write_cell($width, 8, $current_row['po_name'], 1,0, "L", 0); } else { for ($e = $idx_plan; $e<$cnt_plan; $e++) { if ($current_row['pa_id']==$pa_plan[$e]['pa_id']) { $this->pdf->write_cell($width, 8, $current_row['po_name'], 1, 0,"L", 0); $idx_plan=$e; break; } else { $this->pdf->write_cell($width, 8, "", 1,0, "c", 0); } } } $idx_plan++; if ($idx_plan == $cnt_plan ) $idx_plan=0; $old_row = $current_row; } if($idx_plan!=0) { $this->pdf->write_cell($width, 8, "", 1,0, "C", 0); } $this->pdf->write_cell($width, 8,nbm($old_row["signed_amount"],2), 1, 0,"R", 0); $this->pdf->line_new(8); $tot_anc= bcadd($tot_anc, $old_row["signed_amount"]); $this->pdf->write_cell(40, 6,_("Comptabilité")); $this->pdf->write_cell(40, 6,nbm($row_jrnx["j_montant"],2),0,0,"r",0); $this->pdf->line_new(); $this->pdf->write_cell(40, 6,_("Analytique")); $this->pdf->write_cell(40, 6,nbm($tot_anc,2),0,0,"r",0); $this->pdf->line_new(); $this->pdf->write_cell(40, 6,_("Diff")); $this->pdf->write_cell(40, 6,nbm( bcsub($row_jrnx['j_montant'], $tot_anc),2),0,0,"R",0); $this->pdf->line_new(); } private function print_anc_writing() { $a_plan=$this->cn->get_array("select pa_id,pa_name 
                            from public.plan_analytique order by pa_id"); $a_jrnxId=$this->cn->get_array( "select j_id from jrnx join jrn on (jr_grpt_id=j_grpt)
            where
            jr_id=$1",array($this->jr_id)); $nb=count($a_jrnxId); $flag_print_section=0; for ($index = 0; $index<$nb; $index++) { $count_ana=$this->cn->get_value("select count(*)
                from public.operation_analytique
                where j_id=$1
                ",array($a_jrnxId[$index]["j_id"])); if ($count_ana == 0 ) continue; if ($flag_print_section==0) $this->print_section (_("Détail analytique")); $flag_print_section=1; $this->print_anc_detail($a_jrnxId[$index]["j_id"],$a_plan); } } function export_pdf($p_option) { $this->pdf = new PDF($this->cn); $this->pdf->Setdossierinfo(_("Détail opération")); $this->pdf->setTitle(_("Détail opération"), true); $this->pdf->SetAuthor('NOALYSS'); $this->pdf->AliasNbPages(); $this->pdf->AddPage(); $this->print_operation_info(); $this->print_operation_quant(); if ($this->acc_detail->signature=="ODS" || $this->acc_detail->signature=="FIN" || array_search("acc", $p_option) !== false ){ $this->print_acc_writing(); } if (array_search("anc", $p_option) !== false ) $this->print_anc_writing(); $this->print_reconcilied_operation(); } function get_pdf() { return $this->pdf; } function get_pdf_filename() { $file_name=$_ENV['TMP']."/"."acc_op".$this->acc_detail->det->jr_internal.".pdf"; $this->pdf->Output($file_name, "F"); return $file_name; } function download_pdf() { $this->pdf->Output("acc_op".$this->acc_detail->det->jr_internal.".pdf","D"); } function unlink() { $file=$this->get_pdf_filename(); if ( is_file($file)) unlink ($file); } } 