<?php
use chillerlan\Authenticator\{Authenticator, AuthenticatorOptions}; use chillerlan\Authenticator\Authenticators\AuthenticatorInterface; require_once NOALYSS_INCLUDE.'/constant.php'; require_once NOALYSS_INCLUDE.'/lib/user_common.php'; require_once NOALYSS_INCLUDE.'/lib/ac_common.php'; class Noalyss_User { var $id; var $db; var $admin; var $valid; var $first_name; var $last_name ; var $name; var $active; var $login; var $password; var $email; var $access_mode; var $lang ; var $theme ; var $authent_method; private $otp_secret; private $repository; function __construct($p_cn, $p_id=-1,$repository=null) { $this->db=$p_cn; if ( $repository == null ) { $this->repository=new Database(0); } else { $this->repository=$repository; } if ($p_id==-1) { $this->connect_user(); $this->set_session_var(); } else { $this->id=$p_id; $this->load(); } } public function get_repository():\Database { return $this->repository; } public function set_repository(Database $repository) { $this->repository = $repository; return $this; } public function set_session_var() { $this->db->exec_sql(sprintf("select set_config('noalyss.user_login','%s',false)", Database::escape_string($_SESSION[SESSION_KEY.'g_user']))); $this->repository->exec_sql(sprintf("select set_config('noalyss.user_login','%s',false)", Database::escape_string($_SESSION[SESSION_KEY.'g_user']))); } public function __toString(): string { return "User ".print_r($this,true); } function can_connect() { $can_connect=$this->repository->get_value("select count(*) from ac_users 
				   where use_active=1 and
				   use_login=$1 and use_pass=$2", [$this->login,$this->password]); return $can_connect; } private function connect_user() { if (!isset($_SESSION[SESSION_KEY.'g_user'])) { $http=new \HttpInput(); $user_login=$http->request("p_user", "string", ""); $user_password=$http->request("p_pass", "string", ""); if ($user_login!=""&&$user_password!="") { $_SESSION[SESSION_KEY."g_user"]=$user_login; $_SESSION[SESSION_KEY."g_pass"]=md5($user_password); } else { echo '<h2 class="error">'._('Session expirée<br>Utilisateur déconnecté').'</h2>'; redirect('index.php', 1); exit(); } if (strpos($user_login, '@mobile')!=false) { $this->access_mode='MOBILE'; $this->login=str_ireplace("@mobile", "", $user_login); } else { $this->access_mode='PC'; $this->login=strtolower($user_login); } $_SESSION[SESSION_KEY."access_mode"]=$this->access_mode; $_SESSION[SESSION_KEY.'g_user']=$this->login; } $this->login=$_SESSION[SESSION_KEY."g_user"]; $this->password=$_SESSION[SESSION_KEY.'g_pass']; $this->id=-1; $this->lang=(isset($_SESSION[SESSION_KEY.'g_lang']))?$_SESSION[SESSION_KEY.'g_lang']:'fr_FR.utf8'; $this->access_mode=$_SESSION[SESSION_KEY."access_mode"]; $this->repository->exec_sql(sprintf("select set_config('noalyss.user_login','%s',false)", Database::escape_string($_SESSION[SESSION_KEY.'g_user']))); if ($this->can_connect() == 0 || $this->load()==-1 ) { echo '<h2 class="error">'._('Utilisateur ou mot de passe incorrect').'</h2>'; $sql="insert into audit_connect (ac_user,ac_ip,ac_module,ac_url,ac_state) values ($1,$2,$3,$4,$5)"; $server_remote=$_SERVER['REMOTE_ADDR']?? "cmd-line"; $request_uri=$_SERVER['REQUEST_URI']??"REQUEST-URI"; $this->repository->exec_sql($sql, array($_SESSION[SESSION_KEY.'g_user'],$server_remote, "DISCON", $request_uri , 'FAIL')); $this->clean_session(); redirect('logout.php', 1); exit(); } $this->load_global_pref(); $_SESSION[SESSION_KEY.'g_lang']=$this->lang; $this->valid=(isset($_SESSION[SESSION_KEY.'isValid']))?1:0; if (isset($_SESSION[SESSION_KEY.'g_theme'])) { $this->theme=$_SESSION[SESSION_KEY.'g_theme']; } $_SESSION[SESSION_KEY.'use_admin']=$this->admin; $_SESSION[SESSION_KEY.'use_name']=$this->name; $_SESSION[SESSION_KEY.'use_first_name']=$this->first_name; } public function get_access_mode() { return $this->access_mode; } public function set_access_mode($access_mode): object { $this->access_mode=$access_mode; return $this; } public function getId(): int { return $this->id; } public function setId(int $id): void { $this->id=$id; } public function getDb() { return $this->db; } public function setDb($db): void { $this->db=$db; } public function getAdmin() { return $this->admin; } public function setAdmin($admin): void { $this->admin=$admin; } public function getValid(): int { return $this->valid; } public function setValid(int $valid): void { $this->valid=$valid; } public function getFirstName() { return $this->first_name; } public function setFirstName($first_name): void { $this->first_name=$first_name; } public function getName() { return $this->name; } public function setName($name): void { $this->name=$name; } public function getActive() { return $this->active; } public function setActive($active): void { $this->active=$active; } public function getLogin(): string { return $this->login; } public function setLogin(string $login): void { $this->login=$login; } public function getPassword() { return $this->password; } public function setPassword($password): void { $this->password=$password; } public function getEmail() { return $this->email; } public function setEmail($email): void { $this->email=$email; } function load():int { if ($this->id<0) { $sql_cond="   where lower(use_login)=lower($1)"; $sql_array=array($this->login); } else { $sql_cond="   where use_id=$1"; $sql_array=array($this->id); } $sql="select use_id,
                            use_first_name,
                            use_name,
                            use_login,
                            use_active,
                            use_admin,
                            use_pass,
                            use_email,
                            use_auth_method,
                            use_otp_secret
                        from ac_users "; $Res=$this->repository->exec_sql($sql.$sql_cond, $sql_array); if (($Max=Database::num_row($Res))==0) return -1; $row=Database::fetch_array($Res, 0); $this->id=$row['use_id']; $this->first_name=$row['use_first_name']; $this->last_name=$row['use_name']; $this->name=$row['use_name']; $this->active=$row['use_active']; $this->login=strtolower($row['use_login']); $this->admin=$row['use_admin']; $this->password=$row['use_pass']; $this->email=$row['use_email']; $this->authent_method=$row['use_auth_method']; $this->otp_secret=$row['use_otp_secret']; return $this->id; } function save() { if ( $this->authent_method != 0 && $this->otp_secret == null) { $this->generate_otp(); } $Sql="update ac_users set use_first_name=$1, use_name=$2
             ,use_active=$3,use_admin=$4,use_pass=$5 ,use_email = $7 
             , use_auth_method=$8,use_otp_secret=$9
                where use_id=$6"; $Res=$this->repository->exec_sql($Sql, array($this->first_name , $this->last_name , $this->active , $this->admin , $this->password , $this->id , $this->email , $this->authent_method , $this->otp_secret )); } function insert() { $Sql="INSERT INTO ac_users(
                        use_first_name, use_name, use_login, use_active,  
                        use_admin, use_pass, use_email)
                            VALUES ($1, $2, $3, $4, $5, $6, $7) returning use_id"; $this->id=$this->repository->get_value($Sql, array($this->first_name, $this->last_name, $this->login, 1, $this->admin, $this->password, $this->email)); } function Check($silent=false, $from='') { $res=0; $pass5=$this->password; $sql="select ac_users.use_login,ac_users.use_active, ac_users.use_pass,
             use_admin,use_first_name,use_name
             from ac_users
             where ac_users.use_id=$1 
             and ac_users.use_active=1
             and ac_users.use_pass=$2"; $ret=$this->repository->exec_sql($sql, array($this->id, $pass5)); $res=Database::num_row($ret); if ($res>0) { $r=Database::fetch_array($ret, 0); $_SESSION[SESSION_KEY.'use_admin']=$r['use_admin']; $_SESSION[SESSION_KEY.'use_name']=$r['use_name']; $_SESSION[SESSION_KEY.'use_first_name']=$r['use_first_name']; $_SESSION[SESSION_KEY.'isValid']=1; $this->admin=$_SESSION[SESSION_KEY.'use_admin']; $this->name=$_SESSION[SESSION_KEY.'use_name']; $this->first_name=$_SESSION[SESSION_KEY.'use_first_name']; $this->load_global_pref(); } $sql="insert into audit_connect (ac_user,ac_ip,ac_module,ac_url,ac_state) values ($1,$2,$3,$4,$5)"; if ($res==0 || $this->can_connect() == 0) { $this->repository->exec_sql($sql, array($_SESSION[SESSION_KEY.'g_user'], $_SERVER["REMOTE_ADDR"], $from, $_SERVER['REQUEST_URI'], 'FAIL')); if (!$silent) { echo '<script> alert(\''._('Utilisateur ou mot de passe incorrect').'\')</script>'; redirect('index.html'); } $this->valid=0; session_unset(); exit-1; } else { if ($from=='LOGIN' || $from=='PORTAL') { $this->repository->exec_sql($sql, array($_SESSION[SESSION_KEY.'g_user'], $_SERVER["REMOTE_ADDR"], $from, $_SERVER['REQUEST_URI'], 'SUCCESS')); } $this->valid=1; } return $ret; } function get_folder_access($p_dossier=0) { if ($p_dossier==0) $p_dossier=dossier::id(); if ($this->admin==1) return 'R'; $sql="select 'R' from jnt_use_dos where use_id=$1 and dos_id=$2"; $res=$this->repository->get_value($sql, array($this->id, $p_dossier)); if ($this->repository->get_affected()==0) return 'X'; return $res; } function set_folder_access($db_id, $priv) { if ($priv) { $jnt=$this->repository->get_value("select jnt_id from jnt_use_dos where dos_id=$1 and use_id=$2", array($db_id, $this->id)); if ($this->repository->size()==0) { $Res=$this->repository->exec_sql("insert into jnt_use_dos(dos_id,use_id) values($1,$2)", array($db_id, $this->id)); } } else { $this->repository->exec_sql('delete from jnt_use_dos where use_id  = $1 and dos_id = $2 ', array($this->id, $db_id)); } } function get_ledger_access($p_ledger) { if ($this->admin==1|| $this->is_local_admin(dossier::id())==1||$this->get_status_security_ledger()==0) return 'W'; $sql="select uj_priv from user_sec_jrn where uj_login=$1 and uj_jrn_id=$2"; $res=$this->db->get_value($sql, array($this->login, $p_ledger)); if ($res=='') $res='X'; return $res; } function get_ledger($p_type='ALL', $p_access=3, $all=TRUE) { $p_type=strtoupper($p_type); if (!in_array($p_type, ["FIN", "ALL", "ODS", "VEN", 'ACH'])) { record_log(sprintf("UGL1, p_type %s", $p_type)); throw new Exception("UGL1"._("Type incorrecte")); } if ($all==TRUE) { $sql_enable=""; } else { $sql_enable="and jrn_enable=1"; } if ($this->admin!=1&&$this->is_local_admin()!=1&&$this->get_status_security_ledger()==1) { $sql_type=($p_type=='ALL')?'':"and jrn_def_type=upper('".sql_string($p_type)."')"; switch ($p_access) { case 3: $sql_access=" and uj_priv!= 'X' "; break; case 2: $sql_access=" and uj_priv = 'W' and jrn_enable=1 "; break; case 1: $sql_access=" and ( uj_priv = 'R' or uj_priv='W') "; break; } $sql="select jrn_def_id,jrn_def_type,jrn_def_code,
                 jrn_def_name,jrn_def_class_deb,jrn_def_class_cred,jrn_type_id,jrn_desc,uj_priv,
                 jrn_deb_max_line,jrn_cred_max_line,jrn_def_description,jrn_enable
                 from jrn_def join jrn_type on jrn_def_type=jrn_type_id
                 join user_sec_jrn on uj_jrn_id=jrn_def_id
                 where
                 uj_login='".$this->login."'". $sql_type.$sql_access.$sql_enable. " order by jrn_Def_name"; } else { $sql_type=($p_type=='ALL')?'  '.$sql_enable:"where jrn_def_type=upper('".sql_string($p_type)."')  ".$sql_enable; $sql="select jrn_def_id,jrn_def_type,jrn_def_code,jrn_def_name,jrn_def_class_deb,jrn_def_class_cred,jrn_deb_max_line,jrn_cred_max_line,
                 jrn_type_id,jrn_desc,'W' as uj_priv,jrn_def_description,jrn_enable
                 from jrn_def join jrn_type on jrn_def_type=jrn_type_id
                 $sql_type
                 order by jrn_Def_name"; } $res=$this->db->exec_sql($sql); if (Database::num_row($res)==0) return null; $array=Database::fetch_all($res); return $array; } function get_ledger_sql($p_type='ALL', $p_access=3) { $aLedger=$this->get_ledger($p_type, $p_access); if (empty($aLedger)) return ' jrn_def_id < 0 '; $sql=" jrn_def_id in ("; foreach ($aLedger as $row) { $sql.=$row['jrn_def_id'].','; } $sql.='-1)'; return $sql; } function Admin():int { return $this->isAdmin(); } function isAdmin():int { $this->admin=0; $pass5=$this->password; $sql="select count(*) from ac_users where use_login=$1
             and use_active=1 and use_admin=1 and use_pass=$2 "; $this->admin=$this->repository->get_value($sql, array($this->login,$pass5)); return $this->admin; } function set_periode($p_periode) { $sql="update user_local_pref set parameter_value=$1 where user_id=$2 and parameter_type='PERIODE'"; $Res=$this->db->exec_sql($sql, [$p_periode, $this->id]); } private function set_default_periode() { $sql='select min(p_id) as pid ' .' from parm_periode ' .' where p_closed = false and p_start = (select min(p_start) from parm_periode)'; $Res=$this->db->exec_sql($sql); $pid=Database::fetch_result($Res, 0, 0); if ($pid==null) { $sql='select min(p_id) as pid ' .'from parm_periode ' .'where p_start = (select max(p_start) from parm_periode)'; $Res2=$this->db->exec_sql($sql); $pid=Database::fetch_result($Res2, 0, 0); if ($pid==null) { throw new Exception(_("Aucune période trouvéee !!!")); } $pid=Database::fetch_result($Res2, 0, 0); } $sql=sprintf("insert into user_local_pref (user_id,parameter_value,parameter_type)
                     values ('%s','%d','PERIODE')", $this->id, $pid); $Res=$this->db->exec_sql($sql); } function get_periode() { $array=$this->get_preference(); if (!isset($array['PERIODE'])) { $this->set_default_periode(); $array=$this->get_preference(); } return $array['PERIODE']; } function save_global_preference($key, $value) { $count=$this->repository->get_value("select count(*)
	    from
	    user_global_pref
	    where
	    parameter_type=$1 and user_id=$2", array($key, $this->login)); if ($count==1) { $this->repository->exec_sql("update user_global_pref set parameter_value=$1
		where parameter_type=$2 and user_id=$3", array($value, $key, $this->login)); } elseif ($count==0) { $this->repository->exec_sql("insert into user_global_pref(user_id,parameter_type,parameter_value)
		values($1,$2,$3)", array($this->login, $key, $value)); } } function get_preference() { $sql="select parameter_type,parameter_value from user_local_pref where user_id=$1"; $Res=$this->db->exec_sql($sql, array($this->id)); $l_array=array(); for ($i=0; $i<Database::num_row($Res); $i++) { $row=Database::fetch_array($Res, $i); $type=$row['parameter_type']; $l_array[$type]=$row['parameter_value']; } $a_global_pref=$this->repository->get_array("select parameter_type,parameter_value from user_global_pref 
									where 
									upper(user_id) = upper($1)", [$this->login]); $nb_global=count($a_global_pref); for ($i=0; $i<$nb_global; $i++) { $idx=$a_global_pref[$i]['parameter_type']; $value=$a_global_pref[$i]['parameter_value']; $l_array[$idx]=$value; } return $l_array; } function check_module($p_module) { if ( $this->access_mode == "PC") { $acc=$this->db->get_value("select count(*) from v_all_menu where p_id = $1
                    and me_code=$2", array($this->get_profile(), $p_module)); } elseif ($this->access_mode=="MOBILE") { $acc=$this->db->get_value("select count(*) from profile_mobile where p_id=$1 and me_code=$2", array($this->get_profile(), $p_module)); } else { throw new Exception("USER:823:ACCESS_MODE INCONNU"); } if ($acc==0) { $this->audit("FAIL", $p_module); return 0; } $this->audit("SUCCESS", $p_module); return 1; } function check_action($p_action_id) { global $audit; if ($this->Admin()==1) return 1; if ($this->is_local_admin(dossier::id())==1) return 1; if ($this->get_status_security_action()==0) return 1; $Res=$this->db->exec_sql( "select * from user_sec_act where ua_login=$1 and ua_act_id=$2", array($this->login, $p_action_id)); $Count=Database::num_row($Res); if ($Count==0) { if (isset($audit)&&$audit==true) { $sql="insert into audit_connect (ac_user,ac_ip,ac_module,ac_url,ac_state) values ($1,$2,$3,$4,$5)"; $this->repository->exec_sql($sql, array($_SESSION[SESSION_KEY.'g_user'], $_SERVER["REMOTE_ADDR"], $p_action_id, $_SERVER['REQUEST_URI'], 'FAIL')); } return 0; } if ($Count==1) return 1; echo_error(_("Action invalide")); record_log("User:check_action".sprintf("login %s ua_act_id %s", $this->login, $p_action_id)); exit(); } function load_global_pref() { $Res=$this->repository->exec_sql("select parameter_type,parameter_value from
                            user_global_pref
                            where user_id=$1", [$this->login]); $Max=Database::num_row($Res); if ($Max==0) { $this->insert_default_global_pref(); $this->load_global_pref(); return; } $line=array(); for ($i=0; $i<$Max; $i++) { $row=Database::fetch_array($Res, $i); $type=$row['parameter_type']; $line[$type]=$row['parameter_value']; } $array_pref=array('g_theme'=>'THEME', 'g_pagesize'=>'PAGESIZE', 'g_topmenu'=>'TOPMENU', 'g_lang'=>'LANG', 'csv_fieldsep'=>'csv_fieldsep', 'csv_decimal'=>'csv_decimal', 'csv_encoding'=>'csv_encoding', 'first_week_day'=>'first_week_day'); foreach ($array_pref as $name=> $parameter) { if (!isset($line[$parameter])) { $this->insert_default_global_pref($parameter); $this->load_global_pref(); return; } $_SESSION[SESSION_KEY.$name]=$line[$parameter]; } } function insert_default_global_pref($p_type="", $p_value="") { $default_parameter=array("THEME"=>"classic", "PAGESIZE"=>"50", 'TOPMENU'=>'TEXT', 'LANG'=>'fr_FR.utf8', 'csv_fieldsep'=>'0', 'csv_decimal'=>'0', 'csv_encoding'=>'utf8', 'first_week_day'=>1 ); $sql="insert into user_global_pref(user_id,parameter_type,parameter_value)
             values ($1,$2,$3)"; if ($p_type=="") { foreach ($default_parameter as $name=> $value) { $this->repository->exec_sql($sql, array($this->login, $name, $value)); } } else { $value=($p_value=="")?$default_parameter[$p_type]:$p_value; if ( $this->repository->get_value("select count(*) from user_global_pref where user_id=$1 and parameter_type=$2", array($this->login,$p_type)) == 1) { $this->repository->exec_sql("update user_global_pref set parameter_value=$1 where user_id=$2 and parameter_type=$3", array($value,$this->login,$p_type)); } else { $this->repository->exec_sql($sql, array($this->login, $p_type, $value)); } } } function update_global_pref($p_type, $p_value="") { $default_parameter=array("THEME"=>"classic", "PAGESIZE"=>"50", "LANG"=>'fr_FR.utf8', 'TOPMENU'=>'SELECT', 'csv_fieldsep'=>'0', 'csv_decimal'=>'0', 'csv_encoding'=>'utf8', 'first_week_day'=>1 ); $Sql="update user_global_pref set parameter_value=$1
             where parameter_type=$2 and
             user_id=$3"; $value=($p_value=="")?$default_parameter[$p_type]:$p_value; $this->repository->exec_sql($Sql, array($value, $p_type, $this->login)); } function get_exercice() { $sql="select p_exercice from parm_periode where p_id=$1"; $Ret=$this->db->exec_sql($sql,[$this->get_periode()]); if (Database::num_row($Ret)==1) { $r=Database::fetch_array($Ret, 0); return $r['p_exercice']; } else return 0; } function can_request($p_action, $p_js=0) { if ($this->check_action($p_action)==0) { $this->audit('FAIL'); if ($p_js==1) { echo create_script("alert_box(content[59])"); } elseif ($p_js==2) { record_log(_("Access invalid").$p_action); } else { echo '<h2 class="error">', htmlspecialchars(_("Cette action ne vous est pas autorisée Contactez votre responsable")), '</h2>'; echo '</div>'; } exit(-1); } } function check_print($p_action) { global $audit; $this->audit('AUDIT', $p_action); if ($this->Admin()==1) return 1; $res=$this->db->get_value("select count(*) from profile_menu
			join profile_user using (p_id)
			where user_name=$1 and me_code=$2 ", array($this->login, $p_action)); return $res; } function can_print($p_action, $p_js=0) { if ($this->check_print($p_action)==0) { $this->audit('FAIL'); if ($p_js==1) { echo create_script("alert_box(content[59])"); } else { echo '<div class="redcontent">'; echo '<h2 class="error">', htmlspecialchars(_("Cette action ne vous est pas autorisée Contactez votre responsable")), '</h2>'; echo '</div>'; } exit(-1); } } function is_local_admin($p_dossier=-1) { return 0; } function get_available_repository($p_access='R') { $profile=$this->get_profile(); $r=array(); if ($p_access=='R') { $r=$this->db->get_array("select distinct u.r_id,r_name
                from
					profile_sec_repository as u
					join stock_repository as s on(u.r_id=s.r_id)
                where
                p_id =$1
                and ur_right='W'
				order by 2
				", array($profile)); } if ($p_access=='W') { $r=$this->db->get_array("select distinct u.r_id,r_name
                from
					profile_sec_repository as u
					join stock_repository as s on(u.r_id=s.r_id)
                where
                p_id =$1 order by 2
               ", array($profile)); } return $r; } static function get_list($p_dossier, $db_repository = null ) { $sql="select distinct use_id,use_login,use_first_name,use_name from ac_users
             left outer join  jnt_use_dos using (use_id)
             where
              (dos_id=$1 and use_active=1) or (use_active=1 and use_admin=1)
              order by use_login,use_name"; if ( $db_repository == null ) { $repo_cnx=new Database(0); } else { $repo_cnx=$db_repository; } $array=$repo_cnx->get_array($sql, array($p_dossier)); if ($repo->size()==0) { throw new \Exception('noalyss_user.get_list error inaccessible folders',1186); } return $array; } function check_jrn($p_jrn) { return $this->get_ledger_access($p_jrn); } function check_dossier($p_dossier_id, $silent=false) { $this->Admin(); if ($this->admin==1||$this->is_local_admin($p_dossier_id)==1) return 'L'; $dossier=$this->repository->get_value("select 'R' from jnt_use_dos where dos_id=$1 and use_id=$2", array($p_dossier_id, $this->id)); $dossier=($dossier=='')?'X':$dossier; if ($dossier=='X') { $this->audit('FAIL', "Access folder "); if (!$silent) { alert(_('Dossier non accessible')); exit(); } } return $dossier; } function get_limit_current_exercice() { $current_exercice=$this->get_exercice(); $periode=new Periode($this->db); list($per_start, $per_end)=$periode->get_limit($current_exercice); $start=$per_start->first_day(); $end=$per_end->last_day(); return array($start, $end); } function show_dossier($p_filtre="") { $p_array=$this->get_available_folder($p_filtre); $result=""; $result.="<TABLE id=\"folder\" class=\"result\">"; $result.="<tr>"; $result.="<th>"; $result.=_("Id"); $result.="</th>"; $result.="<th>"; $result.=_("Nom"); $result.="</th>"; $result.="<th>"; $result.=_("Description"); $result.="</th>"; $result.="</tr>"; if ($p_array==0) { $result.="<tr>"; $result.='<td style="width:auto" colspan=3>'; $result.=_("Aucun dossier disponible"); $result.='</td>'; $result.="</tr>"; return $result; } for ($i=0; $i<sizeof($p_array); $i++) { $id=$p_array[$i]['dos_id']; $name=$p_array[$i]['dos_name']; $desc=$p_array[$i]['dos_description']; if ($i%2==0) $tr="odd"; else $tr="even"; $target="do.php?gDossier=$id"; $result.="<TR class=\"$tr\">"; $result.=td($id, ' class="num" '); $result.="<TD class=\"$tr\">"; $result.="<A class=\"dossier\" HREF=\"$target\">"; $result.="  <B>".h($name)."</B>"; $result.="</A>"; $result.="</TD>"; $desc=($desc=="")?"<i>Aucune description</i>":h($desc); $desc="<A class=\"dossier\" HREF=\"$target\">$desc</A>"; $result.="<TD class=\"$tr\" >".$desc; $result.="</TD>"; $result.="</TR>"; } $result.="</TABLE>"; return $result; } function get_available_folder($p_filter="") { $cn=$this->repository; $filter=""; if ($this->admin==0) { $Res=$this->repository->exec_sql("select 
    						distinct dos_id,dos_name,dos_description 
                            from ac_users
								natural join jnt_use_dos
								natural join  ac_dossier
                            where
								use_login= $1
								and use_active = 1
								and ( dos_name ilike '%' || $2 || '%' or dos_description ilike '%' || $2 || '%' )
                            order by dos_name", array($this->login, $p_filter)); } else { $Res=$this->repository->exec_sql("select 
    			distinct dos_id,dos_name,dos_description from ac_dossier
             where   
                   dos_name  ilike '%' || $1|| '%' or dos_description ilike '%' || $1 || '%' 
			  order by dos_name", array($p_filter)); } $max=Database::num_row($Res); if ($max==0) return 0; for ($i=0; $i<$max; $i++) { $array[]=Database::fetch_array($Res, $i); } return $array; } static function audit_admin($p_module,$db_repository=null) { if ( $db_repository == null ) { $repo_cnx=new Database(0); } else { $repo_cnx=$db_repository; } $sql="insert into audit_connect (ac_user,ac_ip,ac_module,ac_url,ac_state) values ($1,$2,$3,$4,$5)"; $repo_cnx->exec_sql($sql, array( $_SESSION[SESSION_KEY.'g_user'], $_SERVER["REMOTE_ADDR"], $p_module, $_SERVER['REQUEST_URI'], 'ADMIN')); } function audit($action='AUDIT', $p_module="") { global $audit; $http=new \HttpInput(); if ($audit) { if ($p_module==""&&isset($_REQUEST['ac'])) { $p_module=$_REQUEST['ac']; } $dossier=$http->request("gDossier","string",0); if ( $dossier != 0) $p_module.=" dossier : ".$dossier; $sql="insert into audit_connect (ac_user,ac_ip,ac_module,ac_url,ac_state) values ($1,$2,$3,$4,$5)"; $this->repository->exec_sql($sql, array( $_SESSION[SESSION_KEY.'g_user'], $_SERVER["REMOTE_ADDR"], $p_module, $_SERVER['REQUEST_URI'], $action)); } } function save_profile($p_id) { $count=$this->db->get_value("select count(*) from profile_user where user_name=$1", array($this->login)); if ($count==0) { $this->db->exec_sql("insert into profile_user(p_id,user_name)
								values ($1,$2)", array($p_id, $this->login)); } else { $this->db->exec_sql("update profile_user set p_id=$1 where user_name=$2", array($p_id, $this->login)); } } function get_profile() { $profile=$this->db->get_value("select p_id from profile_user where
				lower(user_name)=lower($1) ", array($this->login)); return $profile; } function sql_writable_profile() { if ($this->admin!=1) { $sql=" (select p_granted " ."     from user_sec_action_profile " ."     where ua_right in ('W','O') and p_id=".$this->get_profile().") "; } else { $sql="(select p_id p_granted from profile)"; } return $sql; } function get_writable_profile() { $value=$this->db->get_array("select p_granted from ".$this->sql_writable_profile()." as m") ; $aGranted=array_column($value,"p_granted"); return $aGranted; } function get_readable_profile() { $value=$this->db->get_array("select p_granted from ".$this->sql_readable_profile()." as m") ; $aGranted=array_column($value,"p_granted"); return $aGranted; } function sql_readable_profile() { if ($this->admin!=1) { $sql=" (select p_granted " ."     from user_sec_action_profile " ."     where ua_right in ('W','R','O') and p_id=".$this->get_profile().") "; } else { $sql="(select p_id p_granted from profile)"; } return $sql; } function can_add_action($p_profile) { $r=$this->db->get_value(' select count(*) 
                from user_sec_action_profile
                where p_granted=$2
                and p_id=$1', array($this->get_profile(), $p_profile)); if ($r==0) { return false; } return true; } function can_write_action($dtoc) { if ($this->Admin()==1) return TRUE; if ($this->get_status_security_action()==0) return TRUE; $profile=$this->get_profile(); $r=$this->db->get_value(" select count(*) from action_gestion where ag_id=$1 and ag_dest in
				(select p_granted from user_sec_action_profile where ua_right in ('W','O') and p_id=$2) ", array($dtoc, $profile)); if ($r==0) return FALSE; return true; } function can_delete_action($dtoc) { if ($this->Admin()==1) return TRUE; if ($this->get_status_security_action()==0) return TRUE; $profile=$this->get_profile(); $r=$this->db->get_value(" select count(*) from action_gestion where ag_id=$1 and ag_dest in
				(select p_granted from user_sec_action_profile where ua_right='W' and p_id=$2) ", array($dtoc, $profile)); if ($r==0) return FALSE; return true; } function can_read_action($dtoc) { if ($this->Admin()==1) return true; $profile=$this->get_profile(); $r=$this->db->get_value(" select count(*) from action_gestion where ag_id=$1 and (ag_dest in
				(select p_granted from user_sec_action_profile where p_id=$2) or ag_owner=$3)", array($dtoc, $profile, $this->login)); if ($r==0) return false; return true; } function can_write_repo($p_repo) { if ($this->Admin()==1) return true; $profile=$this->get_profile(); $r=$this->db->get_value("select count(*)
                from profile_sec_repository
                where
                r_id=$1
                and p_id =$2
                and ur_right='W'", array($p_repo, $profile)); if ($r==0) return false; return true; } function can_read_repo($p_repo) { if ($this->Admin()==1) return true; $profile=$this->get_profile(); $r=$this->db->get_value("select count(*)
                from profile_sec_repository
                where
                r_id=$1
                and p_id =$2
               ", array($p_repo, $profile)); if ($r==0) return false; return true; } function password_to_session() { $_SESSION[SESSION_KEY.'g_pass']=$this->getPassword(); } function save_password($p_pass1, $p_pass2) { if ($p_pass1==$p_pass2 && count(check_password_strength($p_pass1)['msg'])==0) { $l_pass=md5($p_pass1); $this->setPassword($l_pass); $this->repository->exec_sql("update ac_users set use_pass=$1 where use_login=$2", array($l_pass, $this->login)); return true; } else { return false; } } function save_email($p_email) { $this->repository->exec_sql("update ac_users set use_email=$1 where use_login=$2", array($p_email, $_SESSION[SESSION_KEY.'g_user'])); } static function revoke_access($p_login, $p_dossier,$db_repository=null) { if ( $db_repository == null ) { $repo_cnx=new Database(0); } else { $repo_cnx=$db_repository; } $user=$repo_cnx->get_array('select use_id,use_login from ac_users where use_login=$1', array($p_login)); if (!$user) return false; $repo_cnx->exec_sql("delete from jnt_use_dos WHERE use_id=$1 and dos_id=$2", array($user[0]['use_id'], $p_dossier)); $cn_dossier=new Database($p_dossier); $cn_dossier->exec_sql("delete from profile_user where user_name=$1", array($p_login)); $cn_dossier->exec_sql("delete from user_sec_act where ua_login=$1", array($p_login)); } static function grant_admin_access($p_login, $p_dossier,$db_repository=null) { if ( $db_repository == null ) { $repo_cnx=new Database(0); } else { $repo_cnx=$db_repository; } $user=$repo_cnx->get_array("select use_id,use_login
                                from ac_users
                                where use_login=$1", array($p_login)); if (!$user) return false; $cn_dossier=new Database($p_dossier); if ( $repo_cnx->get_value("select count(*) from jnt_use_dos where use_id=$1 and dos_id=$2", array($user[0]['use_id'], $p_dossier))==0 ) { $repo_cnx->exec_sql("insert into jnt_use_dos(use_id,dos_id) values ($1,$2)", array($user[0]['use_id'], $p_dossier)); } if ($cn_dossier->get_value("select count(*) from profile_user where user_name=$1", array($user[0]['use_login']))==0) { $cn_dossier->exec_sql('insert into profile_user(user_name,p_id) values($1,1)', array($user[0]['use_login'])); } $cn_dossier->exec_sql("delete from user_sec_act where ua_login=$1", array($p_login)); $cn_dossier->exec_sql("insert into user_sec_act (ua_login,ua_act_id)" ." select $1 ,ac_id from action ", array($p_login)); $cn_dossier->exec_sql("delete from user_sec_jrn where uj_login=$1", array($p_login)); $cn_dossier->exec_sql("insert into user_sec_jrn(uj_login,uj_jrn_id,uj_priv)" ." select $1,jrn_def_id,'W' from jrn_def", array($p_login)); } static function remove_inexistant_user($p_dossier,$db_repository=null) { if ( $db_repository == null ) { $cnx_repo=new Database(0); } else { $cnx_repo=$db_repository; } $name=$cnx_repo->format_name($p_dossier, 'dos'); if ($cnx_repo->exist_database($name)==0) return false; $cnx_dossier=new Database($p_dossier); if ($cnx_dossier->exist_table('profile_user')) $a_user=$cnx_dossier->get_array('select user_name from profile_user'); else return false; if (!$a_user) return; $nb=count($a_user); for ($i=0; $i<$nb; $i++) { if ($cnx_repo->get_value('select count(*) from ac_users where use_login=$1', array($a_user[$i]['user_name']))==0) { if ($cnx_dossier->exist_table('user_sec_jrn')) $cnx_dossier->exec_sql("delete from user_sec_jrn where uj_login=$1", array($a_user[$i]['user_name'])); $cnx_dossier->exec_sql("delete from profile_user where user_name=$1", array($a_user[$i]['user_name'])); if ($cnx_dossier->exist_table('user_sec_act')) $cnx_dossier->exec_sql("delete from user_sec_act where ua_login=$1", array($a_user[$i]['user_name'])); if ($cnx_dossier->exist_table('user_sec_jrn')) $cnx_dossier->exec_sql("delete from user_sec_jrn where uj_login=$1", array($a_user[$i]['user_name'])); if ($cnx_dossier->exist_table('user_active_security')) $cnx_dossier->exec_sql("delete from user_active_security where us_login=$1", array($a_user[$i]['user_name'])); } } return true; } function get_status_security_ledger() { $security=$this->db->get_value("select us_ledger from user_active_security 
                where 
                us_login=$1", [$this->login]); $n_security=($security=="Y")?1:0; return $n_security; } function set_status_security_ledger($p_value) { if ($p_value!=0&&$p_value!=1) throw new Exception(_("Valeur invalide")); $exist=$this->db->get_value("select count(*) from user_active_security where us_login=$1", [$this->login]); $flag=($p_value==1)?"Y":"N"; if ($exist==0) { $this->db->exec_sql("insert into user_active_security (us_login,us_ledger,us_action) values ($1,$2,$3)", [$this->login, $flag, 'Y']); } else { $this->db->exec_sql("update user_active_security set us_ledger=$1 where us_login = $2", [$flag, $this->login]); } } function get_status_security_action() { $security=$this->db->get_value("select us_action from user_active_security 
                where 
                us_login=$1", [$this->login]); $n_security=($security=="Y")?1:0; return $n_security; } function set_status_security_action($p_value) { if ($p_value!=0&&$p_value!=1) throw new Exception(_("Valeur invalide")); $exist=$this->db->get_value("select count(*) from user_active_security where us_login=$1", [$this->login]); $flag=($p_value==1)?"Y":"N"; if ($exist==0) { $this->db->exec_sql("insert into user_active_security (us_login,us_action,us_ledger) values ($1,$2,$3)", [$this->login, $flag, 'Y']); } else { $this->db->exec_sql("update user_active_security set us_action=$1 where us_login = $2", [$flag, $this->login]); } } function get_first_week_day() { $result=$this->repository->get_value("select parameter_value from user_global_pref where parameter_type=$1 and user_id=$2 ", array("first_week_day", $this->login)); if ($this->repository->count()==0) { $this->save_global_preference("first_week_day", 1); return 1; } return $result; } static function clean_session() { $aSession=$_SESSION; foreach($aSession as $key => $value) { if(DEBUGNOALYSS>1) { echo "[$key]=>[$value]";} if ( strpos($key,SESSION_KEY) === 0) { unset($_SESSION[$key]); if(DEBUGNOALYSS>1) { echo "=> [$key] cleaned";} } } } function get_vat_code_preference():int { $result=$this->repository->get_value("select parameter_value from user_global_pref where parameter_type=$1 and user_id=$2 ", array("vat_code", $this->login)); if ($this->repository->count()==0) { $this->save_global_preference("vat_code", 0); return 0; } return $result; } function generate_otp() { $otp=new \Noalyss\OTP(); $this->otp_secret=$otp->build_secret(); } public function get_authent_method() { return $this->authent_method; } public function get_otp_secret() { return $this->otp_secret; } public function set_authent_method($authent_method) { $this->authent_method = $authent_method; return $this; } public function set_otp_secret($otp_secret) { $this->otp_secret = $otp_secret; return $this; } public function set_identified() { $_SESSION[SESSION_KEY."db_auth"]='ok'; } public function is_double_identified() { if ( $this->authent_method == 0 ) { $_SESSION[SESSION_KEY."db_auth"]='ok'; return true; } if ( ! isset($_SESSION[SESSION_KEY."db_auth"])) { return false; } if ($_SESSION[SESSION_KEY."db_auth"] == "ok") { return true; } return false; } public function send_code_otp() { if ( $this->authent_method !=1 ) { return false; } $mail=new \Sendmail(); $mail->set_format("HTML"); $mail->set_from(ADMIN_WEB); $mail->mailto($this->getEmail()); $mail->set_subject(_("NOALYSS : votre code secret ")); $noalyss_url=NOALYSS_URL; if ( strlen(trim($this->otp_secret??"")) == 0 ) { throw new \Exception("noalyss_user.send_code_otp:secret empty",1945); } $otp=new \Noalyss\OTP(); $code=$otp->compute_code($this->otp_secret); $message="<p>Bonjour,
           <br>
           <br>
           <p>Voici votre code secret utilisable pendant 10 minutes pour NOALYSS : <b> $code</b>  .
               </p>
               
             <p>
   Merci d'utiliser NOALYSS
   <br/>
   <br/>
   <br/>
   
Cordialement,
   <br/>
   <br/>

Noalyss team
      </p>

    <p>
    <i> Si cet email est dans vos spams, ajoutez l'expéditeur dans votre carnet d'adresse</i>
    </p>
"; try { $uuid= guidv4(); $this->repository->exec_sql("delete from otp_send_secret where use_id=$1 and os_code is not null" ,[$this->id]); $this->repository->exec_sql("delete from otp_send_secret where os_valid_time < now()"); $now=new \DateTime(); $valid=new \DateTime(); $valid->modify('+10 minutes'); $otp_send_secret=new Otp_Send_Secret_SQL($this->repository); $otp_send_secret->set("use_id",$this->id) ->set('os_request',$uuid) ->set("os_code",$code) ->set('os_valid_time',$valid->format('d.m.Y H:i:s')); $otp_send_secret->save(); $mail->set_message($message); $mail->compose(); $mail->send(); return $uuid; } catch (Exception $ex) { \record_log ($ex); throw new \Exception("noalyss_user.send_code_otp",1963,$ex); } } function send_link_otp($base_url=null) { $mail = new \Sendmail(); $mail->set_format("HTML"); $mail->set_from(ADMIN_WEB); $mail->mailto($this->getEmail()); $mail->set_subject(_("NOALYSS : Double authentification lien pour 2FA: OTP")); $noalyss_url = $base_url??NOALYSS_URL; $uuid = guidv4(); $valid_time=new \DateTime(); $valid_time->add(new \DateInterval('PT12H')); $str_time=$valid_time->format('d-m-Y H:i'); $message = "<p>Bonjour,</p>
<p>
    Afin de pouvoir utiliser la double authentification avec 2FA: OTP, pourriez-vous
    suivre ce lien et scanner le QRCode avec votre application android freeOTP ou Google Authenticator.
  </p>             
    <p>Ce lien expirera le <b>{$str_time}</b>.
        <br>
        <br>
        <br>
        
   <a href=\"{$noalyss_url}/index.php?otp={$uuid}\">{$noalyss_url}/index.php?otp={$uuid}</a>
        </p>
   
   <p>
   
   Merci d'utiliser NOALYSS
   </p>
   
<p>
Bien cordialement,
</p>
   <p>
               <i> Si cet email est dans vos spams, ajoutez l'expéditeur dans votre carnet d'adresse</i>
               </p>
"; try { $this->repository->exec_sql("delete from otp_send_secret where use_id=$1 and os_code is null" ,[$this->id]); $this->repository->exec_sql("delete from otp_send_secret where os_valid_time < now()"); $otp_send_secret_sql = new \Otp_Send_Secret_SQL($this->repository); $otp_send_secret_sql->set('use_id', $this->id) ->set('os_valid_time',$valid_time->format('d-m-Y H:i')) ->set('os_request', $uuid); $otp_send_secret_sql->save(); $mail->set_message($message); $mail->compose(); $mail->send(); return $uuid; } catch (Exception $ex) { \record_log($ex); throw new \Exception("noalyss_user.send_link_otp",1998,$ex); } } function input_otp($uuid="",$url="") { require_once NOALYSS_TEMPLATE."/noalyss_user-input_otp.php" ; } function check_otp($code) { $otp=new \Noalyss\OTP(); if ( $otp->compute_code($this->otp_secret) == $code ) { return true; } return false; } } ?>
