<?php
 class Document { var $db; var $d_id; var $ag_id; var $d_mimetype; var $d_filename; var $d_lob; var $d_description; var $d_number; var $md_id; var $f_id; protected $counter; var $d_name; var $md_type ; function __construct($p_cn, $p_d_id=0) { $this->db=$p_cn; $this->d_id=$p_d_id; $this->counter=0; } function __toString(): string { return "Document[db=" . $this->db . ", d_id=" . $this->d_id . ", ag_id=" . $this->ag_id . ", d_mimetype=" . $this->d_mimetype . ", d_filename=" . $this->d_filename . ", d_lob=" . $this->d_lob . ", d_description=" . $this->d_description . ", d_number=" . $this->d_number . ", md_id=" . $this->md_id . ", f_id=" . $this->f_id . ", counter=" . $this->counter . ", d_name=" . $this->d_name . ", md_type=" . $this->md_type . "]"; } function blank() { $this->d_id=$this->db->get_next_seq("document_d_id_seq"); $this->d_number=$this->db->get_next_seq("seq_doc_type_".$this->md_type); $sql='insert into document(d_id,ag_id,d_number) values($1,$2,$3)'; $this->db->exec_sql($sql, array ($this->d_id, $this->ag_id, $this->d_number)); } function compute_filename($pj, $filename) { $pos_prefix=strrpos($filename, "."); if ($pos_prefix==0) $pos_prefix=strlen($filename); $filename_no=substr($filename, 0, $pos_prefix); $filename_suff=substr($filename, $pos_prefix, strlen($filename)); foreach (array('/', '*', '<', '>', ';', ',', '\\', '.', ':', '(', ')', ' ', '[', ']',"'") as $i) { $pj=noalyss_str_replace($i, "-", $pj); $filename_no=noalyss_str_replace($i,"-",$filename_no); } $new_filename=strtolower($filename_no."-".$pj.$filename_suff); $pj=noalyss_str_replace("---","-",$pj); $pj=noalyss_str_replace("--","-",$pj); $new_filename=noalyss_str_replace("---","-",$new_filename); $new_filename=noalyss_str_replace("--","-",$new_filename); return $new_filename; } function generate($p_array, $p_filename="") { try { $dirname=tempnam($_ENV['TMP'], 'doc_'); if ($dirname == false) { throw new Exception ('DC117 cannot create tmp file',5000); } unlink($dirname); if ( mkdir($dirname) == false ) { throw new Exception ("DC121 cannot create $dirname directory",5000); } if ( $this->md_id == INVOICE_STD) { $file_to_parse=str_replace( array('/', '*', '<', '>', ';', ',', '\\', '.', ':', '(', ')', ' ', '[', ']') , "-" , "inv-std-".$p_array['e_pj']).".pdf"; $this->d_number=$this->db->get_next_seq("seq_doc_type_stdinv"); $this->d_filename=$file_to_parse; $this->d_mimetype="application/pdf"; $this->d_name=$file_to_parse; $standard_invoice=new \Noalyss\Invoice_PDF($this->db,$dirname,$file_to_parse); $standard_invoice->set_data($p_array); $standard_invoice->export(); $this->saveGenerated($dirname.DIRECTORY_SEPARATOR.$file_to_parse); $href=http_build_query(array('gDossier'=>Dossier::id(), "d_id"=>$this->d_id, 'act'=>'RAW:document')); $ret='<A class="mtitle" HREF="export.php?'.$href.'">'._('Document').'</A>'; return $ret; } $this->db->start(); $dm_info="select md_name,md_type,md_lob,md_filename,md_mimetype
                     from document_modele where md_id=$1"; $Res=$this->db->exec_sql($dm_info, [$this->md_id]); $row=Database::fetch_array($Res, 0); $this->d_lob=$row['md_lob']; $this->d_filename=$row['md_filename']; $this->d_mimetype=$row['md_mimetype']; $this->d_name=$row['md_name']; chdir($dirname); $filename=($p_filename == "")?$row['md_filename']:$p_filename; $filename= sanitize_filename($filename,false); $exp=$this->db->lo_export($row['md_lob'], $dirname.DIRECTORY_SEPARATOR.$filename); if ($exp===false) { record_log(sprintf('DOCUMENT.GENERATE.D1 ,  export failed %s %s',$dirname, $filename)); throw new Exception(sprintf(_("Export a échoué pour %s"), $filename)); } $type="n"; if (strpos($row['md_mimetype'], 'vnd.oasis')!=0) { ob_start(); $zip=new Zip_Extended; if ($zip->open($filename)===TRUE) { $zip->extractTo($dirname.DIRECTORY_SEPARATOR); $zip->close(); } else { record_log(sprintf('DOCUMENT.GENERATE.D2  unzip failed %s', $filename)); throw new Exception(sprintf(_("Décompression a échoué %s", $filename))); } unlink($filename); ob_end_clean(); $file_to_parse="content.xml"; $type="OOo"; } else { $file_to_parse=$filename; } $this->d_number=$this->db->get_next_seq("seq_doc_type_".$row['md_type']); $this->parseDocument($dirname, $file_to_parse, $type, $p_array); $this->db->commit(); if (strpos($row['md_mimetype'], 'vnd.oasis')!=0) { ob_start(); $zip=new Zip_Extended; $res=$zip->open($filename, ZipArchive::CREATE); if ($res!==TRUE) { record_log(sprintf('DOCUMENT.GENERATE.D3  zip failed %s', $filename)); throw new Exception(_('Echec compression'),5000); } $zip->add_recurse_folder($dirname.DIRECTORY_SEPARATOR); $zip->close(); ob_end_clean(); $file_to_parse=$filename; } if ($p_filename!="") { $this->d_filename=$this->compute_filename($p_filename, $this->d_filename); } $this->saveGenerated($dirname.DIRECTORY_SEPARATOR.$file_to_parse); $href=http_build_query(array('gDossier'=>Dossier::id(), "d_id"=>$this->d_id, 'act'=>'RAW:document')); $ret='<A class="mtitle" HREF="export.php?'.$href.'">'._('Document').'</A>'; return $ret; } catch (Exception $e) { record_log($e); return span(_("Génération du document a échoué"),'class="notice"'); } } function parseDocument($p_dir, $p_file, $p_type, $p_array) { $infile_name=$p_dir.DIRECTORY_SEPARATOR.$p_file; $h=fopen($infile_name, "r"); $temp_dir=$_ENV['TMP']; if (is_dir($temp_dir)==false) { if (mkdir($temp_dir)==false) { $msg=sprintf("D221."._("Ne peut pas créer le répertoire %s"), $temp_dir); record_log("D221".$msg); throw new Exception($msg); } } $output_name=tempnam($temp_dir, "gen_doc_"); $output_file=fopen($output_name, "w+"); if ($h===false) { $msg=sprintf("D232"._("Ne peut pas ouvrir [%s] [%s]"), $p_dir, $p_file); record_log("D232".$msg); throw new Exception($msg); } if ($output_file==false) { $msg=sprintf("D264."._("Ne peut pas ouvrir [%s] [%s]"), $p_dir, $output_name); record_log($msg); throw new Exception($msg); } if ($p_type=='OOo') { $regex="/=*&lt;&lt;[A-Z]+_*[A-Z]*_*[A-Z]*_*[A-Z]*_*[0-9]*&gt;&gt;/i"; $lt="&lt;"; $gt="&gt;"; } else { $regex="/=*<<[A-Z]+_*[A-Z]*_*[A-Z]*_*[A-Z]*_*[0-9]*>>/i"; $lt="<"; $gt=">"; } while (!feof($h)) { $buffer=fgets($h); while (preg_match_all($regex, $buffer, $f)>0) { foreach ($f as $apattern) { foreach ($apattern as $pattern) { $to_remove=$pattern; $tag=noalyss_str_replace($lt, '', $pattern); $tag=noalyss_str_replace($gt, '', $tag); $value=$this->replace($tag, $p_array); if (strpos($value??"", 'ERROR')!=false) $value=""; $buffer=\Document::replace_value($buffer, $pattern, $value, 1, $p_type); } } } fwrite($output_file, $buffer); } fclose($h); fclose($output_file); if (($ret=copy($output_name, $infile_name))==FALSE) { $msg="D299 ".sprintf(_('Ne peut pas sauver [%s] vers [%s] code erreur = [%s]'), $output_name, $infile_name, $ret); record_log($msg); throw new Exception($msg); } } protected function saveGenerated($p_file) { $doc=new Document($this->db); $this->db->start(); $this->d_lob=$this->db->lo_import($p_file); if ($this->d_lob==false) { echo "ne peut pas importer [$p_file]"; return 1; } $sql="insert into document(ag_id,d_lob,d_number,d_filename,d_mimetype)
             values ($1,$2,$3,$4,$5)"; $this->db->exec_sql($sql, array($this->ag_id, $this->d_lob, $this->d_number, $this->d_filename, $this->d_mimetype)); $this->d_id=$this->db->get_current_seq("document_d_id_seq"); unlink($p_file); $this->db->commit(); return 0; } function download($aDocument) { if (empty($aDocument)||is_array($aDocument)==false) { throw new Exception("Document.download expects an array"); } $dirname=tempnam($_ENV['TMP'], 'document_dwnall'); unlink($dirname); mkdir($dirname); $nb_document=count($aDocument); $nCopy=0; $this->db->start(); for ($i=0; $i<$nb_document; $i++) { if ( ! $aDocument[$i] instanceof Document ) { throw new Exception("Document.download.2 element is not a document object"); } $filename=$dirname.DIRECTORY_SEPARATOR.$aDocument[$i]->d_filename; if (file_exists($filename)) { while (true) { $nCopy++; $filename=$dirname.DIRECTORY_SEPARATOR.$nCopy."-".$aDocument[$i]->d_filename; if (!file_exists($filename)) { $nCopy=0; break; } } } $this->db->lo_export($aDocument[$i]->d_lob,$filename); } $zip=new Zip_Extended(); $name="document-".date ("Ymd-His").".zip"; if ( $zip->open($_ENV['TMP'].DIRECTORY_SEPARATOR.$name , ZipArchive::CREATE) != true) { die("Cannot create zip file"); } $zip->add_recurse_folder($dirname . "/"); $zip->close(); ini_set('zlib.output_compression', 'off'); header("Pragma: public"); header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT"); header("Cache-Control: must-revalidate"); header('Content-type: zip/application'); header('Content-Disposition: attachment;filename="'.$name.'"', FALSE); header("Accept-Ranges: bytes"); $file=fopen($_ENV['TMP'].DIRECTORY_SEPARATOR.$name, 'r'); while (!feof($file)) { echo fread($file, 8192); } fclose($file); $this->db->commit(); } function upload($p_ag_id) { if (sizeof($_FILES)==0) return; $this->db->start(); $name=$_FILES['file_upload']['name']; $document_saved=array(); $http=new HttpInput(); $aDescription=$http->post("input_desc","array",array()); $description=""; for ($i=0; $i<sizeof($name); $i++) { $new_name=tempnam($_ENV['TMP'], 'doc_'); if (strlen($_FILES['file_upload']['tmp_name'][$i])!=0) { if (move_uploaded_file($_FILES['file_upload']['tmp_name'][$i], $new_name)) { $oid=$this->db->lo_import($new_name); if ($oid==false) { $this->db->rollback(); return 1; } } $this->d_lob=$oid; $this->d_filename=$_FILES['file_upload']['name'][$i]; $this->d_mimetype=$_FILES['file_upload']['type'][$i]; if ( isset($aDescription[$i])) { $description=strip_tags($aDescription[$i]??""); } $this->d_description=$description; $sql="insert into document (ag_id, d_lob,d_filename,d_mimetype,d_number,d_description)" . " values ($1,$2,$3,$4,$5,$6) returning d_id"; $document_id=$this->db->get_value($sql, array($p_ag_id, $this->d_lob, $this->d_filename, $this->d_mimetype, 1, $this->d_description)); $document_saved[]=$document_id; } } $this->db->commit(); return $document_saved; } static function insert_existing_document($p_ag_id, $p_lob, $p_filename, $p_mimetype, $p_description="") { global $cn; $sql="insert into document (ag_id, d_lob,d_filename,d_mimetype,d_number,d_description) " . "values ($1,$2,$3,$4,$5,$6)"; $cn->exec_sql($sql, array($p_ag_id, $p_lob, $p_filename, $p_mimetype, 1, $p_description)); } function anchor() { if ($this->d_id==0) return ''; $image='<IMG SRC="image/insert_table.gif" title="'.$this->d_filename.'" border="0">'; $r=""; $href=http_build_query(array('gDossier'=>Dossier::id(), "d_id"=>$this->d_id, 'act'=>'RAW:document')); $r='<A class="mtitle" HREF="export.php?'.$href.'">'.$image.'</A>'; return $r; } function send() { $this->db->start(); $ret=$this->db->exec_sql( "select d_id,d_lob,d_filename,d_mimetype from document where d_id=$1", [$this->d_id]); if (Database::num_row($ret)==0) { ini_set('zlib.output_compression', 'Off'); header("Pragma: public"); header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT"); header("Cache-Control: must-revalidate"); header('Content-type: text'); header('Content-Disposition: attachment;filename="vide.txt"', FALSE); header("Accept-Ranges: bytes"); echo "VIDE-EMPTY"; return; } $row=Database::fetch_array($ret, 0); $tmp=tempnam($_ENV['TMP'], 'document_'); $this->db->lo_export($row['d_lob'], $tmp); $this->d_mimetype=$row['d_mimetype']; $this->d_filename=$row['d_filename']; $file=fopen($tmp, 'r'); ini_set('zlib.output_compression', 'Off'); header("Pragma: public"); header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT"); header("Cache-Control: must-revalidate"); header('Content-type: '.$this->d_mimetype); header('Content-Disposition: attachment;filename="'.$this->d_filename.'"', FALSE); header("Accept-Ranges: bytes"); while (!feof($file)) { echo fread($file, 8192); } fclose($file); unlink($tmp); $this->db->commit(); } function get_all($ag_id) { $res=$this->db->get_array('select d_id, ag_id, d_lob, d_number, d_filename,'. ' d_mimetype,d_description from document where ag_id=$1', array($ag_id)); $a=array(); for ($i=0; $i<sizeof($res); $i++) { $doc=new Document($this->db); $doc->d_id=$res[$i]['d_id']; $doc->ag_id=$res[$i]['ag_id']; $doc->d_lob=$res[$i]['d_lob']; $doc->d_number=$res[$i]['d_number']; $doc->d_filename=$res[$i]['d_filename']; $doc->d_mimetype=$res[$i]['d_mimetype']; $doc->d_description=$res[$i]['d_description']; $a[$i]=clone $doc; } return $a; } function get() { $sql="select * from document where d_id=$1"; $ret=$this->db->exec_sql($sql,[$this->d_id]); if (Database::num_row($ret)==0) { return; } $row=Database::fetch_array($ret, 0); $this->ag_id=$row['ag_id']; $this->d_mimetype=$row['d_mimetype']; $this->d_filename=$row['d_filename']; $this->d_lob=$row['d_lob']; $this->d_number=$row['d_number']; $this->d_description=$row['d_description']; } function replace($p_tag, $p_array) { global $g_parameter,$g_user; $p_tag=strtoupper($p_tag); $p_tag=noalyss_str_replace('=', '', $p_tag); $r="Tag inconnu"; static $aComment=NULL; static $counter_comment=1; static $aRelatedAction=NULL; static $counter_related_action=0; static $aRelatedOperation=NULL; static $counter_related_operation=0; static $aFileAttached=NULL; static $counter_file=0; static $aOtherCard=NULL; static $counter_other_card=0; static $aTag=NULL; static $counter_tag=0; static $aParameterExtra=NULL; switch ($p_tag) { case 'DATE': $r=(isset($p_array['ag_timestamp']))?$p_array['ag_timestamp']:$p_array['e_date']; break; case 'DATE_CALC': $r=' '; if (isset($p_array['ag_timestamp'])) { $date=format_date($p_array['ag_timestamp'], 'DD.MM.YYYY', 'YYYY-MM-DD'); $r=$date; } if (isset($p_array['e_date'])) { $date=format_date($p_array['e_date'], 'DD.MM.YYYY', 'YYYY-MM-DD'); $r=$date; } return $r; break; case 'MY_NAME': $r=$g_parameter->MY_NAME; break; case 'MY_POSTCODE': case 'MY_CP': $r=$g_parameter->MY_POSTCODE; break; case 'MY_CITY': case 'MY_COMMUNE': $r=$g_parameter->MY_CITY; break; case 'MY_TVA': $r=$g_parameter->MY_TVA; break; case 'MY_STREET': $r=$g_parameter->MY_STREET; break; case 'MY_NUMBER': $r=$g_parameter->MY_NUMBER; break; case 'MY_PHONE': case 'MY_TEL': $r=$g_parameter->MY_PHONE; break; case 'MY_FAX': $r=$g_parameter->MY_FAX; break; case 'MY_COUNTRY': case 'MY_PAYS': $r=$g_parameter->MY_COUNTRY; break; case 'SOLDE': $tiers=new Fiche($this->db); $qcode=isset($p_array['qcode_dest'])?$p_array['qcode_dest']:$p_array['e_client']; $tiers->get_by_qcode($qcode, false); $p=$tiers->get_attribute(ATTR_DEF_ACCOUNT,0); if ( $g_parameter->MY_REPORT == 'Y') { $user_exercice=$g_user->get_exercice(); $start_date=$this->db->get_value("
                        select to_char(min(p_start),'YYYYMMDD') first_day 
                        from parm_periode where p_exercice=$1" ,[$user_exercice]); $end_date =$this->db->get_value("
                            select to_char(max(p_end),'YYYYMMDD') last_day
                            from parm_periode where p_exercice=$1" ,[$user_exercice]); $a=$tiers->get_solde_detail(" to_char(jrnx.j_date,'YYYYMMDD')>='{$start_date}' and to_char(jrnx.j_date,'YYYYMMDD') <= '{$end_date}' "); $r = round($a['solde'],4); }else { $a=$tiers->get_solde_detail(); $r = round($a['solde'],4); } break; case 'CUST_NAME': $tiers=new Fiche($this->db); $qcode=isset($p_array['qcode_dest'])?$p_array['qcode_dest']:$p_array['e_client']; $tiers->get_by_qcode($qcode, false); $r=$tiers->get_attribute(ATTR_DEF_NAME,0); break; case 'CUST_ADDR_1': $tiers=new Fiche($this->db); $qcode=isset($p_array['qcode_dest'])?$p_array['qcode_dest']:$p_array['e_client']; $tiers->get_by_qcode($qcode, false); $r=$tiers->get_attribute(ATTR_DEF_ADRESS,0); break; case 'CUST_CP': $tiers=new Fiche($this->db); $qcode=isset($p_array['qcode_dest'])?$p_array['qcode_dest']:$p_array['e_client']; $tiers->get_by_qcode($qcode, false); $r=$tiers->get_attribute(ATTR_DEF_POSTCODE,0); break; case 'CUST_CITY': $tiers=new Fiche($this->db); $qcode=isset($p_array['qcode_dest'])?$p_array['qcode_dest']:$p_array['e_client']; $tiers->get_by_qcode($qcode, false); $r=$tiers->get_attribute(ATTR_DEF_CITY,0); break; case 'CUST_CO': $tiers=new Fiche($this->db); $qcode=isset($p_array['qcode_dest'])?$p_array['qcode_dest']:$p_array['e_client']; $tiers->get_by_qcode($qcode, false); $r=$tiers->get_attribute(ATTR_DEF_COUNTRY,0); break; case 'CUST_VAT': $tiers=new Fiche($this->db); $qcode=isset($p_array['qcode_dest'])?$p_array['qcode_dest']:$p_array['e_client']; $tiers->get_by_qcode($qcode, false); $r=$tiers->get_attribute(ATTR_DEF_NUMTVA,0); break; case 'CUST_NUM': $tiers=new Fiche($this->db); $qcode=isset($p_array['qcode_dest'])?$p_array['qcode_dest']:$p_array['e_client']; $tiers->get_by_qcode($qcode, false); $r=$tiers->get_attribute(ATTR_DEF_NUMBER_CUSTOMER,0); break; case 'CUST_BANQUE_NO': $tiers=new Fiche($this->db); $qcode=isset($p_array['qcode_dest'])?$p_array['qcode_dest']:$p_array['e_client']; $tiers->get_by_qcode($qcode, false); $r=$tiers->get_attribute(ATTR_DEF_BQ_NO,0); break; case 'CUST_BANQUE_NAME': $tiers=new Fiche($this->db); $qcode=isset($p_array['qcode_dest'])?$p_array['qcode_dest']:$p_array['e_client']; $tiers->get_by_qcode($qcode, false); $r=$tiers->get_attribute(ATTR_DEF_BQ_NAME,0); break; case 'BENEF_NAME': $tiers=new Fiche($this->db); $qcode=isset($p_array['qcode_benef'])?$p_array['qcode_benef']:''; if ($qcode=='') { $r=''; break; } $tiers->get_by_qcode($qcode, false); $r=$tiers->get_attribute(ATTR_DEF_NAME,0); break; case 'BENEF_ADDR_1': $tiers=new Fiche($this->db); $qcode=isset($p_array['qcode_benef'])?$p_array['qcode_benef']:''; if ($qcode=='') { $r=''; break; } $tiers->get_by_qcode($qcode, false); $r=$tiers->get_attribute(ATTR_DEF_ADRESS,0); break; case 'BENEF_CP': $tiers=new Fiche($this->db); $qcode=isset($p_array['qcode_benef'])?$p_array['qcode_benef']:''; if ($qcode=='') { $r=''; break; } $tiers->get_by_qcode($qcode, false); $r=$tiers->get_attribute(ATTR_DEF_POSTCODE,0); break; case 'BENEF_CITY': $tiers=new Fiche($this->db); $qcode=isset($p_array['qcode_benef'])?$p_array['qcode_benef']:''; if ($qcode=='') { $r=''; break; } $tiers->get_by_qcode($qcode, false); $r=$tiers->get_attribute(ATTR_DEF_CITY,0); break; case 'BENEF_CO': $tiers=new Fiche($this->db); $qcode=isset($p_array['qcode_benef'])?$p_array['qcode_benef']:''; if ($qcode=='') { $r=''; break; } $tiers->get_by_qcode($qcode, false); $r=$tiers->get_attribute(ATTR_DEF_COUNTRY,0); break; case 'BENEF_VAT': $tiers=new Fiche($this->db); $qcode=isset($p_array['qcode_benef'])?$p_array['qcode_benef']:''; if ($qcode=='') { $r=''; break; } $tiers->get_by_qcode($qcode, false); $r=$tiers->get_attribute(ATTR_DEF_NUMTVA,0); break; case 'BENEF_NUM': $tiers=new Fiche($this->db); $qcode=isset($p_array['qcode_benef'])?$p_array['qcode_benef']:''; if ($qcode=='') { $r=''; break; } $tiers->get_by_qcode($qcode, false); $r=$tiers->get_attribute(ATTR_DEF_NUMBER_CUSTOMER,0); break; case 'BENEF_BANQUE_NO': $tiers=new Fiche($this->db); $qcode=isset($p_array['qcode_benef'])?$p_array['qcode_benef']:''; if ($qcode=='') { $r=''; break; } $tiers->get_by_qcode($qcode, false); $r=$tiers->get_attribute(ATTR_DEF_BQ_NO,0); break; case 'BENEF_BANQUE_NAME': $tiers=new Fiche($this->db); $qcode=isset($p_array['qcode_benef'])?$p_array['qcode_benef']:''; if ($qcode=='') { $r=''; break; } $tiers->get_by_qcode($qcode, false); $r=$tiers->get_attribute(ATTR_DEF_BQ_NAME,0); break; case 'NUMBER': $r=$this->d_number; break; case "DOCUMENT_ID": if (isset($p_array['ag_id'])) return $p_array['ag_id']; return ""; break; case 'USER' : return $_SESSION[SESSION_KEY.'use_name'].', '.$_SESSION[SESSION_KEY.'use_first_name']; break; case 'REFERENCE': $act=new Follow_Up($this->db); $act->ag_id=$this->ag_id; $act->get(); $r=$act->ag_ref; break; case 'DATE_LIMIT_CALC': if (isset($p_array["e_ech"])) return format_date($p_array["e_ech"], 'DD.MM.YYYY', 'YYYY-MM-DD'); if (isset($p_array["ech"])) return format_date($p_array["ech"], 'DD.MM.YYYY', 'YYYY-MM-DD'); if (isset($p_array["ag_remind_date"])) return format_date($p_array["ag_remind_date"], 'DD.MM.YYYY', 'YYYY-MM-DD'); return ""; break; case 'DATE_LIMIT': if (isset($p_array["ech"])) return $p_array["ech"]; if (isset($p_array["e_ech"])) return $p_array["e_ech"]; if (isset($p_array["ag_remind_date"])) return $p_array["ag_remind_date"]; return ""; break; case 'DATE_PAID': if ( isset ($p_array['jr_date_paid']) ) { return $p_array['jr_date_paid'];} break; case 'MARCH_NEXT': $this->counter++; $r=''; break; case 'VEN_ART_NAME': if (!isset($p_array["e_march".$this->counter])) return ""; if ($p_array['e_march'.$this->counter.'_price']!=0&&$p_array['e_quant'.$this->counter]!=0) { $f=new Fiche($this->db); $f->get_by_qcode($p_array["e_march".$this->counter], false); $r=$f->get_attribute(ATTR_DEF_NAME,0); } else $r=""; break; case 'VEN_ART_LABEL': $id='e_march'.$this->counter."_label"; if (!isset($p_array[$id])||(isset($p_array[$id])&&noalyss_strlentrim($p_array[$id])==0)) { $id='e_march'.$this->counter; if (!isset($p_array[$id])) $r=""; else { if ($p_array['e_march'.$this->counter.'_price']!=0&&$p_array['e_quant'.$this->counter]!=0) { $f=new Fiche($this->db); $f->get_by_qcode($p_array[$id], false); $r=$f->get_attribute(ATTR_DEF_NAME,0); } else $r=""; } } else $r=$p_array[$id]; break; case 'VEN_ART_STOCK_CODE': $id='e_march'.$this->counter; if (!isset($p_array[$id])) $r=""; else { if ($p_array['e_march'.$this->counter.'_price']!=0&&$p_array['e_quant'.$this->counter]!=0) { $f=new Fiche($this->db); $f->get_by_qcode($p_array[$id], false); $r=$f->get_attribute(ATTR_DEF_STOCK,0); $r=($r==NOTFOUND)?'':$r; } } break; case 'VEN_QCODE': $id='e_march'.$this->counter; if (!isset($p_array[$id])) return ""; return $p_array[$id]; break; case 'VEN_ART_PRICE': $id='e_march'.$this->counter.'_price'; if (!isset($p_array[$id])) return ""; if ($p_array[$id]==0) return ""; $r=$p_array[$id]; break; case 'TVA_RATE': case 'VEN_ART_TVA_RATE': $id='e_march'.$this->counter.'_tva_id'; if (!isset($p_array[$id])) return ""; if ($p_array[$id]==-1||$p_array[$id]=='') return ""; $march_id='e_march'.$this->counter.'_price'; if (!isset($p_array[$march_id])) return ''; $tva= Acc_Tva::build($this->db,$p_array[$id]); if ($tva->load()==-1) return ''; return $tva->get_parameter("rate"); break; case 'TVA_CODE': case 'VEN_ART_TVA_CODE': $id='e_march'.$this->counter.'_tva_id'; if (!isset($p_array[$id])) return ""; if ($p_array[$id]==-1) return ""; $qt='e_quant'.$this->counter; $price='e_march'.$this->counter.'_price'; if ($p_array[$price]==0||$p_array[$qt]==0||noalyss_strlentrim($p_array[$price])==0||noalyss_strlentrim($p_array[$qt])==0) return ""; $r=$p_array[$id]; break; case 'TVA_LABEL': $id='e_march'.$this->counter.'_tva_id'; if (!isset($p_array[$id])) return ""; $march_id='e_march'.$this->counter.'_price'; if (!isset($p_array[$march_id])) return ''; if ($p_array[$march_id]==0) return ''; $tva= Acc_Tva::build($this->db, $p_array[$id]); if ($tva->load()==-1) return ""; $r=$tva->get_parameter('label'); break; case 'TVA_AMOUNT': case 'VEN_TVA': $qt='e_quant'.$this->counter; $price='e_march'.$this->counter.'_price'; $tva='e_march'.$this->counter.'_tva_id'; if (!isset($p_array[$tva])) return ''; if (!isset($p_array ['e_march'.$this->counter])) return ""; if (!isset($p_array[$tva])) return ""; if ($p_array[$price]==0||$p_array[$qt]==0||noalyss_strlentrim($p_array[$price])==0||noalyss_strlentrim($p_array[$qt])==0) return ""; $r=$p_array['e_march'.$this->counter.'_tva_amount']; break; case 'VEN_ART_TVA': $qt='e_quant'.$this->counter; $price='e_march'.$this->counter.'_price'; $tva='e_march'.$this->counter.'_tva_id'; if (!isset($p_array['e_march'.$this->counter])) return ""; if (!isset($p_array[$tva])) return ""; if ($p_array[$price]==0||$p_array[$qt]==0||noalyss_strlentrim($p_array[$price])==0||noalyss_strlentrim($p_array[$qt])==0) return ""; $oTva= Acc_Tva::build($this->db, $p_array[$tva]); if ($oTva->load()==-1) return ""; $r=noalyss_round($p_array[$price], 2)*$oTva->get_parameter('rate'); $r=noalyss_round($r, 2); break; case 'VEN_ART_TVAC': $qt='e_quant'.$this->counter; $price='e_march'.$this->counter.'_price'; if (!isset($p_array['e_march'.$this->counter])) return ""; if (!isset($p_array['e_march'.$this->counter.'_tva_id'])) return ""; if ($p_array[$price]==0||$p_array[$qt]==0||noalyss_strlentrim($p_array[$price])==0||noalyss_strlentrim($p_array[$qt])==0) return ""; if (!isset($p_array['e_march'.$this->counter.'_tva_id'])) return ''; $tva=Acc_Tva::build($this->db, $p_array['e_march'.$this->counter.'_tva_id']); if ($tva->load()==-1) { $r=noalyss_round($p_array[$price], 2); } else { $r=noalyss_round($p_array[$price]*$tva->get_parameter('rate')+$p_array[$price], 2); } break; case 'VEN_ART_QUANT': $id='e_quant'.$this->counter; if (!isset($p_array[$id])) return ""; if ($p_array['e_march'.$this->counter.'_price']==0||$p_array['e_quant'.$this->counter]==0||noalyss_strlentrim($p_array['e_march'.$this->counter.'_price'])==0||noalyss_strlentrim($p_array['e_quant'.$this->counter])==0) return ""; $r=$p_array[$id]; break; case 'VEN_HTVA': $id='e_march'.$this->counter.'_price'; $quant='e_quant'.$this->counter; if (!isset($p_array[$id])) return ""; if ($p_array['e_march'.$this->counter.'_price']==0||$p_array['e_quant'.$this->counter]==0||noalyss_strlentrim($p_array['e_march'.$this->counter.'_price'])==0||noalyss_strlentrim($p_array['e_quant'.$this->counter])==0) return ""; bcscale(4); $r=noalyss_bcmul($p_array[$id], $p_array[$quant]); $r=noalyss_round($r, 2); break; case 'VEN_TVAC': $id='e_march'.$this->counter.'_tva_amount'; $price='e_march'.$this->counter.'_price'; $quant='e_quant'.$this->counter; if (!isset($p_array['e_march'.$this->counter.'_price'])||!isset($p_array['e_quant'.$this->counter])) { return ""; } if ($p_array['e_march'.$this->counter.'_price']==0||$p_array['e_quant'.$this->counter]==0) { return ""; } bcscale(4); if (!isset($p_array[$id])) $r=noalyss_bcmul($p_array[$price], $p_array[$quant]); else { $r=noalyss_bcmul($p_array[$price], $p_array[$quant]); $r=noalyss_bcadd($r, $p_array[$id]); } $r=noalyss_round($r, 2); return $r; break; case 'TOTAL_VEN_HTVA': bcscale(4); $sum=0.0; if (!isset($p_array["nb_item"])) return ""; for ($i=0; $i<$p_array["nb_item"]; $i++) { $sell='e_march'.$i.'_price'; $qt='e_quant'.$i; if (!isset($p_array[$sell])) break; if (noalyss_strlentrim($p_array[$sell])==0|| noalyss_strlentrim($p_array[$qt])==0|| $p_array[$qt]==0||$p_array[$sell]==0) continue; $tmp1=noalyss_bcmul($p_array[$sell], $p_array[$qt]); $sum=noalyss_bcadd($sum, $tmp1); } $r=noalyss_round($sum, 2); break; case 'TOTAL_VEN_TVAC': if (!isset($p_array["nb_item"])) return ""; $sum=0.0; bcscale(4); for ($i=0; $i<$p_array["nb_item"]; $i++) { $tva='e_march'.$i.'_tva_amount'; $tva_amount=0; if (isset($p_array[$tva])) { $tva_amount=$p_array[$tva]; } $sell=$p_array['e_march'.$i.'_price']; $qt=$p_array['e_quant'.$i]; $tot=noalyss_bcmul($sell, $qt); $tva_amount=noalyss_round($tva_amount,2); $tot=noalyss_round($tot,2); $tot=noalyss_bcadd($tot, $tva_amount); $sum=noalyss_bcadd($sum, $tot??0); } $r=noalyss_round($sum??0, 2); break; case 'TOTAL_TVA': if (!isset($p_array["nb_item"])) return ""; $sum=0.0; for ($i=0; $i<$p_array["nb_item"]; $i++) { $tva='e_march'.$i.'_tva_amount'; if (!isset($p_array[$tva])) $tva_amount=0.0; else { $tva_amount=$p_array[$tva]; $tva_amount=($tva_amount=="")?0:$tva_amount; } $sum+=$tva_amount; $sum=noalyss_round($sum, 2); } $r=$sum; break; case 'BON_COMMANDE': if (isset($p_array['bon_comm'])) return $p_array['bon_comm']; else return ""; break; case 'PJ': if (isset($p_array['e_pj'])) return $p_array['e_pj']; else return ""; case 'OTHER_INFO': if (isset($p_array['other_info'])) return $p_array['other_info']; else return ""; break; case 'LABELOP': if (isset($p_array['e_comm'])) return $p_array['e_comm']; break; case 'ACOMPTE': if (isset($p_array['acompte'])) return $p_array['acompte']; return "0"; break; case 'STOCK_NAME': if (!isset($p_array['repo'])) return ""; $ret=$this->db->get_value('select r_name from public.stock_repository where r_id=$1', array($p_array['repo'])); return $ret; case 'STOCK_ADRESS': if (!isset($p_array['repo'])) return ""; $ret=$this->db->get_value('select r_adress from public.stock_repository where r_id=$1', array($p_array['repo'])); return $ret; case 'STOCK_COUNTRY': if (!isset($p_array['repo'])) return ""; $ret=$this->db->get_value('select r_country from public.stock_repository where r_id=$1', array($p_array['repo'])); return $ret; case 'STOCK_CITY': if (!isset($p_array['repo'])) return ""; $ret=$this->db->get_value('select r_city from public.stock_repository where r_id=$1', array($p_array['repo'])); return $ret; case 'STOCK_PHONE': if (!isset($p_array['repo'])) return ""; $ret=$this->db->get_value('select r_phone from public.stock_repository where r_id=$1', array($p_array['repo'])); return $ret; case 'TITLE': if (isset($p_array['ag_title'])) return $p_array['ag_title']; return ""; break; case 'DESCRIPTION': if (isset($p_array['ag_id'])) { $description=$this->db->get_value("select agc_comment " ."  from action_gestion_comment " ."where ag_id=$1 order by AGC_ID asc limit 1" , [$p_array['ag_id']]); return $description; } if ( isset($p_array['e_comm'])) {return $p_array['e_comm'] ; } return ""; break; case 'COMMENT': if (isset($p_array['ag_id'])) { if ($aComment==NULL) { $aComment=$this->db->get_array("select AGC_ID,agc_comment ," ." to_char(agc_date,'DD-MM-YY HH24:MI') as str_date ," ." tech_user " ."  from action_gestion_comment " ."where ag_id=$1 order by 1" , [$p_array['ag_id']]); } $nb_comment=count($aComment); $description=""; if (count($aComment)>$counter_comment) { $description.=sprintf(_('le %s , %s écrit %s'), $aComment[$counter_comment]['str_date'], $aComment[$counter_comment]['tech_user'], $aComment[$counter_comment]['agc_comment']); $counter_comment++; } return $description; } return ""; break; case 'RELATED_ACTION': if (isset($p_array['ag_id'])) { if ($aRelatedAction==NULL) { $followup=new Follow_Up($this->db, $p_array["ag_id"]); $aRelatedAction=array(); $aParent=$followup->get_parent(); if ($aParent==-1) return ""; $nb_parent=count($aParent); $sql_related_action="
                 select ag_id,
                    f_id_dest,
                    (select ad_value from fiche_detail fd1 where fd1.ad_id=23 and fd1.f_id=f_id_dest) as qcode,
                    (select ad_value from fiche_detail fd1 where fd1.ad_id=1 and fd1.f_id=f_id_dest) as card_name,
                    (select ad_value from fiche_detail fd1 where fd1.ad_id=32 and fd1.f_id=f_id_dest) as card_fname,
                    ag_title,
                    to_char(ag_timestamp,'DD.MM.YYYY') as strdate,
                    ag_ref
                    from action_gestion ag where ag_id=$1 "; for ($x=0; $x<$nb_parent; $x++) { $aRelatedAction[]=$this->db->get_row($sql_related_action, [$aParent[$x]['aga_least']]); $aChild=$followup->get_children($aParent[$x]['aga_least']); $nb_child=count($aChild); for ($y=0; $y<$nb_child; $y++) { $aRelatedAction[]=$this->db->get_row($sql_related_action, [$aChild[$y]['aga_greatest']]); } } } $description=""; if (count($aRelatedAction)>$counter_related_action) { $description=sprintf("docid %s %s %s %s %s %s %s", $aRelatedAction[$counter_related_action]['ag_id'], $aRelatedAction[$counter_related_action]['ag_ref'], $aRelatedAction[$counter_related_action]['strdate'], $aRelatedAction[$counter_related_action]['qcode'], $aRelatedAction[$counter_related_action]['card_fname'], $aRelatedAction[$counter_related_action]['card_name'], $aRelatedAction[$counter_related_action]['ag_title'] ); $counter_related_action++; } return $description; } return ""; break; case 'CONCERNED_OPERATION': if (isset($p_array['ag_id'])) { if ($aRelatedOperation==NULL) { $aRelatedOperation=$this->db->get_array("select ago_id,
                        j.jr_id,
                        j.jr_internal,
                        j.jr_comment,
                        j.jr_pj_number,
                        to_char(j.jr_date,'DD.MM.YY') as str_date
			from jrn as j 
                        join action_gestion_operation as ago on (j.jr_id=ago.jr_id)
			where ag_id=$1 order by jr_date,jr_id" , [$p_array['ag_id']]); } $description=""; if (count($aRelatedOperation)>$counter_related_operation) { $description.=sprintf('%s %s %s %s ', $aRelatedOperation[$counter_related_operation]['str_date'], $aRelatedOperation[$counter_related_operation]['jr_internal'], $aRelatedOperation[$counter_related_operation]['jr_comment'], $aRelatedOperation[$counter_related_operation]['jr_pj_number'] ); $counter_related_operation++; } return $description; } return ""; break; case 'OTHER_CARDS': if (isset($p_array['ag_id'])) { if ($aOtherCard==NULL) { $aOtherCard=$this->db->get_array("
                        select 
                        (select ad_value from fiche_detail where f_id = ap.f_id and ad_id = 1) as cname,
                        (select ad_value from fiche_detail where f_id = ap.f_id and ad_id = 32) as cfname,
                        (select ad_value from fiche_detail where f_id = ap.f_id and ad_id = 23) as qcode,
                        (select ad_value from fiche_detail where f_id = ap.f_id and ad_id = 18 ) as email,
                        (select ad_value from fiche_detail where f_id = ap.f_id and ad_id = 27 ) as mobile,
                        (select ad_value from fiche_detail where f_id = ap.f_id and ad_id = 17 ) as phone
                         from action_person ap  
                         where ag_id=$1
                            " , [$p_array['ag_id']]); } $description=""; if (count($aOtherCard)>$counter_other_card) { $description.=sprintf('%s %s %s %s %s %s ', $aOtherCard[$counter_other_card]['cname'], $aOtherCard[$counter_other_card]['cfname'], $aOtherCard[$counter_other_card]['qcode'], $aOtherCard[$counter_other_card]['email'], $aOtherCard[$counter_other_card]['phone'], $aOtherCard[$counter_other_card]['mobile']); $counter_other_card++; } return $description; } return ""; break; case 'ATTACHED_FILES': if (isset($p_array['ag_id'])) { if ($aFileAttached==NULL) { $aFileAttached=$this->db->get_array("
                        select d_filename,d_description from document d  where ag_id=$1
                            " , [$p_array['ag_id']]); } $nb_comment=count($aFileAttached); $description=""; if (count($aFileAttached)>$counter_file) { $description.=sprintf("%s %s ", $aFileAttached[$counter_file]['d_filename'], $aFileAttached [$counter_file]['d_description']); $counter_file++; } return $description; } return ""; break; case 'TAGS': if (isset($p_array['ag_id'])) { if ($aTag==NULL) { $aTag=$this->db->get_array("
                       select t_tag from action_tags at2 join tags t using(t_id)  where ag_id=$1 order by upper(t_tag)
                            " , [$p_array['ag_id']]); } $description=""; if (count($aTag)>$counter_tag) { $description.=sprintf("%s ", $aTag [$counter_tag]['t_tag']); $counter_tag++; } return $description; } return ""; break; case 'COMM_PAYMENT': if (isset($p_array["e_comm_paiement"])) { return $p_array["e_comm_paiement"]; } else { return ""; } case 'PRIORITY': if (isset($p_array['ag_priority'])) { $aPriority=array(1=>_("Haute"), 2=>_("Normale"), 3=>_("Basse")); return $aPriority[$p_array["ag_priority"]]; } return ""; case 'GROUPMGT': if (isset($p_array['ag_dest'])) { $profile=$this->db->get_value("select p_name from profile where p_id=$1", array($p_array['ag_dest'])); return $profile; } return ""; case 'HOUR': if (isset($p_array['ag_hour'])) { return $p_array["ag_hour"]; } return ""; case 'STATUS': if (isset($p_array['ag_state'])) { $status=$this->db->get_value("
                            select s_value from document_state where s_id=$1", array($p_array['ag_state'])); return $status; } return ""; case 'DOCUMENT_TYPE': $ret=""; if (isset($p_array['ag_id'])) { $ret=$this->db->get_value("select dt_value 
                                             from action_gestion 
                                             join document_type dt  on (ag_type=dt.dt_id) 
                            where ag_id=$1", array($p_array["ag_id"])); } elseif (isset($p_array['gen_doc'])) { if ( $p_array['gen_doc'] == -2) return _("Facture standard"); $ret = $this->db->get_value("
                                        select md_name from public.document_modele where md_id=$1", [$p_array['gen_doc']]); } return $ret; case 'NOTE': return strip_tags(html_entity_decode($p_array['jrn_note_input']??"")); } if (preg_match('/^ATTR/', $p_tag)==1) { $r=""; if (isset($p_array['e_march'.$this->counter])) { $id=$p_array['e_march'.$this->counter]; $r=$this->replace_special_tag($id, $p_tag); return $r; } } if (preg_match('/^BENEFATTR/', $p_tag)==1) { $r=""; $qcode=isset($p_array['qcode_benef'])?$p_array['qcode_benef']:''; $r=$this->replace_special_tag($qcode, $p_tag); return $r; } if (preg_match('/^CUSTATTR/', $p_tag)==1) { $r=""; if (isset($p_array['qcode_dest'])||isset($p_array['e_client'])) { $qcode=(isset($p_array['qcode_dest']))?$p_array['qcode_dest']:$p_array['e_client']; $r=$this->replace_special_tag($qcode, $p_tag); } return $r; } $pe_value=$this->db->get_value("select pe_value from parameter_extra where pe_code=$1",[$p_tag]); if ( $this->db->count() > 0 ) { return $pe_value;} return $r; } function remove() { $d_lob=$this->db->get_value('select d_lob from document where d_id=$1', array($this->d_id)); $sql='delete from document where d_id='.$this->d_id; $this->db->exec_sql($sql); if ($d_lob!=0) $this->db->lo_unlink($d_lob); } function replace_special_tag($p_qcode, $p_tag) { if ($p_qcode=="") return ""; $f=new Fiche($this->db); $found=$f->get_by_qcode($p_qcode, false); if ($found==1) return ""; $attr=preg_replace("/^.*ATTR/", "", $p_tag); if (isNumber($attr)==0) return ""; $ad_type=$this->db->get_value("select ad_type from attr_def where ad_id=$1", array($attr)); $ad_value=$this->db->get_value("select ad_value from fiche_detail where f_id=$1 and ad_id=$2", array($f->id, $attr)); if ($ad_type=="select") { $sql=$this->db->get_value("select ad_extra from attr_def where ad_id=$1", array($attr)); $array=$this->db->make_array($sql); for ($a=0; $a<count($array); $a++) { if ($array[$a]['value']==$ad_value) return $array[$a]['label']; } } return $ad_value; } function update_description($p_desc) { $this->db->exec_sql('update document set d_description = $1 where d_id=$2', array($p_desc, $this->d_id)); } static function replace_value($p_buffer, $p_pattern, $p_value, $p_limit=-1, $p_type='OOo') { $check=$p_pattern; $p_value=$p_value??''; $check=str_replace(['&lt;', '&gt;', '<', '>', '='], "", $check); if (preg_replace('/[^[:alnum:]^_]/', '', $check)!=$check) { throw new Exception(sprintf(_("chaine à remplacer [%s] contient un caractère interdit"), $p_pattern)); } $count=0; if (is_numeric($p_value)&&$p_type=='OOo') { $searched='/office:value-type="string"><text:p>'.$p_pattern.'/i'; $replaced='office:value-type="float" office:value="'.$p_value.'"><text:p>'.$p_value; $p_buffer=preg_replace($searched, $replaced, $p_buffer, $p_limit, $count); if ($count==0) { $searched='/office:value-type="string" calcext:value-type="string"><text:p>(<text:s\/>)*'.$p_pattern.'/i'; $replaced='office:value-type="float" office:value="'.$p_value.'"  calcext:value-type="float"><text:p>'.$p_value; $p_buffer=preg_replace($searched, $replaced, $p_buffer, $p_limit, $count); } } if ($count==0) { if ($p_type=='OOo') { $p_value=noalyss_str_replace('&', '&amp;', $p_value); $p_value=noalyss_str_replace('<', '&lt;', $p_value); $p_value=noalyss_str_replace('>', '&gt;', $p_value); $p_value=noalyss_str_replace('"', '&quot;', $p_value); $p_value=noalyss_str_replace("'", '&apos;', $p_value); } $p_buffer=preg_replace('/'.$p_pattern.'/i', $p_value, $p_buffer, $p_limit); } return $p_buffer; } function export_file($p_destination_file) { if ($this->d_id==0) { return false; } $this->db->start(); $ret=$this->db->exec_sql( "select d_id,d_lob,d_filename,d_mimetype from document where d_id=$1", [$this->d_id]); if (Database::num_row($ret)==0) { return false; } $row=Database::fetch_array($ret, 0); $tmp=$p_destination_file; if ( $this->db->lo_export($row['d_lob'], $tmp) == true) { $this->d_mimetype=$row['d_mimetype']; $this->d_filename=$row['d_filename']; $this->db->commit(); return true; } else { $this->db->commit(); return false; } } function transform2pdf() { $dirname=tempnam($_ENV['TMP'],"document"); if ( $dirname == false ) { throw new Exception("D1862.cannot create tmp file",5000); } unlink($dirname); umask(0); if ( mkdir($dirname) == false ) { throw new Exception("D1868.cannot create tmp directory",5000); } if ( $this->d_mimetype == "application/pdf") { $destination_file=$dirname."/".$this->d_filename; $this->export_file($destination_file); return $dirname."/".$destination_file; return; } if (GENERATE_PDF == 'NO' ) { \record_log(__FILE__."D1857 PDF not available"); throw new \Exception("Cannot not transform to PDF",5000); } $destination_file=$dirname."/".$this->d_filename; $this->export_file($destination_file); ob_start(); passthru(OFFICE . escapeshellarg($destination_file), $status); $result =ob_get_contents(); ob_end_clean(); if ($status != 0) { \record_log(__FILE__."D1879 Error  cannot transform into PDF"." output [$result]"); throw new \Exception("D1879 Cannot not transform to PDF"); } $ext = strrpos($this->d_filename, "."); $pdf_file = substr($this->d_filename, 0, $ext); $pdf_file .=".pdf"; return $dirname."/".$pdf_file; } } 