<?php
 abstract class Acc_Ledger_History { protected $m_from; protected $m_to; protected $ma_ledger; protected $m_mode; public $db; protected $ledger_type; protected $filter_operation; protected $data; function __construct(Database $cn, $pa_ledger, $p_from, $p_to, $p_mode) { if (is_array($pa_ledger) == FALSE) { throw new Exception (_('pa_ledger doit être un tableau'),EXC_PARAM_VALUE); } $this->db=$cn; $this->ma_ledger=$pa_ledger; $this->m_from=$p_from; $this->m_to=$p_to; $this->m_mode=$p_mode; $this->filter_operation='all'; } public function get_from() { return $this->m_from; } public function get_ledger_type() { return $this->ledger_type; } public function set_ledger_type($ledger_type) { if (! in_array($ledger_type,['ACH','ODS','VEN','FIN'])) { record_log('Acc_Ledger_History:set_ledger_type '.var_export($ledger_type,TRUE)); throw new Exception (_("Donnée invalide",EXC_PARAM_VALUE)); } $this->ledger_type=$ledger_type; return $this; } public function get_to() { return $this->m_to; } public function get_ledger() { return $this->ma_ledger; } public function get_mode() { return $this->m_mode; } public function set_from($m_from) { $this->m_from=$m_from; return $this; } public function set_to($m_to) { $this->m_to=$m_to; return $this; } public function set_a_ledger($ma_ledger) { if (is_array($ma_ledger)==FALSE) throw new Exception(_("invalid parameter"), EXC_PARAM_VALUE); $this->ma_ledger=$ma_ledger; return $this; } public function set_m_mode($m_mode) { if ($m_mode!='E'&&$m_mode!='D'&&$m_mode!='L'&&$m_mode!='A') throw new Exception(_("invalid parameter"), EXC_PARAM_VALUE); $this->m_mode=$m_mode; return $this; } static function factory(Database $cn, $pa_ledger, $p_from, $p_to, $p_mode,$p_paid) { if ($p_mode=="A") { $ret=new Acc_Ledger_History_Generic($cn, $pa_ledger, $p_from, $p_to, $p_mode); return $ret; } $nb_ledger=count($pa_ledger); $ledger=new Acc_Ledger($cn, $pa_ledger[0]); $type=$ledger->get_type(); if ($type=="ODS") { $ret=new Acc_Ledger_History_Generic($cn, $pa_ledger, $p_from, $p_to, $p_mode); return $ret; } for ($i=0; $i<$nb_ledger; $i++) { $ledger=new Acc_Ledger($cn, $pa_ledger[$i]); $type_next=$ledger->get_type(); if ($type_next!=$type) { $ret=new Acc_Ledger_History_Generic($cn, $pa_ledger, $p_from, $p_to, $p_mode); return $ret; } } switch ($type) { case "ACH": $ret=new Acc_Ledger_History_Purchase($cn, $pa_ledger, $p_from, $p_to, $p_mode); $ret->set_filter_operation($p_paid); return $ret; break; case "FIN": $ret=new Acc_Ledger_History_Financial($cn, $pa_ledger, $p_from, $p_to, $p_mode); return $ret; break; case "VEN": $ret=new Acc_Ledger_History_Sale($cn, $pa_ledger, $p_from, $p_to, $p_mode); $ret->set_filter_operation($p_paid); return $ret; break; default: break; } } function get_tiers($p_jrn_type, $jr_id) { if ($p_jrn_type=='ODS') return ' '; $tiers=$this->get_tiers_id($p_jrn_type, $jr_id); if ($tiers==0) return ""; $name=$this->db->get_value('select ad_value from fiche_detail where ad_id=1 and f_id=$1', array($tiers)); $first_name=$this->db->get_value('select ad_value from fiche_detail where ad_id=32 and f_id=$1', array($tiers)); return $name.' '.$first_name; } function get_tiers_id($p_jrn_type, $jr_id) { $tiers=0; switch ($p_jrn_type) { case 'VEN': $tiers=$this->db->get_value('select max(qs_client) ' . 'from quant_sold join jrnx using (j_id) ' . 'join jrn on (jr_grpt_id=j_grpt) where jrn.jr_id=$1', array($jr_id)); break; case 'ACH': $tiers=$this->db->get_value('select max(qp_supplier) ' . ' from quant_purchase ' . ' join jrnx using (j_id) ' . ' join jrn on (jr_grpt_id=j_grpt) ' . ' where jrn.jr_id=$1', array($jr_id)); break; case 'FIN': $tiers=$this->db->get_value('select qf_other from quant_fin where jr_id=$1', array($jr_id)); break; } if ($this->db->count()==0) return 0; return $tiers; } protected function prepare_reconcile_date() { static $not_done=TRUE; if ($not_done ) { $prepare_query = new Prepared_Query($this->db); $prepare_query->prepare_reconcile_date(); } $not_done=FALSE; } abstract function export_accounting_html(); abstract function export_detail_html(); abstract function export_extended_html(); abstract function export_oneline_html(); abstract function export_html(); abstract function get_row($p_limit, $p_offset); protected function build_filter_operation() { switch ( $this->get_filter_operation() ) { case 'all': $sql_filter=""; break; case 'paid': $sql_filter=" and (jr_date_paid is not null or  jr_rapt ='paid' ) "; break; case 'unpaid': $sql_filter=" and (jr_date_paid  is null and coalesce(jr_rapt,'x') <> 'paid' ) "; break; default: throw new Exception(_("Filtre invalide",5)); } return $sql_filter; } function get_filter_operation() { return $this->filter_operation; } public function set_filter_operation($filter_operation) { if (in_array($filter_operation,['all','paid','unpaid'])) { $this->filter_operation=$filter_operation; return $this; } throw new Exception(_("Filter invalide ".$filter_operation),5); } public function has_other_tax() { $str_ledger=join(',',$this->ma_ledger); $count=$this->db->get_value("select count(*) 
                from jrn_tax 
                    join jrnx using (j_id) 
                    join jrn on (jr_grpt_id=j_grpt) 
                    where jr_tech_per>=$1 and jr_tech_per <=$2
                    and jr_def_id in ($str_ledger) ",[$this->m_from,$this->m_to]); return $count; } protected function add_additional_tax_info() { $prepare=$this->db->is_prepare("supp_tax_info"); if ( $prepare == false ){ $this->db->prepare("supp_tax_info","
                select 
                   case when j.j_debit is false and jd.jrn_def_type='ACH'      then 0-j_montant
                      when j.j_debit is true and jd.jrn_def_type='VEN'      then 0-j_montant
                      else j.j_montant end j_montant,
                    jt1.ac_id,
                    ac_label,
                    ac_rate,j_poste 
                from 
                    jrn_tax jt1 
                    join acc_other_tax using (ac_id)
                    join jrnx j using (j_id) 
                    join jrn_def jd on (j.j_jrn_def=jd.jrn_def_id) 
                where j_grpt=$1
            "); } $data=$this->get_data(); $nb_row=count($data); for ($i=0;$i<$nb_row;$i++) { $ret=$this->db->execute("supp_tax_info",array($data[$i]["jr_grpt_id"])); $array=Database::fetch_all($ret); $array=($array==false)?array():$array; $data[$i]["supp_tax"]=$array; } $this->set_data($data); } } 