<?php
 #[AllowDynamicProperties] class Acc_Compute { private static $variable=array( 'amount'=>'amount', 'amount_vat'=>'amount_vat', 'amount_vat_rate'=>'amount_vat_rate', 'nd_vat'=>'nd_vat', 'nd_vat_rate'=>'nd_vat_rate', 'nd_ded_vat'=>'nd_ded_vat', 'nd_ded_vat_rate'=>'nd_ded_vat_rate', 'amount_nd'=>'amount_nd', 'amount_nd_rate'=>'amount_nd_rate', 'nd_vat_rate'=>'nd_vat_rate', 'amount_perso'=>'amount_perso', 'amount_perso_rate'=>'amount_perso_rate', 'amount_currency'=>'amount_currency', 'amount_vat_currency'=>'amount_vat_currency', 'currency_rate'=>'currency_rate', 'autoreverse'=>'autoreverse' ); private $order; var $check; function __construct () { bcscale(4); foreach (self::$variable as $key=>$value) $this->$key=0; $this->order=0; $this->check=true; } function convert_euro() { $local_amount=$this->amount; $this->amount=bcdiv($this->amount,$this->currency_rate,6); $this->amount_currency=$local_amount; } function convert_euro_vat() { $local_amount=$this->amount_vat; $this->amount_vat=bcdiv($this->amount_vat,$this->currency_rate,6); $this->amount_vat_currency=$local_amount; } public function get_parameter($p_string) { if ( array_key_exists($p_string,self::$variable) ) { $idx=self::$variable[$p_string]; return $this->$idx; } else throw new Exception (__FILE__.":".__LINE__._('Erreur attribut inexistant')); } public function set_parameter($p_string,$p_value) { if ( array_key_exists($p_string,self::$variable) ) { $idx=self::$variable[$p_string]; $this->$idx=$p_value; } else throw new Exception (__FILE__.":".__LINE__._('Erreur attribut inexistant')); } public function get_info() { return var_export(self::$variable,true); } function compute_vat() { if ( $this->check && $this->order != 0 ) throw new Exception ('ORDER NOT RESPECTED'); $this->amount_vat=bcmul($this->amount,$this->amount_vat_rate); $this->amount_vat=round($this->amount_vat,2); $this->amount_vat_currency=bcmul($this->amount_vat,$this->currency_rate); $this->order=1; } function compute_nd() { if ( $this->check && $this->order > 2 ) throw new Exception ('ORDER NOT RESPECTED'); $this->amount_nd=bcmul($this->amount,$this->amount_nd_rate); $this->amount_nd=bcdiv($this->amount_nd,100); $this->amount_nd=round($this->amount_nd,2); $nd_vat=bcmul($this->amount_vat,$this->amount_nd_rate); $nd_vat=bcdiv($nd_vat,100); $nd_vat=round($nd_vat,2); } function compute_nd_vat() { if ( $this->check && $this->order > 3 ) throw new Exception ('ORDER NOT RESPECTED'); $this->order=4; if ($this->amount_vat == 0 ) $this->compute_vat(); $this->nd_vat=bcmul($this->amount_vat,$this->nd_vat_rate); $this->nd_vat=bcdiv($this->nd_vat,100); $this->nd_vat=round($this->nd_vat,2); } function compute_ndded_vat() { if ( $this->check && $this->order > 4 ) throw new Exception ('ORDER NOT RESPECTED'); $this->order=5; if ($this->amount_vat == 0 ) $this->compute_vat(); $this->nd_ded_vat=bcmul($this->amount_vat,$this->nd_ded_vat_rate); $this->nd_ded_vat=bcdiv($this->nd_ded_vat,100); $this->nd_ded_vat=round($this->nd_ded_vat,2); } function compute_perso() { if ( $this->check && $this->order != 1 ) throw new Exception ('ORDER NOT RESPECTED'); $this->order=2; if ( $this->amount == 0 ) return; $this->amount_perso=bcmul($this->amount,$this->amount_perso_rate); $this->amount_perso=bcdiv($this->amount_perso,100); $this->amount_perso=round($this->amount_perso,2); } function correct() { $this->amount=bcsub($this->amount,$this->amount_perso); $this->amount=bcsub($this->amount,$this->amount_nd); $this->amount_vat=bcsub($this->amount_vat,$this->nd_ded_vat); $this->amount_vat=round($this->amount_vat,2); $this->amount_vat=bcsub($this->amount_vat,$this->nd_vat); $this->amount_vat=round($this->amount_vat,2); } function verify($p_obj=null) { foreach (self::$variable as $key=>$value) if ( $this->$value < 0 ) throw new Exception (_("Montant invalide")); if ( $p_obj != null ) { $sum=0; foreach ( array( 'amount','amount_vat','amount_nd','nd_vat','amount_perso','nd_ded_vat') as $value) $sum=bcadd($sum,$this->$value); if ( $p_obj->amount_vat == 0 ) $p_obj->compute_vat(); $cmp=bcadd($p_obj->amount,$p_obj->amount_vat); $diff=bcsub($sum,$cmp); if ( $diff != 0.0 ) throw new Exception (_("ECHEC VERIFICATION  : valeur totale = $sum valeur attendue = $cmp diff = $diff")); } } function display() { foreach (self::$variable as $key=>$value) { echo 'key '.$key.' Description '.$value.' value is '.$this->$key.'<br>'; } } public static function test_me () { $a=new Acc_Compute(); echo $a->get_info(); echo '<hr>'; $a->set_parameter('amount',1.23); $a->set_parameter('amount_vat_rate',0.21); echo '<h1> Test VAT </h1>'; echo '<h2> Data </h2>'; $a->display(); echo '<h2> Result </h2>'; $a->compute_vat(); $a->display(); $a->verify(); $a=new Acc_Compute(); $a->set_parameter('amount',1.23); $a->set_parameter('amount_vat_rate',0.21); $a->set_parameter('amount_perso_rate',0.5); echo '<h1> Test VAT + Perso</h1>'; echo '<h2> Data </h2>'; $a->display(); $b=clone $a; $a->compute_vat(); $a->compute_perso(); $a->correct(); echo '<h2> Result </h2>'; $a->display(); $a->verify($b); $a=new Acc_Compute(); $a->set_parameter('amount',1.23); $a->set_parameter('amount_vat_rate',0.21); $a->set_parameter('nd_vat_rate',0.5); $b=clone $a; echo '<h1> Test VAT + ND VAT</h1>'; echo '<h2> Data </h2>'; $a->display(); $a->compute_vat(); $a->compute_nd_vat(); $a->correct(); echo '<h2> Result </h2>'; $a->display(); $a->verify($b); $a=new Acc_Compute(); $a->set_parameter('amount',1.23); $a->set_parameter('amount_vat_rate',0.21); $a->set_parameter('nd_vat_rate',0.5); $a->set_parameter('amount_perso_rate',0.5); $b=clone $a; echo '<h1> Test VAT + ND VAT + perso</h1>'; echo '<h2> Data </h2>'; $a->display(); $a->compute_vat(); $a->compute_perso(); $a->compute_nd_vat(); $a->correct(); echo '<h2> Result </h2>'; $a->display(); $a->verify($b); $a=new Acc_Compute(); $a->set_parameter('amount',1.23); $a->set_parameter('amount_vat_rate',0.21); $a->set_parameter('amount_nd_rate',0.5); $b=clone $a; echo '<h1> Test VAT + ND </h1>'; echo '<h2> Data </h2>'; $a->display(); $a->compute_vat(); $a->compute_nd(); $a->compute_perso(); $a->compute_nd_vat(); $a->correct(); echo '<h2> Result </h2>'; $a->display(); $a->verify($b); $a=new Acc_Compute(); $a->set_parameter('amount',1.23); $a->set_parameter('amount_vat_rate',0.21); $a->set_parameter('amount_nd_rate',0.5); $a->set_parameter('amount_perso_rate',0.2857); $b=clone $a; echo '<h1> Test VAT + ND  + Perso</h1>'; echo '<h2> Data </h2>'; $a->display(); $a->compute_vat(); $a->compute_nd(); $a->compute_perso(); $a->compute_nd_vat(); $a->correct(); echo '<h2> Result </h2>'; $a->display(); $a->verify($b); $a=new Acc_Compute(); $a->set_parameter('amount',1.23); $a->set_parameter('amount_vat_rate',0.21); $a->set_parameter('nd_ded_vat_rate',0.5); $b=clone $a; echo '<h1> Test VAT   +  TVA ND DED</h1>'; echo '<h2> Data </h2>'; $a->display(); $a->compute_vat(); $a->compute_nd(); $a->compute_perso(); $a->compute_nd_vat(); $a->compute_ndded_vat(); $a->correct(); echo '<h2> Result </h2>'; $a->display(); $a->verify($b); } } 