<?php
namespace Noalyss\XMLDocument; abstract class XMLInvoice extends \DOMDocument { protected $cn; protected $data; protected $jr_id; function __construct(\Database $conx) { parent::__construct("1.0", "UTF-8"); $this->cn=$conx; $this->data=[]; } public function get_data() { return $this->data; } public function set_data($data): XMLInvoice { $this->data = $data; return $this; } public function get_db_conx():\Database { return $this->cn; } public function set_db_conx(\Database $cn): XMLInvoice { $this->cn = $cn; return $this; } function build_data($jr_id):array { global $g_parameter; $this->jr_id=$jr_id; $operation = new \Acc_Sold($this->cn,$jr_id); $operation->get(); $result=array(); $result["id"]= $operation->det->jr_pj_number; $result["issue_date"]=$operation->det->jr_date; $result["due_date"]=($operation->det->jr_ech=="")?$operation->det->jr_date:$operation->det->jr_ech; $result['supplier']=$this->fill_supplier(); $result['customer']=$this->fill_customer($operation->det->array[0]['qs_client']); $result['currency']=$this->cn->get_value("select cr_code_iso from currency where id=$1" ,array($operation->det->currency_id)); $result['description']=$operation->det->jr_comment; $result['note']= $result['description']; $a_note = $this->cn->get_array("select n_id,n_text from jrn_note where jr_id=$1",[$operation->det->jr_id]); $nb_note=count($a_note); for ($e=0;$e<$nb_note;$e++) { $result['note'].= html_entity_decode($a_note[$e]['n_text']??""); } $result['operation']=array(); $nb_operation= count($operation->det->array); for ($i=0;$i < $nb_operation;$i++) { $result['operation'][$i]['card_id']=$operation->det->array[$i]['qs_fiche']; $result['operation'][$i]['quantity']=$operation->det->array[$i]['qs_quantite']; $card=new \Fiche($this->cn,$operation->det->array[$i]['qs_fiche']); $result['operation'][$i]['qcode']=$card->get_attribute(ATTR_DEF_QUICKCODE); $result['operation'][$i]['name']=$card->get_attribute(ATTR_DEF_NAME); $result['operation'][$i]['description']=($operation->det->array[$i]['j_text']=="")?$card->get_attribute(9):$operation->det->array[$i]['j_text']; $x= $card->get_attribute(ATTR_DEF_QUANTITY_TYPE,0); $result['operation'][$i]['code_quantity']=($x===false||$x=="")?"EA":$x; if ($operation->det->currency_id == 0 ) { $result['operation'][$i]['price']=$operation->det->array[$i]['qs_price']; $result['operation'][$i]['price_unit']=$operation->det->array[$i]['qs_unit']; $result['operation'][$i]['vat']=$operation->det->array[$i]['qs_vat']; } else { $result['operation'][$i]['price']=$operation->det->array[$i]['oc_amount']; $result['operation'][$i]['price_unit']=bcdiv( $operation->det->array[$i]['oc_amount'], $operation->det->array[$i]['qs_quantite'], 2); $result['operation'][$i]['vat']=$operation->det->array[$i]['oc_vat_amount']; } $result['operation'][$i]['vat_id']=$operation->det->array[$i]['qs_vat_code']; $x=$this->cn->get_row("select tva_peppol_code,tva_rate from tva_rate where tva_id=$1" ,[ $result['operation'][$i]['vat_id']]); $result['operation'][$i]['vat_code']=($x['tva_peppol_code']=="")?"S":$x['tva_peppol_code']; $result['operation'][$i]['vat_rate']=$x['tva_rate']; $result['operation'][$i]['vat_reversed']=$operation->det->array[$i]['qs_vat_sided']; } $a_row=$this->cn->get_array("select id_type,ji_value from jrn_info where jr_id=$1" ,[$jr_id]); $nb_row = count($a_row); $result['info']=[]; $result['info']['order']='NA'; $result['info']['communication']=''; for($i=0;$i<$nb_row;$i++) { switch ($a_row[$i]['id_type']) { case 'BON_COMMANDE': $result['info']['order']=$a_row[$i]['ji_value']; break; case 'OTHER': $result['info']['communication']=$a_row[$i]['ji_value']; break; } } $result['info']['communication']=($result['info']['communication']=="")?$result['id']:""; $result['document']=$this->fill_document($jr_id); $nb_operation = count($result['operation']); $result['LineExtensionAmount']=0; $result['TaxExclusiveAmount']=0; $result['TaxInclusiveAmount']=0; $result['PayableAmount']=0; $result['TaxableAmount']=0; $result['TaxAmount']=0; $VAT_SubTotal=array(); $idx_subtotal=0; bcscale(2); $VAT_SubTotal=array(); for ($i=0;$i < $nb_operation;$i++) { $acc_tva=\Acc_TVA::build($this->cn,$result['operation'][$i]['vat_id'] ); $percent = bcmul($acc_tva->tva_rate,100,2); $idx=sprintf("%s - %s",$percent,$result['operation'][$i]['vat_code'] ); $n = find_idx($VAT_SubTotal,'idx',$idx); if ($n == -1 ) { $n=$idx_subtotal; $VAT_SubTotal[$idx_subtotal]=array(); $VAT_SubTotal[$idx_subtotal]['idx']=$idx; $VAT_SubTotal[$idx_subtotal]['vat_code']=$result['operation'][$i]['vat_code'] ; $VAT_SubTotal[$idx_subtotal]['percent']=$percent; $VAT_SubTotal[$idx_subtotal]['vatex']=$acc_tva->vx_code; $VAT_SubTotal[$idx_subtotal]['amount']=$VAT_SubTotal[$idx_subtotal]['vat']=0; $idx_subtotal++; } $VAT_SubTotal[$n]['amount']=bcadd($VAT_SubTotal[$n]['amount'],$result['operation'][$i]['price']); $VAT_SubTotal[$n]['vat']=bcadd($VAT_SubTotal[$n]['vat'],$result['operation'][$i]['vat']); $VAT_SubTotal[$n]['vat']=bcsub($VAT_SubTotal[$n]['vat'],$result['operation'][$i]['vat_reversed']); $result['TaxableAmount']=bcadd( $result['TaxableAmount'],$result['operation'][$i]['price']); $result['TaxAmount']=bcadd( $result['TaxAmount'],$result['operation'][$i]['vat']); $result['TaxAmount']=bcsub( $result['TaxAmount'],$result['operation'][$i]['vat_reversed']); $result['operation'][$i]['vat_percent']=$percent; } $result['subTotalVAT']=$VAT_SubTotal; $result['LineExtensionAmount']= $result['TaxableAmount']; $result['TaxExclusiveAmount']= $result['TaxableAmount']; $result['TaxInclusiveAmount']=bcadd( $result['TaxableAmount'],$result['TaxAmount']); $result['PayableAmount']=bcadd( $result['TaxableAmount'],$result['TaxAmount']); return $result; } function load_noalyss_parameter() { $r=$this->cn->get_array('
                select pe_code, pe_value from parameter_extra 
                union all 
                select pr_id,pr_value 
                from parameter'); return array_column($r,"pe_value","pe_code"); } abstract function make_xml($jr_id); abstract function check_company_data() ; abstract function check_customer_data() ; abstract function create_invoice($operation_id) ; public function display_error() { $a_error=$this->verify(); include NOALYSS_TEMPLATE."/xmlinvoice-display_error.php"; } abstract function check_VAT(); static function build_xmlinvoice(\Database $conx) { global $g_parameter; if ($g_parameter->MY_INVOICE_FORMAT == 'UBL21BEL') { return new \Noalyss\XMLDocument\InvoiceUBL21($conx); } if ($g_parameter->MY_INVOICE_FORMAT == 'FACTURXFR') { return new \Noalyss\XMLDocument\FacturX($conx); } return null; } public function verify() { $a_error = array(); $a_error['general'] = []; $a_error['operation']=[]; $a_error['company'] = $this->check_company_data(); $a_error['customer'] = $this->check_customer_data(); return $a_error; } function fill_customer($card_id):array { $customer =new \Fiche($this->cn,$card_id); $result=array(); $result['card_id']=$card_id; $result['name']=$customer->get_attribute(ATTR_DEF_NAME,0); $result['street']=$customer->get_attribute(ATTR_DEF_ADRESS,0); $result['postalzone']=$customer->get_attribute(ATTR_DEF_POSTCODE,0); $result['city']=$customer->get_attribute(ATTR_DEF_CITY,0); $result['customer_vat_id']=str_replace([" ",".","-","/"],"" ,$customer->get_attribute(ATTR_DEF_NUMTVA,0)); $result['registration_name']=$customer->get_attribute(ATTR_DEF_NAME,0); $result['country']=$customer->get_attribute(ATTR_DEF_COUNTRY_CODE,0); if ( $result['country'] == "") { $result['country']=substr($result['customer_vat_id'],0,2); } $result['endpoint_id']=$customer->get_attribute(ATTR_DEF_PEPPOLID,0); return $result; } function fill_supplier():array { $a_parameter=$this->load_noalyss_parameter(); $result=array(); $result['name']=$a_parameter['MY_NAME']; $result['street']=$a_parameter['MY_STREET']; $result['postalzone']=$a_parameter['MY_POSTCODE']; $result['city']=$a_parameter['MY_CITY']; $result['country']=$a_parameter['MY_COUNTRY']; $result['registration_name']=$a_parameter['MY_NAME']; $result['supplier_vat_id']=str_replace([" ",".","-","/"],"" ,$a_parameter['MY_TVA']); $result['COUNTRY_CODE']=$a_parameter['MY_COUNTRY_CODE']?? substr($result['supplier_vat_id'], 0, 2); $result['COMPANY_LEGAL_REGISTRATION']=$a_parameter['COMPANY_LEGAL_REGISTRATION']??""; $result['COMPANY_LEGAL_ENTITY']=$a_parameter['COMPANY_LEGAL_ENTITY']??""; $result['INVOICE_CONTACT_NAME']=$a_parameter['INVOICE_CONTACT_NAME']??""; $result['INVOICE_EMAIL_COMPANY']=$a_parameter['INVOICE_EMAIL_COMPANY']??""; $result['COMPANY_PEPPOL_ID']=$a_parameter['COMPANY_PEPPOL_ID']??""; return $result; } function fill_operation_from_array($a_array) { $result=array(); $http=new \HttpInput(); $http->set_array($a_array); $nb_item=$http->get_value("nb_item"); for ($i=0;$i<$nb_item;$i++) { if ( $http->get_value("e_march{$i}_tva_id") == "") { continue; } $operation=array(); $card=\Fiche::from_qcode($this->cn,trim($http->get_value("e_march{$i}"))); $operation['card_id']=$card->id; $operation['quantity']=$http->get_value("e_quant{$i}"); $operation['price']=$http->get_value("e_march{$i}_price"); $operation['vat']=$http->get_value("tvac_march{$i}"); $tva= \Acc_Tva::build($this->cn, $http->get_value("e_march{$i}_tva_id")); $operation['vat_id']=$tva->tva_id; $operation['vat_reversed']=($tva->tva_both_side==1)?$operation['vat']:0; $operation['vat_code']=$tva->tva_peppol_code; $operation['code_quantity']=$card->get_attribute(ATTR_DEF_QUANTITY_TYPE,0); $operation['code_quantity']=($operation['code_quantity']=="")?"EA":$operation['code_quantity']; $result[$i]=$operation; } return $result; } public function set_pdf_filename($pdf_filename) { if ( !file_exists($pdf_filename)) { throw new \Exception("AD65 $pdf_filename doesn't not exist"); } $this->pdf_filename = $pdf_filename; return $this; } public function fill_document($jr_id) { $result=[]; $a_document=$this->cn->get_array("select js_id,js_filename,js_description,js_lob from jrn_sup_document where js_mimetype='application/pdf' AND jr_id=$1", [$jr_id]); if ($a_document == null) return array(); foreach ($a_document as $document) { $result[]=array("filename"=>$document['js_filename'] ,"description"=>$document['js_description'] ,'oid'=>$document['js_lob'] ,'id'=>$document['js_id'] ); } return $result; } } 