<?php
namespace Noalyss\XMLDocument; use horstoeko\zugferd\codelists\ZugferdCountryCodes; use horstoeko\zugferd\codelists\ZugferdCurrencyCodes; use horstoeko\zugferd\codelists\ZugferdElectronicAddressScheme; use horstoeko\zugferd\codelists\ZugferdInvoiceType; use horstoeko\zugferd\codelists\ZugferdReferenceCodeQualifiers; use horstoeko\zugferd\codelists\ZugferdUnitCodes; use horstoeko\zugferd\codelists\ZugferdVatCategoryCodes; use horstoeko\zugferd\codelists\ZugferdVatTypeCodes; use horstoeko\zugferd\ZugferdDocumentBuilder; use horstoeko\zugferd\ZugferdProfiles; class FacturX extends XMLInvoice { const EXTRA_PARAMETER = [ "INVOICE_EMAIL_COMPANY" , 'INVOICE_CONTACT_NAME' , 'COMPANY_LEGAL_ENTITY' , 'COMPANY_LEGAL_REGISTRATION' , 'COMPANY_BANK_IBAN' , 'COMPANY_BANK_BIC' , 'MY_NAME' , 'MY_STREET' , 'MY_CITY' , 'MY_COUNTRY_CODE' , 'MY_TVA' ,'SIREN' ]; protected $pdf_filename; function build_data($jr_id): array { $this->data=parent::build_data($jr_id); return $this->data; } function check_company_data() { $a_error=array(); $company = $this->load_noalyss_parameter(); foreach (FacturX::EXTRA_PARAMETER as $item) { if (!isset($company[$item]) || trim($company[$item]) == '') { $a_error[]=$item; } } return $a_error; } function check_customer_data(){ $a_error=array(); $a_needed=[ATTR_DEF_NAME=>'name' ,ATTR_DEF_ADRESS=>'street' ,ATTR_DEF_POSTCODE=>'postalzone' ,ATTR_DEF_CITY=>'city' ,ATTR_DEF_COUNTRY_CODE=>'country' ,ATTR_DEF_NUMTVA=>'customer_vat_id' ]; foreach ($a_needed as $item=>$value) { if ( $this->data['customer'][$value]=="") { $a_error[]=$value; } } return $a_error; } function make_xml($jr_id) { $this->data = $this->build_data($jr_id); $company = $this->load_noalyss_parameter(); $documentBuilder = ZugferdDocumentBuilder::createNew(ZugferdProfiles::PROFILE_EN16931); $documentBuilder->setDocumentInformation( $this->data['id'] ,"380" ,\DateTime::createFromFormat( 'Y-m-d',$this->data["issue_date"]) , $this->data['currency'] ); $documentBuilder->addDocumentPaymentTerm( sprintf("IBAN %s",$company['COMPANY_BANK_IBAN']) ,\DateTime::createFromFormat( 'Y-m-d',$this->data["due_date"]) , $this->data['info']['communication'] ); $documentBuilder->setDocumentSeller($company['MY_NAME'], ); $documentBuilder->addDocumentSellerGlobalId($company['SIREN'], '0009'); $documentBuilder->addDocumentSellerTaxNumber($company['MY_TVA']); $documentBuilder->addDocumentSellerVATRegistrationNumber($company['MY_TVA']); $documentBuilder->setDocumentSellerAddress( $company['MY_STREET'] , '', '' , $company['MY_POSTCODE'] , $company['MY_CITY'] ,$company['MY_COUNTRY_CODE']); $documentBuilder->setDocumentSellerCommunication(ZugferdElectronicAddressScheme::UNECE3155_EM , $company["INVOICE_EMAIL_COMPANY"]); $documentBuilder->setDocumentBuyer($this->data['customer']['name'], $this->data['customer']['customer_vat_id']); $documentBuilder->setDocumentBuyerAddress( $this->data['customer']['street'] , '' , '' , $this->data['customer']['postalzone'] , $this->data['customer']['city'] , $this->data['customer']['country'] ); $documentBuilder->setDocumentBuyerOrderReferencedDocument($this->data['info']['order']); $base=0;$vat=0; $nb=count($this->data['operation']); for ($i=0;$i < $nb;$i++) { $documentBuilder->addNewPosition($i+1); $documentBuilder->setDocumentPositionProductDetails($this->data['operation'][$i]['qcode'] ,$this->data['operation'][$i]['name'] ,$this->data['operation'][$i]['description'] ); $documentBuilder->setDocumentPositionNetPrice($this->data['operation'][$i]['price']); $documentBuilder->setDocumentPositionQuantity($this->data['operation'][$i]['quantity'] ,$this->data['operation'][$i]['code_quantity'] ); $documentBuilder->addDocumentPositionTax( $this->data['operation'][$i]['vat_code'] , ZugferdVatTypeCodes::VALUE_ADDED_TAX , bcmul($this->data['operation'][$i]['vat_rate'],100,2) ); $documentBuilder->setDocumentPositionLineSummation($this->data['operation'][$i]['price']); $base=bcadd($base,$this->data['operation'][$i]['price'],2); $vat=bcadd($vat,$this->data['operation'][$i]['vat'],2); $vat=bcsub($vat,$this->data['operation'][$i]['vat_reversed'],2); } $tt = bcadd($base,$vat,2); $subTotal=$this->data['subTotalVAT']; $nb_sub=count($subTotal); for ($i=0;$i<$nb_sub;$i++) { $documentBuilder->addDocumentTax( $subTotal[$i]["vat_code"] , ZugferdVatTypeCodes::VALUE_ADDED_TAX ,sprintf("%.2f",$subTotal[$i]['amount']) , sprintf("%.2f",$subTotal[$i]['vat']) , sprintf("%.2f",$subTotal[$i]['percent']) ); } $documentBuilder->setDocumentSummation( sprintf("%.2f",$this->data['TaxInclusiveAmount']) , sprintf("%.2f",$this->data['PayableAmount']) , sprintf("%.2f",$this->data['TaxExclusiveAmount']) , 0.0 , 0.0 , sprintf("%.2f",$this->data['LineExtensionAmount']) , sprintf("%.2f",(bcsub($this->data['TaxInclusiveAmount'], $this->data['TaxExclusiveAmount'], 2) ) ) , 0 ); return $documentBuilder; } function create_invoice($operation_id) { $documentBuilder= $this->make_xml($operation_id); $invoice = \horstoeko\zugferd\ZugferdDocumentPdfBuilder::fromPdfFile($documentBuilder, $this->pdf_filename); $invoice->generateDocument(); $invoice->saveDocument($this->pdf_filename."-new.pdf"); return $invoice->downloadString(); } public function verify() { $a_error = array(); $a_error['general'] = []; $a_error['operation']=[]; $a_error['company'] = $this->check_company_data(); $a_error['customer'] = $this->check_customer_data(); return $a_error; } function check_VAT() { return array(); } }