<?php
 require_once '/Applications/Noalyss/apps/noalyss/htdocs/include/constant.php'; require_once '../row_descriptor.class.php'; class row_descriptorTest extends PHPUnit_Framework_TestCase { protected $object; protected function setUp() { $this->object = new row_descriptor; } protected function tearDown() { } public function testCheck_consistency() { $row = ["2","I Frais d'établissement","20","<<\$C20>>","yes"]; $expected=[2,"I Frais d'établissement",'20','<<$C20>>',true]; $descriptor= new row_descriptor; $this->assertTrue($descriptor->check_consistency($row, 3)); $this->assertEquals($expected, [$descriptor->linestyle,$descriptor->label,$descriptor->code, $descriptor->variable_form, $descriptor->flatten]); } public function testCode_ranges() { $descriptor= new row_descriptor; $expected = [['left'=> '20', 'right'=>'20']]; $this->assertEquals($descriptor->code_ranges('20'),$expected); $expected1 = [['left'=> '20', 'right'=>'24']]; $this->assertEquals($descriptor->code_ranges('20/24'),$expected1); } public function testVariable_name() { $descriptor= new row_descriptor; $result =$descriptor->variable_name('parent',"<<\$C20>>"); $this->assertEquals($result,"C20"); } public function testGet_bilan_row() { $row = ["2","I Frais d'établissement","20","<<\$C20>>","yes"]; $expected=[ 'linestyle' =>2, 'linetype' =>'parent', 'label' => "I Frais d'établissement", 'poste' =>'20', 'solde' => 0.0]; $descriptor= new row_descriptor; $this->assertTrue($descriptor->check_consistency($row, 3)); $this->assertEquals($expected,$descriptor->get_bilan_row()); $row = ["0","ACTIF","","",""]; $expected=[ 'linestyle' =>0, 'linetype' =>'tittle', 'label' => "ACTIF", 'poste' =>'', 'solde' => 0.0]; $descriptor= new row_descriptor; $this->assertTrue($descriptor->check_consistency($row, 3)); $this->assertEquals($expected,$descriptor->get_bilan_row()); } public function testRow_desriptor() { $this->assertEquals(["2","I Frais d'établissement","20","<<\$C20>>","yes"], ["2","I Frais d'établissement","20","<<\$C20>>","yes"] ); } } 